/*
 * Decompiled with CFR 0.152.
 */
package io.github.fishstiz.packed_packs.gui.components.pack;

import com.google.common.collect.ImmutableList;
import io.github.fishstiz.fidgetz.gui.renderables.ColoredRect;
import io.github.fishstiz.fidgetz.gui.renderables.GradientRect;
import io.github.fishstiz.fidgetz.gui.renderables.sprites.Sprite;
import io.github.fishstiz.fidgetz.util.GuiUtil;
import io.github.fishstiz.packed_packs.gui.components.events.MoveEvent;
import io.github.fishstiz.packed_packs.gui.components.events.PackListEventListener;
import io.github.fishstiz.packed_packs.gui.components.pack.AvailablePackList;
import io.github.fishstiz.packed_packs.gui.components.pack.FolderPackList;
import io.github.fishstiz.packed_packs.gui.components.pack.PackList;
import io.github.fishstiz.packed_packs.gui.components.pack.PackListBase;
import io.github.fishstiz.packed_packs.pack.PackAssets;
import io.github.fishstiz.packed_packs.util.InputUtil;
import io.github.fishstiz.packed_packs.util.ResourceUtil;
import io.github.fishstiz.packed_packs.util.constants.GuiConstants;
import io.github.fishstiz.packed_packs.util.constants.Theme;
import io.github.fishstiz.packed_packs.util.lang.IntsUtil;
import io.github.fishstiz.packed_packs.util.lang.ObjectsUtil;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.function.Consumer;
import java.util.function.ToIntFunction;
import net.minecraft.class_3288;
import net.minecraft.class_332;
import net.minecraft.class_350;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CurrentPackList
extends PackListBase<Entry> {
    private static final Sprite UNSELECT_HIGHLIGHTED_SPRITE = Sprite.of32(ResourceUtil.getVanillaSprite("transferable_list/unselect_highlighted"));
    private static final Sprite UNSELECT_SPRITE = Sprite.of32(ResourceUtil.getVanillaSprite("transferable_list/unselect"));
    private static final Sprite MOVE_UP_HIGHLIGHTED_SPRITE = Sprite.of32(ResourceUtil.getVanillaSprite("transferable_list/move_up_highlighted"));
    private static final Sprite MOVE_UP_SPRITE = Sprite.of32(ResourceUtil.getVanillaSprite("transferable_list/move_up"));
    private static final Sprite MOVE_DOWN_HIGHLIGHTED_SPRITE = Sprite.of32(ResourceUtil.getVanillaSprite("transferable_list/move_down_highlighted"));
    private static final Sprite MOVE_DOWN_SPRITE = Sprite.of32(ResourceUtil.getVanillaSprite("transferable_list/move_down"));
    private static final Theme DROP_THEME = Theme.GREEN_500;
    private static final ColoredRect DROP_INDEX = new ColoredRect(DROP_THEME.getARGB());
    private static final GradientRect SCROLL_UP = GradientRect.fromTop(DROP_THEME.withAlpha(0.75f), DROP_THEME.withAlpha(0.0f));
    private static final GradientRect SCROLL_DOWN = SCROLL_UP.flip();
    private static final int DROP_INDEX_PADDING = 2;
    private static final double SCROLL_STEP = 10.0;
    private boolean scrolling;

    public CurrentPackList(PackAssets packAssets, PackListEventListener listener) {
        super(packAssets, listener);
    }

    @Override
    @NotNull
    protected Entry createEntry(class_3288 pack, int index) {
        return new Entry(pack, index);
    }

    @Override
    public boolean method_25404(int keyCode, int scanCode, int modifiers) {
        Entry entry;
        boolean keyPressed = super.method_25404(keyCode, scanCode, modifiers);
        if (!keyPressed && (entry = (Entry)this.getEntry(this.getLastSelected())) != null) {
            if (InputUtil.isMoveDown(keyCode, modifiers)) {
                if (entry.moveDown()) {
                    GuiUtil.playClickSound();
                }
                return true;
            }
            if (InputUtil.isMoveUp(keyCode, modifiers)) {
                if (entry.moveUp()) {
                    GuiUtil.playClickSound();
                }
                return true;
            }
        }
        return keyPressed;
    }

    private void scrollStep(MoveDirection direction, float partialTick) {
        double scrollAmount = this.method_44387();
        if (direction.isUp()) {
            scrollAmount -= 10.0 * (double)partialTick;
        } else if (direction.isDown()) {
            scrollAmount += 10.0 * (double)partialTick;
        }
        this.scrolling = true;
        this.setClampedScrollAmount(scrollAmount);
    }

    private int getDropIndex(double mouseY) {
        if (this.method_25396().isEmpty()) {
            return -1;
        }
        int index = this.getRowIndex(mouseY);
        if (index == -1) {
            return -1;
        }
        Entry entry = (Entry)this.method_25326(index);
        int centerY = entry.method_46427() + entry.method_25364() / 2;
        if (mouseY >= (double)centerY) {
            int next = index + 1;
            return next < this.method_25396().size() ? next : -1;
        }
        return index;
    }

    private int toPackIndex(int dropIndex) {
        List children = this.method_25396();
        if (dropIndex == -1) {
            return !children.isEmpty() ? this.packs.indexOf(((Entry)this.method_25396().getLast()).getPack()) + 1 : -1;
        }
        return Math.clamp((long)this.packs.indexOf(((Entry)this.method_25396().get(dropIndex)).getPack()), 0, this.packs.size());
    }

    private boolean isMouserOverSelection(List<class_3288> selection, double mouseX, double mouseY) {
        for (class_3288 selected : selection) {
            Entry entry = (Entry)this.getEntry(selected);
            if (entry == null || !entry.method_25405(mouseX, mouseY)) continue;
            return true;
        }
        return false;
    }

    public void insertDrop(class_3288 pack, int index) {
        if (pack != null) {
            int previous = this.packs.indexOf(pack);
            if (previous != -1 && previous < index) {
                --index;
            }
            this.packs.remove(pack);
            this.packs.add(Math.clamp((long)index, 0, this.packs.size()), pack);
            this.queryPacks();
        }
    }

    @Override
    public boolean canDrop(PackList source, ImmutableList<class_3288> payload, class_3288 trigger, double mouseX, double mouseY) {
        if (this.scrolling || this.isQueried() || this.isLocked() || payload.isEmpty() || source != this && !(source instanceof AvailablePackList)) {
            return false;
        }
        List children = this.method_25396();
        if (children.isEmpty()) {
            return true;
        }
        int dropIndex = this.getDropIndex(mouseY);
        int minDropIndex = 0;
        int maxDropIndex = this.packs.size();
        block4: for (int i = 0; i < this.packs.size(); ++i) {
            class_3288 pack = (class_3288)this.packs.get(i);
            if (!this.packAssets.isFixed(pack)) continue;
            switch (this.packAssets.getPosition(pack)) {
                case field_14280: {
                    minDropIndex = i + 1;
                    continue block4;
                }
                case field_14281: {
                    maxDropIndex = Math.min(i, maxDropIndex);
                }
            }
        }
        int dropPackIndex = this.toPackIndex(dropIndex);
        if (dropPackIndex == -1) {
            dropPackIndex = minDropIndex;
        }
        if (dropPackIndex < minDropIndex || dropPackIndex > maxDropIndex) {
            return false;
        }
        if (source != this) {
            return source.isTransferable(trigger);
        }
        if (this.packAssets.isFixed(trigger) || this.isMouserOverSelection((List<class_3288>)payload, mouseX, mouseY)) {
            return false;
        }
        int[] indices = this.getIndicesFromSelection((List<class_3288>)payload);
        if (indices.length == 0) {
            return false;
        }
        if (IntsUtil.hasGap(indices)) {
            return true;
        }
        Arrays.sort(indices);
        int lastSelectionIndex = indices[indices.length - 1];
        if (!this.packs.isEmpty()) {
            int lastPackIndex = this.packs.indexOf(this.packs.getLast());
            if (dropIndex == -1 && lastPackIndex == lastSelectionIndex) {
                return false;
            }
        }
        return dropIndex != indices[0] && dropIndex - 1 != lastSelectionIndex;
    }

    @Override
    @Nullable
    protected List<class_3288> handleDrop(PackList source, ImmutableList<class_3288> payload, class_3288 trigger, double mouseX, double mouseY) {
        if (!this.canDrop(source, payload, trigger, mouseX, mouseY)) {
            return null;
        }
        int dropPackIndex = this.toPackIndex(this.getDropIndex(mouseY));
        if (dropPackIndex == -1) {
            int minDropIndex = 0;
            for (int i = 0; i < this.packs.size(); ++i) {
                class_3288 pack = (class_3288)this.packs.get(i);
                if (!this.packAssets.isFixed(pack) || this.packAssets.getPosition(pack) != class_3288.class_3289.field_14280) continue;
                minDropIndex = i + 1;
            }
            dropPackIndex = minDropIndex;
        }
        if (source == this) {
            ObjectArrayList movable = new ObjectArrayList(payload);
            movable.removeIf(this.packAssets::isFixed);
            return this.moveAll(this.orderSelection((List<class_3288>)movable), dropPackIndex) ? payload : null;
        }
        this.clearSelection();
        ObjectArrayList dropped = new ObjectArrayList();
        for (class_3288 selected : payload) {
            if (!source.isTransferable(selected)) continue;
            dropped.add(selected);
            this.insertDrop(selected, dropPackIndex);
            this.select(selected);
        }
        source.removeAll((List<class_3288>)dropped);
        this.select(trigger);
        return dropped;
    }

    private void renderDropIndex(class_332 guiGraphics, int mouseY, int x, int width) {
        int dropIndex = this.getDropIndex(mouseY);
        int rowTop = this.method_25337(dropIndex != -1 ? dropIndex : this.method_25396().size());
        int indexY = rowTop - this.rowGap - 2;
        guiGraphics.method_44379(this.method_46426(), this.method_46427(), this.method_55442(), this.method_55443());
        DROP_INDEX.render(guiGraphics, x, indexY, width, rowTop - indexY + 2);
        guiGraphics.method_44380();
    }

    @Override
    public void renderDroppableZone(class_332 guiGraphics, PackList source, ImmutableList<class_3288> payload, class_3288 trigger, int mouseX, int mouseY, float partialTick) {
        if (this.isLocked() || source.isLocked() || source != this && source instanceof FolderPackList) {
            return;
        }
        int x = this.method_46426();
        int y = this.method_46427();
        int width = this.method_44392() ? this.method_25368() - this.scrollbarOffset : this.method_25368();
        int height = this.method_25364();
        int bottom = this.method_55443();
        if (this.method_25405(mouseX, mouseY)) {
            double scrollAmount = this.method_44387();
            int scrollDownY = bottom - this.field_22741;
            if (scrollAmount < (double)this.method_44390() && mouseY >= scrollDownY) {
                SCROLL_DOWN.render(guiGraphics, x, scrollDownY, width, this.field_22741);
                this.scrollStep(MoveDirection.DOWN, partialTick);
            } else if (scrollAmount > 0.0 && mouseY <= y + this.field_22741) {
                SCROLL_UP.render(guiGraphics, x, y, width, this.field_22741);
                this.scrollStep(MoveDirection.UP, partialTick);
            } else {
                this.scrolling = false;
            }
            if (this.canDrop(source, payload, trigger, mouseX, mouseY)) {
                this.renderDropIndex(guiGraphics, mouseY, x, width);
            }
        }
        guiGraphics.method_49601(x, y, width, height, DROP_THEME.getARGB());
    }

    public boolean isScrolling() {
        return this.scrolling;
    }

    public class Entry
    extends PackListBase.Entry {
        protected Entry(class_3288 pack, int index) {
            super(CurrentPackList.this, pack, index);
        }

        @Override
        public boolean isTransferable() {
            return !CurrentPackList.this.packAssets.isRequired(this.pack) && !CurrentPackList.this.isLocked() && !this.isStale();
        }

        @Override
        protected boolean canDrag() {
            return !this.isFixed() && super.canDrag();
        }

        public boolean isFixed() {
            return CurrentPackList.this.packAssets.isFixed(this.pack) || CurrentPackList.this.isQueried() || CurrentPackList.this.isLocked() || this.isStale();
        }

        public boolean canMoveDown() {
            List selection;
            if (this.isFixed()) {
                return false;
            }
            int size = CurrentPackList.this.packs.size();
            if (this.isSelected() && (selection = CurrentPackList.this.getOrderedSelection().reversed()).size() > 1) {
                Entry entry = (Entry)CurrentPackList.this.getEntry((class_3288)selection.getFirst());
                int index = entry != null ? entry.getPackIndex() : -1;
                int moveIndex = index > -1 ? entry.getMoveDownIndex() : -1;
                return index > -1 && index < size - 1 && moveIndex > -1 && !CurrentPackList.this.packAssets.isFixed((class_3288)CurrentPackList.this.packs.get(moveIndex));
            }
            int index = this.getPackIndex();
            int moveIndex = this.getMoveDownIndex();
            return index > -1 && index < size - 1 && moveIndex > -1 && !CurrentPackList.this.packAssets.isFixed((class_3288)CurrentPackList.this.packs.get(moveIndex));
        }

        public boolean canMoveUp() {
            ImmutableList<class_3288> selection;
            if (this.isFixed()) {
                return false;
            }
            if (this.isSelected() && (selection = CurrentPackList.this.getOrderedSelection()).size() > 1) {
                Entry entry = (Entry)CurrentPackList.this.getEntry((class_3288)selection.getFirst());
                int index = entry != null ? entry.getPackIndex() : -1;
                int moveIndex = index > -1 ? entry.getMoveUpIndex() : -1;
                return index > 0 && moveIndex > -1 && !CurrentPackList.this.packAssets.isFixed((class_3288)CurrentPackList.this.packs.get(moveIndex));
            }
            int index = this.getPackIndex();
            int moveIndex = this.getMoveUpIndex();
            return index > 0 && moveIndex > -1 && !CurrentPackList.this.packAssets.isFixed((class_3288)CurrentPackList.this.packs.get(moveIndex));
        }

        public boolean isMouseOverRemove(double mouseX, double mouseY) {
            return CurrentPackList.this.method_49606() && this.isTransferable() && GuiUtil.containsPoint(this.method_46426() + 2, this.method_46427(), CurrentPackList.UNSELECT_SPRITE.width / 2, CurrentPackList.UNSELECT_SPRITE.height, mouseX, mouseY);
        }

        public boolean isMouseOverUp(double mouseX, double mouseY) {
            return CurrentPackList.this.method_49606() && this.canMoveUp() && GuiUtil.containsPoint(this.method_46426() + 2 + CurrentPackList.MOVE_UP_SPRITE.width / 2, this.method_46427(), CurrentPackList.MOVE_UP_SPRITE.width / 2, CurrentPackList.MOVE_UP_SPRITE.height / 2, mouseX, mouseY);
        }

        public boolean isMouseOverDown(double mouseX, double mouseY) {
            return CurrentPackList.this.method_49606() && this.canMoveDown() && GuiUtil.containsPoint(this.method_46426() + 2 + CurrentPackList.MOVE_DOWN_SPRITE.width / 2, this.method_46427() + CurrentPackList.MOVE_DOWN_SPRITE.height / 2, CurrentPackList.MOVE_DOWN_SPRITE.width / 2, CurrentPackList.MOVE_DOWN_SPRITE.height / 2, mouseX, mouseY);
        }

        protected int getPackIndex() {
            return CurrentPackList.this.packs.indexOf(this.pack);
        }

        protected int getMoveUpIndex() {
            for (int i = this.getPackIndex() - 1; i >= 0; --i) {
                class_3288 nextPack = (class_3288)CurrentPackList.this.packs.get(i);
                if (CurrentPackList.this.packAssets.isFixed(nextPack)) {
                    return -1;
                }
                if (CurrentPackList.this.packAssets.isHidden(nextPack)) continue;
                return i;
            }
            return -1;
        }

        protected int getMoveDownIndex() {
            for (int i = this.getPackIndex() + 1; i < CurrentPackList.this.packs.size(); ++i) {
                class_3288 nextPack = (class_3288)CurrentPackList.this.packs.get(i);
                if (CurrentPackList.this.packAssets.isFixed(nextPack)) {
                    return -1;
                }
                if (CurrentPackList.this.packAssets.isHidden(nextPack)) continue;
                return i;
            }
            return -1;
        }

        @Nullable
        private List<class_3288> moveSelection(List<class_3288> selection, ToIntFunction<Entry> indexGetter) {
            ObjectArrayList moved = new ObjectArrayList();
            class_3288 lastSelected = CurrentPackList.this.getLastSelected();
            for (int i = 0; i < selection.size(); ++i) {
                Entry entry = (Entry)CurrentPackList.this.getEntry(selection.get(i));
                int index = indexGetter.applyAsInt(entry);
                if (index > -1 && entry != null && CurrentPackList.this.move(selection.get(i), index)) {
                    moved.add(selection.get(i));
                    continue;
                }
                if (i != 0) continue;
                return null;
            }
            CurrentPackList.this.select(lastSelected);
            return !moved.isEmpty() ? moved : null;
        }

        private void sendMoveEvent(List<class_3288> moved) {
            CurrentPackList.this.sendEvent(new MoveEvent(CurrentPackList.this, moved, this.pack));
            Entry entry = (Entry)CurrentPackList.this.getEntry(this.pack);
            if (entry != null) {
                CurrentPackList.this.method_25328((class_350.class_351)entry);
            }
        }

        private boolean moveDirection(MoveDirection direction) {
            List<class_3288> moved;
            if (direction.isUp() && !this.canMoveUp() || direction.isDown() && !this.canMoveDown()) {
                return false;
            }
            if (!this.isSelected()) {
                int packIndex = this.getPackIndex();
                if (packIndex > -1) {
                    int targetIndex;
                    int n = targetIndex = direction.isUp() ? this.getMoveUpIndex() : this.getMoveDownIndex();
                    if (targetIndex > -1 && CurrentPackList.this.move(this.pack, targetIndex)) {
                        CurrentPackList.this.selectExclusive(this.pack);
                        this.sendMoveEvent(List.of(this.pack));
                        return true;
                    }
                }
                return false;
            }
            List<class_3288> list = moved = direction.isUp() ? this.moveSelection((List<class_3288>)CurrentPackList.this.getOrderedSelection(), Entry::getMoveUpIndex) : this.moveSelection(CurrentPackList.this.getOrderedSelection().reversed(), Entry::getMoveDownIndex);
            if (moved != null && !moved.isEmpty()) {
                this.sendMoveEvent(moved);
                return true;
            }
            return false;
        }

        public boolean moveUp() {
            return this.moveDirection(MoveDirection.UP);
        }

        public boolean moveDown() {
            return this.moveDirection(MoveDirection.DOWN);
        }

        @Override
        public boolean method_25402(double mouseX, double mouseY, int button) {
            if (InputUtil.isLeftClick(button)) {
                if (this.isMouseOverRemove(mouseX, mouseY)) {
                    return this.consumeClick(PackListBase.Entry::transfer);
                }
                if (this.isMouseOverUp(mouseX, mouseY)) {
                    return this.consumeClick(Entry::moveUp);
                }
                if (this.isMouseOverDown(mouseX, mouseY)) {
                    return this.consumeClick(Entry::moveDown);
                }
            }
            return super.method_25402(mouseX, mouseY, button);
        }

        private boolean consumeClick(Consumer<Entry> action) {
            GuiUtil.playClickSound();
            action.accept(this);
            return false;
        }

        @Override
        protected void renderForeground(class_332 guiGraphics, int top, int left, int width, int height, int mouseX, int mouseY, boolean hovering, float partialTick) {
            if (!hovering && !this.isSelectedLast()) {
                return;
            }
            int x = left + 2;
            GuiConstants.WHITE_OVERLAY.render(guiGraphics, x, top, CurrentPackList.UNSELECT_SPRITE.width, CurrentPackList.UNSELECT_SPRITE.height);
            if (this.isTransferable()) {
                ObjectsUtil.pick(!this.isMouseOverRemove(mouseX, mouseY), UNSELECT_SPRITE, UNSELECT_HIGHLIGHTED_SPRITE).render(guiGraphics, x, top);
            }
            if (this.canMoveUp()) {
                ObjectsUtil.pick(!this.isMouseOverUp(mouseX, mouseY), MOVE_UP_SPRITE, MOVE_UP_HIGHLIGHTED_SPRITE).render(guiGraphics, x, top);
            }
            if (this.canMoveDown()) {
                ObjectsUtil.pick(!this.isMouseOverDown(mouseX, mouseY), MOVE_DOWN_SPRITE, MOVE_DOWN_HIGHLIGHTED_SPRITE).render(guiGraphics, x, top);
            }
        }
    }

    private static enum MoveDirection {
        UP,
        DOWN;


        public boolean isUp() {
            return this == UP;
        }

        public boolean isDown() {
            return this == DOWN;
        }
    }
}

