/*
 * Decompiled with CFR 0.152.
 */
package io.github.fishstiz.packed_packs.gui.components.profile;

import io.github.fishstiz.fidgetz.gui.components.AbstractDynamicList;
import io.github.fishstiz.fidgetz.gui.components.FidgetzButton;
import io.github.fishstiz.fidgetz.gui.components.contextmenu.ContextMenuContainer;
import io.github.fishstiz.fidgetz.gui.components.contextmenu.ContextMenuItemBuilder;
import io.github.fishstiz.fidgetz.gui.components.contextmenu.ContextMenuProvider;
import io.github.fishstiz.fidgetz.gui.renderables.sprites.ButtonSprites;
import io.github.fishstiz.fidgetz.gui.renderables.sprites.Sprite;
import io.github.fishstiz.fidgetz.util.ARGBColor;
import io.github.fishstiz.fidgetz.util.GuiUtil;
import io.github.fishstiz.fidgetz.util.debounce.PollingDebouncer;
import io.github.fishstiz.fidgetz.util.debounce.SimplePollingDebouncer;
import io.github.fishstiz.packed_packs.PackedPacks;
import io.github.fishstiz.packed_packs.config.Config;
import io.github.fishstiz.packed_packs.config.Profile;
import io.github.fishstiz.packed_packs.gui.layouts.ProfilesLayout;
import io.github.fishstiz.packed_packs.util.ResourceUtil;
import io.github.fishstiz.packed_packs.util.constants.GuiConstants;
import io.github.fishstiz.packed_packs.util.constants.Theme;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import net.minecraft.class_2561;
import net.minecraft.class_327;
import net.minecraft.class_332;
import net.minecraft.class_339;
import net.minecraft.class_350;
import net.minecraft.class_364;
import net.minecraft.class_6379;
import net.minecraft.class_7919;
import org.jetbrains.annotations.NotNull;

public class ProfileList
extends AbstractDynamicList<Entry>
implements ContextMenuContainer {
    private static final int ITEM_HEIGHT = 20;
    private static final class_2561 EMPTY_TEXT = ResourceUtil.getText("profile.empty", new Object[0]);
    private static final class_2561 DELETE_TEXT = ResourceUtil.getText("profile.delete", new Object[0]);
    private static final class_7919 DELETE_INFO = class_7919.method_47407((class_2561)ResourceUtil.getText("profile.delete.info", new Object[0]));
    private static final Sprite TRASH_SPRITE = Sprite.of16(ResourceUtil.getIcon("trash"));
    private static final Sprite STAR_OUTLINE_SPRITE = Sprite.of16(ResourceUtil.getIcon("star_outline"));
    private final PollingDebouncer<Void> debouncedRefresh = new SimplePollingDebouncer<Void>(this::refresh, 200L);
    private final ProfilesLayout layout;
    private final Config.Packs config;
    private List<Profile> profiles;

    public ProfileList(Config.Packs config, ProfilesLayout profilesLayout) {
        super(20, 6, 0, 0);
        this.config = config;
        this.layout = profilesLayout;
        this.refresh();
    }

    public void scheduleRefresh() {
        this.debouncedRefresh.run();
    }

    public void refresh() {
        this.method_25339();
        this.profiles = this.config.getProfiles();
        for (int i = 0; i < this.profiles.size(); ++i) {
            this.method_25321((class_350.class_351)new Entry(this.profiles.get(i), i));
        }
    }

    public void method_48579(class_332 guiGraphics, int mouseX, int mouseY, float partialTick) {
        this.debouncedRefresh.poll();
        super.method_48579(guiGraphics, mouseX, mouseY, partialTick);
        if (this.profiles == null || this.profiles.isEmpty()) {
            int padding = 8;
            ProfileList.method_52718((class_332)guiGraphics, (class_327)this.field_22740.field_1772, (class_2561)EMPTY_TEXT, (int)(this.method_46426() + padding), (int)(this.method_46427() + padding), (int)(this.method_55442() - padding), (int)(this.method_55443() - padding), (int)Theme.WHITE.getARGB());
        }
    }

    public class Entry
    extends AbstractDynamicList.Entry
    implements ContextMenuProvider {
        private final Profile profile;
        private final List<FidgetzButton<Void>> children;
        private final FidgetzButton<Void> selectButton;
        private final FidgetzButton<Void> deleteButton;

        protected Entry(Profile profile, int index) {
            super(index);
            this.children = new ArrayList<FidgetzButton<Void>>();
            this.profile = profile;
            this.deleteButton = ((FidgetzButton.Builder)((FidgetzButton.Builder)((FidgetzButton.Builder)((FidgetzButton.Builder)FidgetzButton.builder().makeSquare(this.method_25364())).setMessage(DELETE_TEXT)).setSprite(this.isDefault() ? ButtonSprites.of(GuiConstants.STAR_SPRITE) : (profile.isLocked() ? ButtonSprites.unclamp(GuiConstants.LOCK_SPRITE) : ButtonSprites.of(TRASH_SPRITE)))).setOnPress(() -> ProfileList.this.layout.removeProfile(this.profile))).build();
            boolean bl = this.deleteButton.field_22763 = !profile.isLocked() && !this.isDefault();
            if (this.deleteButton.field_22763) {
                this.deleteButton.method_47400(DELETE_INFO);
            }
            this.selectButton = ((FidgetzButton.Builder)((FidgetzButton.Builder)FidgetzButton.builder().setMessage((class_2561)class_2561.method_43470((String)this.profile.getName()))).setOnPress(() -> ProfileList.this.layout.setProfile(this.profile))).build();
            this.children.add(this.deleteButton);
            this.children.add(this.selectButton);
        }

        public void method_25343(class_332 guiGraphics, int index, int top, int left, int width, int height, int mouseX, int mouseY, boolean hovering, float partialTick) {
            this.selectButton.field_22763 = ProfileList.this.layout.getProfile() != this.profile;
            this.deleteButton.method_48229(left, top);
            this.selectButton.method_48229(left + this.deleteButton.method_25368(), top);
            this.selectButton.method_25358(width - this.deleteButton.method_25368());
            this.deleteButton.method_25394(guiGraphics, mouseX, mouseY, partialTick);
            this.selectButton.method_25394(guiGraphics, mouseX, mouseY, partialTick);
            if (PackedPacks.CONFIG.isDevMode()) {
                boolean hovered;
                int borderColor;
                boolean hasProperty = true;
                if (this.isDefault() && this.profile.isLocked()) {
                    borderColor = Theme.PURPLE_500.getARGB();
                } else if (this.isDefault()) {
                    borderColor = Theme.BLUE_500.getARGB();
                } else if (this.profile.isLocked()) {
                    borderColor = Theme.RED_700.getARGB();
                } else {
                    borderColor = Theme.WHITE.getARGB();
                    hasProperty = false;
                }
                boolean bl = hovered = guiGraphics.method_58135(mouseX, mouseY) && GuiUtil.isHovered((class_364)this, mouseX, mouseY);
                if (hasProperty || hovered) {
                    guiGraphics.method_49601(left, top, width, height, borderColor);
                }
                if (hovered) {
                    int foregroundColor = ARGBColor.withAlpha(borderColor, 0.25f);
                    guiGraphics.method_25294(left, top, left + width, top + height, foregroundColor);
                }
            }
        }

        private boolean isDefault() {
            return ProfileList.this.config.getDefaultProfile() == this.profile;
        }

        private boolean isSelected() {
            return ProfileList.this.layout.getProfile() == this.profile;
        }

        @NotNull
        public List<? extends class_364> method_25396() {
            return this.children;
        }

        @NotNull
        public List<? extends class_6379> method_37025() {
            return this.children;
        }

        @Override
        public void method_48206(Consumer<class_339> consumer) {
            this.children.forEach(consumer);
        }

        @Override
        public void buildItems(ContextMenuItemBuilder builder, int mouseX, int mouseY) {
            if (!PackedPacks.CONFIG.isDevMode()) {
                return;
            }
            builder.separatorIfNonEmpty();
            builder.add(GuiConstants.devItem((class_2561)ResourceUtil.getText("profile.default." + (this.isDefault() ? "unset" : "set"), new Object[0])).icon(() -> this.isDefault() ? GuiConstants.STAR_SPRITE : STAR_OUTLINE_SPRITE).action(() -> {
                ProfileList.this.config.setDefaultProfile(this.isDefault() ? null : this.profile);
                ProfileList.this.refresh();
                ProfileList.this.layout.setProfile(this.profile);
            }).build());
            builder.add(GuiConstants.devItem((class_2561)ResourceUtil.getText("profile." + (this.profile.isLocked() ? "unlock" : "lock"), new Object[0])).icon(this.profile.isLocked() ? GuiConstants.LOCK_SPRITE_SMALL : GuiConstants.UNLOCK_SPRITE_SMALL).action(() -> {
                boolean selected = this.isSelected();
                if (selected) {
                    ProfileList.this.layout.setProfile(this.profile);
                }
                this.profile.setLocked(!this.profile.isLocked());
                ProfileList.this.refresh();
                if (selected) {
                    ProfileList.this.layout.updateGuiState(this.profile);
                }
            }).build());
        }
    }
}

