/*
 * Decompiled with CFR 0.152.
 */
package io.github.fishstiz.packed_packs.gui.screens;

import com.google.common.collect.ImmutableList;
import io.github.fishstiz.fidgetz.gui.components.FidgetzButton;
import io.github.fishstiz.fidgetz.gui.components.LayoutWrapper;
import io.github.fishstiz.fidgetz.gui.components.Modal;
import io.github.fishstiz.fidgetz.gui.components.ToggleableDialog;
import io.github.fishstiz.fidgetz.gui.components.ToggleableDialogContainer;
import io.github.fishstiz.fidgetz.gui.components.ToggleableEditBox;
import io.github.fishstiz.fidgetz.gui.components.contextmenu.ContextMenu;
import io.github.fishstiz.fidgetz.gui.components.contextmenu.ContextMenuContainer;
import io.github.fishstiz.fidgetz.gui.components.contextmenu.ContextMenuItemBuilder;
import io.github.fishstiz.fidgetz.gui.components.contextmenu.MenuItem;
import io.github.fishstiz.fidgetz.gui.layouts.FlexLayout;
import io.github.fishstiz.fidgetz.gui.renderables.ColoredRect;
import io.github.fishstiz.fidgetz.gui.renderables.sprites.Sprite;
import io.github.fishstiz.fidgetz.gui.shapes.Size;
import io.github.fishstiz.fidgetz.util.debounce.ImmediateDebouncer;
import io.github.fishstiz.packed_packs.PackedPacks;
import io.github.fishstiz.packed_packs.compat.ModAdditions;
import io.github.fishstiz.packed_packs.config.Config;
import io.github.fishstiz.packed_packs.config.Folder;
import io.github.fishstiz.packed_packs.config.Preferences;
import io.github.fishstiz.packed_packs.config.Profile;
import io.github.fishstiz.packed_packs.gui.components.contextmenu.DirectoryMenuItem;
import io.github.fishstiz.packed_packs.gui.components.contextmenu.PackMenuHeader;
import io.github.fishstiz.packed_packs.gui.components.events.BasicEvent;
import io.github.fishstiz.packed_packs.gui.components.events.FileDeleteEvent;
import io.github.fishstiz.packed_packs.gui.components.events.FileRenameCloseEvent;
import io.github.fishstiz.packed_packs.gui.components.events.FileRenameEvent;
import io.github.fishstiz.packed_packs.gui.components.events.FileRenameOpenEvent;
import io.github.fishstiz.packed_packs.gui.components.events.FolderCloseEvent;
import io.github.fishstiz.packed_packs.gui.components.events.FolderOpenEvent;
import io.github.fishstiz.packed_packs.gui.components.events.MoveEvent;
import io.github.fishstiz.packed_packs.gui.components.events.PackListEvent;
import io.github.fishstiz.packed_packs.gui.components.pack.AvailablePackList;
import io.github.fishstiz.packed_packs.gui.components.pack.CurrentPackList;
import io.github.fishstiz.packed_packs.gui.components.pack.FileRenameModal;
import io.github.fishstiz.packed_packs.gui.components.pack.FolderDialog;
import io.github.fishstiz.packed_packs.gui.components.pack.FolderPackList;
import io.github.fishstiz.packed_packs.gui.components.pack.PackList;
import io.github.fishstiz.packed_packs.gui.components.pack.PackListBase;
import io.github.fishstiz.packed_packs.gui.history.HistoryManager;
import io.github.fishstiz.packed_packs.gui.history.Restorable;
import io.github.fishstiz.packed_packs.gui.layouts.OptionsLayout;
import io.github.fishstiz.packed_packs.gui.layouts.ProfilesLayout;
import io.github.fishstiz.packed_packs.gui.layouts.pack.AvailablePacksLayout;
import io.github.fishstiz.packed_packs.gui.layouts.pack.CurrentPacksLayout;
import io.github.fishstiz.packed_packs.gui.layouts.pack.PackLayout;
import io.github.fishstiz.packed_packs.gui.metadata.PackSelectionScreenArgs;
import io.github.fishstiz.packed_packs.gui.metadata.Toggleable;
import io.github.fishstiz.packed_packs.gui.screens.PackListEventHandler;
import io.github.fishstiz.packed_packs.pack.PackGroup;
import io.github.fishstiz.packed_packs.pack.PackRepositoryHelper;
import io.github.fishstiz.packed_packs.pack.PackWatcher;
import io.github.fishstiz.packed_packs.pack.folder.FolderPack;
import io.github.fishstiz.packed_packs.transform.mixin.PackSelectionModelAccessor;
import io.github.fishstiz.packed_packs.transform.mixin.PackSelectionScreenAccessor;
import io.github.fishstiz.packed_packs.transform.mixin.gui.HeaderAndFooterLayoutAccess;
import io.github.fishstiz.packed_packs.util.InputUtil;
import io.github.fishstiz.packed_packs.util.PackUtil;
import io.github.fishstiz.packed_packs.util.ResourceUtil;
import io.github.fishstiz.packed_packs.util.ToastUtil;
import io.github.fishstiz.packed_packs.util.constants.GuiConstants;
import io.github.fishstiz.packed_packs.util.constants.Theme;
import io.github.fishstiz.packed_packs.util.lang.CollectionsUtil;
import io.github.fishstiz.packed_packs.util.lang.ObjectsUtil;
import it.unimi.dsi.fastutil.booleans.BooleanConsumer;
import java.lang.invoke.MethodHandle;
import java.lang.runtime.ObjectMethods;
import java.lang.runtime.SwitchBootstraps;
import java.nio.file.Path;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import net.minecraft.class_156;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_3288;
import net.minecraft.class_332;
import net.minecraft.class_339;
import net.minecraft.class_364;
import net.minecraft.class_403;
import net.minecraft.class_4069;
import net.minecraft.class_410;
import net.minecraft.class_437;
import net.minecraft.class_5244;
import net.minecraft.class_5375;
import net.minecraft.class_7919;
import net.minecraft.class_8016;
import net.minecraft.class_8021;
import net.minecraft.class_8132;
import net.minecraft.class_8667;
import net.minecraft.class_8669;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PackedPacksScreen
extends PackListEventHandler
implements ToggleableDialogContainer,
ContextMenuContainer,
Restorable<Snapshot> {
    private static final class_2561 ACTION_BAR_INFO = ResourceUtil.getText("toggle_actionbar.info", new Object[0]);
    private static final class_2561 ORIGINAL_SCREEN_INFO = ResourceUtil.getText("original_screen.info", new Object[0]);
    private static final class_2561 OPTIONS_TEXT = ResourceUtil.getText("options.title", new Object[0]);
    private static final class_2561 OPEN_FOLDER_TEXT = class_2561.method_43471((String)"pack.openFolder");
    private static final class_2561 OPEN_FOLDER_INFO_TEXT = class_2561.method_43471((String)"pack.folderInfo");
    private static final class_2561 APPLY_TEXT = ResourceUtil.getText("apply", new Object[0]);
    private static final class_2561 REFRESH_PACKS_TEXT = ResourceUtil.getText("refresh", new Object[0]);
    private static final class_2561 RESET_ENABLED_TEXT = ResourceUtil.getText("reset_enabled", new Object[0]);
    private final class_437 previous;
    private final PackSelectionScreenArgs original;
    private final PackRepositoryHelper repository;
    private final class_8132 layout = new class_8132((class_437)this);
    private final HistoryManager<Snapshot> history = new HistoryManager();
    private final ImmediateDebouncer<String> searchListener = new ImmediateDebouncer(this::clearHistory, 250L);
    private final AvailablePacksLayout availablePacks;
    private final CurrentPacksLayout currentPacks;
    private final Config.Packs packsConfig;
    private final ProfilesLayout profiles;
    private final FolderDialog folderDialog;
    private final Modal<class_8667> options;
    private final FileRenameModal fileRenameModal;
    private final ContextMenu contextMenu;
    private final List<ToggleableDialog<?>> dialogs;
    private final List<PackList> packLists;
    private List<Path> additionalFolders;
    private CompletableFuture<Void> refreshFuture;
    private PackWatcher watcher;
    private boolean showActionBar = PackedPacks.CONFIG.isShowActionBar();
    private boolean initialized = false;

    private PackedPacksScreen(class_437 previous, PackSelectionScreenArgs original, @Nullable Profile profile, @Nullable PackGroup packs) {
        super((class_2561)ResourceUtil.getModName());
        this.previous = previous;
        this.original = original;
        this.packsConfig = PackedPacks.CONFIG.get(original.packType());
        this.profiles = new ProfilesLayout(profile, this.packsConfig, this);
        this.repository = new PackRepositoryHelper(this.original.repository(), this.original.packDir(), this.packsConfig, this.profiles::getProfile);
        this.availablePacks = new AvailablePacksLayout(this.repository, this);
        this.currentPacks = new CurrentPacksLayout(this.repository, this);
        this.options = ((Modal.Builder)((Modal.Builder)Modal.builder(this, new OptionsLayout().layout()).setBackdrop(new ColoredRect(Theme.BLACK.withAlpha(0.5f)))).setCaptureFocus(true)).build();
        this.folderDialog = FolderDialog.create(this, this.repository);
        this.fileRenameModal = new FileRenameModal(this, this.repository);
        this.contextMenu = ContextMenu.builder(this).setSpacing(8).setBackground(Theme.GRAY_800.getARGB()).setBorderColor(Theme.GRAY_500.getARGB()).build();
        this.dialogs = List.of(this.options, this.contextMenu, this.fileRenameModal, this.profiles.getSidebar(), this.folderDialog);
        this.packLists = List.of((PackList)this.folderDialog.root(), this.availablePacks.getList(), this.currentPacks.getList());
        for (int i = 0; i < this.dialogs.size(); ++i) {
            this.dialogs.get(i).setZ(this.dialogs.size() - i);
        }
        this.initAdditionalFolders();
        if (profile != null) {
            this.applyProfile(profile);
        } else if (packs == null) {
            this.useSelected();
        } else {
            this.applyPacks((List<class_3288>)packs.unselected(), (List<class_3288>)packs.selected());
        }
    }

    public PackedPacksScreen(class_437 previous, PackSelectionScreenArgs original) {
        this(previous, original, null, null);
    }

    public PackedPacksScreen(class_437 previous, PackSelectionScreenArgs original, Profile profile) {
        this(previous, original, profile, null);
    }

    public PackedPacksScreen(class_437 previous, PackSelectionScreenArgs original, PackGroup packs) {
        this(previous, original, null, packs);
    }

    public void method_49589() {
        if (this.initialized) {
            this.refreshPacks();
            this.initAdditionalFolders();
            this.createWatcher();
        }
    }

    public void method_25432() {
        this.closeWatcher();
        this.syncProfile(this.profiles.getProfile());
        PackedPacks.CONFIG.save();
        Preferences.INSTANCE.save();
    }

    protected void method_25426() {
        if (this.initialized) {
            return;
        }
        this.layout.method_48992((class_8021)this.createHeader());
        this.layout.method_48999((class_8021)this.createContents());
        this.layout.method_48996((class_8021)this.createFooter());
        ((FolderPackList)this.folderDialog.root()).method_48206(this.folderDialog::addRenderableWidget);
        this.profiles.initContents();
        this.profiles.getSidebar().getCloseButton().addListener(() -> this.method_56131());
        ((LayoutWrapper)((Object)this.options.root())).method_48206(this.options::addRenderableWidget);
        this.method_25429((class_364)this.options);
        this.method_25429((class_364)this.contextMenu);
        this.method_25429((class_364)this.fileRenameModal);
        this.method_25429((class_364)this.profiles.getSidebar());
        this.method_25429((class_364)this.folderDialog);
        this.layout.method_48206(x$0 -> {
            class_339 cfr_ignored_0 = (class_339)this.method_37063((class_364)x$0);
        });
        this.method_37060(this.folderDialog);
        this.method_37060(this.profiles.getSidebar());
        this.method_37060(this.fileRenameModal);
        this.method_37060(this.contextMenu);
        this.method_37060(this.options);
        this.clearHistory();
        this.method_48640();
        this.refreshPacks();
        this.createWatcher();
        this.initialized = true;
    }

    private FlexLayout createHeader() {
        class_5375 s;
        FlexLayout header = FlexLayout.horizontal(this::getMaxWidth).spacing(8);
        boolean devMode = PackedPacks.CONFIG.isDevMode();
        header.addChild(((FidgetzButton.Builder)((FidgetzButton.Builder)((FidgetzButton.Builder)((FidgetzButton.Builder)((FidgetzButton.Builder)FidgetzButton.builder().makeSquare()).setMessage(ProfilesLayout.TITLE_TEXT)).setTooltip(class_7919.method_47407((class_2561)ProfilesLayout.TITLE_TEXT))).setSprite(GuiConstants.HAMBURGER_SPRITE)).setOnPress(this.profiles.getSidebar()::toggle)).build());
        if (devMode || Preferences.INSTANCE.actionBarWidget.get().booleanValue()) {
            header.addChild(((FidgetzButton.Builder)((FidgetzButton.Builder)((FidgetzButton.Builder)((FidgetzButton.Builder)Toggleable.applyPref(Preferences.INSTANCE.actionBarWidget, FidgetzButton.builder()).makeSquare()).setTooltip(class_7919.method_47407((class_2561)ACTION_BAR_INFO))).setSprite(new Sprite(ResourceUtil.getIcon("filter"), Size.of16()))).setOnPress(this::toggleActionBar)).build());
        }
        header.addChild(this.profiles.getToggleNameButton());
        header.addFlexChild(this.profiles.getNameField());
        class_437 class_4372 = this.previous;
        class_5375 packSelectionScreen = class_4372 instanceof class_5375 ? (s = (class_5375)class_4372) : this.original.createDummy();
        ModAdditions.addToHeader(this.repository.isResourcePacks(), header, packSelectionScreen);
        if (devMode || Preferences.INSTANCE.optionsWidget.get().booleanValue()) {
            header.addChild(((FidgetzButton.Builder)((FidgetzButton.Builder)((FidgetzButton.Builder)((FidgetzButton.Builder)((FidgetzButton.Builder)Toggleable.applyPref(Preferences.INSTANCE.optionsWidget, FidgetzButton.builder()).makeSquare()).setMessage(OPTIONS_TEXT)).setTooltip(class_7919.method_47407((class_2561)OPTIONS_TEXT))).setSprite(new Sprite(ResourceUtil.getIcon("gear"), Size.of16()))).setOnPress(this.options::toggle)).build());
        }
        if (devMode || Preferences.INSTANCE.originalScreenWidget.get().booleanValue()) {
            header.addChild(((FidgetzButton.Builder)((FidgetzButton.Builder)((FidgetzButton.Builder)((FidgetzButton.Builder)Toggleable.applyPref(Preferences.INSTANCE.originalScreenWidget, FidgetzButton.builder()).makeSquare()).setTooltip(class_7919.method_47407((class_2561)ORIGINAL_SCREEN_INFO))).setSprite(new Sprite(ResourceUtil.getIcon("exit"), Size.of16()))).setOnPress(this::setOriginalScreen)).build());
        }
        return header;
    }

    private FlexLayout createContents() {
        FlexLayout contents = FlexLayout.horizontal(this::getMaxWidth).spacing(8);
        this.availablePacks.init(contents.addFlexChild(FlexLayout.vertical(() -> ((class_8132)this.layout).method_57727()).spacing(8), false));
        this.currentPacks.init(contents.addFlexChild(FlexLayout.vertical(() -> ((class_8132)this.layout).method_57727()).spacing(8), false));
        this.currentPacks.getSearchField().addListener(this.searchListener);
        this.availablePacks.getSearchField().addListener(this.searchListener);
        return contents;
    }

    private FlexLayout createFooter() {
        FlexLayout footer = FlexLayout.horizontal(this::getMaxWidth).spacing(8);
        FlexLayout firstColumn = FlexLayout.horizontal().spacing(8);
        FlexLayout secondColumn = firstColumn.copyLayout();
        firstColumn.addFlexChild(((FidgetzButton.Builder)((FidgetzButton.Builder)((FidgetzButton.Builder)FidgetzButton.builder().setMessage(OPEN_FOLDER_TEXT)).setTooltip(class_7919.method_47407((class_2561)OPEN_FOLDER_INFO_TEXT))).setOnPress(this.repository::openDir)).build());
        if (this.repository.isResourcePacks()) {
            secondColumn.addFlexChild(((FidgetzButton.Builder)((FidgetzButton.Builder)FidgetzButton.builder().setMessage(APPLY_TEXT)).setOnPress(this::commit)).build());
        }
        secondColumn.addFlexChild(((FidgetzButton.Builder)((FidgetzButton.Builder)FidgetzButton.builder().setMessage(class_5244.field_24334)).setOnPress(this::method_25419)).build());
        footer.addFlexChild(firstColumn);
        footer.addFlexChild(secondColumn);
        return footer;
    }

    public int getMaxWidth() {
        return this.field_22789 - 16;
    }

    protected void method_41843() {
        PackedPacksScreen screen;
        if (this.field_22787 == null) {
            return;
        }
        Profile profile = this.profiles.getProfile();
        if (profile != null) {
            profile.setPacks((Collection<class_3288>)((CurrentPackList)this.currentPacks.getList()).copyFlattenedPacks());
            screen = new PackedPacksScreen(this.previous, this.original, profile);
        } else {
            PackGroup packs = PackGroup.of(((CurrentPackList)this.currentPacks.getList()).copyPacks(), ((AvailablePackList)this.availablePacks.getList()).copyPacks());
            screen = new PackedPacksScreen(this.previous, this.original, packs);
        }
        this.field_22787.method_1507((class_437)screen);
    }

    public void method_29638(List<Path> packs) {
        if (this.field_22787 != null) {
            this.field_22787.method_1507((class_437)new class_410(this.confirmFileDrop(packs), (class_2561)class_2561.method_43471((String)"pack.dropConfirm"), (class_2561)class_2561.method_43470((String)PackUtil.joinPackNames(packs))));
        }
    }

    private BooleanConsumer confirmFileDrop(List<Path> packs) {
        return confirmed -> {
            if (this.field_22787 == null) {
                return;
            }
            if (!confirmed) {
                this.field_22787.method_1507((class_437)this);
                return;
            }
            PackUtil.PathValidationResults results = PackUtil.validatePaths(packs);
            if (!results.symlinkWarnings().isEmpty()) {
                this.field_22787.method_1507(class_8669.method_52750(() -> this.field_22787.method_1507((class_437)this)));
                return;
            }
            if (!results.valid().isEmpty()) {
                class_5375.method_29669((class_310)this.field_22787, results.valid(), (Path)this.original.packDir());
                this.refreshPacks();
            }
            if (!results.rejected().isEmpty()) {
                String rejectedNames = PackUtil.joinPackNames(results.rejected());
                this.field_22787.method_1507((class_437)new class_403(() -> this.field_22787.method_1507((class_437)this), (class_2561)class_2561.method_43471((String)"pack.dropRejected.title"), (class_2561)class_2561.method_43469((String)"pack.dropRejected.message", (Object[])new Object[]{rejectedNames})));
                return;
            }
            this.field_22787.method_1507((class_437)this);
        };
    }

    private void setOriginalScreen() {
        if (this.previous instanceof class_5375) {
            this.method_25419();
        } else if (this.field_22787 != null) {
            class_5375 originalScreen = this.original.createScreen();
            ((PackSelectionScreenAccessor)originalScreen).packed_packs$setPrevious(this.previous);
            this.field_22787.method_1507((class_437)originalScreen);
        }
    }

    public void method_25419() {
        Config.Packs packs;
        if (this.field_22787 == null) {
            return;
        }
        String commitRequestor = ModAdditions.shouldCommit(this.repository.isResourcePacks());
        if (commitRequestor != null) {
            this.commit();
            PackedPacks.LOGGER.info("[packed_packs] Commiting packs on close at the request of mod '{}'.", (Object)commitRequestor);
        } else {
            Config.ResourcePacks resourceConfig;
            packs = this.packsConfig;
            if (!(packs instanceof Config.ResourcePacks) || (resourceConfig = (Config.ResourcePacks)packs).isApplyOnClose()) {
                this.commit();
            }
        }
        if (!this.repository.isResourcePacks() && !(this.previous instanceof class_5375)) {
            this.original.output().accept(this.repository.getRepository());
            return;
        }
        packs = this.previous;
        if (packs instanceof PackSelectionScreenAccessor) {
            PackSelectionScreenAccessor packScreen = (PackSelectionScreenAccessor)((Object)packs);
            ((PackSelectionModelAccessor)packScreen.getModel()).packed_packs$reset();
            packScreen.invokeReload();
        }
        this.field_22787.method_1507(this.previous);
    }

    public void method_25393() {
        if (this.watcher != null) {
            this.watcher.poll();
        }
    }

    private void createWatcher() {
        if (this.watcher == null) {
            try {
                List<Path> paths = CollectionsUtil.mutableListOf(this.repository.getBaseDir());
                paths.addAll(this.additionalFolders);
                this.watcher = new PackWatcher(paths, this::refreshPacks);
            }
            catch (Exception e) {
                PackedPacks.LOGGER.error("[packed_packs] Failed to initialize pack directory watcher.", (Throwable)e);
                this.closeWatcher();
            }
        }
    }

    private void closeWatcher() {
        if (this.watcher != null) {
            this.watcher.close();
            this.watcher = null;
        }
    }

    private void initAdditionalFolders() {
        this.additionalFolders = CollectionsUtil.deduplicate(CollectionsUtil.addAll(PackUtil.mapValidDirectories(this.packsConfig.getAdditionalFolders()), this.repository.getAdditionalDirs()));
    }

    private void repositionLists() {
        this.availablePacks.setHeaderVisibility(this.showActionBar);
        this.currentPacks.setHeaderVisibility(this.showActionBar);
    }

    protected void method_48640() {
        this.layout.method_48222();
        ((HeaderAndFooterLayoutAccess)this.layout).getContentsFrame().method_46419(this.layout.method_48998());
        this.profiles.getSidebar().repositionElements();
        this.options.repositionElements();
        this.fileRenameModal.repositionElements();
        this.contextMenu.setOpen(false);
        this.repositionLists();
    }

    public void toggleActionBar() {
        this.showActionBar = !this.showActionBar;
        PackedPacks.CONFIG.setShowActionBar(this.showActionBar);
        this.repositionLists();
    }

    public void commit() {
        this.currentPacks.getSearchField().method_1852("");
        this.syncProfile(this.profiles.getProfile());
        this.repository.selectPacks((List<class_3288>)((CurrentPackList)this.currentPacks.getList()).copyPacks());
        if (this.repository.isResourcePacks()) {
            this.original.output().accept(this.repository.getRepository());
        }
    }

    private void replacePacks(PackList list, ImmutableList<class_3288> packs) {
        list.replaceState(new PackList.Snapshot(list, packs, list.copySelection(), list.copyQuery()));
    }

    private void revalidateFolder() {
        if (this.folderDialog.isOpen()) {
            FolderPack folderPack = this.folderDialog.getFolderPack();
            if (folderPack == null || this.repository.getFolderConfig(folderPack) == null) {
                this.folderDialog.setOpen(false);
            } else {
                this.replacePacks((PackList)this.folderDialog.root(), (ImmutableList<class_3288>)ImmutableList.copyOf(this.repository.getNestedPacks(folderPack)));
            }
        }
    }

    public void revalidatePacks() {
        Object availableList = this.availablePacks.getList();
        Object currentList = this.currentPacks.getList();
        PackGroup packs = this.repository.validatePacks((List<class_3288>)availableList.copyPacks(), (List<class_3288>)currentList.copyPacks());
        this.repository.clearIconCache();
        this.replacePacks((PackList)availableList, packs.unselected());
        this.replacePacks((PackList)currentList, packs.selected());
        this.revalidateFolder();
        this.clearHistory();
    }

    public void refreshPacks() {
        this.refreshFuture = CompletableFuture.runAsync(this.repository::refresh, (Executor)class_156.method_18349()).thenRunAsync(this::revalidatePacks, (Executor)this.field_22787);
    }

    public void reset() {
        PackGroup packs = this.repository.getPacksByRequirement();
        ((AvailablePackList)this.availablePacks.getList()).reload((Collection<class_3288>)packs.unselected());
        ((CurrentPackList)this.currentPacks.getList()).reload((Collection<class_3288>)packs.selected());
        this.clearHistory();
    }

    public void useSelected() {
        PackGroup packs = this.repository.getPacksBySelected();
        ((AvailablePackList)this.availablePacks.getList()).reload((Collection<class_3288>)packs.unselected());
        ((CurrentPackList)this.currentPacks.getList()).reload((Collection<class_3288>)packs.selected());
        this.clearHistory();
    }

    public void resetToEnabled() {
        this.onEvent(new BasicEvent(true));
        this.useSelected();
    }

    public void onProfileChange(@Nullable Profile previous, @Nullable Profile current) {
        if (previous != null) {
            previous.setPacks((Collection<class_3288>)((CurrentPackList)this.currentPacks.getList()).copyFlattenedPacks());
        }
        if (current == null) {
            this.useSelected();
        } else if (!current.getPackIds().isEmpty()) {
            this.applyProfile(current);
        } else {
            this.reset();
        }
        boolean unlocked = current == null || !current.isLocked();
        this.availablePacks.getSearchField().method_1852("");
        this.availablePacks.getTransferButton().field_22763 = unlocked;
        this.currentPacks.getSearchField().method_1852("");
        this.currentPacks.getTransferButton().field_22763 = unlocked;
        this.method_48640();
    }

    public void onProfileCopy(@Nullable Profile original, @NotNull Profile copy) {
        copy.setPacks((Collection<class_3288>)((CurrentPackList)this.currentPacks.getList()).copyFlattenedPacks());
    }

    private void applyProfile(@NotNull Profile profile) {
        ImmutableList<class_3288> available = ((AvailablePackList)this.availablePacks.getList()).copyPacks();
        List<class_3288> current = this.repository.getPacksByFlattenedIds(profile.getPackIds());
        this.applyPacks((List<class_3288>)available, current);
    }

    private void applyPacks(List<class_3288> available, List<class_3288> current) {
        PackGroup packs = this.repository.validatePacks(available, current);
        ((AvailablePackList)this.availablePacks.getList()).reload((Collection<class_3288>)packs.unselected());
        ((CurrentPackList)this.currentPacks.getList()).reload((Collection<class_3288>)packs.selected());
        this.clearHistory();
    }

    public void syncProfile(@Nullable Profile profile) {
        if (profile != null) {
            profile.syncPacks((Collection<class_3288>)this.repository.getFlattenedPacks(), (Collection<class_3288>)((CurrentPackList)this.currentPacks.getList()).copyFlattenedPacks());
        }
    }

    private boolean isUnlocked() {
        Profile profile = this.profiles.getProfile();
        return profile == null || !profile.isLocked();
    }

    @Override
    @NotNull
    public List<PackList> getPackLists() {
        return this.packLists;
    }

    @Override
    @Nullable
    public PackList getDestination(PackList source) {
        if (source == this.availablePacks.getList()) {
            return this.currentPacks.getList();
        }
        if (source == this.currentPacks.getList()) {
            return this.availablePacks.getList();
        }
        return null;
    }

    @Override
    protected void transferFocus(PackList source, PackList destination) {
        super.transferFocus(source, destination);
        if (destination == this.currentPacks.getList()) {
            ((CurrentPackList)this.currentPacks.getList()).scrollToLastSelected();
        }
    }

    private void onFolderOpen(FolderOpenEvent event) {
        ((FolderPackList)this.folderDialog.root()).reload(this.repository.getNestedPacks(event.opened()));
        this.folderDialog.updateFolder(event.target(), event.opened(), this.repository);
        this.folderDialog.setOpen(true);
    }

    private void onFolderClose(FolderCloseEvent event) {
        this.folderDialog.setOpen(false);
        FolderPack folderPack = event.folderPack();
        if (folderPack == null) {
            return;
        }
        Folder folder = this.repository.getFolderConfig(folderPack);
        if (folder != null && this.isUnlocked()) {
            if (folder.trySetPacks(this.repository.validateAndOrderNestedPacks(folderPack, (List<class_3288>)event.target().copyPacks()))) {
                folderPack.saveConfig(folder);
            }
            this.focusList(ObjectsUtil.firstNonNullOrDefault(this.availablePacks.getList(), this.folderDialog.getParent()));
        }
    }

    private void onFileRename(FileRenameEvent event) {
        if (this.folderDialog.isOpen()) {
            this.folderDialog.onRename(event.renamed(), event.newName());
        }
        this.refreshPacks();
    }

    @Override
    protected void handleMoveEvent(MoveEvent event) {
        if (event.target() != this.folderDialog.root()) {
            super.handleMoveEvent(event);
            return;
        }
        PackList.Entry entry = event.target().getEntry(event.trigger());
        if (entry != null) {
            this.focus(class_8016.method_48194((class_364)entry, (class_4069[])new class_4069[]{event.target(), this.folderDialog, this}));
        } else {
            this.focus(class_8016.method_48194((class_364)event.target(), (class_4069[])new class_4069[]{this.folderDialog, this}));
        }
    }

    @Override
    public void onEvent(PackListEvent event) {
        boolean notFolderDialogEvent;
        super.onEvent(event);
        this.profiles.getSidebar().setOpen(false);
        this.contextMenu.setOpen(false);
        this.fileRenameModal.setOpen(false);
        boolean bl = notFolderDialogEvent = event.target() != this.folderDialog.root();
        if (notFolderDialogEvent) {
            this.folderDialog.setOpen(false);
        }
        PackListEvent packListEvent = event;
        Objects.requireNonNull(packListEvent);
        PackListEvent packListEvent2 = packListEvent;
        int n = 0;
        switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{FileDeleteEvent.class, FileRenameOpenEvent.class, FileRenameEvent.class, FileRenameCloseEvent.class, FolderOpenEvent.class, FolderCloseEvent.class}, (Object)packListEvent2, n)) {
            case 0: {
                FileDeleteEvent ignore = (FileDeleteEvent)packListEvent2;
                this.revalidatePacks();
                break;
            }
            case 1: {
                FileRenameOpenEvent e = (FileRenameOpenEvent)packListEvent2;
                this.fileRenameModal.open(e.target(), e.trigger());
                break;
            }
            case 2: {
                FileRenameEvent e = (FileRenameEvent)packListEvent2;
                this.onFileRename(e);
                break;
            }
            case 3: {
                FileRenameCloseEvent e = (FileRenameCloseEvent)packListEvent2;
                this.focusList(e.target());
                break;
            }
            case 4: {
                FolderOpenEvent e = (FolderOpenEvent)packListEvent2;
                this.onFolderOpen(e);
                break;
            }
            case 5: {
                FolderCloseEvent e = (FolderCloseEvent)packListEvent2;
                this.onFolderClose(e);
                break;
            }
        }
        if (event.pushToHistory() && notFolderDialogEvent) {
            this.history.push(this.captureState());
        }
    }

    @Nullable
    public PackLayout<?> getLayoutFromSelectedList() {
        return ObjectsUtil.firstNonNull(ObjectsUtil.pick(this.availablePacks, this.currentPacks, pl -> pl.getList() == this.method_25399()), ObjectsUtil.pick(this.availablePacks, this.currentPacks, pl -> ((PackListBase)pl.getList()).method_49606()), ObjectsUtil.pick(this.availablePacks, this.currentPacks, pl -> pl.getList().method_25370()));
    }

    public ToggleableEditBox<Void> focusSearchField(@NotNull PackLayout<?> packLayout) {
        if (!this.showActionBar) {
            this.toggleActionBar();
        }
        ToggleableEditBox<Void> searchField = packLayout.getSearchField();
        this.focus((class_364)searchField);
        return searchField;
    }

    @Override
    public boolean method_25400(char codePoint, int modifiers) {
        PackLayout<?> packLayout;
        if (super.method_25400(codePoint, modifiers)) {
            return true;
        }
        if (codePoint != ' ' && InputUtil.noModifiers(modifiers) && (packLayout = this.getLayoutFromSelectedList()) != null && !packLayout.getSearchField().method_25370()) {
            return this.focusSearchField(packLayout).method_25400(codePoint, modifiers);
        }
        return false;
    }

    public void toggleDevMode() {
        PackedPacks.CONFIG.setDevMode(!PackedPacks.CONFIG.isDevMode());
        ToastUtil.onDevModeToggleToast(PackedPacks.CONFIG.isDevMode());
        this.method_41843();
    }

    @Override
    public boolean method_25404(int keyCode, int scanCode, int modifiers) {
        ToggleableEditBox<Void> searchField;
        PackLayout<?> packLayout;
        this.contextMenu.setOpen(false);
        if (InputUtil.isDeveloperMode(keyCode, modifiers)) {
            this.toggleDevMode();
            return true;
        }
        if (InputUtil.isRefresh(keyCode, modifiers) && (this.refreshFuture == null || this.refreshFuture.isDone())) {
            this.refreshPacks();
            return true;
        }
        if (super.method_25404(keyCode, scanCode, modifiers)) {
            return true;
        }
        if (InputUtil.isRedo(keyCode, modifiers)) {
            return this.history.redo();
        }
        if (InputUtil.isUndo(keyCode, modifiers)) {
            return this.history.undo();
        }
        if (keyCode == 259 && (packLayout = this.getLayoutFromSelectedList()) != null && !(searchField = packLayout.getSearchField()).method_25370() && !searchField.method_1882().isEmpty()) {
            return this.focusSearchField(packLayout).method_25404(keyCode, scanCode, modifiers);
        }
        return false;
    }

    private boolean hasHeader(List<MenuItem> items) {
        return !items.isEmpty() && items.getFirst() instanceof PackMenuHeader;
    }

    private void openContextMenu(int mouseX, int mouseY) {
        if (this.contextMenu.method_25405(mouseX, mouseY)) {
            return;
        }
        ((ContextMenuItemBuilder.PredicateChain)this.buildItems(mouseX, mouseY).when(PackedPacks.CONFIG.isDevMode()).ifTrue(dev -> dev.separatorIfNonEmpty().whenNonNull(this.profiles.getProfile()).ifTrue((profile, b) -> b.add(GuiConstants.devItem((class_2561)ResourceUtil.getText("profile.save", new Object[0])).action(() -> profile.setPacks((Collection<class_3288>)((CurrentPackList)this.currentPacks.getList()).copyFlattenedPacks())).build()).separator()).add(GuiConstants.devItem((class_2561)ResourceUtil.getText("preferences", new Object[0])).addChildren(Toggleable.preferences()).addChild(GuiConstants.devItem((class_2561)ResourceUtil.getText("preferences.reset", new Object[0])).action(Preferences.INSTANCE::reset).build()).build())).separatorIfNonEmpty().simpleItem(RESET_ENABLED_TEXT, this::isUnlocked, this::resetToEnabled).simpleItem(REFRESH_PACKS_TEXT, this::canRefresh, this::refreshPacks).when(this.additionalFolders, List::isEmpty).ifTrue(b -> b.simpleItem(OPEN_FOLDER_TEXT, this.repository::openDir))).ifFalse((dirs, b) -> b.parent(OPEN_FOLDER_TEXT, p -> p.add(new DirectoryMenuItem(this.repository.getBaseDir())).separator().addAll(dirs.stream().map(DirectoryMenuItem::new).toList()))).peek(items -> {
            int yOffset = this.hasHeader((List<MenuItem>)items) ? this.contextMenu.getItemHeight() : 0;
            this.contextMenu.open(mouseX, mouseY - yOffset, (List<MenuItem>)items);
        });
    }

    @Override
    public boolean method_25402(double mouseX, double mouseY, int button) {
        this.setDragged(null);
        if (InputUtil.isRightClick(button) && !this.options.method_25405(mouseX, mouseY)) {
            this.openContextMenu((int)mouseX, (int)mouseY);
            return true;
        }
        if (ToggleableDialogContainer.super.method_25402(mouseX, mouseY, button)) {
            return true;
        }
        if (InputUtil.isClickForward(button)) {
            return this.history.redo();
        }
        if (InputUtil.isClickBack(button)) {
            return this.history.undo();
        }
        if (InputUtil.isLeftClick(button) && !(this.method_25399() instanceof PackList)) {
            this.method_25395((class_364)this.method_25396().getFirst());
            this.layout.method_48206(w -> w.method_25365(false));
        }
        this.contextMenu.setOpen(false);
        return false;
    }

    @Override
    public List<ToggleableDialog<?>> getDialogs() {
        return this.dialogs;
    }

    @Override
    public void method_25394(class_332 guiGraphics, int mouseX, int mouseY, float partialTick) {
        super.method_25394(guiGraphics, mouseX, mouseY, partialTick);
        if (PackedPacks.CONFIG.isDevMode()) {
            float scale = 0.5f;
            float f = this.field_22790;
            Objects.requireNonNull(this.field_22793);
            int y = (int)((f - 9.0f * scale) / scale);
            guiGraphics.method_51448().method_22903();
            guiGraphics.method_51448().method_22905(scale, scale, 0.0f);
            guiGraphics.method_27535(this.field_22793, (class_2561)ResourceUtil.getText("dev_mode", "CTRL + SHIFT + I"), 0, y, Theme.WHITE.getARGB());
            guiGraphics.method_51448().method_22909();
        }
    }

    public boolean canRefresh() {
        return this.refreshFuture == null || this.refreshFuture.isDone();
    }

    public void clearHistory() {
        this.history.reset(this.captureState());
    }

    @Override
    @NotNull
    public Snapshot captureState() {
        return new Snapshot(this, ((AvailablePackList)this.availablePacks.getList()).captureState(), ((CurrentPackList)this.currentPacks.getList()).captureState());
    }

    @Override
    public void replaceState(@NotNull Snapshot snapshot) {
        List<class_3288> validPacks = this.repository.getPacks();
        this.availablePacks.getSortButton().setValueSilently(snapshot.availablePacks.query().getSort());
        this.availablePacks.getCompatButton().setValueSilently(snapshot.availablePacks.query().isHideIncompatible());
        snapshot.availablePacks.validate(validPacks).restore();
        snapshot.currentPacks.validate(validPacks).restore();
        ((AvailablePackList)this.availablePacks.getList()).scrollToLastSelected();
        ((CurrentPackList)this.currentPacks.getList()).scrollToLastSelected();
    }

    public static final class Snapshot
    extends Record
    implements Restorable.Snapshot<Snapshot> {
        private final PackedPacksScreen target;
        private final PackList.Snapshot availablePacks;
        private final PackList.Snapshot currentPacks;

        public Snapshot(PackedPacksScreen target, PackList.Snapshot availablePacks, PackList.Snapshot currentPacks) {
            this.target = target;
            this.availablePacks = availablePacks;
            this.currentPacks = currentPacks;
        }

        @Override
        public final String toString() {
            return ObjectMethods.bootstrap("toString", new MethodHandle[]{Snapshot.class, "target;availablePacks;currentPacks", "target", "availablePacks", "currentPacks"}, this);
        }

        @Override
        public final int hashCode() {
            return (int)ObjectMethods.bootstrap("hashCode", new MethodHandle[]{Snapshot.class, "target;availablePacks;currentPacks", "target", "availablePacks", "currentPacks"}, this);
        }

        @Override
        public final boolean equals(Object o) {
            return (boolean)ObjectMethods.bootstrap("equals", new MethodHandle[]{Snapshot.class, "target;availablePacks;currentPacks", "target", "availablePacks", "currentPacks"}, this, o);
        }

        public PackedPacksScreen target() {
            return this.target;
        }

        public PackList.Snapshot availablePacks() {
            return this.availablePacks;
        }

        public PackList.Snapshot currentPacks() {
            return this.currentPacks;
        }
    }
}

