/*
 * Decompiled with CFR 0.152.
 */
package io.github.fishstiz.packed_packs.pack;

import io.github.fishstiz.packed_packs.config.Config;
import io.github.fishstiz.packed_packs.config.PackOptions;
import io.github.fishstiz.packed_packs.config.Profile;
import java.util.Objects;
import java.util.function.BiFunction;
import java.util.function.BiPredicate;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;
import net.minecraft.class_3288;
import net.minecraft.class_9225;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public record PackOptionsResolver(Supplier<@Nullable Profile> profileSupplier, Config.Packs config) implements PackOptions
{
    public PackOptionsResolver(Config.Packs config) {
        this(() -> null, config);
    }

    @Override
    public boolean isHidden(class_3288 pack) {
        return Boolean.TRUE.equals(this.inDefaultOrSelected(pack, Profile::isHidden, Profile::isHidden));
    }

    @Override
    public boolean isRequired(class_3288 pack) {
        return Boolean.TRUE.equals(this.inDefaultOrSelected(pack, Profile::overridesRequired, Profile::isRequired));
    }

    @Override
    public boolean isFixed(class_3288 pack) {
        return Boolean.TRUE.equals(this.inDefaultOrSelected(pack, Profile::overridesPosition, Profile::isFixed));
    }

    @Override
    @Nullable
    public class_3288.class_3289 getPosition(class_3288 pack) {
        return this.inDefaultOrSelected(pack, Profile::overridesPosition, Profile::getPosition);
    }

    @Override
    @Nullable
    public class_9225 getSelectionConfig(class_3288 pack) {
        return this.inDefaultOrSelected(pack, (profile, p) -> profile.overridesPosition((class_3288)p) || profile.overridesRequired((class_3288)p), Profile::getSelectionConfig);
    }

    public boolean isRequiredOrDefault(class_3288 pack) {
        return this.inDefaultOrSelected(pack, Profile::overridesRequired, Profile::isRequired, class_3288::method_14464);
    }

    public boolean isFixedOrDefault(class_3288 pack) {
        return this.inDefaultOrSelected(pack, Profile::overridesPosition, Profile::isFixed, class_3288::method_14465);
    }

    @NotNull
    public class_3288.class_3289 getPositionOrDefault(class_3288 pack) {
        return Objects.requireNonNull(this.inDefaultOrSelected(pack, Profile::overridesPosition, Profile::getPosition, class_3288::method_14466));
    }

    @NotNull
    public class_9225 getSelectionConfigOrDefault(class_3288 pack) {
        return Objects.requireNonNull(this.getOrDefault(pack, PackOptions::getSelectionConfig, Objects::nonNull, class_3288::method_56934));
    }

    public boolean overridesRequired(class_3288 pack) {
        return this.hasOverride(pack, Profile::overridesRequired);
    }

    public boolean overridesPosition(class_3288 pack) {
        return this.hasOverride(pack, Profile::overridesPosition);
    }

    private boolean hasOverride(class_3288 pack, BiPredicate<Profile, class_3288> option) {
        Profile defaultProfile = this.profileSupplier.get();
        Profile selected = this.config.getDefaultProfile();
        if (defaultProfile != null && option.test(defaultProfile, pack)) {
            return true;
        }
        return selected != null && option.test(selected, pack);
    }

    private <T> T getOrDefault(class_3288 pack, BiFunction<PackOptions, class_3288, T> option, Predicate<T> predicate, Function<class_3288, T> defaultValue) {
        T value = option.apply(this, pack);
        return predicate.test(value) ? value : defaultValue.apply(pack);
    }

    private <T> T inDefaultOrSelected(class_3288 pack, BiPredicate<Profile, class_3288> shouldApply, BiFunction<Profile, class_3288, T> option, Function<class_3288, T> defaultValue) {
        Profile defaultProfile = this.config.getDefaultProfile();
        if (defaultProfile != null && shouldApply.test(defaultProfile, pack)) {
            return option.apply(defaultProfile, pack);
        }
        Profile selected = this.profileSupplier.get();
        if (selected != null && shouldApply.test(selected, pack)) {
            return option.apply(selected, pack);
        }
        return defaultValue.apply(pack);
    }

    @Nullable
    private <T> T inDefaultOrSelected(class_3288 pack, BiPredicate<Profile, class_3288> shouldApply, BiFunction<Profile, class_3288, T> option) {
        return (T)this.inDefaultOrSelected(pack, shouldApply, option, p -> null);
    }
}

