/*
 * Decompiled with CFR 0.152.
 */
package io.github.fishstiz.packed_packs.pack;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.google.common.util.concurrent.Runnables;
import io.github.fishstiz.packed_packs.PackedPacks;
import io.github.fishstiz.packed_packs.config.Config;
import io.github.fishstiz.packed_packs.config.Folder;
import io.github.fishstiz.packed_packs.config.Profile;
import io.github.fishstiz.packed_packs.pack.PackAssets;
import io.github.fishstiz.packed_packs.pack.PackGroup;
import io.github.fishstiz.packed_packs.pack.PackOptionsResolver;
import io.github.fishstiz.packed_packs.pack.folder.FolderPack;
import io.github.fishstiz.packed_packs.transform.interfaces.FilteredPackSelectionModel;
import io.github.fishstiz.packed_packs.transform.interfaces.IPack;
import io.github.fishstiz.packed_packs.transform.mixin.PackSelectionModelAccessor;
import io.github.fishstiz.packed_packs.transform.mixin.folders.additional.FolderRepositorySourceAccessor;
import io.github.fishstiz.packed_packs.transform.mixin.folders.additional.PackRepositoryAccessor;
import io.github.fishstiz.packed_packs.util.PackUtil;
import io.github.fishstiz.packed_packs.util.lang.CollectionsUtil;
import it.unimi.dsi.fastutil.objects.Object2ObjectLinkedOpenHashMap;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import it.unimi.dsi.fastutil.objects.ObjectOpenHashSet;
import java.nio.file.Path;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.function.Consumer;
import java.util.function.Supplier;
import net.minecraft.class_156;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_3283;
import net.minecraft.class_3288;
import net.minecraft.class_5369;
import net.minecraft.class_9225;
import org.apache.commons.lang3.function.Consumers;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PackRepositoryHelper
implements PackAssets {
    private final Map<String, class_2960> cachedIcons = new Object2ObjectOpenHashMap();
    private final Map<String, class_3288> availablePacks = new Object2ObjectLinkedOpenHashMap();
    private final Map<String, List<class_3288>> folderPacks = new Object2ObjectOpenHashMap();
    private final Map<String, CompletableFuture<Folder>> folderConfigs = new Object2ObjectOpenHashMap();
    private final PackOptionsResolver resolver;
    private final class_3283 repository;
    private final Path packDir;
    private final boolean resourcePacks;
    private class_5369 model;
    private Map<String, class_2960> staleIcons;

    public PackRepositoryHelper(class_3283 repository, Path packDir, Config.Packs config, Supplier<@Nullable Profile> profileSupplier) {
        this.resolver = new PackOptionsResolver(profileSupplier, config);
        this.repository = repository;
        this.packDir = packDir;
        this.resourcePacks = config instanceof Config.ResourcePacks;
        this.refreshModel();
        this.regenerateAvailablePacks();
    }

    public class_3283 getRepository() {
        return this.repository;
    }

    private List<class_3288> getSelectedPacks() {
        return ((PackSelectionModelAccessor)this.model).getSelectedPacks();
    }

    private List<class_3288> getUnselectedPacks() {
        return ((PackSelectionModelAccessor)this.model).getUnselectedPacks();
    }

    private void refreshModel() {
        this.model = new class_5369(Runnables.doNothing(), PackAssets::getDefaultIcon, this.repository, Consumers.nop());
        ((FilteredPackSelectionModel)this.model).packed_packs$filterHidden(false);
    }

    public List<class_3288> getPacks() {
        return List.copyOf(this.availablePacks.values());
    }

    public List<class_3288> getFlattenedPacks() {
        return this.flattenPacks(List.copyOf(this.availablePacks.values()));
    }

    public PackGroup getPacksByRequirement() {
        ObjectArrayList required = new ObjectArrayList();
        ObjectArrayList optional = new ObjectArrayList();
        for (class_3288 pack : this.availablePacks.values()) {
            if (this.isRequired(pack)) {
                this.getPosition(pack).method_14468((List)required, (Object)pack, this::getSelectionConfig, true);
                continue;
            }
            optional.add(pack);
        }
        return PackGroup.of((List<class_3288>)required, (List<class_3288>)optional);
    }

    public PackGroup getPacksBySelected() {
        return this.validateAndGroupPacks(this.getUnselectedPacks(), this.getSelectedPacks());
    }

    private void removePack(class_3288 pack) {
        this.repository.method_49428(pack.method_14463());
        this.availablePacks.remove(pack.method_14463());
        try {
            this.getSelectedPacks().remove(pack);
            this.getUnselectedPacks().remove(pack);
        }
        catch (UnsupportedOperationException e) {
            PackedPacks.LOGGER.warn("[packed_packs] Failed to mutate PackSelectionModel lists. Report this issue to mod author.");
        }
    }

    @Override
    public boolean deletePack(class_3288 pack) {
        if (!PackAssets.super.deletePack(pack)) {
            return false;
        }
        if (pack instanceof FolderPack) {
            Optional.ofNullable(this.folderPacks.get(pack.method_14463())).ifPresent(packs -> packs.forEach(this::removePack));
            this.folderPacks.remove(pack.method_14463());
            this.folderConfigs.remove(pack.method_14463());
        }
        this.removePack(pack);
        this.regenerateAvailablePacks();
        return true;
    }

    public PackGroup validateAndGroupPacks(List<class_3288> unselected, List<class_3288> selected) {
        return this.validatePacks(this.groupByFolders(unselected), this.groupByFolders(selected));
    }

    public void validateOverrides(class_3288 pack) {
        Profile profile = this.resolver.profileSupplier().get();
        if (profile == null) {
            return;
        }
        Profile defaultProfile = this.getConfig().getDefaultProfile();
        if (defaultProfile != null && defaultProfile.overridesRequired(pack)) {
            return;
        }
        if (profile.overridesRequired(pack) && !profile.isRequired(pack)) {
            profile.setRequired(null, pack);
        }
    }

    private void addValidPacks(List<class_3288> source, Set<class_3288> seen, ObjectOpenHashSet<class_3288> validPacks, List<class_3288> target) {
        for (class_3288 pack : source) {
            this.validateOverrides(pack);
            class_3288 validPack = (class_3288)validPacks.get((Object)pack);
            if (validPack == null || !seen.add(pack)) continue;
            target.add(validPack);
        }
    }

    private void addValidPacks(List<class_3288> source, Set<class_3288> seen, ObjectOpenHashSet<class_3288> validPacks, List<class_3288> targetUnselected, List<class_3288> targetSelected) {
        for (class_3288 pack : source) {
            this.validateOverrides(pack);
            class_3288 validPack = (class_3288)validPacks.get((Object)pack);
            if (validPack == null || !seen.add(pack)) continue;
            if (this.isRequired(validPack)) {
                this.getPosition(validPack).method_14468(targetSelected, (Object)validPack, this::getSelectionConfig, true);
                continue;
            }
            targetUnselected.add(validPack);
        }
    }

    public PackGroup validatePacks(List<class_3288> unselected, List<class_3288> selected) {
        ObjectOpenHashSet seen = new ObjectOpenHashSet();
        ObjectOpenHashSet validPacks = new ObjectOpenHashSet(this.availablePacks.values());
        ObjectArrayList validSelected = new ObjectArrayList(selected.size());
        ObjectArrayList validUnselected = new ObjectArrayList(unselected.size());
        this.addValidPacks(selected, (Set<class_3288>)seen, (ObjectOpenHashSet<class_3288>)validPacks, (List<class_3288>)validSelected);
        this.addValidPacks(unselected, (Set<class_3288>)seen, (ObjectOpenHashSet<class_3288>)validPacks, (List<class_3288>)validUnselected, (List<class_3288>)validSelected);
        for (class_3288 validPack : validPacks) {
            if (!seen.add(validPack)) continue;
            if (this.isRequired(validPack)) {
                this.getPosition(validPack).method_14468((List)validSelected, (Object)validPack, this::getSelectionConfig, true);
                continue;
            }
            validUnselected.add(validPack);
        }
        return PackGroup.of((List<class_3288>)validSelected, (List<class_3288>)validUnselected);
    }

    public List<class_3288> validateAndOrderNestedPacks(FolderPack folderPack, List<class_3288> orderedPacks) {
        List<class_3288> orderedValidPacks = this.folderPacks.get(folderPack.method_14463());
        ObjectOpenHashSet validPacks = new ObjectOpenHashSet(orderedValidPacks);
        ObjectOpenHashSet seen = new ObjectOpenHashSet();
        ObjectArrayList finalOrderedPacks = new ObjectArrayList();
        this.addValidPacks(orderedPacks, (Set<class_3288>)seen, (ObjectOpenHashSet<class_3288>)validPacks, (List<class_3288>)finalOrderedPacks);
        for (class_3288 validPack : orderedValidPacks) {
            if (!seen.add(validPack)) continue;
            finalOrderedPacks.add(validPack);
        }
        this.folderPacks.put(folderPack.method_14463(), (List<class_3288>)finalOrderedPacks);
        return finalOrderedPacks;
    }

    public List<class_3288> validateAndOrderNestedPackIds(FolderPack folderPack, List<String> orderedPacks) {
        return this.validateAndOrderNestedPacks(folderPack, this.getPacksById(orderedPacks, (Collection<class_3288>)this.folderPacks.get(folderPack.method_14463())));
    }

    public List<class_3288> getPacksById(Collection<String> packIds, Map<String, class_3288> source) {
        return CollectionsUtil.lookup(packIds, source);
    }

    public List<class_3288> getPacksById(Collection<String> packIds, Collection<class_3288> source) {
        return CollectionsUtil.lookup(packIds, CollectionsUtil.toMap(source, class_3288::method_14463));
    }

    public List<class_3288> getPacksById(Collection<String> packIds) {
        return this.getPacksById(packIds, this.availablePacks);
    }

    public List<class_3288> getPacksByFlattenedIds(Collection<String> packIds) {
        List folderPacks = (List)CollectionsUtil.filter(this.availablePacks.values(), FolderPack.class::isInstance, ObjectArrayList::new);
        List<class_3288> available = CollectionsUtil.addAll(folderPacks, this.repository.method_14441());
        return this.groupByFolders(this.getPacksById(packIds, available));
    }

    private void populateAvailablePacks(Collection<class_3288> packs) {
        for (class_3288 pack : packs) {
            IPack _pack = (IPack)pack;
            if (_pack.packed_packs$nestedPack()) {
                Path folderPath = Objects.requireNonNull(_pack.packed_packs$getPath()).getParent();
                String folderName = PackUtil.generatePackName(folderPath);
                String folderId = PackUtil.generatePackId(folderName);
                if (!this.availablePacks.containsKey(folderId)) {
                    FolderPack folderPack = new FolderPack(folderId, folderName, folderPath);
                    this.folderConfigs.put(folderId, folderPack.loadConfig());
                    this.availablePacks.put(folderId, folderPack);
                }
                this.folderPacks.computeIfAbsent(folderId, id -> new ObjectArrayList()).add(pack);
                continue;
            }
            this.availablePacks.put(pack.method_14463(), pack);
        }
    }

    private void regenerateAvailablePacks() {
        this.availablePacks.clear();
        this.folderPacks.clear();
        this.folderConfigs.clear();
        this.populateAvailablePacks(this.getSelectedPacks());
        this.populateAvailablePacks(this.getUnselectedPacks());
    }

    public void refresh() {
        ((PackSelectionModelAccessor)this.model).packed_packs$reset();
        this.model.method_29981();
        this.regenerateAvailablePacks();
    }

    public void selectPacks(List<class_3288> selected) {
        this.repository.method_14447((Collection)Lists.reverse(this.flattenPacks(selected)).stream().map(class_3288::method_14463).collect(ImmutableList.toImmutableList()));
        this.refreshModel();
    }

    @Override
    public List<class_3288> flattenPacks(List<class_3288> groupedPacks) {
        if (this.folderPacks.isEmpty()) {
            return groupedPacks;
        }
        ObjectArrayList flattened = new ObjectArrayList(groupedPacks);
        for (int i = flattened.size() - 1; i >= 0; --i) {
            FolderPack folderPack;
            List<class_3288> nested;
            Object e = flattened.get(i);
            if (!(e instanceof FolderPack) || (nested = this.getNestedPacks(folderPack = (FolderPack)e)) == null || nested.isEmpty()) continue;
            for (class_3288 pack : Lists.reverse(nested)) {
                flattened.add(i + 1, pack);
            }
        }
        return flattened;
    }

    public List<class_3288> groupByFolders(List<class_3288> flatPacks) {
        if (this.folderPacks.isEmpty()) {
            return flatPacks;
        }
        Object2ObjectOpenHashMap packToFolder = new Object2ObjectOpenHashMap();
        for (Map.Entry<String, List<class_3288>> entry : this.folderPacks.entrySet()) {
            for (class_3288 pack : entry.getValue()) {
                packToFolder.put(pack.method_14463(), entry.getKey());
            }
        }
        ObjectOpenHashSet seenFolders = new ObjectOpenHashSet();
        ObjectArrayList grouped = new ObjectArrayList(flatPacks.size());
        for (class_3288 pack : flatPacks) {
            String folderId = (String)packToFolder.get(pack.method_14463());
            if (folderId != null) {
                if (!seenFolders.add(folderId)) continue;
                grouped.add(this.availablePacks.get(folderId));
                continue;
            }
            grouped.add(pack);
        }
        return grouped;
    }

    public void openDir() {
        class_156.method_668().method_60932(this.packDir);
    }

    @Override
    public void getOrLoadIcon(class_3288 pack, Consumer<class_2960> iconCallback) {
        class_2960 cachedIcon;
        class_2960 staleIcon;
        if (this.staleIcons != null && (staleIcon = this.staleIcons.get(pack.method_14463())) != null) {
            iconCallback.accept(staleIcon);
        }
        if ((cachedIcon = this.cachedIcons.get(pack.method_14463())) != null) {
            iconCallback.accept(cachedIcon);
        } else {
            PackAssets.loadPackIcon(pack).thenAcceptAsync(location -> {
                this.cachedIcons.put(pack.method_14463(), (class_2960)location);
                iconCallback.accept((class_2960)location);
            }, (Executor)class_310.method_1551());
        }
    }

    public void clearIconCache() {
        this.staleIcons = new Object2ObjectOpenHashMap(this.cachedIcons);
        this.cachedIcons.clear();
    }

    @Override
    public boolean isResourcePacks() {
        return this.resourcePacks;
    }

    @Override
    public boolean isLocked() {
        Profile profile = this.resolver.profileSupplier().get();
        return profile != null && profile.isLocked();
    }

    @Override
    public boolean isEnabled(class_3288 pack) {
        ObjectOpenHashSet selectedIds = new ObjectOpenHashSet(this.repository.method_29210());
        if (pack instanceof FolderPack) {
            FolderPack folderPack = (FolderPack)pack;
            try {
                for (class_3288 nestedPack : this.getNestedPacks(folderPack)) {
                    if (!selectedIds.contains(nestedPack.method_14463())) continue;
                    return true;
                }
            }
            catch (NullPointerException nullPointerException) {
                // empty catch block
            }
            return false;
        }
        return selectedIds.contains(pack.method_14463());
    }

    @Override
    public boolean isHidden(class_3288 pack) {
        return this.resolver.isHidden(pack);
    }

    @Override
    public boolean isRequired(class_3288 pack) {
        return this.resolver.isRequiredOrDefault(pack);
    }

    @Override
    public boolean isFixed(class_3288 pack) {
        return this.resolver.isFixedOrDefault(pack);
    }

    @Override
    @NotNull
    public class_3288.class_3289 getPosition(class_3288 pack) {
        return this.resolver.getPositionOrDefault(pack);
    }

    @Override
    @NotNull
    public class_9225 getSelectionConfig(class_3288 pack) {
        return this.resolver.getSelectionConfigOrDefault(pack);
    }

    @Override
    public Config.Packs getConfig() {
        return this.resolver.config();
    }

    public Path getBaseDir() {
        return this.packDir;
    }

    public List<Path> getAdditionalDirs() {
        Path normalizedBaseDir = this.getBaseDir().toAbsolutePath().normalize();
        return ((PackRepositoryAccessor)this.repository).packed_packs$getSources().stream().filter(FolderRepositorySourceAccessor.class::isInstance).map(source -> ((FolderRepositorySourceAccessor)source).packed_packs$getFolder()).map(path -> path.toAbsolutePath().normalize()).filter(path -> !path.equals(normalizedBaseDir)).distinct().toList();
    }

    @Override
    @Nullable
    public Folder getFolderConfig(@Nullable FolderPack folderPack) {
        if (folderPack == null) {
            return null;
        }
        CompletableFuture<Folder> future = this.folderConfigs.get(folderPack.method_14463());
        return future != null ? future.join() : null;
    }

    @Override
    @Nullable
    public Profile getProfile() {
        return this.resolver.profileSupplier().get();
    }

    public List<class_3288> getNestedPacks(FolderPack folderPack) {
        return this.validateAndOrderNestedPackIds(folderPack, Objects.requireNonNull(this.getFolderConfig(folderPack)).getPackIds());
    }
}

