package io.github.fishstiz.packed_packs.compat.api;

import io.github.fishstiz.fidgetz.gui.components.contextmenu.ContextMenuItemBuilder;
import io.github.fishstiz.fidgetz.gui.layouts.FlexLayout;
import io.github.fishstiz.packed_packs.gui.components.pack.PackList;
import io.github.fishstiz.packed_packs.gui.screens.PackedPacksScreen;
import org.jetbrains.annotations.Nullable;

import java.nio.file.Path;
import net.minecraft.class_2960;
import net.minecraft.class_3264;
import net.minecraft.class_5375;

/**
 * Register entrypoint under the {@code packed_packs} key
 */
public interface ModExtension {
    /**
     * The identifier
     */
    class_2960 id();

    /**
     * @return A {@link class_2960} that this extension should load after.
     */
    default @Nullable class_2960 loadAfter() {
        return null;
    }

    /**
     * Invoked when building the header layout for the PackedPacksScreen.
     *
     * @param type     Resource or data packs.
     * @param header   The header to add widgets to.
     * @param screen   The current {@link PackedPacksScreen}.
     * @param original The original vanilla {@link class_5375}.
     */
    default void onCreateHeader(class_3264 type, FlexLayout header, PackedPacksScreen screen, class_5375 original) {
    }

    /**
     * Invoked when creating a pack entry.
     *
     * @param type  Resource or data packs.
     * @param entry The entry to modify or add widgets to.
     */
    default void onCreateEntry(class_3264 type, PackList.Entry entry) {
    }

    /**
     * Invoked when creating the context menu for preferences.
     *
     * @param builder The context menu item builder to add items to.
     */
    default void onCreatePreferencesMenu(class_3264 type, ContextMenuItemBuilder builder) {
    }

    /**
     * @param type Resource or datapacks.
     * @return {@code true} if a commit should occur when closing the screen.
     */
    default boolean forceCommitOnClose(class_3264 type) {
        return false;
    }

    /**
     * @param type Resource or datapacks.
     * @param path The changed file path.
     * @return {@code true} to ignore this change.
     */
    default boolean shouldIgnoreChange(class_3264 type, Path path) {
        return false;
    }
}
