package io.github.fishstiz.packed_packs.pack;

import io.github.fishstiz.packed_packs.PackedPacks;
import io.github.fishstiz.packed_packs.config.Config;
import io.github.fishstiz.packed_packs.config.DevConfig;
import it.unimi.dsi.fastutil.objects.ObjectOpenHashSet;
import org.jetbrains.annotations.Nullable;

import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import net.minecraft.class_3288;

/**
 * The vanilla available packs map is an immutable copy ({@link com.google.common.collect.ImmutableMap}) of a {@link TreeMap}.
 */
public class PackAliasMap extends TreeMap<String, class_3288> {
    private final DevConfig.Packs config;
    private Set<String> unresolvedIds;

    public PackAliasMap(DevConfig.Packs config, Map<String, class_3288> map) {
        super(map);
        this.config = config;
    }

    @Override
    public boolean containsKey(Object key) {
        return super.containsKey(key) || this.resolvePackId(key) != null;
    }

    /**
     * Called when rebuilding selected ids, so hopefully the resolved map is also built immediately.
     */
    @Override
    public class_3288 get(Object key) {
        class_3288 pack = super.get(key);
        if (pack != null) {
            return pack;
        }
        return this.resolvePackId(key);
    }

    private @Nullable class_3288 resolvePackId(Object key) {
        if (!(key instanceof String packId)) {
            return null;
        }
        if (this.unresolvedIds != null && this.unresolvedIds.contains(key)) {
            return null;
        }

        String resolvedPackId = this.config.getAndSaveCanonicalId(Config.get().get(this.config.packType()).getProfiles(), packId);
        if (resolvedPackId != null) {
            class_3288 resolvedPack = super.get(resolvedPackId);
            if (resolvedPack != null) {
                PackedPacks.LOGGER.info("[packed_packs] Resolved unknown pack '{}' to '{}'.", packId, resolvedPackId);
                this.put(resolvedPackId, resolvedPack);
            } else {
                PackedPacks.LOGGER.warn("[packed_packs] Unknown pack '{}' resolved to '{}', but no such pack is available.", packId, resolvedPackId);
                this.setUnresolved(packId);
            }
            return resolvedPack;
        }

        this.setUnresolved(packId);
        return null;
    }

    private void setUnresolved(String packId) {
        if (this.unresolvedIds == null) {
            this.unresolvedIds = new ObjectOpenHashSet<>();
        }
        this.unresolvedIds.add(packId);
    }
}
