package io.github.fishstiz.packed_packs.config;

import com.google.gson.*;
import io.github.fishstiz.packed_packs.PackedPacks;
import io.github.fishstiz.packed_packs.transform.interfaces.ConfiguredPack;
import org.jetbrains.annotations.Nullable;

import java.io.Serializable;
import java.lang.reflect.Type;
import net.minecraft.class_3288;

public final class PackOverride implements Serializable {
    /**
     * @deprecated remove on stable release. from fixed -> position.
     */
    @Deprecated(forRemoval = true)
    private static final String FIXED_DEPRECATED_SERIALIZED_NAME = "fixed";
    private static final String HIDDEN_SERIALIZED_NAME = "hidden";
    private static final String REQUIRED_SERIALIZED_NAME = "required";
    private static final String POSITION_SERIALIZED_NAME = "position";
    private @Nullable Boolean hidden;
    private @Nullable Boolean required;
    private @Nullable Position position;

    public PackOverride() {
    }

    public PackOverride(@Nullable Boolean hidden, @Nullable Boolean required, @Nullable PackOverride.Position position) {
        this.hidden = hidden;
        this.required = required;
        this.position = position;
    }

    public boolean hasOverride() {
        return this.hidden != null || this.required != null || this.position != null;
    }

    public @Nullable Boolean hidden() {
        return hidden;
    }

    void setHidden(@Nullable Boolean hidden) {
        this.hidden = hidden;
    }

    public @Nullable Boolean required() {
        return required;
    }

    void setRequired(@Nullable Boolean required) {
        this.required = required;
    }

    public @Nullable Position position() {
        return position;
    }

    void setPosition(@Nullable Position position) {
        this.position = position;
    }

    public enum Position {
        UNFIXED(null),
        TOP(class_3288.class_3289.field_14280),
        BOTTOM(class_3288.class_3289.field_14281);

        private final class_3288.class_3289 position;

        Position(class_3288.class_3289 position) {
            this.position = position;
        }

        public boolean fixed() {
            return this != UNFIXED;
        }

        class_3288.class_3289 get(class_3288 pack) {
            return this.fixed() ? this.position : ((ConfiguredPack) pack).packed_packs$originalConfig().comp_2334();
        }
    }

    static class Adapter implements JsonSerializer<PackOverride>, JsonDeserializer<PackOverride> {
        @Override
        public JsonElement serialize(PackOverride src, Type typeOfSrc, JsonSerializationContext context) {
            if (!src.hasOverride()) {
                throw new IllegalStateException("Cannot serialize pack override with no override.");
            }

            JsonObject obj = new JsonObject();
            if (src.hidden() != null) obj.addProperty(HIDDEN_SERIALIZED_NAME, src.hidden());
            if (src.required() != null) obj.addProperty(REQUIRED_SERIALIZED_NAME, src.required());
            if (src.position() != null) obj.addProperty(POSITION_SERIALIZED_NAME, src.position().name());
            return obj;
        }

        @Override
        public PackOverride deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
            JsonObject obj = json.getAsJsonObject();

            Boolean hidden = obj.has(HIDDEN_SERIALIZED_NAME) ? obj.get(HIDDEN_SERIALIZED_NAME).getAsBoolean() : null;
            Boolean required = obj.has(REQUIRED_SERIALIZED_NAME) ? obj.get(REQUIRED_SERIALIZED_NAME).getAsBoolean() : null;
            Position fixed = null;
            if (obj.has(POSITION_SERIALIZED_NAME) || obj.has(FIXED_DEPRECATED_SERIALIZED_NAME)) {
                String position = obj.has(POSITION_SERIALIZED_NAME)
                        ? obj.get(POSITION_SERIALIZED_NAME).getAsString()
                        : obj.get(FIXED_DEPRECATED_SERIALIZED_NAME).getAsString();

                try {
                    fixed = Position.valueOf(position.toUpperCase());
                } catch (IllegalArgumentException e) {
                    PackedPacks.LOGGER.error("[packed_packs] Invalid value for key 'position': '{}'. Expected one of {}", position, Position.values());
                }
            }

            return new PackOverride(hidden, required, fixed);
        }
    }
}
