package io.github.fishstiz.packed_packs.gui.components.profile;

import io.github.fishstiz.fidgetz.gui.components.*;
import io.github.fishstiz.fidgetz.gui.components.contextmenu.ContextMenuContainer;
import io.github.fishstiz.fidgetz.gui.layouts.FlexLayout;
import io.github.fishstiz.packed_packs.util.constants.GuiConstants;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_437;
import net.minecraft.class_5244;
import net.minecraft.class_7847;

import static io.github.fishstiz.fidgetz.util.DrawUtil.DEMO_BACKGROUND;

public class Sidebar extends ToggleableDialog<LayoutWrapper<FlexLayout>> implements ContextMenuContainer {
    private static final int SPACING = 8;
    private static final int MIN_WIDTH = 100;
    private final FidgetzButton<Void> closeButton;

    protected Sidebar(io.github.fishstiz.packed_packs.gui.components.profile.Sidebar.Builder builder) {
        super(builder);

        this.root().method_25355(builder.title);
        this.root().setMinWidth(builder.minWidth);

        int maxWidth = Math.max(builder.minWidth, builder.maxWidth);
        FlexLayout header = this.root().layout().addChild(FlexLayout.horizontal(() -> maxWidth));

        this.closeButton = header.addChild(
                FidgetzButton.<Void>builder()
                        .makeSquare()
                        .setMessage(class_5244.field_24334)
                        .setSprite(GuiConstants.CROSS_SPRITE)
                        .setOnPress(() -> this.setOpen(false))
                        .build(),
                builder.headerSettings
        );

        class_327 font = class_310.method_1551().field_1772;
        int titleFontWidth = font.method_27525(builder.title);
        int titleWidth = MIN_WIDTH > titleFontWidth ? MIN_WIDTH : titleFontWidth + SPACING;
        header.addFlexChild(
                FidgetzText.builder(font)
                        .setDimensions(titleWidth, this.closeButton.method_25364())
                        .setMessage(builder.title)
                        .setShadow(builder.shadow)
                        .setOffsetY(1)
                        .alignLeft()
                        .build(),
                false,
                builder.headerSettings
        );

        header.method_48206(this::addRenderableWidget);
        this.repositionElements();
    }

    public FidgetzButton<Void> getCloseButton() {
        return this.closeButton;
    }

    public void repositionElements() {
        this.root().setMinHeight(this.screen.field_22790);
        this.root().method_48222();
    }

    public static <S extends class_437 & ToggleableDialogContainer> io.github.fishstiz.packed_packs.gui.components.profile.Sidebar.Builder builder(S screen) {
        return new io.github.fishstiz.packed_packs.gui.components.profile.Sidebar.Builder(screen, new LayoutWrapper<>(
                FlexLayout.vertical(() -> screen.field_22790).spacing(SPACING),
                MIN_WIDTH,
                class_310.method_1551().method_22683().method_4506()
        ));
    }

    public static class Builder extends ToggleableDialog.Builder<LayoutWrapper<FlexLayout>, io.github.fishstiz.packed_packs.gui.components.profile.Sidebar.Builder> {
        private class_2561 title;
        private boolean shadow;
        private class_7847 headerSettings = class_7847.method_46481();
        private int minWidth = MIN_WIDTH;
        private int maxWidth;

        protected <S extends class_437 & ToggleableDialogContainer> Builder(S screen, LayoutWrapper<FlexLayout> root) {
            super(screen, root);

            this.background = DEMO_BACKGROUND;
        }

        public io.github.fishstiz.packed_packs.gui.components.profile.Sidebar.Builder setHeaderSettings(class_7847 headerSettings) {
            this.headerSettings = headerSettings;
            return this;
        }

        public io.github.fishstiz.packed_packs.gui.components.profile.Sidebar.Builder setTitle(class_2561 title) {
            this.title = title;
            return this;
        }

        public io.github.fishstiz.packed_packs.gui.components.profile.Sidebar.Builder setTitle(String title) {
            this.title = class_2561.method_43470(title);
            return this;
        }

        public io.github.fishstiz.packed_packs.gui.components.profile.Sidebar.Builder setTitle(class_2561 title, boolean shadow) {
            this.shadow = shadow;
            return this.setTitle(title);
        }

        public io.github.fishstiz.packed_packs.gui.components.profile.Sidebar.Builder setTitle(String title, boolean shadow) {
            this.shadow = shadow;
            return this.setTitle(class_2561.method_43470(title));
        }

        public io.github.fishstiz.packed_packs.gui.components.profile.Sidebar.Builder setMinWidth(int minWidth) {
            this.minWidth = minWidth;
            return this;
        }

        public io.github.fishstiz.packed_packs.gui.components.profile.Sidebar.Builder setMaxWidth(int maxWidth) {
            this.maxWidth = maxWidth;
            return this;
        }

        @Override
        public Sidebar build() {
            return new Sidebar(this);
        }
    }
}
