/*
 * Decompiled with CFR 0.152.
 */
package io.github.fishstiz.fidgetz.gui.components;

import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_332;
import net.minecraft.class_339;
import net.minecraft.class_3532;
import net.minecraft.class_364;
import net.minecraft.class_4069;
import net.minecraft.class_8016;
import net.minecraft.class_8023;
import org.jetbrains.annotations.Nullable;

public abstract class AbstractScrollContainer
extends class_339
implements class_4069 {
    public static final int SCROLLBAR_WIDTH = 6;
    private double scrollAmount;
    private static final class_2960 SCROLLER_SPRITE = class_2960.method_60656((String)"widget/scroller");
    private static final class_2960 SCROLLER_BACKGROUND_SPRITE = class_2960.method_60656((String)"widget/scroller_background");
    @Nullable
    private class_364 focused;
    private boolean dragging;
    private boolean scrolling;

    public AbstractScrollContainer(int x, int y, int width, int height, class_2561 message) {
        super(x, y, width, height, message);
    }

    public boolean method_25397() {
        return this.dragging;
    }

    public void method_25398(boolean dragging) {
        this.dragging = dragging;
    }

    @Nullable
    public class_364 method_25399() {
        return this.focused;
    }

    public boolean method_25370() {
        return super.method_25370();
    }

    public void method_25365(boolean focused) {
    }

    public void method_25395(@Nullable class_364 focused) {
        if (this.focused != null) {
            this.focused.method_25365(false);
        }
        if (focused != null) {
            focused.method_25365(true);
        }
        this.focused = focused;
    }

    @Nullable
    public class_8016 method_48205(class_8023 event) {
        return super.method_48205(event);
    }

    public boolean method_25401(double mouseX, double mouseY, double scrollX, double scrollY) {
        if (!this.field_22764) {
            return false;
        }
        this.setScrollAmount(this.scrollAmount() - scrollY * this.scrollRate());
        return true;
    }

    public boolean method_25402(double mouseX, double mouseY, int button) {
        boolean scrolled = this.updateScrolling(mouseX, mouseY, button);
        return super.method_25402(mouseX, mouseY, button) || scrolled;
    }

    public boolean method_25406(double mouseX, double mouseY, int button) {
        super.method_25406(mouseX, mouseY, button);
        return super.method_25406(mouseX, mouseY, button);
    }

    public boolean method_25403(double mouseX, double mouseY, int button, double dragX, double dragY) {
        if (this.scrolling) {
            if (mouseY < (double)this.method_46427()) {
                this.setScrollAmount(0.0);
            } else if (mouseY > (double)this.method_55443()) {
                this.setScrollAmount(this.maxScrollAmount());
            } else {
                double scrollRange = Math.max(1, this.maxScrollAmount());
                double scrollRatio = Math.max(1.0, scrollRange / (double)(this.field_22759 - this.scrollerHeight()));
                this.setScrollAmount(this.scrollAmount() + dragY * scrollRatio);
            }
        } else {
            super.method_25403(mouseX, mouseY, button, dragX, dragY);
        }
        return super.method_25403(mouseX, mouseY, button, dragX, dragY);
    }

    public void method_25357(double mouseX, double mouseY) {
        this.scrolling = false;
    }

    public double scrollAmount() {
        return this.scrollAmount;
    }

    public void setScrollAmount(double scrollAmount) {
        this.scrollAmount = class_3532.method_15350((double)scrollAmount, (double)0.0, (double)this.maxScrollAmount());
    }

    public boolean updateScrolling(double mouseX, double mouseY, int button) {
        this.scrolling = this.scrollbarVisible() && this.method_25351(button) && mouseX >= (double)this.scrollBarX() && mouseX <= (double)(this.scrollBarX() + 6) && mouseY >= (double)this.method_46427() && mouseY < (double)this.method_55443();
        return this.scrolling;
    }

    public void refreshScrollAmount() {
        this.setScrollAmount(this.scrollAmount);
    }

    public int maxScrollAmount() {
        return Math.max(0, this.contentHeight() - this.field_22759);
    }

    protected boolean scrollbarVisible() {
        return this.maxScrollAmount() > 0;
    }

    protected int scrollerHeight() {
        return class_3532.method_15340((int)((int)((float)(this.field_22759 * this.field_22759) / (float)this.contentHeight())), (int)32, (int)(this.field_22759 - 8));
    }

    protected int scrollBarX() {
        return this.method_55442() - 6;
    }

    protected int scrollBarY() {
        return Math.max(this.method_46427(), (int)this.scrollAmount * (this.field_22759 - this.scrollerHeight()) / this.maxScrollAmount() + this.method_46427());
    }

    protected void renderScrollbar(class_332 guiGraphics) {
        if (this.scrollbarVisible()) {
            int scrollBarX = this.scrollBarX();
            int scrollBarY = this.scrollBarY();
            int scrollBarHeight = this.scrollerHeight();
            guiGraphics.method_52706(SCROLLER_BACKGROUND_SPRITE, scrollBarX, this.method_46427(), 6, this.method_25364());
            guiGraphics.method_52706(SCROLLER_SPRITE, scrollBarX, scrollBarY, 6, scrollBarHeight);
        }
    }

    protected abstract int contentHeight();

    protected abstract double scrollRate();
}

