/*
 * Decompiled with CFR 0.152.
 */
package io.github.fishstiz.fidgetz.gui.components;

import io.github.fishstiz.fidgetz.gui.Metadata;
import io.github.fishstiz.fidgetz.gui.WidgetBuilder;
import io.github.fishstiz.fidgetz.gui.components.Fidgetz;
import io.github.fishstiz.fidgetz.gui.components.contextmenu.ContextMenuItemBuilder;
import io.github.fishstiz.fidgetz.gui.components.contextmenu.ContextMenuProvider;
import io.github.fishstiz.fidgetz.gui.renderables.RenderableRect;
import io.github.fishstiz.fidgetz.gui.renderables.sprites.ButtonSprites;
import io.github.fishstiz.fidgetz.gui.renderables.sprites.Sprite;
import java.util.ArrayList;
import java.util.List;
import java.util.function.BiConsumer;
import net.minecraft.class_2561;
import net.minecraft.class_327;
import net.minecraft.class_332;
import net.minecraft.class_4185;
import net.minecraft.class_7919;
import org.jetbrains.annotations.NotNull;

public class FidgetzButton<E>
extends class_4185
implements Fidgetz,
ContextMenuProvider,
Metadata<E> {
    private final List<Runnable> listeners = new ArrayList<Runnable>();
    private final ButtonSprites sprites;
    private final Integer focusedBorder;
    private final boolean spriteOnly;
    private final BiConsumer<FidgetzButton<E>, ContextMenuItemBuilder> contextMenuBuilder;
    private final RenderableRect foreground;
    private E metadata;

    protected FidgetzButton(Builder<E, ?> builder) {
        super(builder.x, builder.y, builder.width, builder.height, builder.message, builder.onPress, field_40754);
        this.metadata = builder.metadata;
        this.sprites = builder.sprites;
        this.spriteOnly = builder.spriteOnly;
        this.foreground = builder.foreground;
        this.focusedBorder = builder.focusedBorder;
        this.contextMenuBuilder = builder.contextMenuBuilder;
        if (builder.tooltip != null) {
            this.method_47400(builder.tooltip);
        }
    }

    public void method_25306() {
        super.method_25306();
        for (Runnable listener : this.listeners) {
            listener.run();
        }
    }

    public void addListener(Runnable listener) {
        this.listeners.add(listener);
    }

    @Override
    public E getMetadata() {
        return this.metadata;
    }

    @Override
    public void setMetadata(E metadata) {
        this.metadata = metadata;
    }

    protected boolean hasSprite() {
        return this.sprites != null;
    }

    protected void renderSprite(class_332 guiGraphics, int x, int y, int width, int height, float partialTick) {
        this.sprites.render(guiGraphics, x, y, width, height, this.field_22763, partialTick);
    }

    protected void renderBorder(class_332 guiGraphics, int x, int y, int width, int height, float partialTick) {
        guiGraphics.method_49601(x, y, width, height, this.focusedBorder.intValue());
    }

    protected void renderForeground(class_332 guiGraphics, int x, int y, int width, int height, float partialTick) {
        if (this.foreground != null) {
            this.foreground.render(guiGraphics, x, y, width, height, partialTick);
        }
    }

    protected void method_48579(class_332 guiGraphics, int mouseX, int mouseY, float partialTick) {
        boolean bl = this.field_22762 = this.field_22762 && this.isHovered(mouseX, mouseY);
        if (!this.spriteOnly) {
            super.method_48579(guiGraphics, mouseX, mouseY, partialTick);
        }
        if (this.hasSprite()) {
            int spriteWidth = this.method_25368();
            int spriteHeight = this.method_25364();
            int spriteX = this.method_46426() + (this.method_25368() - spriteWidth) / 2;
            int spriteY = this.method_46427() + (this.method_25364() - spriteHeight) / 2;
            this.renderSprite(guiGraphics, spriteX, spriteY, spriteWidth, spriteHeight, partialTick);
        }
        if (this.method_25367() && this.focusedBorder != null) {
            this.renderBorder(guiGraphics, this.method_46426(), this.method_46427(), this.method_25368(), this.method_25364(), partialTick);
        }
        this.renderForeground(guiGraphics, this.method_46426(), this.method_46427(), this.method_25368(), this.method_25364(), partialTick);
    }

    public void method_48589(class_332 guiGraphics, class_327 font, int color) {
        if (!this.hasSprite()) {
            super.method_48589(guiGraphics, font, color);
        }
    }

    @Override
    public void buildItems(ContextMenuItemBuilder builder, int mouseX, int mouseY) {
        if (this.contextMenuBuilder != null) {
            this.contextMenuBuilder.accept(this, builder);
        }
    }

    public static <E> Builder<E, ?> builder() {
        return new Builder();
    }

    public static class Builder<E, B extends Builder<E, B>>
    implements WidgetBuilder<Builder<E, B>> {
        private int x = 0;
        private int y = 0;
        private int width = 150;
        private int height = 20;
        private class_2561 message = class_2561.method_43473();
        private class_7919 tooltip;
        private ButtonSprites sprites;
        private boolean spriteOnly = false;
        private RenderableRect foreground;
        private Integer focusedBorder;
        private class_4185.class_4241 onPress = btn -> {};
        private BiConsumer<FidgetzButton<E>, ContextMenuItemBuilder> contextMenuBuilder;
        private E metadata;

        protected Builder() {
        }

        protected B self() {
            return (B)this;
        }

        @Override
        @NotNull
        public B setX(int x) {
            this.x = x;
            return this.self();
        }

        @Override
        @NotNull
        public B setY(int y) {
            this.y = y;
            return this.self();
        }

        @Override
        @NotNull
        public B setPosition(int x, int y) {
            this.x = x;
            this.y = y;
            return this.self();
        }

        @Override
        @NotNull
        public B setWidth(int width) {
            this.width = width;
            return this.self();
        }

        @Override
        @NotNull
        public B setHeight(int height) {
            this.height = height;
            return this.self();
        }

        @Override
        @NotNull
        public B setDimensions(int width, int height) {
            this.width = width;
            this.height = height;
            return this.self();
        }

        public B makeSquare(int size) {
            this.height = size;
            this.width = size;
            return this.self();
        }

        public B makeSquare() {
            return this.makeSquare(this.height);
        }

        public B setMessage(class_2561 message) {
            this.message = message;
            return this.self();
        }

        public B setMessage(String message) {
            return this.setMessage((class_2561)class_2561.method_43471((String)message));
        }

        public B setTooltip(class_7919 tooltip) {
            this.tooltip = tooltip;
            return this.self();
        }

        public B setSprite(ButtonSprites sprites) {
            this.sprites = sprites;
            return this.self();
        }

        public B setSprite(Sprite sprite) {
            this.sprites = ButtonSprites.of(sprite);
            return this.self();
        }

        public B spriteOnly() {
            this.spriteOnly = true;
            return this.self();
        }

        public B setForeground(RenderableRect foreground) {
            this.foreground = foreground;
            return this.self();
        }

        public B setFocusedBorder(Integer hoverBorder) {
            this.focusedBorder = hoverBorder;
            return this.self();
        }

        public B setOnPress(class_4185.class_4241 onPress) {
            this.onPress = onPress;
            return this.self();
        }

        public B setOnPress(Runnable onPress) {
            this.onPress = btn -> onPress.run();
            return this.self();
        }

        public B setContextMenuBuilder(BiConsumer<FidgetzButton<E>, ContextMenuItemBuilder> contextMenuBuilder) {
            this.contextMenuBuilder = contextMenuBuilder;
            return this.self();
        }

        public B setMetadata(E metadata) {
            this.metadata = metadata;
            return this.self();
        }

        public FidgetzButton<E> build() {
            return new FidgetzButton(this);
        }
    }
}

