/*
 * Decompiled with CFR 0.152.
 */
package io.github.fishstiz.fidgetz.gui.components;

import io.github.fishstiz.fidgetz.gui.components.ToggleableDialog;
import io.github.fishstiz.fidgetz.util.GuiUtil;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import net.minecraft.class_364;

public interface ToggleableDialogContainer {
    public List<ToggleableDialog<?>> getDialogs();

    default public ArrayList<ToggleableDialog<?>> getOpenDialogs() {
        List<ToggleableDialog<?>> dialogs = this.getDialogs();
        ArrayList openDialogs = new ArrayList(dialogs.size());
        for (ToggleableDialog<?> dialog : dialogs) {
            if (!dialog.isOpen()) continue;
            openDialogs.add(dialog);
        }
        return openDialogs;
    }

    default public boolean isChildCovered(class_364 child) {
        boolean isDialogChild = false;
        boolean isEnclosed = false;
        for (ToggleableDialog<?> dialog : this.getOpenDialogsFromTop()) {
            if (dialog != child && (dialog.isCaptureClick() || dialog.isCaptureFocus()) && !GuiUtil.isDescendant(dialog, child)) {
                return true;
            }
            if (!isEnclosed && GuiUtil.isDescendant(dialog, child)) {
                isDialogChild = true;
                break;
            }
            if (isEnclosed || dialog == child || !dialog.encloses(child)) continue;
            isEnclosed = true;
        }
        return !isDialogChild && isEnclosed;
    }

    default public boolean isChildCoveredAtPoint(class_364 child, double px, double py) {
        boolean isDialogChild = false;
        boolean isIntersected = false;
        for (ToggleableDialog<?> dialog : this.getOpenDialogsFromTop()) {
            if (dialog != child && (dialog.isCaptureClick() || dialog.isCaptureFocus()) && !GuiUtil.isDescendant(dialog, child)) {
                return true;
            }
            if (!isIntersected && GuiUtil.isDescendant(dialog, child)) {
                isDialogChild = true;
                break;
            }
            if (isIntersected || dialog == child || !dialog.method_25405(px, py) || !dialog.intersects(child)) continue;
            isIntersected = true;
        }
        return !isDialogChild && isIntersected;
    }

    private List<ToggleableDialog<?>> getOpenDialogsFromTop() {
        ArrayList<ToggleableDialog<?>> dialogs = this.getOpenDialogs();
        dialogs.sort(Comparator.comparing(ToggleableDialog::getZ).reversed());
        return dialogs;
    }
}

