/*
 * Decompiled with CFR 0.152.
 */
package io.github.fishstiz.packed_packs.gui.components.pack;

import com.google.common.collect.ImmutableList;
import com.google.common.primitives.Ints;
import io.github.fishstiz.fidgetz.gui.components.AbstractDynamicList;
import io.github.fishstiz.fidgetz.gui.components.ContainerEventHandlerPatch;
import io.github.fishstiz.fidgetz.gui.components.FidgetzButton;
import io.github.fishstiz.fidgetz.gui.components.contextmenu.ContextMenuContainer;
import io.github.fishstiz.fidgetz.gui.components.contextmenu.ContextMenuItemBuilder;
import io.github.fishstiz.fidgetz.gui.renderables.ColoredRect;
import io.github.fishstiz.fidgetz.util.GuiUtil;
import io.github.fishstiz.packed_packs.PackedPacks;
import io.github.fishstiz.packed_packs.compat.ModAdditions;
import io.github.fishstiz.packed_packs.config.Preferences;
import io.github.fishstiz.packed_packs.config.Profile;
import io.github.fishstiz.packed_packs.gui.components.contextmenu.PackMenuHeader;
import io.github.fishstiz.packed_packs.gui.components.events.DragEvent;
import io.github.fishstiz.packed_packs.gui.components.events.DropEvent;
import io.github.fishstiz.packed_packs.gui.components.events.FileDeleteEvent;
import io.github.fishstiz.packed_packs.gui.components.events.FileRenameOpenEvent;
import io.github.fishstiz.packed_packs.gui.components.events.FolderOpenEvent;
import io.github.fishstiz.packed_packs.gui.components.events.MoveEvent;
import io.github.fishstiz.packed_packs.gui.components.events.PackListEvent;
import io.github.fishstiz.packed_packs.gui.components.events.PackListEventListener;
import io.github.fishstiz.packed_packs.gui.components.events.RequestTransferEvent;
import io.github.fishstiz.packed_packs.gui.components.events.SelectionEvent;
import io.github.fishstiz.packed_packs.gui.components.pack.PackList;
import io.github.fishstiz.packed_packs.gui.components.pack.PackListDevMenu;
import io.github.fishstiz.packed_packs.gui.components.pack.PackWidget;
import io.github.fishstiz.packed_packs.gui.components.pack.Query;
import io.github.fishstiz.packed_packs.gui.metadata.Toggleable;
import io.github.fishstiz.packed_packs.pack.PackAssets;
import io.github.fishstiz.packed_packs.pack.folder.FolderPack;
import io.github.fishstiz.packed_packs.transform.interfaces.IPack;
import io.github.fishstiz.packed_packs.transform.mixin.gui.AbstractSelectionListAccessor;
import io.github.fishstiz.packed_packs.util.InputUtil;
import io.github.fishstiz.packed_packs.util.PackUtil;
import io.github.fishstiz.packed_packs.util.constants.GuiConstants;
import io.github.fishstiz.packed_packs.util.constants.Theme;
import io.github.fishstiz.packed_packs.util.lang.CollectionsUtil;
import io.github.fishstiz.packed_packs.util.lang.IntsUtil;
import io.github.fishstiz.packed_packs.util.lang.ObjectsUtil;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import net.minecraft.class_156;
import net.minecraft.class_2561;
import net.minecraft.class_3288;
import net.minecraft.class_332;
import net.minecraft.class_350;
import net.minecraft.class_364;
import net.minecraft.class_4068;
import net.minecraft.class_4069;
import net.minecraft.class_6379;
import net.minecraft.class_7919;
import net.minecraft.class_8016;
import net.minecraft.class_8023;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class PackListBase<T extends Entry>
extends AbstractDynamicList<T>
implements PackList,
ContainerEventHandlerPatch,
ContextMenuContainer {
    protected static final int OFFSET_Y = 2;
    protected static final int ITEM_HEIGHT = 32;
    protected static final int ROW_GAP = 3;
    protected final PackAssets packAssets;
    protected final List<class_3288> packs = new ObjectArrayList();
    private final List<class_3288> queried = new ObjectArrayList();
    private final List<class_3288> selection = new ObjectArrayList();
    private final PackListEventListener listener;
    private final Query query = new Query();

    protected PackListBase(PackAssets packAssets, PackListEventListener listener) {
        super(32, 6, 2, 3);
        this.packAssets = packAssets;
        this.listener = listener;
        this.queryPacks();
    }

    @NotNull
    protected abstract T createEntry(class_3288 var1, int var2);

    @Nullable
    public T getEntry(@Nullable class_3288 pack) {
        if (pack == null) {
            return null;
        }
        for (Entry entry : this.method_25396()) {
            if (!Objects.equals(entry.pack, pack)) continue;
            return (T)entry;
        }
        return null;
    }

    protected void refreshEntries() {
        this.method_25339();
        for (int i = 0; i < this.queried.size(); ++i) {
            this.method_25321((class_350.class_351)this.createEntry(this.queried.get(i), i));
        }
        Entry focused = (Entry)this.method_25336();
        if (focused != null && !this.queried.contains(focused.pack)) {
            this.method_25395(null);
        }
        this.method_60322();
    }

    public boolean isQueried() {
        return this.query.isQuerying();
    }

    protected void queryPacks() {
        this.queried.clear();
        if (PackedPacks.CONFIG.isDevMode()) {
            this.queried.addAll(this.packs);
        } else {
            CollectionsUtil.addIf(this.queried, this.packs, pack -> !this.packAssets.isHidden((class_3288)pack));
        }
        this.query.apply(this.queried);
        this.selection.retainAll(this.queried);
        this.refreshEntries();
    }

    public void scrollToTop() {
        this.method_25307(0.0);
    }

    public void reload(Collection<class_3288> packs) {
        this.packs.clear();
        for (class_3288 pack : packs) {
            if (pack == null || this.packs.contains(pack)) continue;
            this.packs.add(pack);
        }
        this.method_25395(null);
        this.clearSelection();
        this.queryPacks();
        this.scrollToTop();
    }

    @Override
    @NotNull
    public ImmutableList<class_3288> copyPacks() {
        return ImmutableList.copyOf(this.packs);
    }

    public ImmutableList<class_3288> copyFlattenedPacks() {
        return ImmutableList.copyOf(this.packAssets.flattenPacks(this.packs));
    }

    @Override
    @NotNull
    public ImmutableList<class_3288> copySelection() {
        return ImmutableList.copyOf(this.selection);
    }

    @Override
    @NotNull
    public Query copyQuery() {
        return this.query.copy();
    }

    protected List<class_3288> orderSelection(List<class_3288> selection) {
        ArrayList<class_3288> sortedSelection = new ArrayList<class_3288>(selection);
        sortedSelection.retainAll(this.queried);
        sortedSelection.sort(Comparator.comparingInt(this.queried::indexOf));
        return sortedSelection;
    }

    public ImmutableList<class_3288> getOrderedSelection() {
        return ImmutableList.copyOf(this.orderSelection(this.selection));
    }

    protected int[] getIndicesFromSelection(List<class_3288> selection) {
        int[] selectionIndices = new int[selection.size()];
        for (int i = 0; i < selection.size(); ++i) {
            int index;
            selectionIndices[i] = index = this.queried.indexOf(selection.get(i));
        }
        return selectionIndices;
    }

    protected int[] getSelectionIndices() {
        return this.getIndicesFromSelection(this.selection);
    }

    @Override
    public void clearSelection() {
        this.selection.clear();
    }

    private void refresh() {
        this.clearSelection();
        this.queryPacks();
        this.scrollToTop();
    }

    public void sort(Query.SortOption sort) {
        if (this.query.setSort(sort)) {
            this.refresh();
        }
    }

    public void hideIncompatible(boolean hideIncompatible) {
        if (this.query.setHideIncompatible(hideIncompatible)) {
            this.clearSelection();
            this.queryPacks();
        }
    }

    public void search(@NotNull String search) {
        if (this.query.setSearch(search)) {
            this.refresh();
        }
    }

    private void addPack(class_3288 pack) {
        if (pack != null && !this.packs.contains(pack)) {
            int index = 0;
            for (class_3288 p : this.packs) {
                if (!this.packAssets.isFixed(p) || this.packAssets.getPosition(p) == class_3288.class_3289.field_14281) break;
                ++index;
            }
            this.packs.add(index, pack);
        }
    }

    @Override
    public void add(class_3288 pack) {
        this.addPack(pack);
        this.queryPacks();
    }

    @Override
    public void addAll(List<class_3288> packs) {
        for (class_3288 pack : packs) {
            this.addPack(pack);
        }
        this.queryPacks();
    }

    @Override
    public boolean move(class_3288 pack, int to) {
        if (this.packAssets.isFixed(pack)) {
            return false;
        }
        int from = this.packs.indexOf(pack);
        if (from == -1 || to < 0 || to >= this.packs.size() || from == to) {
            return false;
        }
        this.packs.remove(from);
        this.packs.add(to, pack);
        this.queryPacks();
        this.method_25395(this.getEntry(pack));
        return true;
    }

    @Override
    public boolean moveAll(List<class_3288> selection, int to) {
        if (selection == null || selection.isEmpty() || to < 0 || to > this.packs.size()) {
            return false;
        }
        if (!new HashSet<class_3288>(this.packs).containsAll(selection)) {
            return false;
        }
        int index = to;
        for (class_3288 pack : selection) {
            int from = this.packs.indexOf(pack);
            if (from >= to) continue;
            --index;
        }
        this.packs.removeAll(selection);
        this.packs.addAll(index, selection);
        this.queryPacks();
        return true;
    }

    private void removePack(class_3288 pack) {
        if (this.packs.remove(pack) && this.selection.remove(pack)) {
            this.method_25395(null);
        }
    }

    @Override
    public void remove(class_3288 pack) {
        this.removePack(pack);
        this.queryPacks();
    }

    @Override
    public void removeAll(List<class_3288> packs) {
        for (class_3288 pack : packs) {
            this.removePack(pack);
        }
        this.queryPacks();
    }

    @Nullable
    public class_3288 getLastSelected() {
        return !this.selection.isEmpty() ? this.selection.getLast() : null;
    }

    @Nullable
    public T getSelected() {
        return (T)(this.getLastSelected() != null ? this.getEntry(this.getLastSelected()) : (Entry)super.method_25334());
    }

    public boolean isSelected(class_3288 pack) {
        return this.selection.contains(pack);
    }

    @Override
    public boolean method_49606() {
        return super.method_49606();
    }

    @Override
    public boolean isLocked() {
        return this.packAssets.isLocked();
    }

    public void scrollToLastSelected() {
        Optional.ofNullable(this.getEntry(this.getLastSelected())).ifPresent(x$0 -> this.method_25328((class_350.class_351)x$0));
    }

    @Override
    public void unselect(class_3288 pack) {
        this.selection.remove(pack);
        PackList.Entry entry = this.getEntry(pack);
        if (entry == this.method_25336()) {
            this.method_25395(null);
        }
        if (entry == this.getSelected()) {
            this.method_25313(null);
        }
    }

    @Override
    public void select(class_3288 pack) {
        if (pack != null && this.queried.contains(pack)) {
            this.selection.remove(pack);
            this.selection.add(pack);
            PackList.Entry entry = this.getEntry(pack);
            this.method_25395(entry);
            this.method_25313((class_350.class_351)entry);
        }
    }

    @Override
    public void selectAll(List<class_3288> packs) {
        for (class_3288 pack : packs) {
            this.select(pack);
        }
    }

    @Override
    public void selectExclusive(class_3288 pack) {
        this.clearSelection();
        this.select(pack);
    }

    public void selectToggle(class_3288 pack) {
        if (this.isSelected(pack)) {
            this.unselect(pack);
        } else {
            this.select(pack);
        }
    }

    @Override
    public void selectRange(class_3288 pack) {
        class_3288 selectionStart = this.getLastSelected();
        int lastSelectedIndex = this.queried.indexOf(selectionStart);
        int selectedPackIndex = this.queried.indexOf(pack);
        int[] selectionIndices = this.getSelectionIndices();
        Arrays.sort(selectionIndices);
        if (!Ints.contains((int[])selectionIndices, (int)-1) && !IntsUtil.hasGap(selectionIndices, true) && selectionIndices.length > 0) {
            if (selectionIndices[0] == lastSelectedIndex) {
                selectionStart = this.queried.get(selectionIndices[selectionIndices.length - 1]);
            } else if (selectionIndices[selectionIndices.length - 1] == lastSelectedIndex) {
                selectionStart = this.queried.get(selectionIndices[0]);
            }
        }
        int startIndex = this.queried.indexOf(selectionStart);
        if (selectedPackIndex != -1 && startIndex != -1) {
            this.clearSelection();
            for (int i = Math.min(selectedPackIndex, startIndex); i <= Math.max(selectedPackIndex, startIndex); ++i) {
                class_3288 selected = this.queried.get(i);
                if (selected == pack) continue;
                this.select(selected);
            }
        }
        this.select(pack);
    }

    public void transferAll() {
        ArrayList<class_3288> payload = new ArrayList<class_3288>();
        for (int i = this.queried.size() - 1; i >= 0; --i) {
            class_3288 pack = this.queried.get(i);
            if (!this.isTransferable(pack)) continue;
            payload.add(pack);
        }
        if (!payload.isEmpty()) {
            this.sendEvent(new RequestTransferEvent(this, payload, this.getLastSelected()));
        }
    }

    protected void sendEvent(PackListEvent event) {
        this.listener.onEvent(event);
    }

    @Nullable
    protected abstract List<class_3288> handleDrop(PackList var1, ImmutableList<class_3288> var2, class_3288 var3, double var4, double var6);

    @Override
    public final void drop(PackList source, ImmutableList<class_3288> payload, class_3288 trigger, double mouseX, double mouseY) {
        List<class_3288> dropped = this.handleDrop(source, payload, trigger, mouseX, mouseY);
        if (dropped != null && !dropped.isEmpty()) {
            if (source != this) {
                this.sendEvent(new DropEvent(source, this, dropped));
            } else {
                this.sendEvent(new MoveEvent(this, dropped, trigger));
            }
        }
    }

    protected void openFolder(FolderPack folderPack) {
        this.sendEvent(new FolderOpenEvent(this, folderPack));
    }

    @Nullable
    private class_8016 handleArrowNavigation(class_8023.class_8024 arrowNavigation) {
        Entry entry;
        switch (arrowNavigation.comp_1191()) {
            case field_41826: {
                Entry entry2 = (Entry)this.getPreviousEntry();
                break;
            }
            case field_41827: {
                Entry entry2 = (Entry)this.getNextEntry();
                break;
            }
            default: {
                Entry entry2 = entry = null;
            }
        }
        if (entry != null) {
            if (InputUtil.isRangeModifierActive()) {
                this.selectRange(entry.pack);
            } else {
                this.selectExclusive(entry.pack);
            }
            this.sendEvent(new SelectionEvent(this));
            this.method_25328((class_350.class_351)entry);
            return class_8016.method_48194((class_364)entry, (class_4069[])new class_4069[]{this});
        }
        this.method_25395(null);
        return null;
    }

    @Nullable
    public class_8016 method_48205(class_8023 event) {
        if (!this.method_25370()) {
            class_3288 lastSelected = this.getLastSelected();
            PackList.Entry entry = null;
            if (lastSelected != null) {
                entry = this.getEntry(lastSelected);
            } else if (!this.method_25396().isEmpty()) {
                entry = (Entry)this.method_48200();
            }
            if (entry != null) {
                this.select(((Entry)entry).pack);
                this.method_25328((class_350.class_351)entry);
                return class_8016.method_48194((class_364)entry, (class_4069[])new class_4069[]{this});
            }
        } else {
            if (event instanceof class_8023.class_8024) {
                class_8023.class_8024 arrowNavigation = (class_8023.class_8024)event;
                return this.handleArrowNavigation(arrowNavigation);
            }
            this.method_25395(null);
        }
        return null;
    }

    public boolean method_25404(int keyCode, int scanCode, int modifiers) {
        class_3288 class_32882;
        PackList.Entry entry = this.getEntry(this.getLastSelected());
        if (entry != null && ((Entry)entry).folderWidget != null && (class_32882 = ((Entry)entry).getPack()) instanceof FolderPack) {
            FolderPack folderPack = (FolderPack)class_32882;
            if (this.selection.size() == 1 && InputUtil.isExpandFolder(keyCode, modifiers)) {
                this.openFolder(folderPack);
                return true;
            }
        }
        if (InputUtil.isTransfer(keyCode, modifiers)) {
            if (entry != null && ((Entry)entry).transfer()) {
                GuiUtil.playClickSound();
            }
            return entry != null;
        }
        return super.method_25404(keyCode, scanCode, modifiers);
    }

    public boolean method_25402(double mouseX, double mouseY, int button) {
        if (this.method_53812(button)) {
            this.method_25318(mouseX, mouseY, button);
        }
        if (!this.method_25405(mouseX, mouseY)) {
            return false;
        }
        return ContainerEventHandlerPatch.super.mouseClickedAt(mouseX, mouseY, button) || ((AbstractSelectionListAccessor)((Object)this)).packed_packs$scrolling();
    }

    public void method_48579(class_332 guiGraphics, int mouseX, int mouseY, float partialTick) {
        this.field_22762 = this.field_22762 && GuiUtil.isHovered((class_364)this, mouseX, mouseY);
        super.method_48579(guiGraphics, mouseX, mouseY, partialTick);
    }

    @Override
    protected void method_25311(class_332 guiGraphics, int mouseX, int mouseY, float partialTick) {
        super.method_25311(guiGraphics, mouseX, mouseY, partialTick);
        Entry focused = (Entry)this.method_25336();
        if (focused != null && focused.method_25370() && this.method_25396().contains(focused)) {
            int outlineTop = focused.method_46427() - 1;
            int outlineHeight = focused.method_25364() + 2;
            guiGraphics.method_49601(focused.method_46426(), outlineTop, focused.method_25368(), outlineHeight, Theme.WHITE.getARGB());
        }
    }

    protected boolean beforeScrollbarX(double mouseX) {
        return !this.method_57717() || mouseX < (double)this.method_25329();
    }

    @Override
    public void replaceState(@NotNull PackList.Snapshot snapshot) {
        class_3288 focused = ObjectsUtil.mapOrNull((Entry)this.method_25336(), PackList.Entry::getPack);
        this.packs.clear();
        for (class_3288 pack : snapshot.packs()) {
            if (pack == null || this.packs.contains(pack)) continue;
            this.packs.add(pack);
        }
        this.query.update(snapshot.query());
        this.queryPacks();
        this.clearSelection();
        for (class_3288 selected : snapshot.selection()) {
            this.select(selected);
        }
        this.method_25395(this.getEntry(focused));
    }

    public abstract class Entry
    extends AbstractDynamicList.Entry
    implements PackList.Entry,
    ContextMenuContainer {
        private static final double DRAG_THRESHOLD = 1.0;
        private static final class_7919 FOLDER_OPEN_INFO = class_7919.method_47407((class_2561)FolderPack.FOLDER_OPEN_TEXT);
        protected static final int SPACING = 2;
        protected static final int BACKGROUND_OFFSET = 1;
        protected static final ColoredRect SELECTED_OVERLAY = new ColoredRect(Theme.BLUE_500.withAlpha(0.25f));
        protected final List<class_364> children;
        protected final List<class_4068> renderables;
        protected final List<class_4068> topRenderables;
        protected final List<class_6379> narratables;
        protected final class_3288 pack;
        private final PackWidget packWidget;
        @Nullable
        private final PackListDevMenu devMenu;
        private FidgetzButton<FolderPack> folderWidget;
        private MouseSelectionState mouseSelectionState;
        private long lastClickTime;
        private boolean stale;

        protected Entry(class_3288 pack, int index) {
            super(index);
            this.children = new ArrayList<class_364>();
            this.renderables = new ArrayList<class_4068>();
            this.topRenderables = new ArrayList<class_4068>();
            this.narratables = new ArrayList<class_6379>();
            this.mouseSelectionState = MouseSelectionState.INACTIVE;
            this.lastClickTime = 0L;
            this.stale = false;
            this.pack = pack;
            this.packWidget = this.addRenderableWidget(new PackWidget(this.pack, PackListBase.this.packAssets, this.method_46426(), PackListBase.this.method_25337(this.index), this.method_25368(), PackListBase.this.field_22741, 2));
            class_3288 class_32882 = this.pack;
            if (class_32882 instanceof FolderPack) {
                FolderPack folderPack = (FolderPack)class_32882;
                if (PackedPacks.CONFIG.isDevMode() || Preferences.INSTANCE.folderPackWidget.get().booleanValue()) {
                    this.folderWidget = this.addTopRenderableOnly((class_4068)this.prependWidget(((FidgetzButton.Builder)((FidgetzButton.Builder)((FidgetzButton.Builder)((FidgetzButton.Builder)((FidgetzButton.Builder)((FidgetzButton.Builder)Toggleable.applyPref(Preferences.INSTANCE.folderPackWidget, FidgetzButton.builder()).setTooltip(FOLDER_OPEN_INFO)).setHeight(this.packWidget.method_25364() / 3)).makeSquare()).setSprite(GuiConstants.HAMBURGER_SPRITE)).setMetadata((FolderPack)folderPack)).setOnPress(this::openFolder)).build()));
                }
            }
            this.devMenu = PackedPacks.CONFIG.isDevMode() ? new PackListDevMenu(PackListBase.this, this.pack) : null;
            ModAdditions.addToEntry(PackListBase.this.packAssets.isResourcePacks(), this);
        }

        public <U extends class_364 & class_4068> U addRenderableWidget(U widget) {
            this.children.add(widget);
            this.renderables.add(widget);
            if (widget instanceof class_6379) {
                class_6379 narratable = (class_6379)widget;
                this.narratables.add(narratable);
            }
            return widget;
        }

        public <U extends class_364> U prependWidget(U widget) {
            this.children.addFirst(widget);
            if (widget instanceof class_6379) {
                class_6379 narratable = (class_6379)widget;
                this.narratables.add(narratable);
            }
            return widget;
        }

        public <U extends class_4068> U addTopRenderableOnly(U renderable) {
            this.topRenderables.add(renderable);
            return renderable;
        }

        @Override
        public boolean isTransferable() {
            return !PackListBase.this.isLocked();
        }

        @Override
        public class_3288 getPack() {
            return this.pack;
        }

        public boolean isSelected() {
            return PackListBase.this.selection.contains(this.pack);
        }

        public boolean isSelectedLast() {
            return ObjectsUtil.mapOrDefault(PackListBase.this.getLastSelected(), false, p -> Objects.equals(p, this.pack));
        }

        private boolean sendSelection() {
            ArrayList<class_3288> payload = new ArrayList<class_3288>();
            for (class_3288 selected : PackListBase.this.getOrderedSelection().reversed()) {
                if (!PackListBase.this.isTransferable(selected)) continue;
                payload.add(selected);
            }
            if (!payload.isEmpty()) {
                class_3288 trigger = this.isTransferable() ? this.pack : null;
                PackListBase.this.sendEvent(new RequestTransferEvent(PackListBase.this, payload, trigger));
                return true;
            }
            return false;
        }

        public boolean transfer() {
            if (!this.isSelected() && this.isTransferable()) {
                PackListBase.this.sendEvent(new RequestTransferEvent(PackListBase.this, this.pack));
                return true;
            }
            return this.sendSelection();
        }

        private void fireClickEvent(BiConsumer<PackListBase<T>, class_3288> selector, MouseSelectionState state) {
            this.mouseSelectionState = state;
            selector.accept(PackListBase.this, this.pack);
            PackListBase.this.sendEvent(new SelectionEvent(PackListBase.this));
        }

        private boolean exceedsDragThreshold(double dragX, double dragY) {
            return Math.hypot(dragX, dragY) > 1.0;
        }

        public boolean method_25405(double mouseX, double mouseY) {
            return PackListBase.this.method_49606() && PackListBase.this.beforeScrollbarX(mouseX) && super.method_25405(mouseX, mouseY);
        }

        protected boolean canDrag() {
            return this.isSelected() && !this.isStale() && this.mouseSelectionState == MouseSelectionState.SELECTING_ONE;
        }

        public boolean updateDoubleClick() {
            long currentTime = class_156.method_658();
            boolean doubleClicked = currentTime - this.lastClickTime < 250L;
            this.lastClickTime = currentTime;
            return doubleClicked;
        }

        public boolean method_25402(double mouseX, double mouseY, int button) {
            if (super.method_25402(mouseX, mouseY, button)) {
                return false;
            }
            if (InputUtil.isLeftClick(button) && this.method_25405(mouseX, mouseY)) {
                boolean doubleClickedLocal = this.updateDoubleClick();
                if (!InputUtil.isRangeModifierActive() && !InputUtil.isSelectModifierActive() && doubleClickedLocal && this.isTransferable()) {
                    PackListBase.this.sendEvent(new RequestTransferEvent(PackListBase.this, this.pack));
                    return false;
                }
                if (InputUtil.isRangeModifierActive()) {
                    this.fireClickEvent(PackListBase::selectRange, MouseSelectionState.SELECTING_MANY);
                } else if (InputUtil.isSelectModifierActive()) {
                    this.fireClickEvent(PackListBase::selectToggle, MouseSelectionState.SELECTING_MANY);
                } else if (!this.isSelected()) {
                    this.fireClickEvent(PackListBase::selectExclusive, MouseSelectionState.SELECTING_ONE);
                } else if (this.isSelected() && !this.isSelectedLast()) {
                    this.fireClickEvent(PackListBase::select, MouseSelectionState.SELECTING_ONE);
                } else {
                    this.mouseSelectionState = MouseSelectionState.SELECTING_ONE;
                }
                return true;
            }
            this.mouseSelectionState = MouseSelectionState.INACTIVE;
            return false;
        }

        public boolean method_25406(double mouseX, double mouseY, int button) {
            if (this.isSelectedLast() && this.method_25405(mouseX, mouseY) && this.mouseSelectionState == MouseSelectionState.SELECTING_ONE && PackListBase.this.selection.size() > 1) {
                this.fireClickEvent(PackListBase::selectExclusive, MouseSelectionState.INACTIVE);
                return true;
            }
            this.mouseSelectionState = MouseSelectionState.INACTIVE;
            return false;
        }

        public boolean method_25403(double mouseX, double mouseY, int button, double dragX, double dragY) {
            if (!this.method_25405(mouseX, mouseY)) {
                this.mouseSelectionState = MouseSelectionState.INACTIVE;
                return false;
            }
            if (this.exceedsDragThreshold(dragX, dragY) && this.canDrag()) {
                PackListBase.this.sendEvent(new DragEvent(PackListBase.this, PackListBase.this.getOrderedSelection().reversed(), this.pack, this.packWidget.getSprite()));
                return true;
            }
            return false;
        }

        public boolean method_25404(int keyCode, int scanCode, int modifiers) {
            boolean keyPressed = super.method_25404(keyCode, scanCode, modifiers);
            if (!keyPressed) {
                if (InputUtil.isOpenFile(keyCode, modifiers)) {
                    PackUtil.openPack(this.pack);
                    return true;
                }
                if (InputUtil.isOpenFolder(keyCode, modifiers)) {
                    PackUtil.openParent(this.pack);
                    return true;
                }
                if (this.canOperateFile()) {
                    if (InputUtil.isDelete(keyCode, modifiers)) {
                        this.deletePack();
                        return true;
                    }
                    if (InputUtil.isRename(keyCode, modifiers)) {
                        this.renamePack();
                        return true;
                    }
                }
            }
            return keyPressed;
        }

        public void method_49568(class_332 guiGraphics, int index, int top, int left, int width, int height, int mouseX, int mouseY, boolean isMouseOver, float partialTick) {
            if (!this.pack.method_14460().method_14437() && !PackListBase.this.packAssets.getConfig().isIncompatibleWarningsHidden()) {
                int backgroundLeft = this.method_46426() + 1;
                int backgroundRight = backgroundLeft + this.method_25368() - 2;
                guiGraphics.method_25294(backgroundLeft, this.method_46427(), backgroundRight, this.getBottom(), Theme.RED_900.getARGB());
            }
        }

        protected abstract void renderForeground(class_332 var1, int var2, int var3, int var4, int var5, int var6, int var7, boolean var8, float var9);

        private void renderSelection(class_332 guiGraphics, int top, int left, int width, int height) {
            if (this.isSelected()) {
                int overlayLeft = this.method_46426() + 1;
                int overlayWidth = this.method_25368() - 2;
                ObjectsUtil.pick(this.isSelectedLast(), GuiConstants.WHITE_OVERLAY, SELECTED_OVERLAY).render(guiGraphics, overlayLeft, this.method_46427(), overlayWidth, this.method_25364());
            }
            if (this.isSelected() || this.method_25370()) {
                int outlineTop = this.method_46427() - 1;
                int outlineHeight = this.method_25364() + 2;
                if (!this.method_25370()) {
                    guiGraphics.method_49601(left, outlineTop, width, outlineHeight, Theme.BLUE_500.getARGB());
                }
            }
        }

        protected void renderTop(class_332 guiGraphics, int mouseX, int mouseY, float partialTick) {
            if (this.folderWidget != null) {
                int folderWidgetY = this.getBottom() - this.folderWidget.method_25364() - 1;
                this.folderWidget.method_48229(this.packWidget.getContentLeft(), folderWidgetY);
            }
            for (class_4068 renderable : this.topRenderables) {
                renderable.method_25394(guiGraphics, mouseX, mouseY, partialTick);
            }
        }

        private void renderWidget(class_332 guiGraphics, int top, int left, int width, int height, int mouseX, int mouseY, boolean hovering, float partialTick) {
            this.packWidget.method_48229(left, top);
            this.packWidget.method_25358(width);
            for (class_4068 renderable : this.renderables) {
                renderable.method_25394(guiGraphics, mouseX, mouseY, partialTick);
            }
            this.renderSelection(guiGraphics, top, left, width, height);
            this.renderForeground(guiGraphics, top, left, width, height, mouseX, mouseY, hovering, partialTick);
            this.renderTop(guiGraphics, mouseX, mouseY, partialTick);
            if (this.devMenu != null) {
                guiGraphics.method_51448().method_22903();
                guiGraphics.method_51448().method_46416(0.0f, 0.0f, 1.0f);
                this.devMenu.renderDevSprites(guiGraphics, top, left, width);
                guiGraphics.method_51448().method_22909();
            }
        }

        public final void method_25343(class_332 guiGraphics, int index, int top, int left, int width, int height, int mouseX, int mouseY, boolean hovering, float partialTick) {
            this.renderWidget(guiGraphics, top, left, width, height, mouseX, mouseY, hovering && PackListBase.this.method_49606() && PackListBase.this.beforeScrollbarX(mouseX), partialTick);
        }

        @Override
        public void buildItems(ContextMenuItemBuilder builder, int mouseX, int mouseY) {
            PackListBase.this.method_25395(this);
            ContextMenuContainer.super.buildItems(builder.add(new PackMenuHeader(this.pack, this.packWidget.getSprite())).whenNonNull(this.devMenu).ifTrue(PackListDevMenu::onBuildHeader).whenNonNull((PackListDevMenu)((Object)this.folderWidget)).ifTrue(b -> b.simpleItem(FolderPack.FOLDER_OPEN_TEXT, this::openFolder).separator()).whenNonNull(((IPack)this.pack).packed_packs$getPath()).ifTrue(b -> b.simpleItem(PackAssets.RENAME_FILE_TEXT, this::canOperateFile, this::renamePack).simpleItem(PackAssets.DELETE_FILE_TEXT, this::canOperateFile, this::deletePack).simpleItem(PackAssets.OPEN_FILE_TEXT, () -> PackUtil.openPack(this.pack)).simpleItem(PackAssets.OPEN_PARENT_TEXT, () -> PackUtil.openParent(this.pack))), mouseX, mouseY);
        }

        private void openFolder() {
            PackListBase.this.openFolder(this.folderWidget.getMetadata());
        }

        private boolean hasOverride() {
            Profile profile = PackListBase.this.packAssets.getProfile();
            Profile defaultProfile = PackListBase.this.packAssets.getConfig().getDefaultProfile();
            return ObjectsUtil.testNullable(profile, p -> p.hasOverride(this.pack)) || ObjectsUtil.testNullable(defaultProfile, p -> p.hasOverride(this.pack));
        }

        public boolean canOperateFile() {
            return !this.hasOverride() && !PackListBase.this.isLocked() && !PackListBase.this.packAssets.isFixed(this.pack) && !PackListBase.this.packAssets.isRequired(this.pack) && !PackListBase.this.packAssets.isEnabled(this.pack) && PackAssets.validatePackPath(this.pack) != null;
        }

        public void deletePack() {
            if (PackListBase.this.packAssets.deletePack(this.pack)) {
                this.stale = true;
                PackListBase.this.remove(this.pack);
                PackListBase.this.sendEvent(new FileDeleteEvent(PackListBase.this));
            }
        }

        public void renamePack() {
            PackListBase.this.sendEvent(new FileRenameOpenEvent(PackListBase.this, this.pack));
        }

        public void onRename(class_2561 newName) {
            this.stale = true;
            this.packWidget.onRename(newName);
            if (this.folderWidget != null) {
                this.folderWidget.field_22763 = false;
            }
        }

        public boolean isStale() {
            return this.stale;
        }

        @NotNull
        public List<? extends class_364> method_25396() {
            return this.children;
        }

        @NotNull
        public List<? extends class_6379> method_37025() {
            return this.narratables;
        }

        @Override
        public int method_46427() {
            return super.method_46427() - 1;
        }

        @Override
        public int method_25364() {
            return super.method_25364() + 2;
        }

        private static enum MouseSelectionState {
            INACTIVE,
            SELECTING_ONE,
            SELECTING_MANY;

        }
    }
}

