/*
 * Decompiled with CFR 0.152.
 */
package io.github.fishstiz.packed_packs.gui.components.pack;

import io.github.fishstiz.fidgetz.gui.components.FidgetzText;
import io.github.fishstiz.fidgetz.gui.renderables.sprites.Sprite;
import io.github.fishstiz.packed_packs.pack.PackAssets;
import io.github.fishstiz.packed_packs.util.constants.Theme;
import java.util.Objects;
import net.minecraft.class_124;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_3288;
import net.minecraft.class_332;
import net.minecraft.class_339;
import net.minecraft.class_5489;
import net.minecraft.class_6382;

class PackWidget
extends class_339 {
    private static final int DESCRIPTION_LINES = 2;
    private final class_3288 pack;
    private final PackAssets packAssets;
    private final FidgetzText<?> title;
    private class_5489 description;
    private Sprite sprite;
    private final int spacing;
    private boolean lazyLoaded;

    PackWidget(class_3288 pack, PackAssets packAssets, int x, int y, int width, int height, int spacing) {
        super(x, y, width, height, pack.method_14457());
        FidgetzText.Builder builder = FidgetzText.builder();
        Objects.requireNonNull(class_310.method_1551().field_1772);
        this.title = ((FidgetzText.Builder)builder.setHeight(9)).setColor(class_124.field_1068.method_532()).setShadow(true).alignLeft().build();
        this.lazyLoaded = false;
        this.pack = pack;
        this.packAssets = packAssets;
        this.title.method_25355(pack.method_14457());
        this.spacing = spacing;
        this.sprite = Sprite.of32(PackAssets.getDefaultIcon(pack));
        this.cacheDescription();
    }

    public Sprite getSprite() {
        return this.sprite;
    }

    private int getIconSize() {
        return this.method_25364();
    }

    private void cacheDescription() {
        this.description = class_5489.method_61132((class_327)class_310.method_1551().field_1772, (int)this.title.method_25368(), (int)2, (class_2561[])new class_2561[]{this.pack.method_29483().method_45282(this.pack.method_14459())});
    }

    public void method_25358(int width) {
        super.method_25358(width);
        int bodyX = this.spacing * 2 + this.method_46426() + this.getIconSize();
        int bodyWidth = this.method_55442() - this.spacing * 2 - bodyX;
        if (this.title.method_25368() != bodyWidth) {
            this.title.method_46421(bodyX);
            this.title.method_25358(bodyWidth);
            this.cacheDescription();
        }
    }

    public void onRename(class_2561 title) {
        this.title.method_25355((class_2561)title.method_27662().method_27692(class_124.field_1080));
    }

    public int getContentLeft() {
        return this.title.method_46426();
    }

    protected void renderSprite(class_332 guiGraphics, float partialTick) {
        if (!this.lazyLoaded) {
            this.lazyLoaded = true;
            this.packAssets.getOrLoadIcon(this.pack, icon -> {
                this.sprite = Sprite.of32(icon);
            });
        }
        int x = this.method_46426() + this.spacing;
        int y = this.method_46427();
        int size = this.getIconSize();
        this.sprite.render(guiGraphics, x, y, size, size, partialTick);
    }

    protected void method_48579(class_332 guiGraphics, int mouseX, int mouseY, float partialTick) {
        this.renderSprite(guiGraphics, partialTick);
        Objects.requireNonNull(class_310.method_1551().field_1772);
        int lineHeight = 9;
        int totalContentHeight = lineHeight + this.spacing + lineHeight * 2;
        int startY = this.method_46427() + (this.method_25364() - totalContentHeight) / 2;
        this.title.method_46419(startY);
        this.title.method_48579(guiGraphics, mouseX, mouseY, partialTick);
        this.description.method_30893(guiGraphics, this.title.method_46426(), startY + lineHeight + this.spacing, lineHeight, Theme.GRAY_500.getARGB());
    }

    public boolean method_25405(double mouseX, double mouseY) {
        return false;
    }

    public boolean method_25402(double mouseX, double mouseY, int button) {
        return false;
    }

    protected void method_47399(class_6382 narrationElementOutput) {
    }
}

