/*
 * Decompiled with CFR 0.152.
 */
package io.github.fishstiz.packed_packs.pack;

import com.google.common.hash.Hashing;
import io.github.fishstiz.packed_packs.PackedPacks;
import io.github.fishstiz.packed_packs.config.Config;
import io.github.fishstiz.packed_packs.config.Folder;
import io.github.fishstiz.packed_packs.config.PackOptions;
import io.github.fishstiz.packed_packs.config.Profile;
import io.github.fishstiz.packed_packs.pack.folder.FolderPack;
import io.github.fishstiz.packed_packs.transform.interfaces.IPack;
import io.github.fishstiz.packed_packs.util.PackUtil;
import io.github.fishstiz.packed_packs.util.ResourceUtil;
import io.github.fishstiz.packed_packs.util.ToastUtil;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.NoSuchFileException;
import java.nio.file.Path;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.function.Consumer;
import net.minecraft.class_1011;
import net.minecraft.class_1043;
import net.minecraft.class_1044;
import net.minecraft.class_1060;
import net.minecraft.class_124;
import net.minecraft.class_156;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_3262;
import net.minecraft.class_3288;
import net.minecraft.class_5352;
import net.minecraft.class_7367;
import org.jetbrains.annotations.Nullable;

public interface PackAssets
extends PackOptions {
    public static final String ICON_FILENAME = "pack.png";
    public static final String ZIP_PACK_EXTENSION = ".zip";
    public static final class_2960 DEFAULT_FOLDER_ICON = ResourceUtil.getResource("textures/misc/unknown_folder.png");
    public static final class_2960 DEFAULT_ICON = class_2960.method_60656((String)"textures/misc/unknown_pack.png");
    public static final class_2561 OPEN_FILE_TEXT = ResourceUtil.getText("file.open", new Object[0]);
    public static final class_2561 OPEN_PARENT_TEXT = ResourceUtil.getText("file.parent.open", new Object[0]);
    public static final class_2561 RENAME_FILE_TEXT = ResourceUtil.getText("file.rename", new Object[0]);
    public static final class_2561 DELETE_FILE_TEXT = ResourceUtil.getText("file.delete", new Object[0]);
    public static final class_5352 SOURCE = class_5352.method_45281(name -> class_2561.method_43469((String)"pack.nameAndSource", (Object[])new Object[]{name, ResourceUtil.getModName().method_27692(class_124.field_1054)}).method_27692(class_124.field_1080), (boolean)false);

    public void getOrLoadIcon(class_3288 var1, Consumer<class_2960> var2);

    public boolean isResourcePacks();

    public boolean isLocked();

    public boolean isEnabled(class_3288 var1);

    public Config.Packs getConfig();

    public Folder getFolderConfig(@Nullable FolderPack var1);

    @Nullable
    public Profile getProfile();

    public List<class_3288> flattenPacks(List<class_3288> var1);

    default public boolean deletePack(class_3288 pack) {
        if (pack == null || this.isEnabled(pack)) {
            return false;
        }
        Path path = PackAssets.validatePackPath(pack);
        if (path == null) {
            PackAssets.showFailToast(PackAssets.getDeleteFailText(pack.method_14457().getString()));
            return false;
        }
        if (!PackUtil.deletePath(path)) {
            PackAssets.showFailToast(PackAssets.getDeleteFailText(PackUtil.fileName(path)));
            return false;
        }
        return true;
    }

    default public boolean renamePack(class_3288 pack, String newName) {
        if (pack == null || this.isEnabled(pack)) {
            return false;
        }
        Path path = PackAssets.validatePackPath(pack);
        if (path == null) {
            PackAssets.showFailToast(PackAssets.getRenameFailText(pack.method_14457().getString(), newName));
            return false;
        }
        Path newPath = path.getParent().resolve(newName);
        if (!PackUtil.renamePath(path, newPath)) {
            PackAssets.showFailToast(PackAssets.getRenameFailText(PackUtil.fileName(path), PackUtil.fileName(newPath)));
            return false;
        }
        return true;
    }

    @Nullable
    public static Path validatePackPath(class_3288 pack) {
        if (pack == null) {
            return null;
        }
        Path path = ((IPack)pack).packed_packs$getPath();
        if (path == null) {
            return null;
        }
        try {
            return Files.exists(path, new LinkOption[0]) ? path : null;
        }
        catch (SecurityException e) {
            PackedPacks.LOGGER.error("[packed_packs] Could not read file: '{}'", (Object)path);
            return null;
        }
    }

    public static boolean isZipPack(class_3288 pack) {
        Path path = PackAssets.validatePackPath(pack);
        return path != null && Files.isRegularFile(path, new LinkOption[0]) && PackUtil.fileName(path).endsWith(ZIP_PACK_EXTENSION);
    }

    private static void showFailToast(class_2561 message) {
        ToastUtil.onFileFailToast(message);
    }

    public static class_2960 getDefaultIcon(class_3288 pack) {
        return pack instanceof FolderPack ? DEFAULT_FOLDER_ICON : DEFAULT_ICON;
    }

    public static class_2561 getRenameFailText(String from, String to) {
        return ResourceUtil.getText("file.rename.fail", from, to);
    }

    public static class_2561 getDeleteFailText(String fileName) {
        return ResourceUtil.getText("file.delete.fail", fileName);
    }

    public static CompletableFuture<class_2960> loadPackIcon(class_3288 pack) {
        return CompletableFuture.supplyAsync(() -> {
            try (class_3262 packResources = pack.method_14458();){
                class_7367 iconIoSupplier = packResources.method_14410(new String[]{ICON_FILENAME});
                if (iconIoSupplier == null) {
                    class_2960 class_29602 = PackAssets.getDefaultIcon(pack);
                    return class_29602;
                }
                String id = pack.method_14463();
                class_2960 resourceLocation = class_2960.method_60656((String)("pack/" + class_156.method_30309((String)id, class_2960::method_29184) + "/" + String.valueOf(Hashing.sha1().hashUnencodedChars((CharSequence)id)) + "/icon"));
                try (InputStream iconStream = (InputStream)iconIoSupplier.get();){
                    class_1011 nativeImage = class_1011.method_4309((InputStream)iconStream);
                    class_1060 manager = class_310.method_1551().method_1531();
                    class_310.method_1551().execute(() -> manager.method_4616(resourceLocation, (class_1044)new class_1043(nativeImage)));
                    class_2960 packIcon = resourceLocation;
                    return packIcon;
                }
            }
            catch (Exception e) {
                if (e instanceof NoSuchFileException) return PackAssets.getDefaultIcon(pack);
                PackedPacks.LOGGER.warn("Failed to load icon from pack '{}'", (Object)pack.method_14463(), (Object)e);
                return PackAssets.getDefaultIcon(pack);
            }
        }, class_156.method_18349());
    }
}

