/*
 * Decompiled with CFR 0.152.
 */
package io.github.fishstiz.packed_packs.util.lang;

import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import it.unimi.dsi.fastutil.objects.ObjectOpenHashSet;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;
import org.jetbrains.annotations.Nullable;

public class CollectionsUtil {
    private CollectionsUtil() {
    }

    @SafeVarargs
    public static <E> List<E> mutableListOf(E ... elements) {
        ObjectArrayList list = new ObjectArrayList(elements.length);
        Collections.addAll(list, elements);
        return list;
    }

    public static <K, V> List<V> lookup(Collection<K> keys, Map<K, V> source) {
        ObjectArrayList result = new ObjectArrayList();
        for (K key : keys) {
            V v = source.get(key);
            if (v == null) continue;
            result.add(v);
        }
        return result;
    }

    public static <T, K> Map<K, T> toMap(Collection<T> collection, Function<T, K> keyFn) {
        Object2ObjectOpenHashMap map = new Object2ObjectOpenHashMap(collection.size());
        for (T item : collection) {
            map.put(keyFn.apply(item), item);
        }
        return map;
    }

    public static <T, R> List<R> extractNonNull(Collection<T> collection, Function<T, R> mapper) {
        ObjectArrayList result = new ObjectArrayList(collection.size());
        for (T item : collection) {
            R value;
            if (item == null || (value = mapper.apply(item)) == null) continue;
            result.add(value);
        }
        return result;
    }

    public static <T> void forEachDistinct(Collection<T> collection, Consumer<T> action) {
        ObjectOpenHashSet seen = new ObjectOpenHashSet(collection.size());
        for (T entry : collection) {
            if (entry == null || !seen.add(entry)) continue;
            action.accept(entry);
        }
    }

    public static <T> List<T> deduplicate(Collection<T> list) {
        ObjectArrayList deduplicated = new ObjectArrayList();
        CollectionsUtil.forEachDistinct(list, ((List)deduplicated)::add);
        return deduplicated;
    }

    @SafeVarargs
    public static <T> List<T> addAll(Collection<T> ... collections) {
        ObjectArrayList list = new ObjectArrayList();
        for (Collection<T> collection : collections) {
            list.addAll(collection);
        }
        return list;
    }

    public static <E> void addIf(Collection<E> out, Collection<E> add, Predicate<E> predicate) {
        for (E e : add) {
            if (!predicate.test(e)) continue;
            out.add(e);
        }
    }

    public static <E> boolean equalsOrdered(Collection<E> a, Collection<E> b) {
        if (a == b) {
            return true;
        }
        if (a == null || b == null || a.size() != b.size()) {
            return false;
        }
        Iterator<E> itA = a.iterator();
        Iterator<E> itB = b.iterator();
        while (itA.hasNext()) {
            if (Objects.equals(itA.next(), itB.next())) continue;
            return false;
        }
        return true;
    }

    public static <E, T> boolean containsId(Collection<E> collection, T id, Function<E, T> identifier) {
        for (E e : collection) {
            if (!Objects.equals(id, identifier.apply(e))) continue;
            return true;
        }
        return false;
    }

    public static <E, R, T extends Collection<R>> T map(Collection<E> collection, Function<E, R> mapper, Supplier<T> collectionFactory) {
        Collection result = (Collection)collectionFactory.get();
        for (E element : collection) {
            result.add(mapper.apply(element));
        }
        return (T)result;
    }

    public static <E, T extends Collection<E>> T filter(Collection<E> collection, Predicate<E> filter, Supplier<T> collectionFactory) {
        Collection result = (Collection)collectionFactory.get();
        for (E e : collection) {
            if (!filter.test(e)) continue;
            result.add(e);
        }
        return (T)result;
    }

    @Nullable
    public static <E, T> E firstMatch(Collection<E> collection, T value, Function<E, T> mapper) {
        for (E e : collection) {
            if (mapper.apply(e) != value) continue;
            return e;
        }
        return null;
    }
}

