/*
 * Decompiled with CFR 0.152.
 */
package net.cinchtail.cinchcraft;

import com.google.common.collect.ImmutableSet;
import com.mojang.logging.LogUtils;
import java.util.Collection;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.cinchtail.cinchcraft.block.ModBlocks;
import net.cinchtail.cinchcraft.block.entity.ModBlockEntities;
import net.cinchtail.cinchcraft.entity.ModEntities;
import net.cinchtail.cinchcraft.entity.client.ModBoatRenderer;
import net.cinchtail.cinchcraft.event.ModEvents;
import net.cinchtail.cinchcraft.item.ModCreativeModeTabs;
import net.cinchtail.cinchcraft.item.ModItems;
import net.cinchtail.cinchcraft.loot.ModLootModifiers;
import net.cinchtail.cinchcraft.potion.ModPotions;
import net.cinchtail.cinchcraft.sound.ModSounds;
import net.cinchtail.cinchcraft.util.ModWoodTypes;
import net.cinchtail.cinchcraft.villagers.ModVillagers;
import net.cinchtail.cinchcraft.world.biome.ModOverworldRegion;
import net.minecraft.client.renderer.Sheets;
import net.minecraft.client.renderer.entity.EntityRenderers;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.npc.Villager;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.ComposterBlock;
import net.minecraft.world.level.block.FlowerPotBlock;
import net.minecraft.world.level.block.state.properties.WoodType;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import org.slf4j.Logger;
import terrablender.api.Region;
import terrablender.api.Regions;

@Mod(value="cinchcraft")
public class Cinchcraft {
    public static final String MOD_ID = "cinchcraft";
    private static final Logger LOGGER = LogUtils.getLogger();

    public Cinchcraft(FMLJavaModLoadingContext context) {
        IEventBus modEventBus = context.getModEventBus();
        ModItems.register(modEventBus);
        ModBlocks.register(modEventBus);
        ModCreativeModeTabs.register(modEventBus);
        ModBlockEntities.register(modEventBus);
        ModEntities.register(modEventBus);
        ModSounds.register(modEventBus);
        ModVillagers.register(modEventBus);
        ModPotions.register(modEventBus);
        ModLootModifiers.register(modEventBus);
        modEventBus.addListener(this::commonSetup);
        modEventBus.addListener(this::clientSetup);
        MinecraftForge.EVENT_BUS.register((Object)new ModEvents());
        MinecraftForge.EVENT_BUS.register((Object)this);
    }

    private void commonSetup(FMLCommonSetupEvent event) {
        ComposterBlock.COMPOSTABLES.put((Object)Items.ROTTEN_FLESH, 0.2f);
        ComposterBlock.COMPOSTABLES.put((Object)Items.BAMBOO, 0.65f);
        ComposterBlock.COMPOSTABLES.put((Object)Items.POISONOUS_POTATO, 0.2f);
        ComposterBlock.COMPOSTABLES.put((Object)((ItemLike)ModItems.CARROT_SEEDS.get()), 0.3f);
        ComposterBlock.COMPOSTABLES.put((Object)((ItemLike)ModItems.SUNFLOWER_SEEDS.get()), 0.3f);
        ComposterBlock.COMPOSTABLES.put((Object)((ItemLike)ModItems.SUNFLOWER_HEAD.get()), 1.0f);
        ComposterBlock.COMPOSTABLES.put((Object)((ItemLike)ModItems.BLUEBERRY_PIE.get()), 1.0f);
        ComposterBlock.COMPOSTABLES.put((Object)((ItemLike)ModItems.BLUEBERRIES.get()), 0.3f);
        ComposterBlock.COMPOSTABLES.put((Object)((ItemLike)ModItems.STRAWBERRIES.get()), 0.3f);
        ComposterBlock.COMPOSTABLES.put((Object)((ItemLike)ModItems.PINEAPPLE.get()), 0.5f);
        ComposterBlock.COMPOSTABLES.put((Object)((ItemLike)ModItems.PITCHER_PLANT_ROOT.get()), 0.65f);
        ComposterBlock.COMPOSTABLES.put((Object)((ItemLike)ModItems.CARVED_MELON.get()), 0.65f);
        ComposterBlock.COMPOSTABLES.put((Object)((ItemLike)ModItems.BUTTER_CUP.get()), 0.65f);
        ComposterBlock.COMPOSTABLES.put((Object)((ItemLike)ModItems.SMALL_ROSE.get()), 0.65f);
        ComposterBlock.COMPOSTABLES.put((Object)((ItemLike)ModItems.CROCUS.get()), 0.65f);
        ComposterBlock.COMPOSTABLES.put((Object)((ItemLike)ModItems.ALYSSUM.get()), 0.65f);
        ComposterBlock.COMPOSTABLES.put((Object)((ItemLike)ModItems.LUPINE.get()), 0.65f);
        ComposterBlock.COMPOSTABLES.put((Object)((ItemLike)ModItems.STAR_CACTUS.get()), 0.65f);
        ComposterBlock.COMPOSTABLES.put((Object)((ItemLike)ModItems.FIRE_FERN.get()), 0.65f);
        ComposterBlock.COMPOSTABLES.put((Object)((ItemLike)ModItems.REEDS_SEEDS.get()), 0.65f);
        ComposterBlock.COMPOSTABLES.put((Object)((ItemLike)ModItems.REEDS.get()), 0.65f);
        ComposterBlock.COMPOSTABLES.put((Object)((ItemLike)ModItems.CATTAILS.get()), 0.65f);
        ComposterBlock.COMPOSTABLES.put((Object)((ItemLike)ModItems.STALK.get()), 0.65f);
        Stream vanillaWantedItems = Villager.WANTED_ITEMS.stream();
        Stream<Item> modWantedItems = Stream.of((Item)ModItems.CARROT_SEEDS.get());
        Villager.WANTED_ITEMS = ImmutableSet.copyOf((Collection)Stream.concat(vanillaWantedItems, modWantedItems).collect(Collectors.toSet()));
    }

    public void clientSetup(FMLClientSetupEvent event) {
    }

    @Mod.EventBusSubscriber(modid="cinchcraft", bus=Mod.EventBusSubscriber.Bus.MOD, value={Dist.CLIENT})
    public static class ClientModEvents {
        @SubscribeEvent
        public static void onClientSetup(FMLClientSetupEvent event) {
            event.enqueueWork(() -> {
                Regions.register((Region)new ModOverworldRegion(ResourceLocation.fromNamespaceAndPath((String)Cinchcraft.MOD_ID, (String)"overworld"), 3));
                Sheets.addWoodType((WoodType)ModWoodTypes.AZALEA);
                ((FlowerPotBlock)Blocks.FLOWER_POT).addPlant(ModBlocks.BUTTER_CUP.getId(), ModBlocks.POTTED_BUTTER_CUP);
                ((FlowerPotBlock)Blocks.FLOWER_POT).addPlant(ModBlocks.SMALL_ROSE.getId(), ModBlocks.POTTED_SMALL_ROSE);
                ((FlowerPotBlock)Blocks.FLOWER_POT).addPlant(ModBlocks.CROCUS.getId(), ModBlocks.POTTED_CROCUS);
                ((FlowerPotBlock)Blocks.FLOWER_POT).addPlant(ModBlocks.ALYSSUM.getId(), ModBlocks.POTTED_ALYSSUM);
                ((FlowerPotBlock)Blocks.FLOWER_POT).addPlant(ModBlocks.LUPINE.getId(), ModBlocks.POTTED_LUPINE);
                ((FlowerPotBlock)Blocks.FLOWER_POT).addPlant(ModBlocks.STAR_CACTUS.getId(), ModBlocks.POTTED_STAR_CACTUS);
                EntityRenderers.register((EntityType)((EntityType)ModEntities.MOD_BOAT.get()), pContext -> new ModBoatRenderer(pContext, false));
                EntityRenderers.register((EntityType)((EntityType)ModEntities.MOD_CHEST_BOAT.get()), pContext -> new ModBoatRenderer(pContext, true));
            });
        }
    }
}

