/*
 * Decompiled with CFR 0.152.
 */
package net.cinchtail.cinchcraft.block.custom;

import com.mojang.serialization.MapCodec;
import net.cinchtail.cinchcraft.item.ModItems;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.ItemInteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.BonemealableBlock;
import net.minecraft.world.level.block.BushBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraftforge.common.ForgeHooks;

public class BlueBerryBushBlock
extends BushBlock
implements BonemealableBlock {
    public static final IntegerProperty AGE = BlockStateProperties.AGE_3;
    private static final VoxelShape SAPLING_SHAPE = Block.box((double)3.0, (double)0.0, (double)3.0, (double)13.0, (double)8.0, (double)13.0);
    private static final VoxelShape MID_GROWTH_SHAPE = Block.box((double)1.0, (double)0.0, (double)1.0, (double)15.0, (double)16.0, (double)15.0);

    public BlueBerryBushBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.registerDefaultState((BlockState)((BlockState)this.stateDefinition.any()).setValue((Property)AGE, (Comparable)Integer.valueOf(0)));
    }

    protected MapCodec<? extends BushBlock> codec() {
        return BlueBerryBushBlock.simpleCodec(BlueBerryBushBlock::new);
    }

    public ItemStack getCloneItemStack(LevelReader levelReader, BlockPos blockPos, BlockState blockState) {
        return new ItemStack((ItemLike)ModItems.BLUEBERRIES.get());
    }

    public VoxelShape getShape(BlockState blockState, BlockGetter blockGetter, BlockPos pos, CollisionContext collisionContext) {
        if ((Integer)blockState.getValue((Property)AGE) == 0) {
            return SAPLING_SHAPE;
        }
        return (Integer)blockState.getValue((Property)AGE) < 3 ? MID_GROWTH_SHAPE : super.getShape(blockState, blockGetter, pos, collisionContext);
    }

    public boolean isRandomlyTicking(BlockState blockState) {
        return (Integer)blockState.getValue((Property)AGE) < 3;
    }

    public void randomTick(BlockState blockState, ServerLevel serverLevel, BlockPos pos, RandomSource randomSource) {
        int i = (Integer)blockState.getValue((Property)AGE);
        if (i < 3 && serverLevel.getRawBrightness(pos.above(), 0) >= 9 && ForgeHooks.onCropsGrowPre((Level)serverLevel, (BlockPos)pos, (BlockState)blockState, (randomSource.nextInt(5) == 0 ? 1 : 0) != 0)) {
            BlockState blockstate = (BlockState)blockState.setValue((Property)AGE, (Comparable)Integer.valueOf(i + 1));
            serverLevel.setBlock(pos, blockstate, 2);
            serverLevel.gameEvent((Holder)GameEvent.BLOCK_CHANGE, pos, GameEvent.Context.of((BlockState)blockstate));
            ForgeHooks.onCropsGrowPost((Level)serverLevel, (BlockPos)pos, (BlockState)blockState);
        }
    }

    public void entityInside(BlockState blockState, Level level, BlockPos pos, Entity type) {
        if (type instanceof LivingEntity && type.getType() != EntityType.FOX && type.getType() != EntityType.BEE) {
            type.makeStuckInBlock(blockState, new Vec3((double)0.8f, 0.75, (double)0.8f));
        }
    }

    protected ItemInteractionResult useItemOn(ItemStack itemStack, BlockState blockState, Level level, BlockPos blockPos, Player player, InteractionHand interactionHand, BlockHitResult blockHitResult) {
        int i = (Integer)blockState.getValue((Property)AGE);
        boolean flag = i == 3;
        return !flag && itemStack.is(Items.BONE_MEAL) ? ItemInteractionResult.SKIP_DEFAULT_BLOCK_INTERACTION : super.useItemOn(itemStack, blockState, level, blockPos, player, interactionHand, blockHitResult);
    }

    protected InteractionResult useWithoutItem(BlockState blockState, Level level, BlockPos blockPos, Player player, BlockHitResult blockHitResult) {
        boolean flag;
        int i = (Integer)blockState.getValue((Property)AGE);
        boolean bl = flag = i == 3;
        if (i > 1) {
            int j = 1 + level.random.nextInt(2);
            BlueBerryBushBlock.popResource((Level)level, (BlockPos)blockPos, (ItemStack)new ItemStack((ItemLike)ModItems.BLUEBERRIES.get(), j + (flag ? 1 : 0)));
            level.playSound(null, blockPos, SoundEvents.SWEET_BERRY_BUSH_PICK_BERRIES, SoundSource.BLOCKS, 1.0f, 0.8f + player.getRandom().nextFloat() * 0.4f);
            BlockState blockstate = (BlockState)blockState.setValue((Property)AGE, (Comparable)Integer.valueOf(1));
            level.setBlock(blockPos, blockstate, 2);
            level.gameEvent((Holder)GameEvent.BLOCK_CHANGE, blockPos, GameEvent.Context.of((Entity)player, (BlockState)blockstate));
            return InteractionResult.sidedSuccess((boolean)level.isClientSide);
        }
        return super.useWithoutItem(blockState, level, blockPos, player, blockHitResult);
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> blockBlockStateBuilder) {
        blockBlockStateBuilder.add(new Property[]{AGE});
    }

    public boolean isValidBonemealTarget(LevelReader levelReader, BlockPos pos, BlockState blockState) {
        return (Integer)blockState.getValue((Property)AGE) < 3;
    }

    public boolean isBonemealSuccess(Level level, RandomSource randomSource, BlockPos pos, BlockState blockState) {
        return true;
    }

    public void performBonemeal(ServerLevel serverLevel, RandomSource randomSource, BlockPos pos, BlockState blockState) {
        int i = Math.min(3, (Integer)blockState.getValue((Property)AGE) + 1);
        serverLevel.setBlock(pos, (BlockState)blockState.setValue((Property)AGE, (Comparable)Integer.valueOf(i)), 2);
    }
}

