/*
 * Decompiled with CFR 0.152.
 */
package net.cinchtail.cinchcraft.block.custom;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.util.Mth;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.item.component.SuspiciousStewEffects;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.BushBlock;
import net.minecraft.world.level.block.FlowerBlock;
import net.minecraft.world.level.block.SuspiciousEffectHolder;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;

public class CrocusFlowerBlock
extends BushBlock
implements SuspiciousEffectHolder {
    protected static final MapCodec<SuspiciousStewEffects> EFFECTS_FIELD = SuspiciousStewEffects.CODEC.fieldOf("suspicious_stew_effects");
    public static final MapCodec<FlowerBlock> CODEC = RecordCodecBuilder.mapCodec(flowerBlockInstance -> flowerBlockInstance.group((App)EFFECTS_FIELD.forGetter(FlowerBlock::getSuspiciousEffects), (App)CrocusFlowerBlock.propertiesCodec()).apply((Applicative)flowerBlockInstance, FlowerBlock::new));
    protected static final float AABB_OFFSET = 3.0f;
    protected static final VoxelShape SHAPE = Block.box((double)2.0, (double)0.0, (double)2.0, (double)14.0, (double)13.0, (double)14.0);
    private final SuspiciousStewEffects suspiciousStewEffects;

    public MapCodec<? extends FlowerBlock> codec() {
        return CODEC;
    }

    public CrocusFlowerBlock(Holder<MobEffect> mobEffectHolder, float v, BlockBehaviour.Properties properties) {
        this(CrocusFlowerBlock.makeEffectList(mobEffectHolder, v), properties);
    }

    public CrocusFlowerBlock(SuspiciousStewEffects suspiciousStewEffects, BlockBehaviour.Properties properties) {
        super(properties);
        this.suspiciousStewEffects = suspiciousStewEffects;
    }

    protected static SuspiciousStewEffects makeEffectList(Holder<MobEffect> mobEffectHolder, float v) {
        return new SuspiciousStewEffects(List.of(new SuspiciousStewEffects.Entry(mobEffectHolder, Mth.floor((float)(v * 20.0f)))));
    }

    protected VoxelShape getShape(BlockState blockState, BlockGetter blockGetter, BlockPos blockPos, CollisionContext collisionContext) {
        Vec3 $$4 = blockState.getOffset(blockGetter, blockPos);
        return SHAPE.move($$4.x, $$4.y, $$4.z);
    }

    public SuspiciousStewEffects getSuspiciousEffects() {
        return this.suspiciousStewEffects;
    }
}

