/*
 * Decompiled with CFR 0.152.
 */
package net.cinchtail.cinchcraft.block.custom;

import javax.annotation.Nullable;
import net.cinchtail.cinchcraft.block.ModBlocks;
import net.cinchtail.cinchcraft.item.ModItems;
import net.cinchtail.cinchcraft.util.ModBlockTags;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.BonemealableBlock;
import net.minecraft.world.level.block.DoublePlantBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.DoubleBlockHalf;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraftforge.common.IPlantable;

public class ModSunflowerCropBlock
extends DoublePlantBlock
implements BonemealableBlock {
    public static final IntegerProperty AGE = BlockStateProperties.AGE_4;
    public static final int MAX_AGE = 4;
    private static final int DOUBLE_PLANT_AGE_INTERSECTION = 3;
    private static final int BONEMEAL_INCREASE = 1;
    private static final VoxelShape FULL_UPPER_SHAPE = Block.box((double)3.0, (double)0.0, (double)3.0, (double)13.0, (double)15.0, (double)13.0);
    private static final VoxelShape FULL_LOWER_SHAPE = Block.box((double)3.0, (double)-1.0, (double)3.0, (double)13.0, (double)16.0, (double)13.0);
    private static final VoxelShape[] UPPER_SHAPE_BY_AGE = new VoxelShape[]{Block.box((double)5.0, (double)0.0, (double)5.0, (double)11.0, (double)10.0, (double)11.0), FULL_UPPER_SHAPE};
    private static final VoxelShape[] LOWER_SHAPE_BY_AGE = new VoxelShape[]{Block.box((double)5.0, (double)0.0, (double)5.0, (double)11.0, (double)10.0, (double)11.0), FULL_LOWER_SHAPE, FULL_LOWER_SHAPE, FULL_LOWER_SHAPE, FULL_LOWER_SHAPE};

    public ModSunflowerCropBlock(BlockBehaviour.Properties properties) {
        super(properties);
    }

    private boolean isMaxAge(BlockState blockState) {
        return (Integer)blockState.getValue((Property)AGE) >= 4;
    }

    public boolean isRandomlyTicking(BlockState blockState) {
        return blockState.getValue((Property)HALF) == DoubleBlockHalf.LOWER && !this.isMaxAge(blockState);
    }

    @Nullable
    public BlockState getStateForPlacement(BlockPlaceContext placeContext) {
        return this.defaultBlockState();
    }

    protected boolean mayPlaceOn(BlockState blockState, BlockGetter blockGetter, BlockPos pos) {
        return blockState.is(ModBlockTags.SUNFLOWER_CROP_PLACEABLE);
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> blockBlockStateBuilder) {
        blockBlockStateBuilder.add(new Property[]{AGE});
        super.createBlockStateDefinition(blockBlockStateBuilder);
    }

    public VoxelShape getShape(BlockState blockState, BlockGetter blockGetter, BlockPos pos, CollisionContext collisionContext) {
        return blockState.getValue((Property)HALF) == DoubleBlockHalf.UPPER ? UPPER_SHAPE_BY_AGE[Math.min(Math.abs(4 - ((Integer)blockState.getValue((Property)AGE) + 1)), UPPER_SHAPE_BY_AGE.length - 1)] : LOWER_SHAPE_BY_AGE[(Integer)blockState.getValue((Property)AGE)];
    }

    public BlockState updateShape(BlockState blockState, Direction direction, BlockState blockState1, LevelAccessor levelAccessor, BlockPos pos, BlockPos pos1) {
        return !blockState.canSurvive((LevelReader)levelAccessor, pos) ? Blocks.AIR.defaultBlockState() : blockState;
    }

    public boolean canSurvive(BlockState blockState, LevelReader levelReader, BlockPos pos) {
        if (!ModSunflowerCropBlock.isLower(blockState)) {
            return super.canSurvive(blockState, levelReader, pos);
        }
        return this.mayPlaceOn(levelReader.getBlockState(pos.below()), (BlockGetter)levelReader, pos.below()) && ModSunflowerCropBlock.sufficientLight(levelReader, pos) && ((Integer)blockState.getValue((Property)AGE) < 3 || ModSunflowerCropBlock.isUpper(levelReader.getBlockState(pos.above())));
    }

    public boolean canBeReplaced(BlockState blockState, BlockPlaceContext placeContext) {
        return false;
    }

    public void setPlacedBy(Level level, BlockPos pos, BlockState blockState, LivingEntity livingEntity, ItemStack itemStack) {
    }

    public void randomTick(BlockState blockState, ServerLevel serverLevel, BlockPos pos, RandomSource randomSource) {
        boolean flag;
        float f = ModSunflowerCropBlock.modGetGrowthSpeed((Block)this, (BlockGetter)serverLevel, pos);
        boolean bl = flag = randomSource.nextInt((int)(25.0f / f) + 1) == 0;
        if (flag) {
            this.grow(serverLevel, blockState, pos, 1);
        }
    }

    protected static float modGetGrowthSpeed(Block block, BlockGetter blockGetter, BlockPos pos) {
        boolean flag1;
        float f = 1.0f;
        BlockPos blockpos = pos.below();
        for (int i = -1; i <= 1; ++i) {
            for (int j = -1; j <= 1; ++j) {
                float f1 = 0.0f;
                BlockState blockstate = blockGetter.getBlockState(blockpos.offset(i, 0, j));
                if (blockstate.canSustainPlant(blockGetter, blockpos.offset(i, 0, j), Direction.UP, (IPlantable)block)) {
                    f1 = 3.0f;
                }
                if (i != 0 || j != 0) {
                    f1 /= 4.0f;
                }
                f += f1;
            }
        }
        BlockPos blockpos1 = pos.north();
        BlockPos blockpos2 = pos.south();
        BlockPos blockpos3 = pos.west();
        BlockPos blockpos4 = pos.east();
        boolean flag = blockGetter.getBlockState(blockpos3).is(block) || blockGetter.getBlockState(blockpos4).is(block);
        boolean bl = flag1 = blockGetter.getBlockState(blockpos1).is(block) || blockGetter.getBlockState(blockpos2).is(block);
        if (flag && flag1) {
            f /= 2.0f;
        } else {
            boolean flag2;
            boolean bl2 = flag2 = blockGetter.getBlockState(blockpos3.north()).is(block) || blockGetter.getBlockState(blockpos4.north()).is(block) || blockGetter.getBlockState(blockpos4.south()).is(block) || blockGetter.getBlockState(blockpos3.south()).is(block);
            if (flag2) {
                f /= 2.0f;
            }
        }
        return f;
    }

    private void grow(ServerLevel serverLevel, BlockState blockState, BlockPos pos, int i1) {
        int i = Math.min((Integer)blockState.getValue((Property)AGE) + i1, 4);
        if (this.canGrow((LevelReader)serverLevel, pos, blockState, i)) {
            serverLevel.setBlock(pos, (BlockState)blockState.setValue((Property)AGE, (Comparable)Integer.valueOf(i)), 2);
            if (i >= 3) {
                BlockPos blockpos = pos.above();
                serverLevel.setBlock(blockpos, ModSunflowerCropBlock.copyWaterloggedFrom((LevelReader)serverLevel, (BlockPos)pos, (BlockState)((BlockState)((BlockState)this.defaultBlockState().setValue((Property)AGE, (Comparable)Integer.valueOf(i))).setValue((Property)HALF, (Comparable)DoubleBlockHalf.UPPER))), 3);
            }
        }
    }

    private static boolean canGrowInto(LevelReader levelReader, BlockPos pos) {
        BlockState blockstate = levelReader.getBlockState(pos);
        return blockstate.isAir() || blockstate.is((Block)ModBlocks.SUNFLOWER_CROP.get());
    }

    private static boolean sufficientLight(LevelReader levelReader, BlockPos pos) {
        return levelReader.getRawBrightness(pos, 0) >= 8 || levelReader.canSeeSky(pos);
    }

    private static boolean isLower(BlockState blockState) {
        return blockState.is((Block)ModBlocks.SUNFLOWER_CROP.get()) && blockState.getValue((Property)HALF) == DoubleBlockHalf.LOWER;
    }

    private static boolean isUpper(BlockState blockState) {
        return blockState.is((Block)ModBlocks.SUNFLOWER_CROP.get()) && blockState.getValue((Property)HALF) == DoubleBlockHalf.UPPER;
    }

    private boolean canGrow(LevelReader levelReader, BlockPos pos, BlockState blockState, int i) {
        return !this.isMaxAge(blockState) && ModSunflowerCropBlock.sufficientLight(levelReader, pos) && (i < 3 || ModSunflowerCropBlock.canGrowInto(levelReader, pos.above()));
    }

    @Nullable
    private PosAndState getLowerHalf(LevelReader levelReader, BlockPos pos, BlockState blockState) {
        if (ModSunflowerCropBlock.isLower(blockState)) {
            return new PosAndState(pos, blockState);
        }
        BlockPos blockpos = pos.below();
        BlockState blockstate = levelReader.getBlockState(blockpos);
        return ModSunflowerCropBlock.isLower(blockstate) ? new PosAndState(blockpos, blockstate) : null;
    }

    public boolean isValidBonemealTarget(LevelReader levelReader, BlockPos pos, BlockState blockState) {
        PosAndState modsunflowercropblock$posandstate = this.getLowerHalf(levelReader, pos, blockState);
        return modsunflowercropblock$posandstate != null && this.canGrow(levelReader, modsunflowercropblock$posandstate.pos, modsunflowercropblock$posandstate.state, (Integer)modsunflowercropblock$posandstate.state.getValue((Property)AGE) + 1);
    }

    public boolean isBonemealSuccess(Level level, RandomSource randomSource, BlockPos pos, BlockState blockState) {
        return true;
    }

    public void performBonemeal(ServerLevel serverLevel, RandomSource randomSource, BlockPos pos, BlockState blockState) {
        PosAndState modsunflowercropblock$posandstate = this.getLowerHalf((LevelReader)serverLevel, pos, blockState);
        if (modsunflowercropblock$posandstate != null) {
            this.grow(serverLevel, modsunflowercropblock$posandstate.state, modsunflowercropblock$posandstate.pos, 1);
        }
    }

    public ItemStack getCloneItemStack(BlockGetter blockGetter, BlockPos pos, BlockState blockState) {
        return new ItemStack((ItemLike)ModItems.SUNFLOWER_SEEDS.get());
    }

    record PosAndState(BlockPos pos, BlockState state) {
    }
}

