/*
 * Decompiled with CFR 0.152.
 */
package net.cinchtail.cinchcraft.block.custom;

import javax.annotation.Nullable;
import net.cinchtail.cinchcraft.block.ModBlocks;
import net.cinchtail.cinchcraft.item.ModItems;
import net.cinchtail.cinchcraft.util.ModBlockTags;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.BonemealableBlock;
import net.minecraft.world.level.block.DoublePlantBlock;
import net.minecraft.world.level.block.SimpleWaterloggedBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.DoubleBlockHalf;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraftforge.common.IPlantable;

public class ReedsCropBlock
extends DoublePlantBlock
implements SimpleWaterloggedBlock,
BonemealableBlock {
    public static final IntegerProperty AGE = BlockStateProperties.AGE_4;
    public static final int MAX_AGE = 4;
    private static final int DOUBLE_PLANT_AGE_INTERSECTION = 3;
    private static final int BONEMEAL_INCREASE = 1;
    private static final BooleanProperty WATERLOGGED = BlockStateProperties.WATERLOGGED;
    public static final DirectionProperty FACING = BlockStateProperties.HORIZONTAL_FACING;
    private static final VoxelShape FULL_UPPER_SHAPE = Block.box((double)3.0, (double)0.0, (double)3.0, (double)13.0, (double)15.0, (double)13.0);
    private static final VoxelShape FULL_LOWER_SHAPE = Block.box((double)3.0, (double)-1.0, (double)3.0, (double)13.0, (double)16.0, (double)13.0);
    private static final VoxelShape[] UPPER_SHAPE_BY_AGE = new VoxelShape[]{Block.box((double)5.0, (double)0.0, (double)5.0, (double)11.0, (double)10.0, (double)11.0), FULL_UPPER_SHAPE};
    private static final VoxelShape[] LOWER_SHAPE_BY_AGE = new VoxelShape[]{Block.box((double)5.0, (double)0.0, (double)5.0, (double)11.0, (double)10.0, (double)11.0), FULL_LOWER_SHAPE, FULL_LOWER_SHAPE, FULL_LOWER_SHAPE, FULL_LOWER_SHAPE};

    public ReedsCropBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.registerDefaultState((BlockState)((BlockState)((BlockState)((BlockState)this.stateDefinition.any()).setValue((Property)HALF, (Comparable)DoubleBlockHalf.LOWER)).setValue((Property)WATERLOGGED, (Comparable)Boolean.TRUE)).setValue((Property)FACING, (Comparable)Direction.NORTH));
    }

    private boolean isMaxAge(BlockState blockState) {
        return (Integer)blockState.getValue((Property)AGE) >= 4;
    }

    public boolean isRandomlyTicking(BlockState blockState) {
        return blockState.getValue((Property)HALF) == DoubleBlockHalf.LOWER && !this.isMaxAge(blockState);
    }

    public ItemStack getCloneItemStack(LevelReader levelReader, BlockPos blockPos, BlockState blockState) {
        return new ItemStack((ItemLike)ModItems.REEDS_SEEDS.get());
    }

    public VoxelShape getShape(BlockState blockState, BlockGetter blockGetter, BlockPos pos, CollisionContext collisionContext) {
        return blockState.getValue((Property)HALF) == DoubleBlockHalf.UPPER ? UPPER_SHAPE_BY_AGE[Math.min(Math.abs(4 - ((Integer)blockState.getValue((Property)AGE) + 1)), UPPER_SHAPE_BY_AGE.length - 1)] : LOWER_SHAPE_BY_AGE[(Integer)blockState.getValue((Property)AGE)];
    }

    @Nullable
    public BlockState getStateForPlacement(BlockPlaceContext placeContext) {
        BlockState blockstate = super.getStateForPlacement(placeContext);
        return blockstate != null ? ReedsCropBlock.copyWaterloggedFrom((LevelReader)placeContext.getLevel(), (BlockPos)placeContext.getClickedPos(), (BlockState)((BlockState)blockstate.setValue((Property)FACING, (Comparable)placeContext.getHorizontalDirection().getOpposite()))) : null;
    }

    public void setPlacedBy(Level blockstate1, BlockPos pos, BlockState blockState, LivingEntity livingEntity, ItemStack itemStack) {
    }

    public boolean canBeReplaced(BlockState blockState, BlockPlaceContext placeContext) {
        return false;
    }

    public FluidState getFluidState(BlockState blockState) {
        return (Boolean)blockState.getValue((Property)WATERLOGGED) != false ? Fluids.WATER.getSource(false) : super.getFluidState(blockState);
    }

    public boolean canSurvive(BlockState blockState, LevelReader levelReader, BlockPos pos) {
        if (blockState.getValue((Property)HALF) == DoubleBlockHalf.UPPER) {
            BlockState blockstate = levelReader.getBlockState(pos.below());
            return blockstate.is((Block)this) && blockstate.getValue((Property)HALF) == DoubleBlockHalf.LOWER && ReedsCropBlock.sufficientLight(levelReader, pos) || ReedsCropBlock.isUpper(levelReader.getBlockState(pos.above()));
        }
        if (blockState.getValue((Property)HALF) == DoubleBlockHalf.LOWER && ((Boolean)blockState.getValue((Property)WATERLOGGED)).booleanValue()) {
            return levelReader.getBlockState(pos.below()).is(ModBlockTags.REEDS_PLACEABLE) && levelReader.getFluidState(pos).is((Fluid)Fluids.WATER) && levelReader.getFluidState(pos.above()).isEmpty();
        }
        return false;
    }

    public BlockState updateShape(BlockState blockState, Direction direction, BlockState blockState1, LevelAccessor levelAccessor, BlockPos pos, BlockPos pos1) {
        if (((Boolean)blockState.getValue((Property)WATERLOGGED)).booleanValue()) {
            levelAccessor.scheduleTick(pos, (Fluid)Fluids.WATER, Fluids.WATER.getTickDelay((LevelReader)levelAccessor));
        }
        return super.updateShape(blockState, direction, blockState1, levelAccessor, pos, pos1);
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> blockBlockStateBuilder) {
        blockBlockStateBuilder.add(new Property[]{HALF, WATERLOGGED, FACING, AGE});
    }

    public void randomTick(BlockState blockState, ServerLevel serverLevel, BlockPos pos, RandomSource randomSource) {
        boolean flag;
        float f = ReedsCropBlock.modGetGrowthSpeed((Block)this, (BlockGetter)serverLevel, pos);
        boolean bl = flag = randomSource.nextInt((int)(25.0f / f) + 1) == 0;
        if (flag) {
            this.grow(serverLevel, blockState, pos, 1);
        }
    }

    protected static float modGetGrowthSpeed(Block block, BlockGetter blockGetter, BlockPos pos) {
        boolean flag1;
        float f = 1.0f;
        BlockPos blockpos = pos.below();
        for (int i = -1; i <= 1; ++i) {
            for (int j = -1; j <= 1; ++j) {
                float f1 = 0.0f;
                BlockState blockstate = blockGetter.getBlockState(blockpos.offset(i, 0, j));
                if (blockstate.canSustainPlant(blockGetter, blockpos.offset(i, 0, j), Direction.UP, (IPlantable)block)) {
                    f1 = 3.0f;
                }
                if (i != 0 || j != 0) {
                    f1 /= 4.0f;
                }
                f += f1;
            }
        }
        BlockPos blockpos1 = pos.north();
        BlockPos blockpos2 = pos.south();
        BlockPos blockpos3 = pos.west();
        BlockPos blockpos4 = pos.east();
        boolean flag = blockGetter.getBlockState(blockpos3).is(block) || blockGetter.getBlockState(blockpos4).is(block);
        boolean bl = flag1 = blockGetter.getBlockState(blockpos1).is(block) || blockGetter.getBlockState(blockpos2).is(block);
        if (flag && flag1) {
            f /= 2.0f;
        } else {
            boolean flag2;
            boolean bl2 = flag2 = blockGetter.getBlockState(blockpos3.north()).is(block) || blockGetter.getBlockState(blockpos4.north()).is(block) || blockGetter.getBlockState(blockpos4.south()).is(block) || blockGetter.getBlockState(blockpos3.south()).is(block);
            if (flag2) {
                f /= 2.0f;
            }
        }
        return f;
    }

    private void grow(ServerLevel serverLevel, BlockState blockState, BlockPos pos, int i1) {
        int i = Math.min((Integer)blockState.getValue((Property)AGE) + i1, 4);
        if (this.canGrow((LevelReader)serverLevel, pos, blockState, i)) {
            serverLevel.setBlock(pos, (BlockState)blockState.setValue((Property)AGE, (Comparable)Integer.valueOf(i)), 2);
            if (i >= 3) {
                BlockPos blockpos = pos.above();
                serverLevel.setBlock(blockpos, (BlockState)((BlockState)((BlockState)this.defaultBlockState().setValue((Property)AGE, (Comparable)Integer.valueOf(i))).setValue((Property)HALF, (Comparable)DoubleBlockHalf.UPPER)).setValue((Property)WATERLOGGED, (Comparable)Boolean.valueOf(false)), 3);
            }
        }
    }

    private static boolean canGrowInto(LevelReader levelReader, BlockPos pos) {
        BlockState blockstate = levelReader.getBlockState(pos);
        return blockstate.isAir() || blockstate.is((Block)ModBlocks.REEDS_CROP_BLOCK.get());
    }

    private static boolean sufficientLight(LevelReader levelReader, BlockPos pos) {
        return levelReader.getRawBrightness(pos, 0) >= 8 || levelReader.canSeeSky(pos);
    }

    private static boolean isLower(BlockState blockState) {
        return blockState.is((Block)ModBlocks.REEDS_CROP_BLOCK.get()) && blockState.getValue((Property)HALF) == DoubleBlockHalf.LOWER;
    }

    private static boolean isUpper(BlockState blockState) {
        return blockState.is((Block)ModBlocks.REEDS_CROP_BLOCK.get()) && blockState.getValue((Property)HALF) == DoubleBlockHalf.UPPER;
    }

    private boolean canGrow(LevelReader levelReader, BlockPos pos, BlockState blockState, int i) {
        return !this.isMaxAge(blockState) && ReedsCropBlock.sufficientLight(levelReader, pos) && (i < 3 || ReedsCropBlock.canGrowInto(levelReader, pos.above()));
    }

    @Nullable
    private PosAndState getLowerHalf(LevelReader levelReader, BlockPos pos, BlockState blockState) {
        if (ReedsCropBlock.isLower(blockState)) {
            return new PosAndState(pos, blockState);
        }
        BlockPos blockpos = pos.below();
        BlockState blockstate = levelReader.getBlockState(blockpos);
        return ReedsCropBlock.isLower(blockstate) ? new PosAndState(blockpos, blockstate) : null;
    }

    public boolean isValidBonemealTarget(LevelReader levelReader, BlockPos pos, BlockState blockState) {
        PosAndState reedscropblock$posandstate = this.getLowerHalf(levelReader, pos, blockState);
        return reedscropblock$posandstate != null && this.canGrow(levelReader, reedscropblock$posandstate.pos, reedscropblock$posandstate.state, (Integer)reedscropblock$posandstate.state.getValue((Property)AGE) + 1);
    }

    public boolean isBonemealSuccess(Level level, RandomSource randomSource, BlockPos pos, BlockState blockState) {
        return true;
    }

    public void performBonemeal(ServerLevel serverLevel, RandomSource randomSource, BlockPos pos, BlockState blockState) {
        PosAndState reedscropblock$posandstate = this.getLowerHalf((LevelReader)serverLevel, pos, blockState);
        if (reedscropblock$posandstate != null) {
            this.grow(serverLevel, reedscropblock$posandstate.state, reedscropblock$posandstate.pos, 1);
        }
    }

    public float getMaxVerticalOffset() {
        return 0.1f;
    }

    record PosAndState(BlockPos pos, BlockState state) {
    }
}

