/*
 * Decompiled with CFR 0.152.
 */
package net.cinchtail.cinchcraft.datagen;

import java.util.Objects;
import java.util.function.Supplier;
import net.cinchtail.cinchcraft.block.ModBlocks;
import net.minecraft.data.PackOutput;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.ButtonBlock;
import net.minecraft.world.level.block.DoorBlock;
import net.minecraft.world.level.block.FenceBlock;
import net.minecraft.world.level.block.FenceGateBlock;
import net.minecraft.world.level.block.PressurePlateBlock;
import net.minecraft.world.level.block.RotatedPillarBlock;
import net.minecraft.world.level.block.SlabBlock;
import net.minecraft.world.level.block.StairBlock;
import net.minecraft.world.level.block.StandingSignBlock;
import net.minecraft.world.level.block.TrapDoorBlock;
import net.minecraft.world.level.block.WallBlock;
import net.minecraft.world.level.block.WallSignBlock;
import net.minecraftforge.client.model.generators.BlockStateProvider;
import net.minecraftforge.client.model.generators.ModelBuilder;
import net.minecraftforge.client.model.generators.ModelFile;
import net.minecraftforge.common.data.ExistingFileHelper;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.RegistryObject;

public class ModBlockStateProvider
extends BlockStateProvider {
    public ModBlockStateProvider(PackOutput output, ExistingFileHelper exFileHelper) {
        super(output, "cinchcraft", exFileHelper);
    }

    protected void registerStatesAndModels() {
        this.blockWithItem(ModBlocks.BLOCK_OF_RUBY);
        this.blockWithItem(ModBlocks.RUBY_ORE);
        this.blockWithItem(ModBlocks.DEEPSLATE_RUBY_ORE);
        this.blockWithItem(ModBlocks.NETHER_RUBY_ORE);
        this.blockWithItem(ModBlocks.NETHER_IRON_ORE);
        this.blockWithItem(ModBlocks.NETHER_COPPER_ORE);
        this.blockWithItem(ModBlocks.NETHER_COAL_ORE);
        this.blockWithItem(ModBlocks.NETHER_LAPIS_LAZULI_ORE);
        this.blockWithItem(ModBlocks.NETHER_REDSTONE_ORE);
        this.blockWithItem(ModBlocks.NETHER_DIAMOND_ORE);
        this.blockWithItem(ModBlocks.NETHER_EMERALD_ORE);
        this.blockWithItem(ModBlocks.CHISELED_END_STONE_BRICKS);
        this.blockWithItem(ModBlocks.CHISELED_RED_NETHER_BRICKS);
        this.blockWithItem(ModBlocks.CRACKED_RED_NETHER_BRICKS);
        this.blockWithItem(ModBlocks.MOSSY_MUD_BRICKS);
        this.blockWithItem(ModBlocks.CHISELED_MUD_BRICKS);
        this.blockWithItem(ModBlocks.CRACKED_MUD_BRICKS);
        this.blockWithItem(ModBlocks.POLISHED_CALCITE);
        this.blockWithItem(ModBlocks.POLISHED_DRIPSTONE_BLOCK);
        this.blockWithItem(ModBlocks.MOSSY_COBBLED_DEEPSLATE);
        this.blockWithItem(ModBlocks.MOSSY_DEEPSLATE_BRICKS);
        this.blockWithItem(ModBlocks.MOSSY_DEEPSLATE_TILES);
        this.blockWithItem(ModBlocks.CRACKED_QUARTZ_BRICKS);
        this.blockWithItem(ModBlocks.MOSSY_NETHER_BRICKS);
        this.blockWithItem(ModBlocks.CRIMSON_MOSSY_NETHER_BRICKS);
        this.blockWithItem(ModBlocks.WARPED_MOSSY_NETHER_BRICKS);
        this.blockWithItem(ModBlocks.CRACKED_BRICKS);
        this.blockWithItem(ModBlocks.CRACKED_PRISMARINE_BRICKS);
        this.blockWithItem(ModBlocks.CRACKED_END_STONE_BRICKS);
        this.blockWithItem(ModBlocks.AZALEA_PLANKS);
        this.blockWithItem(ModBlocks.MOSSY_BRICKS);
        this.blockWithItem(ModBlocks.MOSSY_QUARTZ_BRICKS);
        this.blockWithItem(ModBlocks.CRACKED_TUFF_BRICKS);
        this.vanillaSlabBlock(ModBlocks.CALCITE_SLAB, Blocks.CALCITE);
        this.vanillaSlabBlock(ModBlocks.DRIPSTONE_SLAB, Blocks.DRIPSTONE_BLOCK);
        this.vanillaSlabBlock(ModBlocks.QUARTZ_BRICK_SLAB, Blocks.QUARTZ_BRICKS);
        this.vanillaSlabBlock(ModBlocks.END_STONE_SLAB, Blocks.END_STONE);
        this.modSlabBlock(ModBlocks.MOSSY_MUD_BRICK_SLAB, ModBlocks.MOSSY_MUD_BRICKS);
        this.modSlabBlock(ModBlocks.POLISHED_CALCITE_SLAB, ModBlocks.POLISHED_CALCITE);
        this.modSlabBlock(ModBlocks.POLISHED_DRIPSTONE_SLAB, ModBlocks.POLISHED_DRIPSTONE_BLOCK);
        this.modSlabBlock(ModBlocks.MOSSY_COBBLED_DEEPSLATE_SLAB, ModBlocks.MOSSY_COBBLED_DEEPSLATE);
        this.modSlabBlock(ModBlocks.MOSSY_DEEPSLATE_BRICK_SLAB, ModBlocks.MOSSY_DEEPSLATE_BRICKS);
        this.modSlabBlock(ModBlocks.MOSSY_DEEPSLATE_TILE_SLAB, ModBlocks.MOSSY_DEEPSLATE_TILES);
        this.vanillaSlabBlock(ModBlocks.CRACKED_STONE_BRICK_SLAB, Blocks.CRACKED_STONE_BRICKS);
        this.vanillaSlabBlock(ModBlocks.CRACKED_DEEPSLATE_BRICK_SLAB, Blocks.CRACKED_DEEPSLATE_BRICKS);
        this.vanillaSlabBlock(ModBlocks.CRACKED_DEEPSLATE_TILE_SLAB, Blocks.CRACKED_DEEPSLATE_TILES);
        this.vanillaSlabBlock(ModBlocks.CRACKED_POLISHED_BLACKSTONE_BRICK_SLAB, Blocks.CRACKED_POLISHED_BLACKSTONE_BRICKS);
        this.vanillaSlabBlock(ModBlocks.CRACKED_NETHER_BRICK_SLAB, Blocks.CRACKED_NETHER_BRICKS);
        this.modSlabBlock(ModBlocks.CRACKED_RED_NETHER_BRICK_SLAB, ModBlocks.CRACKED_RED_NETHER_BRICKS);
        this.modSlabBlock(ModBlocks.CRACKED_MUD_BRICK_SLAB, ModBlocks.CRACKED_MUD_BRICKS);
        this.modSlabBlock(ModBlocks.CRACKED_QUARTZ_BRICK_SLAB, ModBlocks.CRACKED_QUARTZ_BRICKS);
        this.vanillaSlabBlock(ModBlocks.SMOOTH_BASALT_SLAB, Blocks.SMOOTH_BASALT);
        this.modSlabBlock(ModBlocks.MOSSY_NETHER_BRICK_SLAB, ModBlocks.MOSSY_NETHER_BRICKS);
        this.modSlabBlock(ModBlocks.CRIMSON_MOSSY_NETHER_BRICK_SLAB, ModBlocks.CRIMSON_MOSSY_NETHER_BRICKS);
        this.modSlabBlock(ModBlocks.WARPED_MOSSY_NETHER_BRICK_SLAB, ModBlocks.WARPED_MOSSY_NETHER_BRICKS);
        this.modSlabBlock(ModBlocks.CRACKED_BRICK_SLAB, ModBlocks.CRACKED_BRICKS);
        this.modSlabBlock(ModBlocks.CRACKED_PRISMARINE_BRICK_SLAB, ModBlocks.CRACKED_PRISMARINE_BRICKS);
        this.modSlabBlock(ModBlocks.CRACKED_END_STONE_BRICK_SLAB, ModBlocks.CRACKED_END_STONE_BRICKS);
        this.modSlabBlock(ModBlocks.AZALEA_SLAB, ModBlocks.AZALEA_PLANKS);
        this.modSlabBlock(ModBlocks.MOSSY_BRICK_SLAB, ModBlocks.MOSSY_BRICKS);
        this.modSlabBlock(ModBlocks.MOSSY_QUARTZ_BRICK_SLAB, ModBlocks.MOSSY_QUARTZ_BRICKS);
        this.modSlabBlock(ModBlocks.CRACKED_TUFF_BRICK_SLAB, ModBlocks.CRACKED_TUFF_BRICKS);
        this.vanillaStairsBlock(ModBlocks.SMOOTH_STONE_STAIRS, Blocks.SMOOTH_STONE);
        this.vanillaStairsBlock(ModBlocks.CALCITE_STAIRS, Blocks.CALCITE);
        this.vanillaStairsBlock(ModBlocks.DRIPSTONE_STAIRS, Blocks.DRIPSTONE_BLOCK);
        this.vanillaStairsBlock(ModBlocks.QUARTZ_BRICK_STAIRS, Blocks.QUARTZ_BRICKS);
        this.vanillaStairsBlock(ModBlocks.END_STONE_STAIRS, Blocks.END_STONE);
        this.modStairsBlock(ModBlocks.MOSSY_MUD_BRICK_STAIRS, ModBlocks.MOSSY_MUD_BRICKS);
        this.modStairsBlock(ModBlocks.POLISHED_CALCITE_STAIRS, ModBlocks.POLISHED_CALCITE);
        this.modStairsBlock(ModBlocks.POLISHED_DRIPSTONE_STAIRS, ModBlocks.POLISHED_DRIPSTONE_BLOCK);
        this.modStairsBlock(ModBlocks.MOSSY_COBBLED_DEEPSLATE_STAIRS, ModBlocks.MOSSY_COBBLED_DEEPSLATE);
        this.modStairsBlock(ModBlocks.MOSSY_DEEPSLATE_BRICK_STAIRS, ModBlocks.MOSSY_DEEPSLATE_BRICKS);
        this.modStairsBlock(ModBlocks.MOSSY_DEEPSLATE_TILE_STAIRS, ModBlocks.MOSSY_DEEPSLATE_TILES);
        this.vanillaStairsBlock(ModBlocks.CRACKED_STONE_BRICK_STAIRS, Blocks.CRACKED_STONE_BRICKS);
        this.vanillaStairsBlock(ModBlocks.CRACKED_DEEPSLATE_BRICK_STAIRS, Blocks.CRACKED_DEEPSLATE_BRICKS);
        this.vanillaStairsBlock(ModBlocks.CRACKED_DEEPSLATE_TILE_STAIRS, Blocks.CRACKED_DEEPSLATE_TILES);
        this.vanillaStairsBlock(ModBlocks.CRACKED_POLISHED_BLACKSTONE_BRICK_STAIRS, Blocks.CRACKED_POLISHED_BLACKSTONE_BRICKS);
        this.vanillaStairsBlock(ModBlocks.CRACKED_NETHER_BRICK_STAIRS, Blocks.CRACKED_NETHER_BRICKS);
        this.modStairsBlock(ModBlocks.CRACKED_RED_NETHER_BRICK_STAIRS, ModBlocks.CRACKED_RED_NETHER_BRICKS);
        this.modStairsBlock(ModBlocks.CRACKED_MUD_BRICK_STAIRS, ModBlocks.CRACKED_MUD_BRICKS);
        this.modStairsBlock(ModBlocks.CRACKED_QUARTZ_BRICK_STAIRS, ModBlocks.CRACKED_QUARTZ_BRICKS);
        this.vanillaStairsBlock(ModBlocks.SMOOTH_BASALT_STAIRS, Blocks.SMOOTH_BASALT);
        this.modStairsBlock(ModBlocks.MOSSY_NETHER_BRICK_STAIRS, ModBlocks.MOSSY_NETHER_BRICKS);
        this.modStairsBlock(ModBlocks.CRIMSON_MOSSY_NETHER_BRICK_STAIRS, ModBlocks.CRIMSON_MOSSY_NETHER_BRICKS);
        this.modStairsBlock(ModBlocks.WARPED_MOSSY_NETHER_BRICK_STAIRS, ModBlocks.WARPED_MOSSY_NETHER_BRICKS);
        this.modStairsBlock(ModBlocks.CRACKED_BRICK_STAIRS, ModBlocks.CRACKED_BRICKS);
        this.modStairsBlock(ModBlocks.CRACKED_PRISMARINE_BRICK_STAIRS, ModBlocks.CRACKED_PRISMARINE_BRICKS);
        this.modStairsBlock(ModBlocks.CRACKED_END_STONE_BRICK_STAIRS, ModBlocks.CRACKED_END_STONE_BRICKS);
        this.modStairsBlock(ModBlocks.AZALEA_STAIRS, ModBlocks.AZALEA_PLANKS);
        this.modStairsBlock(ModBlocks.MOSSY_BRICK_STAIRS, ModBlocks.MOSSY_BRICKS);
        this.modStairsBlock(ModBlocks.MOSSY_QUARTZ_BRICK_STAIRS, ModBlocks.MOSSY_QUARTZ_BRICKS);
        this.modStairsBlock(ModBlocks.CRACKED_TUFF_BRICK_STAIRS, ModBlocks.CRACKED_TUFF_BRICKS);
        this.vanillaWallBlock(ModBlocks.SMOOTH_STONE_WALL, Blocks.SMOOTH_STONE);
        this.vanillaWallBlock(ModBlocks.STONE_WALL, Blocks.STONE);
        this.vanillaWallBlock(ModBlocks.POLISHED_ANDESITE_WALL, Blocks.POLISHED_ANDESITE);
        this.vanillaWallBlock(ModBlocks.POLISHED_DIORITE_WALL, Blocks.POLISHED_DIORITE);
        this.vanillaWallBlock(ModBlocks.POLISHED_GRANITE_WALL, Blocks.POLISHED_GRANITE);
        this.vanillaWallBlock(ModBlocks.PRISMARINE_BRICK_WALL, Blocks.PRISMARINE_BRICKS);
        this.vanillaWallBlock(ModBlocks.DARK_PRISMARINE_WALL, Blocks.DARK_PRISMARINE);
        this.vanillaWallBlock(ModBlocks.PURPUR_WALL, Blocks.PURPUR_BLOCK);
        this.vanillaWallBlock(ModBlocks.CALCITE_WALL, Blocks.CALCITE);
        this.vanillaWallBlock(ModBlocks.DRIPSTONE_WALL, Blocks.DRIPSTONE_BLOCK);
        this.vanillaWallBlock(ModBlocks.QUARTZ_BRICK_WALL, Blocks.QUARTZ_BRICKS);
        this.vanillaWallBlock(ModBlocks.CUT_SANDSTONE_WALL, Blocks.CUT_SANDSTONE);
        this.vanillaWallBlock(ModBlocks.CUT_RED_SANDSTONE_WALL, Blocks.CUT_RED_SANDSTONE);
        this.vanillaWallBlock(ModBlocks.END_STONE_WALL, Blocks.END_STONE);
        this.vanillaWallBlock(ModBlocks.CRACKED_STONE_BRICK_WALL, Blocks.CRACKED_STONE_BRICKS);
        this.vanillaWallBlock(ModBlocks.CRACKED_DEEPSLATE_BRICK_WALL, Blocks.CRACKED_DEEPSLATE_BRICKS);
        this.vanillaWallBlock(ModBlocks.CRACKED_DEEPSLATE_TILE_WALL, Blocks.CRACKED_DEEPSLATE_TILES);
        this.vanillaWallBlock(ModBlocks.CRACKED_POLISHED_BLACKSTONE_BRICK_WALL, Blocks.CRACKED_POLISHED_BLACKSTONE_BRICKS);
        this.vanillaWallBlock(ModBlocks.CRACKED_NETHER_BRICK_WALL, Blocks.CRACKED_NETHER_BRICKS);
        this.vanillaWallBlock(ModBlocks.SMOOTH_BASALT_WALL, Blocks.SMOOTH_BASALT);
        this.vanillaWallBlock(ModBlocks.DEEPSLATE_WALL, Blocks.DEEPSLATE);
        this.modWallBlock(ModBlocks.MOSSY_MUD_BRICK_WALL, ModBlocks.MOSSY_MUD_BRICKS);
        this.modWallBlock(ModBlocks.POLISHED_CALCITE_WALL, ModBlocks.POLISHED_CALCITE);
        this.modWallBlock(ModBlocks.POLISHED_DRIPSTONE_WALL, ModBlocks.POLISHED_DRIPSTONE_BLOCK);
        this.modWallBlock(ModBlocks.MOSSY_COBBLED_DEEPSLATE_WALL, ModBlocks.MOSSY_COBBLED_DEEPSLATE);
        this.modWallBlock(ModBlocks.MOSSY_DEEPSLATE_BRICK_WALL, ModBlocks.MOSSY_DEEPSLATE_BRICKS);
        this.modWallBlock(ModBlocks.MOSSY_DEEPSLATE_TILE_WALL, ModBlocks.MOSSY_DEEPSLATE_TILES);
        this.modWallBlock(ModBlocks.CRACKED_RED_NETHER_BRICK_WALL, ModBlocks.CRACKED_RED_NETHER_BRICKS);
        this.modWallBlock(ModBlocks.CRACKED_MUD_BRICK_WALL, ModBlocks.CRACKED_MUD_BRICKS);
        this.modWallBlock(ModBlocks.CRACKED_QUARTZ_BRICK_WALL, ModBlocks.CRACKED_QUARTZ_BRICKS);
        this.modWallBlock(ModBlocks.MOSSY_NETHER_BRICK_WALL, ModBlocks.MOSSY_NETHER_BRICKS);
        this.modWallBlock(ModBlocks.CRIMSON_MOSSY_NETHER_BRICK_WALL, ModBlocks.CRIMSON_MOSSY_NETHER_BRICKS);
        this.modWallBlock(ModBlocks.WARPED_MOSSY_NETHER_BRICK_WALL, ModBlocks.WARPED_MOSSY_NETHER_BRICKS);
        this.modWallBlock(ModBlocks.CRACKED_BRICK_WALL, ModBlocks.CRACKED_BRICKS);
        this.modWallBlock(ModBlocks.CRACKED_PRISMARINE_BRICK_WALL, ModBlocks.CRACKED_PRISMARINE_BRICKS);
        this.modWallBlock(ModBlocks.CRACKED_END_STONE_BRICK_WALL, ModBlocks.CRACKED_END_STONE_BRICKS);
        this.modWallBlock(ModBlocks.MOSSY_BRICK_WALL, ModBlocks.MOSSY_BRICKS);
        this.modWallBlock(ModBlocks.MOSSY_QUARTZ_BRICK_WALL, ModBlocks.MOSSY_QUARTZ_BRICKS);
        this.modWallBlock(ModBlocks.CRACKED_TUFF_BRICK_WALL, ModBlocks.CRACKED_TUFF_BRICKS);
        this.vanillaFenceBlock(ModBlocks.RED_NETHER_BRICK_FENCE, Blocks.RED_NETHER_BRICKS);
        this.vanillaFenceBlock(ModBlocks.CRACKED_NETHER_BRICK_FENCE, Blocks.CRACKED_NETHER_BRICKS);
        this.modFenceBlock(ModBlocks.MOSSY_NETHER_BRICK_FENCE, ModBlocks.MOSSY_NETHER_BRICKS);
        this.modFenceBlock(ModBlocks.CRIMSON_MOSSY_NETHER_BRICK_FENCE, ModBlocks.CRIMSON_MOSSY_NETHER_BRICKS);
        this.modFenceBlock(ModBlocks.WARPED_MOSSY_NETHER_BRICK_FENCE, ModBlocks.WARPED_MOSSY_NETHER_BRICKS);
        this.modFenceBlock(ModBlocks.AZALEA_FENCE, ModBlocks.AZALEA_PLANKS);
        this.modFenceBlock(ModBlocks.CRACKED_RED_NETHER_BRICK_FENCE, ModBlocks.CRACKED_RED_NETHER_BRICKS);
        this.fenceGateBlock((FenceGateBlock)ModBlocks.AZALEA_FENCE_GATE.get(), this.blockLoc((Supplier<? extends Block>)ModBlocks.AZALEA_PLANKS));
        this.vanillaButtonBlock(ModBlocks.POLISHED_DEEPSLATE_BUTTON, Blocks.POLISHED_DEEPSLATE);
        this.vanillaButtonBlock(ModBlocks.IRON_BUTTON, Blocks.IRON_BLOCK);
        this.vanillaButtonBlock(ModBlocks.GOLD_BUTTON, Blocks.GOLD_BLOCK);
        this.modButtonBlock(ModBlocks.AZALEA_BUTTON, ModBlocks.AZALEA_PLANKS);
        this.pressurePlateBlock((PressurePlateBlock)ModBlocks.POLISHED_DEEPSLATE_PRESSURE_PLATE.get(), this.blockTexture(Blocks.POLISHED_DEEPSLATE));
        this.pressurePlateBlock((PressurePlateBlock)ModBlocks.AZALEA_PRESSURE_PLATE.get(), this.blockLoc((Supplier<? extends Block>)ModBlocks.AZALEA_PLANKS));
        this.logBlock((RotatedPillarBlock)ModBlocks.AZALEA_LOG.get());
        this.axisBlock((RotatedPillarBlock)ModBlocks.AZALEA_WOOD.get(), this.blockTexture((Block)ModBlocks.AZALEA_LOG.get()), this.blockTexture((Block)ModBlocks.AZALEA_LOG.get()));
        this.axisBlock((RotatedPillarBlock)ModBlocks.STRIPPED_AZALEA_LOG.get(), ResourceLocation.fromNamespaceAndPath((String)"cinchcraft", (String)"block/stripped_azalea_log"), ResourceLocation.fromNamespaceAndPath((String)"cinchcraft", (String)"block/stripped_azalea_log_top"));
        this.axisBlock((RotatedPillarBlock)ModBlocks.STRIPPED_AZALEA_WOOD.get(), ResourceLocation.fromNamespaceAndPath((String)"cinchcraft", (String)"block/stripped_azalea_log"), ResourceLocation.fromNamespaceAndPath((String)"cinchcraft", (String)"block/stripped_azalea_log"));
        this.signBlock(ModBlocks.AZALEA_SIGN, ModBlocks.AZALEA_WALL_SIGN, ModBlocks.AZALEA_PLANKS);
        this.hangingSignBlock(ModBlocks.AZALEA_HANGING_SIGN, ModBlocks.AZALEA_WALL_HANGING_SIGN, ModBlocks.AZALEA_PLANKS);
        this.blockItem(ModBlocks.AZALEA_PRESSURE_PLATE);
        this.blockItem(ModBlocks.POLISHED_DEEPSLATE_PRESSURE_PLATE);
        this.blockItem(ModBlocks.AZALEA_LOG);
        this.blockItem(ModBlocks.AZALEA_WOOD);
        this.blockItem(ModBlocks.STRIPPED_AZALEA_LOG);
        this.blockItem(ModBlocks.STRIPPED_AZALEA_WOOD);
        this.blockItem(ModBlocks.AZALEA_FENCE_GATE);
        this.trapDoorBlockItem(ModBlocks.AZALEA_TRAPDOOR, "_bottom");
        this.doorBlock(ModBlocks.AZALEA_DOOR, true);
        this.trapdoorBlock(ModBlocks.AZALEA_TRAPDOOR, true);
    }

    private void blockItem(RegistryObject<Block> blockRegistryObject) {
        this.simpleBlockItem((Block)blockRegistryObject.get(), (ModelFile)new ModelFile.UncheckedModelFile("cinchcraft:block/" + Objects.requireNonNull(ForgeRegistries.BLOCKS.getKey((Object)((Block)blockRegistryObject.get()))).getPath()));
    }

    public void blockWithItem(RegistryObject<Block> blockRegistryObject) {
        this.simpleBlockWithItem((Block)blockRegistryObject.get(), this.cubeAll((Block)blockRegistryObject.get()));
    }

    public void vanillaStairsBlock(RegistryObject<Block> block, Block texture) {
        this.simpleBlockItem((Block)block.get(), (ModelFile)this.models().withExistingParent(((Block)block.get()).asItem().toString(), this.blockTexture(block)));
        this.stairsBlock((StairBlock)block.get(), this.blockTexture(texture));
    }

    public void modStairsBlock(RegistryObject<Block> block, RegistryObject<Block> texture) {
        this.simpleBlockItem((Block)block.get(), (ModelFile)this.models().withExistingParent(((Block)block.get()).asItem().toString(), this.blockTexture(block)));
        this.stairsBlock((StairBlock)block.get(), this.blockTexture(texture));
    }

    public void vanillaSlabBlock(RegistryObject<Block> block, Block texture) {
        this.simpleBlockItem((Block)block.get(), (ModelFile)this.models().withExistingParent(((Block)block.get()).asItem().toString(), this.blockTexture(block)));
        this.slabBlock((SlabBlock)block.get(), ForgeRegistries.BLOCKS.getKey((Object)texture), this.blockTexture(texture));
    }

    public void modSlabBlock(RegistryObject<Block> block, RegistryObject<Block> texture) {
        this.simpleBlockItem((Block)block.get(), (ModelFile)this.models().withExistingParent(((Block)block.get()).asItem().toString(), this.blockTexture(block)));
        this.slabBlock((SlabBlock)block.get(), texture.getId(), this.blockTexture(texture));
    }

    public void vanillaWallBlock(RegistryObject<Block> block, Block texture) {
        this.simpleBlockItem((Block)block.get(), (ModelFile)this.models().wallInventory(this.key(block).toString(), this.blockTexture(texture)));
        this.wallBlock((WallBlock)block.get(), this.blockTexture(texture));
    }

    public void modWallBlock(RegistryObject<Block> block, RegistryObject<Block> texture) {
        this.simpleBlockItem((Block)block.get(), (ModelFile)this.models().wallInventory(this.key(block).toString(), this.blockTexture(texture)));
        this.wallBlock((WallBlock)block.get(), this.blockTexture(texture));
    }

    public void vanillaFenceBlock(RegistryObject<Block> block, Block texture) {
        this.simpleBlockItem((Block)block.get(), (ModelFile)this.models().fenceInventory(this.key(block).toString(), this.blockTexture(texture)));
        this.fenceBlock((FenceBlock)block.get(), this.blockTexture(texture));
    }

    public void modFenceBlock(RegistryObject<Block> block, RegistryObject<Block> texture) {
        this.simpleBlockItem((Block)block.get(), (ModelFile)this.models().fenceInventory(this.key(block).toString(), this.blockTexture(texture)));
        this.fenceBlock((FenceBlock)block.get(), this.blockTexture(texture));
    }

    private void trapDoorBlockItem(RegistryObject<Block> blockRegistryObject, String appendix) {
        this.simpleBlockItem((Block)blockRegistryObject.get(), (ModelFile)new ModelFile.UncheckedModelFile("cinchcraft:block/" + Objects.requireNonNull(ForgeRegistries.BLOCKS.getKey((Object)((Block)blockRegistryObject.get()))).getPath() + appendix));
    }

    public void doorBlock(RegistryObject<Block> block, boolean cutout) {
        this.simpleBlockItem((Block)block.get(), (ModelFile)this.models().singleTexture(((Block)block.get()).asItem().toString(), ResourceLocation.withDefaultNamespace((String)"item/generated"), "layer0", ResourceLocation.fromNamespaceAndPath((String)"cinchcraft", (String)("item/" + block.getId().getPath()))));
        if (cutout) {
            this.doorBlockWithRenderType((DoorBlock)block.get(), this.blockTexture(block, "_bottom"), this.blockTexture(block, "_top"), "cutout");
        } else {
            this.doorBlock((DoorBlock)block.get(), this.blockTexture(block, "_bottom"), this.blockTexture(block, "_top"));
        }
    }

    public void trapdoorBlock(RegistryObject<Block> block, boolean cutout) {
        if (cutout) {
            this.trapdoorBlockWithRenderType((TrapDoorBlock)block.get(), this.blockTexture(block), true, "cutout");
        } else {
            this.trapdoorBlock((TrapDoorBlock)block.get(), this.blockTexture(block), true);
        }
        this.simpleBlockItem((Block)block.get(), (ModelFile)this.models().withExistingParent(((Block)block.get()).asItem().toString(), this.blockTexture(block, "_bottom")));
    }

    public void modButtonBlock(RegistryObject<Block> block, RegistryObject<Block> texture) {
        this.simpleBlockItem((Block)block.get(), (ModelFile)this.models().buttonInventory(block.getId().getPath() + "_inventory", this.blockTexture(texture)));
        this.buttonBlock((ButtonBlock)block.get(), this.blockTexture(texture));
    }

    public void vanillaButtonBlock(RegistryObject<Block> block, Block texture) {
        this.simpleBlockItem((Block)block.get(), (ModelFile)this.models().buttonInventory(block.getId().getPath() + "_inventory", this.blockTexture(texture)));
        this.buttonBlock((ButtonBlock)block.get(), this.blockTexture(texture));
    }

    public void signBlock(RegistryObject<Block> standing, RegistryObject<Block> wall, RegistryObject<Block> texture) {
        this.signBlock((StandingSignBlock)standing.get(), (WallSignBlock)wall.get(), this.blockTexture(texture));
    }

    public void hangingSignBlock(RegistryObject<Block> hangingSignBlock, RegistryObject<Block> wallHangingSignBlock, RegistryObject<Block> texture) {
        ModelBuilder sign = this.models().sign(this.name(hangingSignBlock), this.blockTexture(texture));
        this.simpleBlock((Block)hangingSignBlock.get(), (ModelFile)sign);
        this.simpleBlock((Block)wallHangingSignBlock.get(), (ModelFile)sign);
    }

    public String getName(Supplier<? extends Block> block) {
        return block.get().builtInRegistryHolder().key().location().getPath();
    }

    public ResourceLocation blockLoc(Supplier<? extends Block> block) {
        return ResourceLocation.fromNamespaceAndPath((String)"cinchcraft", (String)("block/" + this.getName(block)));
    }

    public ResourceLocation blockTexture(RegistryObject<Block> block) {
        ResourceLocation name = this.key(block);
        return ResourceLocation.fromNamespaceAndPath((String)name.getNamespace(), (String)("block/" + name.getPath()));
    }

    public ResourceLocation blockTexture(RegistryObject<Block> block, String string) {
        ResourceLocation name = this.key(block);
        return ResourceLocation.fromNamespaceAndPath((String)name.getNamespace(), (String)("block/" + name.getPath() + string));
    }

    private ResourceLocation key(RegistryObject<Block> block) {
        return ForgeRegistries.BLOCKS.getKey((Object)((Block)block.get()));
    }

    private String name(RegistryObject<Block> block) {
        return this.key(block).getPath();
    }
}

