/*
 * Decompiled with CFR 0.152.
 */
package net.cinchtail.cinchcraft.event;

import java.util.List;
import net.cinchtail.cinchcraft.block.ModBlocks;
import net.cinchtail.cinchcraft.item.ModItems;
import net.cinchtail.cinchcraft.potion.ModPotions;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.stats.Stats;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.BucketItem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.alchemy.PotionBrewing;
import net.minecraft.world.item.alchemy.Potions;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.item.enchantment.ItemEnchantments;
import net.minecraft.world.item.trading.ItemCost;
import net.minecraft.world.item.trading.MerchantOffer;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.CarvedPumpkinBlock;
import net.minecraft.world.level.block.ComposterBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.ToolActions;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.brewing.BrewingRecipeRegisterEvent;
import net.minecraftforge.event.entity.player.BonemealEvent;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.event.village.WandererTradesEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

public class ModEvents {

    @Mod.EventBusSubscriber(modid="cinchcraft", bus=Mod.EventBusSubscriber.Bus.FORGE)
    public static class ForgeEvents {
        @SubscribeEvent
        public static InteractionResult shearMelonBlock(PlayerInteractEvent.RightClickBlock event) {
            Level level = event.getLevel();
            Player player = event.getEntity();
            BlockPos pos = event.getPos();
            BlockState blockState = level.getBlockState(pos);
            BlockHitResult result = event.getHitVec();
            Direction direction = result.getDirection();
            Direction direction1 = direction.getAxis() == Direction.Axis.Y ? player.getDirection().getOpposite() : direction;
            InteractionHand hand = event.getHand();
            ItemStack stack = event.getItemStack();
            if (stack.canPerformAction(ToolActions.SHEARS_CARVE) && !level.isClientSide() && blockState.is(Blocks.MELON)) {
                level.setBlock(pos, (BlockState)((Block)ModBlocks.CARVED_MELON.get()).defaultBlockState().setValue((Property)CarvedPumpkinBlock.FACING, (Comparable)direction1), 11);
                level.playSound(null, pos, SoundEvents.PUMPKIN_CARVE, SoundSource.BLOCKS, 1.0f, 1.0f);
                ItemEntity itementity = new ItemEntity(level, (double)pos.getX() + 0.5 + (double)direction1.getStepX() * 0.65, (double)pos.getY() + 0.1, (double)pos.getZ() + 0.5 + (double)direction1.getStepZ() * 0.65, new ItemStack((ItemLike)Items.MELON_SEEDS, 4));
                itementity.setDeltaMovement(0.05 * (double)direction1.getStepX() + level.random.nextDouble() * 0.02, 0.05, 0.05 * (double)direction1.getStepZ() + level.random.nextDouble() * 0.02);
                level.addFreshEntity((Entity)itementity);
                stack.hurtAndBreak(1, (LivingEntity)player, LivingEntity.getSlotForHand((InteractionHand)hand));
                level.gameEvent((Entity)player, (Holder)GameEvent.SHEAR, pos);
                player.awardStat(Stats.ITEM_USED.get((Object)Items.SHEARS));
            }
            return InteractionResult.sidedSuccess((boolean)level.isClientSide);
        }

        @SubscribeEvent
        public static void cancelCarrotPlanting(PlayerInteractEvent.RightClickBlock event) {
            ItemStack stack = event.getItemStack();
            BlockPos pos = event.getPos();
            Level world = event.getLevel();
            BlockState clickedBlock = world.getBlockState(pos);
            if (stack.is(Items.CARROT) && clickedBlock.is(Blocks.FARMLAND)) {
                event.setCanceled(true);
            }
        }

        @SubscribeEvent
        public static void cancelSunflowerBoneMealing(BonemealEvent event) {
            Block targetBlock = event.getLevel().getBlockState(event.getPos()).getBlock();
            if (targetBlock == Blocks.SUNFLOWER) {
                event.setCanceled(true);
            }
        }

        @SubscribeEvent
        public static void bucketKeepsEnchantmentOnUse(PlayerInteractEvent.RightClickItem event) {
            final Player player = event.getEntity();
            final ItemStack heldItem = event.getItemStack();
            if (!(heldItem.getItem() instanceof BucketItem)) {
                return;
            }
            if (!heldItem.isEmpty() && heldItem.isEnchanted()) {
                final ItemEnchantments enchantments = heldItem.getEnchantments();
                MinecraftForge.EVENT_BUS.register(new Object(){

                    @SubscribeEvent
                    public void onTick(TickEvent.PlayerTickEvent tickEvent) {
                        if (tickEvent.player == player && tickEvent.phase == TickEvent.Phase.END) {
                            ItemStack newItem = player.getMainHandItem();
                            if (!ItemStack.isSameItemSameComponents((ItemStack)heldItem, (ItemStack)newItem) && newItem.getItem() instanceof BucketItem) {
                                EnchantmentHelper.setEnchantments((ItemStack)newItem, (ItemEnchantments)enchantments);
                            }
                            MinecraftForge.EVENT_BUS.unregister((Object)this);
                        }
                    }
                });
            }
        }

        @SubscribeEvent
        public static void compostFromComposter(PlayerInteractEvent.RightClickBlock event) {
            Level level = event.getLevel();
            BlockPos pos = event.getPos();
            BlockState state = level.getBlockState(pos);
            if (!level.isClientSide && state.getBlock() == Blocks.COMPOSTER && (Integer)state.getValue((Property)ComposterBlock.LEVEL) == 8) {
                event.setCanceled(true);
                level.setBlock(pos, (BlockState)state.setValue((Property)ComposterBlock.LEVEL, (Comparable)Integer.valueOf(0)), 3);
                Block.popResource((Level)level, (BlockPos)pos.above(), (ItemStack)new ItemStack((ItemLike)ModItems.COMPOST.get()));
            }
        }

        @SubscribeEvent
        public static void onBrewingRecipeRegister(BrewingRecipeRegisterEvent event) {
            PotionBrewing.Builder builder = event.getBuilder();
            builder.addMix(Potions.AWKWARD, Items.GLOW_BERRIES, (Holder)ModPotions.GLOWING_POTION.getHolder().get());
            builder.addMix(Potions.AWKWARD, Items.INK_SAC, (Holder)ModPotions.BLINDNESS_POTION.getHolder().get());
            builder.addMix((Holder)ModPotions.GLOWING_POTION.getHolder().get(), Items.REDSTONE, (Holder)ModPotions.LONG_GLOWING_POTION.getHolder().get());
            builder.addMix((Holder)ModPotions.BLINDNESS_POTION.getHolder().get(), Items.REDSTONE, (Holder)ModPotions.LONG_BLINDNESS_POTION.getHolder().get());
        }

        @SubscribeEvent
        public static void addWanderingTraderTrades(WandererTradesEvent event) {
            List genericTrades = event.getGenericTrades();
            List rareTrades = event.getRareTrades();
            genericTrades.add((pTrader, pRandom) -> new MerchantOffer(new ItemCost((ItemLike)Items.EMERALD, 5), new ItemStack((ItemLike)Items.TADPOLE_BUCKET, 1), 4, 1, 0.02f));
            genericTrades.add((pTrader, pRandom) -> new MerchantOffer(new ItemCost((ItemLike)Items.EMERALD, 2), new ItemStack((ItemLike)Items.POWDER_SNOW_BUCKET, 1), 5, 10, 0.02f));
            genericTrades.add((pTrader, pRandom) -> new MerchantOffer(new ItemCost((ItemLike)Items.EMERALD, 1), new ItemStack((ItemLike)ModItems.CROCUS.get(), 1), 12, 1, 0.02f));
            genericTrades.add((pTrader, pRandom) -> new MerchantOffer(new ItemCost((ItemLike)Items.EMERALD, 1), new ItemStack((ItemLike)ModItems.BUTTER_CUP.get(), 1), 12, 1, 0.02f));
            genericTrades.add((pTrader, pRandom) -> new MerchantOffer(new ItemCost((ItemLike)Items.EMERALD, 1), new ItemStack((ItemLike)ModItems.SMALL_ROSE.get(), 1), 12, 1, 0.02f));
            genericTrades.add((pTrader, pRandom) -> new MerchantOffer(new ItemCost((ItemLike)Items.EMERALD, 1), new ItemStack((ItemLike)ModItems.STAR_CACTUS.get(), 1), 12, 1, 0.02f));
            genericTrades.add((pTrader, pRandom) -> new MerchantOffer(new ItemCost((ItemLike)Items.EMERALD, 1), new ItemStack((ItemLike)ModItems.ALYSSUM.get(), 1), 12, 1, 0.02f));
            genericTrades.add((pTrader, pRandom) -> new MerchantOffer(new ItemCost((ItemLike)Items.EMERALD, 1), new ItemStack((ItemLike)ModItems.LUPINE.get(), 1), 12, 1, 0.02f));
            genericTrades.add((pTrader, pRandom) -> new MerchantOffer(new ItemCost((ItemLike)Items.EMERALD, 1), new ItemStack((ItemLike)Items.PINK_PETALS, 1), 12, 1, 0.02f));
            genericTrades.add((pTrader, pRandom) -> new MerchantOffer(new ItemCost((ItemLike)Items.EMERALD, 1), new ItemStack((ItemLike)ModItems.CATTAILS.get(), 1), 5, 3, 0.02f));
            rareTrades.add((pTrader, pRandom) -> new MerchantOffer(new ItemCost((ItemLike)Items.EMERALD, 30), new ItemStack((ItemLike)Items.WITHER_ROSE, 1), 1, 12, 0.02f));
            rareTrades.add((pTrader, pRandom) -> new MerchantOffer(new ItemCost((ItemLike)Items.EMERALD, 4), new ItemStack((ItemLike)Items.SPORE_BLOSSOM, 1), 3, 10, 0.02f));
            genericTrades.add((pTrader, pRandom) -> new MerchantOffer(new ItemCost((ItemLike)Items.EMERALD, 1), new ItemStack((ItemLike)Items.SWEET_BERRIES, 3), 7, 3, 0.02f));
            genericTrades.add((pTrader, pRandom) -> new MerchantOffer(new ItemCost((ItemLike)Items.EMERALD, 1), new ItemStack((ItemLike)Items.GLOW_BERRIES, 3), 7, 3, 0.02f));
            genericTrades.add((pTrader, pRandom) -> new MerchantOffer(new ItemCost((ItemLike)Items.EMERALD, 1), new ItemStack((ItemLike)ModItems.BLUEBERRIES.get(), 3), 7, 3, 0.02f));
            genericTrades.add((pTrader, pRandom) -> new MerchantOffer(new ItemCost((ItemLike)Items.EMERALD, 1), new ItemStack((ItemLike)ModItems.STRAWBERRIES.get(), 3), 7, 3, 0.02f));
            genericTrades.add((pTrader, pRandom) -> new MerchantOffer(new ItemCost((ItemLike)Items.EMERALD, 1), new ItemStack((ItemLike)ModItems.PINEAPPLE.get(), 1), 5, 3, 0.02f));
            genericTrades.add((pTrader, pRandom) -> new MerchantOffer(new ItemCost((ItemLike)Items.EMERALD, 1), new ItemStack((ItemLike)ModItems.SUNFLOWER_SEEDS.get(), 1), 12, 1, 0.02f));
            genericTrades.add((pTrader, pRandom) -> new MerchantOffer(new ItemCost((ItemLike)Items.EMERALD, 1), new ItemStack((ItemLike)ModItems.REEDS_SEEDS.get(), 1), 12, 1, 0.02f));
            genericTrades.add((pTrader, pRandom) -> new MerchantOffer(new ItemCost((ItemLike)Items.EMERALD, 1), new ItemStack((ItemLike)Items.COCOA_BEANS, 1), 12, 1, 0.02f));
            rareTrades.add((pTrader, pRandom) -> new MerchantOffer(new ItemCost((ItemLike)Items.EMERALD, 6), new ItemStack((ItemLike)Items.SPYGLASS, 1), 1, 10, 0.02f));
            rareTrades.add((pTrader, pRandom) -> new MerchantOffer(new ItemCost((ItemLike)Items.EMERALD, 9), new ItemStack((ItemLike)Items.SADDLE, 1), 1, 10, 0.02f));
            genericTrades.add((pTrader, pRandom) -> new MerchantOffer(new ItemCost((ItemLike)Items.EMERALD, 1), new ItemStack((ItemLike)Items.PAINTING, 1), 5, 10, 0.02f));
            genericTrades.add((pTrader, pRandom) -> new MerchantOffer(new ItemCost((ItemLike)Items.EMERALD, 1), new ItemStack((ItemLike)Items.SCAFFOLDING, 8), 4, 10, 0.02f));
            genericTrades.add((pTrader, pRandom) -> new MerchantOffer(new ItemCost((ItemLike)Items.EMERALD, 1), new ItemStack((ItemLike)Items.CANDLE, 4), 5, 10, 0.02f));
            rareTrades.add((pTrader, pRandom) -> new MerchantOffer(new ItemCost((ItemLike)Items.EMERALD, 12), new ItemStack((ItemLike)Items.TURTLE_EGG, 1), 2, 10, 0.02f));
            genericTrades.add((pTrader, pRandom) -> new MerchantOffer(new ItemCost((ItemLike)Items.EMERALD, 1), new ItemStack((ItemLike)Items.INK_SAC, 1), 5, 3, 0.02f));
            genericTrades.add((pTrader, pRandom) -> new MerchantOffer(new ItemCost((ItemLike)Items.EMERALD, 1), new ItemStack((ItemLike)Items.GLOW_INK_SAC, 1), 5, 3, 0.02f));
            genericTrades.add((pTrader, pRandom) -> new MerchantOffer(new ItemCost((ItemLike)Items.EMERALD, 1), new ItemStack((ItemLike)Items.GLOW_LICHEN, 2), 5, 5, 0.02f));
            genericTrades.add((pTrader, pRandom) -> new MerchantOffer(new ItemCost((ItemLike)Items.EMERALD, 1), new ItemStack((ItemLike)ModBlocks.ICICLE.get(), 2), 5, 3, 0.02f));
            genericTrades.add((pTrader, pRandom) -> new MerchantOffer(new ItemCost((ItemLike)Items.EMERALD, 1), new ItemStack((ItemLike)Items.SNOWBALL, 4), 4, 3, 0.02f));
            rareTrades.add((pTrader, pRandom) -> new MerchantOffer(new ItemCost((ItemLike)ModItems.RUBY.get(), 1), new ItemStack((ItemLike)Items.EMERALD, 1), 9, 3, 0.02f));
        }
    }
}

