/*
 * Decompiled with CFR 0.152.
 */
package net.cinchtail.cinchcraft.world.feature;

import java.util.List;
import net.cinchtail.cinchcraft.block.ModBlocks;
import net.cinchtail.cinchcraft.block.custom.BlueBerryBushBlock;
import net.cinchtail.cinchcraft.block.custom.ReedsCropBlock;
import net.minecraft.core.registries.Registries;
import net.minecraft.data.worldgen.BootstrapContext;
import net.minecraft.data.worldgen.placement.PlacementUtils;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.BlockTags;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.levelgen.feature.ConfiguredFeature;
import net.minecraft.world.level.levelgen.feature.Feature;
import net.minecraft.world.level.levelgen.feature.configurations.FeatureConfiguration;
import net.minecraft.world.level.levelgen.feature.configurations.OreConfiguration;
import net.minecraft.world.level.levelgen.feature.configurations.RandomPatchConfiguration;
import net.minecraft.world.level.levelgen.feature.configurations.SimpleBlockConfiguration;
import net.minecraft.world.level.levelgen.feature.stateproviders.BlockStateProvider;
import net.minecraft.world.level.levelgen.placement.PlacementModifier;
import net.minecraft.world.level.levelgen.structure.templatesystem.BlockMatchTest;
import net.minecraft.world.level.levelgen.structure.templatesystem.RuleTest;
import net.minecraft.world.level.levelgen.structure.templatesystem.TagMatchTest;

public class ModConfiguredFeatures {
    public static final ResourceKey<ConfiguredFeature<?, ?>> OVERWORLD_RUBY_ORE_KEY = ModConfiguredFeatures.registerKey("overworld_ruby_ore");
    public static final ResourceKey<ConfiguredFeature<?, ?>> NETHER_RUBY_ORE_KEY = ModConfiguredFeatures.registerKey("nether_ruby_ore");
    public static final ResourceKey<ConfiguredFeature<?, ?>> NETHER_COAL_ORE_KEY = ModConfiguredFeatures.registerKey("nether_coal_ore");
    public static final ResourceKey<ConfiguredFeature<?, ?>> NETHER_IRON_ORE_KEY = ModConfiguredFeatures.registerKey("nether_iron_ore");
    public static final ResourceKey<ConfiguredFeature<?, ?>> NETHER_COPPER_ORE_KEY = ModConfiguredFeatures.registerKey("nether_copper_ore");
    public static final ResourceKey<ConfiguredFeature<?, ?>> NETHER_LAPIS_LAZULI_ORE_KEY = ModConfiguredFeatures.registerKey("lapis_lazuli_ore");
    public static final ResourceKey<ConfiguredFeature<?, ?>> NETHER_REDSTONE_ORE_KEY = ModConfiguredFeatures.registerKey("nether_redstone_ore");
    public static final ResourceKey<ConfiguredFeature<?, ?>> NETHER_EMERALD_ORE_KEY = ModConfiguredFeatures.registerKey("nether_emerald_ore");
    public static final ResourceKey<ConfiguredFeature<?, ?>> NETHER_DIAMOND_ORE_KEY = ModConfiguredFeatures.registerKey("nether_diamond_ore");
    public static final ResourceKey<ConfiguredFeature<?, ?>> BUTTER_CUP_KEY = ModConfiguredFeatures.registerKey("butter_cup");
    public static final ResourceKey<ConfiguredFeature<?, ?>> CROCUS_KEY = ModConfiguredFeatures.registerKey("crocus");
    public static final ResourceKey<ConfiguredFeature<?, ?>> ALYSSUM_KEY = ModConfiguredFeatures.registerKey("alyssum");
    public static final ResourceKey<ConfiguredFeature<?, ?>> LUPINE_KEY = ModConfiguredFeatures.registerKey("lupine");
    public static final ResourceKey<ConfiguredFeature<?, ?>> BUBBLE_FLOWER_KEY = ModConfiguredFeatures.registerKey("bubble_flower");
    public static final ResourceKey<ConfiguredFeature<?, ?>> STAR_CACTUS_KEY = ModConfiguredFeatures.registerKey("starl_cactus");
    public static final ResourceKey<ConfiguredFeature<?, ?>> BLUEBERRIES_KEY = ModConfiguredFeatures.registerKey("blueberries");
    public static final ResourceKey<ConfiguredFeature<?, ?>> PINEAPPLE_PLANT_KEY = ModConfiguredFeatures.registerKey("pineapple");
    public static final ResourceKey<ConfiguredFeature<?, ?>> STRAWBERRY_KEY = ModConfiguredFeatures.registerKey("strawberry");
    public static final ResourceKey<ConfiguredFeature<?, ?>> REEDS_KEY = ModConfiguredFeatures.registerKey("reeds");
    public static final ResourceKey<ConfiguredFeature<?, ?>> CATTAILS_KEY = ModConfiguredFeatures.registerKey("cattails");

    public static void bootstrap(BootstrapContext<ConfiguredFeature<?, ?>> context) {
        TagMatchTest stoneReplaceables = new TagMatchTest(BlockTags.STONE_ORE_REPLACEABLES);
        TagMatchTest deepslateReplaceables = new TagMatchTest(BlockTags.DEEPSLATE_ORE_REPLACEABLES);
        BlockMatchTest netherrackReplaceables = new BlockMatchTest(Blocks.NETHERRACK);
        List<OreConfiguration.TargetBlockState> overworldRubyOres = List.of(OreConfiguration.target((RuleTest)stoneReplaceables, (BlockState)((Block)ModBlocks.RUBY_ORE.get()).defaultBlockState()), OreConfiguration.target((RuleTest)deepslateReplaceables, (BlockState)((Block)ModBlocks.DEEPSLATE_RUBY_ORE.get()).defaultBlockState()));
        ModConfiguredFeatures.register(context, OVERWORLD_RUBY_ORE_KEY, Feature.ORE, new OreConfiguration(overworldRubyOres, 8));
        ModConfiguredFeatures.register(context, NETHER_RUBY_ORE_KEY, Feature.ORE, new OreConfiguration((RuleTest)netherrackReplaceables, ((Block)ModBlocks.NETHER_RUBY_ORE.get()).defaultBlockState(), 3));
        ModConfiguredFeatures.register(context, NETHER_IRON_ORE_KEY, Feature.ORE, new OreConfiguration((RuleTest)netherrackReplaceables, ((Block)ModBlocks.NETHER_IRON_ORE.get()).defaultBlockState(), 5));
        ModConfiguredFeatures.register(context, NETHER_COPPER_ORE_KEY, Feature.ORE, new OreConfiguration((RuleTest)netherrackReplaceables, ((Block)ModBlocks.NETHER_COPPER_ORE.get()).defaultBlockState(), 5));
        ModConfiguredFeatures.register(context, NETHER_COAL_ORE_KEY, Feature.ORE, new OreConfiguration((RuleTest)netherrackReplaceables, ((Block)ModBlocks.NETHER_COAL_ORE.get()).defaultBlockState(), 4));
        ModConfiguredFeatures.register(context, NETHER_LAPIS_LAZULI_ORE_KEY, Feature.ORE, new OreConfiguration((RuleTest)netherrackReplaceables, ((Block)ModBlocks.NETHER_LAPIS_LAZULI_ORE.get()).defaultBlockState(), 3));
        ModConfiguredFeatures.register(context, NETHER_REDSTONE_ORE_KEY, Feature.ORE, new OreConfiguration((RuleTest)netherrackReplaceables, ((Block)ModBlocks.NETHER_REDSTONE_ORE.get()).defaultBlockState(), 3));
        ModConfiguredFeatures.register(context, NETHER_EMERALD_ORE_KEY, Feature.ORE, new OreConfiguration((RuleTest)netherrackReplaceables, ((Block)ModBlocks.NETHER_EMERALD_ORE.get()).defaultBlockState(), 3));
        ModConfiguredFeatures.register(context, NETHER_DIAMOND_ORE_KEY, Feature.ORE, new OreConfiguration((RuleTest)netherrackReplaceables, ((Block)ModBlocks.NETHER_DIAMOND_ORE.get()).defaultBlockState(), 3));
        ModConfiguredFeatures.register(context, CATTAILS_KEY, Feature.RANDOM_PATCH, new RandomPatchConfiguration(50, 6, 2, PlacementUtils.inlinePlaced((Feature)Feature.SIMPLE_BLOCK, (FeatureConfiguration)new SimpleBlockConfiguration((BlockStateProvider)BlockStateProvider.simple((BlockState)((Block)ModBlocks.CATTAILS.get()).defaultBlockState())), (PlacementModifier[])new PlacementModifier[0])));
        ModConfiguredFeatures.register(context, BUTTER_CUP_KEY, Feature.FLOWER, new RandomPatchConfiguration(32, 6, 2, PlacementUtils.onlyWhenEmpty((Feature)Feature.SIMPLE_BLOCK, (FeatureConfiguration)new SimpleBlockConfiguration((BlockStateProvider)BlockStateProvider.simple((Block)((Block)ModBlocks.BUTTER_CUP.get()))))));
        ModConfiguredFeatures.register(context, CROCUS_KEY, Feature.FLOWER, new RandomPatchConfiguration(40, 6, 2, PlacementUtils.onlyWhenEmpty((Feature)Feature.SIMPLE_BLOCK, (FeatureConfiguration)new SimpleBlockConfiguration((BlockStateProvider)BlockStateProvider.simple((Block)((Block)ModBlocks.CROCUS.get()))))));
        ModConfiguredFeatures.register(context, ALYSSUM_KEY, Feature.FLOWER, new RandomPatchConfiguration(32, 6, 2, PlacementUtils.onlyWhenEmpty((Feature)Feature.SIMPLE_BLOCK, (FeatureConfiguration)new SimpleBlockConfiguration((BlockStateProvider)BlockStateProvider.simple((Block)((Block)ModBlocks.ALYSSUM.get()))))));
        ModConfiguredFeatures.register(context, LUPINE_KEY, Feature.FLOWER, new RandomPatchConfiguration(32, 6, 2, PlacementUtils.onlyWhenEmpty((Feature)Feature.SIMPLE_BLOCK, (FeatureConfiguration)new SimpleBlockConfiguration((BlockStateProvider)BlockStateProvider.simple((Block)((Block)ModBlocks.LUPINE.get()))))));
        ModConfiguredFeatures.register(context, BUBBLE_FLOWER_KEY, Feature.FLOWER, new RandomPatchConfiguration(20, 6, 2, PlacementUtils.onlyWhenEmpty((Feature)Feature.SIMPLE_BLOCK, (FeatureConfiguration)new SimpleBlockConfiguration((BlockStateProvider)BlockStateProvider.simple((Block)((Block)ModBlocks.BUBBLE_FLOWER.get()))))));
        ModConfiguredFeatures.register(context, STAR_CACTUS_KEY, Feature.FLOWER, new RandomPatchConfiguration(10, 6, 2, PlacementUtils.onlyWhenEmpty((Feature)Feature.SIMPLE_BLOCK, (FeatureConfiguration)new SimpleBlockConfiguration((BlockStateProvider)BlockStateProvider.simple((Block)((Block)ModBlocks.STAR_CACTUS.get()))))));
        ModConfiguredFeatures.register(context, PINEAPPLE_PLANT_KEY, Feature.FLOWER, new RandomPatchConfiguration(15, 6, 2, PlacementUtils.onlyWhenEmpty((Feature)Feature.SIMPLE_BLOCK, (FeatureConfiguration)new SimpleBlockConfiguration((BlockStateProvider)BlockStateProvider.simple((BlockState)((BlockState)((Block)ModBlocks.PINEAPPLE_PLANT.get()).defaultBlockState().setValue((Property)BlueBerryBushBlock.AGE, (Comparable)Integer.valueOf(3))))))));
        ModConfiguredFeatures.register(context, STRAWBERRY_KEY, Feature.FLOWER, new RandomPatchConfiguration(32, 6, 2, PlacementUtils.onlyWhenEmpty((Feature)Feature.SIMPLE_BLOCK, (FeatureConfiguration)new SimpleBlockConfiguration((BlockStateProvider)BlockStateProvider.simple((BlockState)((BlockState)((Block)ModBlocks.STRAWBERRY_PLANT.get()).defaultBlockState().setValue((Property)BlueBerryBushBlock.AGE, (Comparable)Integer.valueOf(3))))))));
        ModConfiguredFeatures.register(context, BLUEBERRIES_KEY, Feature.FLOWER, new RandomPatchConfiguration(32, 6, 2, PlacementUtils.onlyWhenEmpty((Feature)Feature.SIMPLE_BLOCK, (FeatureConfiguration)new SimpleBlockConfiguration((BlockStateProvider)BlockStateProvider.simple((BlockState)((BlockState)((Block)ModBlocks.BLUEBERRY_BUSH.get()).defaultBlockState().setValue((Property)BlueBerryBushBlock.AGE, (Comparable)Integer.valueOf(3))))))));
        ModConfiguredFeatures.register(context, REEDS_KEY, Feature.RANDOM_PATCH, new RandomPatchConfiguration(50, 6, 2, PlacementUtils.inlinePlaced((Feature)Feature.SIMPLE_BLOCK, (FeatureConfiguration)new SimpleBlockConfiguration((BlockStateProvider)BlockStateProvider.simple((BlockState)((BlockState)((Block)ModBlocks.REEDS_CROP_BLOCK.get()).defaultBlockState().setValue((Property)ReedsCropBlock.AGE, (Comparable)Integer.valueOf(4))))), (PlacementModifier[])new PlacementModifier[0])));
    }

    public static ResourceKey<ConfiguredFeature<?, ?>> registerKey(String name) {
        return ResourceKey.create((ResourceKey)Registries.CONFIGURED_FEATURE, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"cinchcraft", (String)name));
    }

    private static <FC extends FeatureConfiguration, F extends Feature<FC>> void register(BootstrapContext<ConfiguredFeature<?, ?>> context, ResourceKey<ConfiguredFeature<?, ?>> key, F feature, FC configuration) {
        context.register(key, (Object)new ConfiguredFeature(feature, configuration));
    }
}

