/*
 * Decompiled with CFR 0.152.
 */
package net.cinchtail.cinchcraft.world.feature;

import java.util.List;
import net.cinchtail.cinchcraft.world.feature.ModConfiguredFeatures;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderGetter;
import net.minecraft.core.registries.Registries;
import net.minecraft.data.worldgen.BootstrapContext;
import net.minecraft.data.worldgen.placement.PlacementUtils;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.levelgen.VerticalAnchor;
import net.minecraft.world.level.levelgen.feature.ConfiguredFeature;
import net.minecraft.world.level.levelgen.placement.BiomeFilter;
import net.minecraft.world.level.levelgen.placement.CountPlacement;
import net.minecraft.world.level.levelgen.placement.HeightRangePlacement;
import net.minecraft.world.level.levelgen.placement.InSquarePlacement;
import net.minecraft.world.level.levelgen.placement.PlacedFeature;
import net.minecraft.world.level.levelgen.placement.PlacementModifier;
import net.minecraft.world.level.levelgen.placement.RarityFilter;

public class ModPlacedFeatures {
    public static final ResourceKey<PlacedFeature> RUBY_ORE_PLACED_KEY = ModPlacedFeatures.createKey("ruby_ore_placed");
    public static final ResourceKey<PlacedFeature> NETHER_RUBY_ORE_PLACED_KEY = ModPlacedFeatures.createKey("nether_ruby_ore_placed");
    public static final ResourceKey<PlacedFeature> NETHER_COAL_ORE_PLACED_KEY = ModPlacedFeatures.createKey("nether_coal_ore_placed");
    public static final ResourceKey<PlacedFeature> NETHER_IRON_ORE_PLACED_KEY = ModPlacedFeatures.createKey("nether_iron_ore_placed");
    public static final ResourceKey<PlacedFeature> NETHER_COPPER_ORE_PLACED_KEY = ModPlacedFeatures.createKey("nether_copper_ore_placed");
    public static final ResourceKey<PlacedFeature> NETHER_LAPIS_LAZULI_ORE_PLACED_KEY = ModPlacedFeatures.createKey("nether_lapis_lazuli_ore_placed");
    public static final ResourceKey<PlacedFeature> NETHER_REDSTONE_ORE_PLACED_KEY = ModPlacedFeatures.createKey("nether_redstone_ore_placed");
    public static final ResourceKey<PlacedFeature> NETHER_EMERALD_ORE_PLACED_KEY = ModPlacedFeatures.createKey("nether_emerald_ore_placed");
    public static final ResourceKey<PlacedFeature> NETHER_DIAMOND_ORE_PLACED_KEY = ModPlacedFeatures.createKey("nether_diamond_ore_placed");
    public static final ResourceKey<PlacedFeature> BUTTER_CUP_PLACED_KEY = ModPlacedFeatures.createKey("butter_cup_placed");
    public static final ResourceKey<PlacedFeature> CROCUS_PLACED_KEY = ModPlacedFeatures.createKey("crocus_placed");
    public static final ResourceKey<PlacedFeature> ALYSSUM_PLACED_KEY = ModPlacedFeatures.createKey("alyssum_placed");
    public static final ResourceKey<PlacedFeature> LUPINE_PLACED_KEY = ModPlacedFeatures.createKey("lupine_placed");
    public static final ResourceKey<PlacedFeature> BUBBLE_FLOWER_PLACED_KEY = ModPlacedFeatures.createKey("bubble_flower_placed");
    public static final ResourceKey<PlacedFeature> STAR_CACTUS_PLACED_KEY = ModPlacedFeatures.createKey("star_cactus_placed");
    public static final ResourceKey<PlacedFeature> BLUEBERRIES_PLACED_KEY = ModPlacedFeatures.createKey("blueberries_placed");
    public static final ResourceKey<PlacedFeature> PINEAPPLE_PLANT_PLACED_KEY = ModPlacedFeatures.createKey("pineapple_placed");
    public static final ResourceKey<PlacedFeature> STRAWBERRY_PLACED_KEY = ModPlacedFeatures.createKey("strawberry_placed");
    public static final ResourceKey<PlacedFeature> REEDS_PLACED_KEY = ModPlacedFeatures.createKey("reeds_placed");
    public static final ResourceKey<PlacedFeature> CATTAILS_PLACED_KEY = ModPlacedFeatures.createKey("cattails_placed");

    public static void bootstrap(BootstrapContext<PlacedFeature> context) {
        HolderGetter configuredFeatures = context.lookup(Registries.CONFIGURED_FEATURE);
        ModPlacedFeatures.register(context, RUBY_ORE_PLACED_KEY, configuredFeatures.getOrThrow(ModConfiguredFeatures.OVERWORLD_RUBY_ORE_KEY), ModPlacedFeatures.commonOrePlacement(6, (PlacementModifier)HeightRangePlacement.triangle((VerticalAnchor)VerticalAnchor.aboveBottom((int)-80), (VerticalAnchor)VerticalAnchor.aboveBottom((int)100))));
        ModPlacedFeatures.register(context, NETHER_RUBY_ORE_PLACED_KEY, configuredFeatures.getOrThrow(ModConfiguredFeatures.NETHER_RUBY_ORE_KEY), ModPlacedFeatures.commonOrePlacement(3, (PlacementModifier)HeightRangePlacement.uniform((VerticalAnchor)VerticalAnchor.aboveBottom((int)-80), (VerticalAnchor)VerticalAnchor.aboveBottom((int)80))));
        ModPlacedFeatures.register(context, NETHER_IRON_ORE_PLACED_KEY, configuredFeatures.getOrThrow(ModConfiguredFeatures.NETHER_IRON_ORE_KEY), ModPlacedFeatures.commonOrePlacement(6, (PlacementModifier)HeightRangePlacement.uniform((VerticalAnchor)VerticalAnchor.aboveBottom((int)-80), (VerticalAnchor)VerticalAnchor.aboveBottom((int)80))));
        ModPlacedFeatures.register(context, NETHER_COPPER_ORE_PLACED_KEY, configuredFeatures.getOrThrow(ModConfiguredFeatures.NETHER_COPPER_ORE_KEY), ModPlacedFeatures.commonOrePlacement(6, (PlacementModifier)HeightRangePlacement.uniform((VerticalAnchor)VerticalAnchor.aboveBottom((int)-80), (VerticalAnchor)VerticalAnchor.aboveBottom((int)80))));
        ModPlacedFeatures.register(context, NETHER_COAL_ORE_PLACED_KEY, configuredFeatures.getOrThrow(ModConfiguredFeatures.NETHER_COAL_ORE_KEY), ModPlacedFeatures.commonOrePlacement(4, (PlacementModifier)HeightRangePlacement.uniform((VerticalAnchor)VerticalAnchor.aboveBottom((int)-80), (VerticalAnchor)VerticalAnchor.aboveBottom((int)80))));
        ModPlacedFeatures.register(context, NETHER_LAPIS_LAZULI_ORE_PLACED_KEY, configuredFeatures.getOrThrow(ModConfiguredFeatures.NETHER_LAPIS_LAZULI_ORE_KEY), ModPlacedFeatures.commonOrePlacement(3, (PlacementModifier)HeightRangePlacement.uniform((VerticalAnchor)VerticalAnchor.aboveBottom((int)-80), (VerticalAnchor)VerticalAnchor.aboveBottom((int)80))));
        ModPlacedFeatures.register(context, NETHER_REDSTONE_ORE_PLACED_KEY, configuredFeatures.getOrThrow(ModConfiguredFeatures.NETHER_REDSTONE_ORE_KEY), ModPlacedFeatures.commonOrePlacement(3, (PlacementModifier)HeightRangePlacement.uniform((VerticalAnchor)VerticalAnchor.aboveBottom((int)-80), (VerticalAnchor)VerticalAnchor.aboveBottom((int)80))));
        ModPlacedFeatures.register(context, NETHER_DIAMOND_ORE_PLACED_KEY, configuredFeatures.getOrThrow(ModConfiguredFeatures.NETHER_DIAMOND_ORE_KEY), ModPlacedFeatures.commonOrePlacement(2, (PlacementModifier)HeightRangePlacement.uniform((VerticalAnchor)VerticalAnchor.aboveBottom((int)-80), (VerticalAnchor)VerticalAnchor.aboveBottom((int)80))));
        ModPlacedFeatures.register(context, NETHER_EMERALD_ORE_PLACED_KEY, configuredFeatures.getOrThrow(ModConfiguredFeatures.NETHER_EMERALD_ORE_KEY), ModPlacedFeatures.commonOrePlacement(2, (PlacementModifier)HeightRangePlacement.uniform((VerticalAnchor)VerticalAnchor.aboveBottom((int)-80), (VerticalAnchor)VerticalAnchor.aboveBottom((int)80))));
        ModPlacedFeatures.register(context, REEDS_PLACED_KEY, configuredFeatures.getOrThrow(ModConfiguredFeatures.REEDS_KEY), List.of(RarityFilter.onAverageOnceEvery((int)5), InSquarePlacement.spread(), PlacementUtils.HEIGHTMAP_TOP_SOLID, BiomeFilter.biome()));
        ModPlacedFeatures.register(context, CATTAILS_PLACED_KEY, configuredFeatures.getOrThrow(ModConfiguredFeatures.CATTAILS_KEY), List.of(RarityFilter.onAverageOnceEvery((int)4), InSquarePlacement.spread(), PlacementUtils.HEIGHTMAP_TOP_SOLID, BiomeFilter.biome()));
        ModPlacedFeatures.register(context, BLUEBERRIES_PLACED_KEY, configuredFeatures.getOrThrow(ModConfiguredFeatures.BLUEBERRIES_KEY), List.of(RarityFilter.onAverageOnceEvery((int)16), InSquarePlacement.spread(), PlacementUtils.HEIGHTMAP, BiomeFilter.biome()));
        ModPlacedFeatures.register(context, BUTTER_CUP_PLACED_KEY, configuredFeatures.getOrThrow(ModConfiguredFeatures.BUTTER_CUP_KEY), List.of(RarityFilter.onAverageOnceEvery((int)20), InSquarePlacement.spread(), PlacementUtils.HEIGHTMAP, BiomeFilter.biome()));
        ModPlacedFeatures.register(context, CROCUS_PLACED_KEY, configuredFeatures.getOrThrow(ModConfiguredFeatures.CROCUS_KEY), List.of(RarityFilter.onAverageOnceEvery((int)10), InSquarePlacement.spread(), PlacementUtils.HEIGHTMAP, BiomeFilter.biome()));
        ModPlacedFeatures.register(context, ALYSSUM_PLACED_KEY, configuredFeatures.getOrThrow(ModConfiguredFeatures.ALYSSUM_KEY), List.of(RarityFilter.onAverageOnceEvery((int)12), InSquarePlacement.spread(), PlacementUtils.HEIGHTMAP, BiomeFilter.biome()));
        ModPlacedFeatures.register(context, LUPINE_PLACED_KEY, configuredFeatures.getOrThrow(ModConfiguredFeatures.LUPINE_KEY), List.of(RarityFilter.onAverageOnceEvery((int)12), InSquarePlacement.spread(), PlacementUtils.HEIGHTMAP, BiomeFilter.biome()));
        ModPlacedFeatures.register(context, BUBBLE_FLOWER_PLACED_KEY, configuredFeatures.getOrThrow(ModConfiguredFeatures.BUBBLE_FLOWER_KEY), List.of(RarityFilter.onAverageOnceEvery((int)42), InSquarePlacement.spread(), PlacementUtils.HEIGHTMAP, BiomeFilter.biome()));
        ModPlacedFeatures.register(context, PINEAPPLE_PLANT_PLACED_KEY, configuredFeatures.getOrThrow(ModConfiguredFeatures.PINEAPPLE_PLANT_KEY), List.of(RarityFilter.onAverageOnceEvery((int)20), InSquarePlacement.spread(), PlacementUtils.HEIGHTMAP, BiomeFilter.biome()));
        ModPlacedFeatures.register(context, STRAWBERRY_PLACED_KEY, configuredFeatures.getOrThrow(ModConfiguredFeatures.STRAWBERRY_KEY), List.of(RarityFilter.onAverageOnceEvery((int)70), InSquarePlacement.spread(), PlacementUtils.HEIGHTMAP, BiomeFilter.biome()));
        ModPlacedFeatures.register(context, STAR_CACTUS_PLACED_KEY, configuredFeatures.getOrThrow(ModConfiguredFeatures.STAR_CACTUS_KEY), List.of(RarityFilter.onAverageOnceEvery((int)38), InSquarePlacement.spread(), PlacementUtils.HEIGHTMAP, BiomeFilter.biome()));
    }

    public static List<PlacementModifier> orePlacement(PlacementModifier pCountPlacement, PlacementModifier pHeightRange) {
        return List.of(pCountPlacement, InSquarePlacement.spread(), pHeightRange, BiomeFilter.biome());
    }

    public static List<PlacementModifier> commonOrePlacement(int pCount, PlacementModifier pHeightRange) {
        return ModPlacedFeatures.orePlacement((PlacementModifier)CountPlacement.of((int)pCount), pHeightRange);
    }

    public static List<PlacementModifier> rareOrePlacement(int pChance, PlacementModifier pHeightRange) {
        return ModPlacedFeatures.orePlacement((PlacementModifier)RarityFilter.onAverageOnceEvery((int)pChance), pHeightRange);
    }

    private static ResourceKey<PlacedFeature> createKey(String name) {
        return ResourceKey.create((ResourceKey)Registries.PLACED_FEATURE, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"cinchcraft", (String)name));
    }

    private static void register(BootstrapContext<PlacedFeature> context, ResourceKey<PlacedFeature> key, Holder<ConfiguredFeature<?, ?>> configuration, List<PlacementModifier> modifiers) {
        context.register(key, (Object)new PlacedFeature(configuration, List.copyOf(modifiers)));
    }
}

