/*
 * Decompiled with CFR 0.152.
 */
package net.asian.civiliansmod.chat;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import net.asian.civiliansmod.CiviliansMod;
import net.asian.civiliansmod.chat.DefaultChat;
import net.asian.civiliansmod.util.FolderUtil;
import net.minecraft.class_310;
import net.minecraft.class_5819;

public class NpcChat {
    public static Map<ChatReason, List<String>> dialogues = new LinkedHashMap<ChatReason, List<String>>();
    private static String currentLoadedLanguage = "en_us";

    public static String getRandomChat(ChatReason reason, String requestedLanguage) {
        List<String> languagechat;
        if (!requestedLanguage.equals(currentLoadedLanguage)) {
            CiviliansMod.LOGGER.debug("Language changed from {} to {}, reloading dialogues", (Object)currentLoadedLanguage, (Object)requestedLanguage);
            NpcChat.loadLanguage(requestedLanguage);
        }
        if ((languagechat = dialogues.get((Object)reason)) == null || languagechat.isEmpty()) {
            CiviliansMod.LOGGER.debug("No dialogues loaded for reason: {}, using internal defaults", (Object)reason.getName());
            return NpcChat.getInternalFallback(reason, requestedLanguage);
        }
        return languagechat.get(class_5819.method_43047().method_43048(languagechat.size()));
    }

    private static String getInternalFallback(ChatReason reason, String language) {
        List<String> chat;
        Map<String, Map<ChatReason, List<String>>> defaultChats = DefaultChat.getDefaultChat();
        Map<ChatReason, List<String>> languageChats = defaultChats.get(language);
        if (languageChats == null || languageChats.isEmpty()) {
            CiviliansMod.LOGGER.debug("Language {} not found in internal defaults, falling back to en_us", (Object)language);
            languageChats = defaultChats.get("en_us");
        }
        if (languageChats == null || languageChats.isEmpty()) {
            CiviliansMod.LOGGER.debug("en_us not found, using first available language");
            languageChats = defaultChats.values().stream().findFirst().orElse(Collections.emptyMap());
        }
        if ((chat = languageChats.get((Object)reason)) == null || chat.isEmpty()) {
            CiviliansMod.LOGGER.warn("No chat found for reason: {} in language: {}, using default", (Object)reason.getName(), (Object)language);
            return "...";
        }
        return chat.get(class_5819.method_43047().method_43048(chat.size()));
    }

    public static void registerChat() {
        CiviliansMod.LOGGER.info("Registering dialogues from internal defaults");
        NpcChat.loadLanguage(NpcChat.getCurrentLanguage());
    }

    public static void refresh() {
        CiviliansMod.LOGGER.info("Refreshing dialogues from internal defaults");
        NpcChat.loadLanguage(NpcChat.getCurrentLanguage());
    }

    private static String getCurrentLanguage() {
        try {
            if (class_310.method_1551() != null && class_310.method_1551().method_1526() != null) {
                return class_310.method_1551().method_1526().method_4669();
            }
        }
        catch (Exception e) {
            CiviliansMod.LOGGER.warn("Could not determine language, using en_us as fallback", (Throwable)e);
        }
        return "en_us";
    }

    private static void loadLanguage(String languageCode) {
        dialogues.clear();
        if (languageCode == null || languageCode.isEmpty()) {
            languageCode = NpcChat.getCurrentLanguage();
            CiviliansMod.LOGGER.debug("No language provided, using current client language: {}", (Object)languageCode);
        }
        currentLoadedLanguage = languageCode;
        Path customDialogue = FolderUtil.DIALOGUES_PATH.resolve(languageCode + ".json");
        JsonObject customcontent = null;
        try {
            if (Files.exists(customDialogue, new LinkOption[0])) {
                CiviliansMod.LOGGER.info("Loading dialogues for language {}", (Object)languageCode);
                String CustomJsonDialogue = Files.readString(customDialogue);
                customcontent = JsonParser.parseString((String)CustomJsonDialogue).getAsJsonObject();
            } else {
                Path defaultFallbackDialogue = FolderUtil.DIALOGUES_PATH.resolve("en_us.json");
                if (Files.exists(defaultFallbackDialogue, new LinkOption[0])) {
                    CiviliansMod.LOGGER.info("Falling back to default en_us dialogues");
                    String CustomJsonDialouge = Files.readString(defaultFallbackDialogue);
                    customcontent = JsonParser.parseString((String)CustomJsonDialouge).getAsJsonObject();
                } else {
                    CiviliansMod.LOGGER.warn("No custom dialogues found \u2013 using built-in DefaultChat");
                }
            }
        }
        catch (IOException e) {
            CiviliansMod.LOGGER.error("Couldn't read dialogue JSON for language: {}", (Object)languageCode, (Object)e);
        }
        if (customcontent == null) {
            CiviliansMod.LOGGER.info("Using built-in default chat for language: {}", (Object)languageCode);
            Map<String, Map<ChatReason, List<String>>> fallback = DefaultChat.getDefaultChat();
            Map englishFallback = fallback.getOrDefault("en_us", Collections.emptyMap());
            for (ChatReason reason : ChatReason.values()) {
                ArrayList list = new ArrayList(englishFallback.getOrDefault((Object)reason, Collections.singletonList("...")));
                dialogues.put(reason, list);
            }
            return;
        }
        for (ChatReason reason : ChatReason.values()) {
            ArrayList<String> reasons = new ArrayList<String>();
            if (customcontent.has(reason.getName())) {
                JsonArray jsonArray = customcontent.get(reason.getName()).getAsJsonArray();
                for (JsonElement element : jsonArray) {
                    reasons.add(element.getAsString());
                }
            }
            if (reasons.isEmpty()) {
                Map<String, Map<ChatReason, List<String>>> defaults = DefaultChat.getDefaultChat();
                Map englishDefaults = defaults.getOrDefault("en_us", Collections.emptyMap());
                List<String> fallbackChat = englishDefaults.getOrDefault((Object)reason, Collections.singletonList("..."));
                reasons.addAll(fallbackChat);
                CiviliansMod.LOGGER.warn("Missing JSON section for '{}', using {} default dialogues.", (Object)reason.getName(), (Object)fallbackChat.size());
            }
            dialogues.put(reason, reasons);
            CiviliansMod.LOGGER.info("Loaded {} dialogues for {}", (Object)reasons.size(), (Object)reason.getName());
        }
    }

    public static enum ChatReason {
        HURT("hurt"),
        INTERACT("interact");

        final String name;

        private ChatReason(String name) {
            this.name = name;
        }

        public String getName() {
            return this.name;
        }

        public static ChatReason fromName(String name) {
            for (ChatReason reason : ChatReason.values()) {
                if (!reason.name.equalsIgnoreCase(name) && !reason.name().equalsIgnoreCase(name)) continue;
                return reason;
            }
            throw new IllegalArgumentException("Unknown ChatReason: " + name);
        }
    }
}

