/*
 * Decompiled with CFR 0.152.
 */
package net.asian.civiliansmod.entity;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.function.BiConsumer;
import net.asian.civiliansmod.CiviliansMod;
import net.asian.civiliansmod.chat.DefaultChat;
import net.asian.civiliansmod.chat.NpcChat;
import net.asian.civiliansmod.entity.goal.CustomDoorGoal;
import net.asian.civiliansmod.gui.CustomNPCScreen;
import net.asian.civiliansmod.gui.DefaultNPCScreen;
import net.asian.civiliansmod.gui.SlimNPCScreen;
import net.asian.civiliansmod.networking.payload.npc.dialogue.ClientDialogueSyncPayload;
import net.asian.civiliansmod.networking.payload.npc.dialogue.DialogueSyncPayload;
import net.asian.civiliansmod.networking.payload.npc.dialogue.OpenScreenDialoguesPayload;
import net.asian.civiliansmod.networking.payload.npc.skin.ClientNpcSkinPayload;
import net.asian.civiliansmod.networking.payload.npc.skin.SyncSkinPayload;
import net.asian.civiliansmod.util.NPCUtil;
import net.asian.civiliansmod.util.SkinIdentifier;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.fabric.api.client.networking.v1.ClientPlayNetworking;
import net.fabricmc.fabric.api.networking.v1.ServerPlayNetworking;
import net.fabricmc.loader.api.FabricLoader;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1282;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1308;
import net.minecraft.class_1314;
import net.minecraft.class_1352;
import net.minecraft.class_1376;
import net.minecraft.class_1394;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1937;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2519;
import net.minecraft.class_2520;
import net.minecraft.class_2561;
import net.minecraft.class_2596;
import net.minecraft.class_2602;
import net.minecraft.class_2604;
import net.minecraft.class_2940;
import net.minecraft.class_2941;
import net.minecraft.class_2943;
import net.minecraft.class_2945;
import net.minecraft.class_310;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3231;
import net.minecraft.class_3532;
import net.minecraft.class_437;
import net.minecraft.class_5132;
import net.minecraft.class_5134;
import net.minecraft.class_5819;
import net.minecraft.class_8710;
import org.jetbrains.annotations.NotNull;

public class NPCEntity
extends class_1314 {
    private float targetYaw = 0.0f;
    private boolean isTurning = false;
    private int lookAtPlayerTicks = 0;
    private static final class_2940<Boolean> IS_PAUSED = class_2945.method_12791(NPCEntity.class, (class_2941)class_2943.field_13323);
    private int regenerationCooldown = 0;
    private static final class_2940<Boolean> IS_FOLLOWING = class_2945.method_12791(NPCEntity.class, (class_2941)class_2943.field_13323);
    int updateDialoguesTicks = 0;
    Set<UUID> sent;
    @Environment(value=EnvType.CLIENT)
    public boolean dialoguesReceived;
    NameManager nameManager = new NameManager(this);
    SkinManager skinManager = new SkinManager(this);
    ChatManager chatManager = new ChatManager(this);

    public NameManager getNameManager() {
        return this.nameManager;
    }

    public SkinManager getSkinManager() {
        return this.skinManager;
    }

    public ChatManager getChatManager() {
        return this.chatManager;
    }

    public void method_31471(class_2604 packet) {
        super.method_31471(packet);
        SkinIdentifier skinIdentifier = NPCUtil.waitingSync.get(this.method_5628());
        if (skinIdentifier != null) {
            this.skinManager.setIdSkin(skinIdentifier);
        }
        this.updateDialoguesTicks = 10;
    }

    public class_2596<class_2602> method_18002(class_3231 entityTrackerEntry) {
        if (this.skinManager.skinByteArray == null) {
            for (class_3222 player : Objects.requireNonNull(this.method_37908().method_8503()).method_3760().method_14571()) {
                ServerPlayNetworking.send((class_3222)player, (class_8710)new SyncSkinPayload(this.method_5628(), this.skinManager.baseVariant));
            }
        } else {
            for (class_3222 player : Objects.requireNonNull(this.method_37908().method_8503()).method_3760().method_14571()) {
                ServerPlayNetworking.send((class_3222)player, (class_8710)new ClientNpcSkinPayload(this.method_5628(), this.skinManager.slim, this.skinManager.skinByteArray));
            }
        }
        return super.method_18002(entityTrackerEntry);
    }

    public NPCEntity(class_1299<? extends class_1314> entityType, class_1937 world) {
        super(entityType, world);
        if (!this.method_37908().field_9236) {
            this.method_5880(true);
            this.sent = new HashSet<UUID>();
        } else {
            this.dialoguesReceived = false;
        }
    }

    protected void method_5693(class_2945.class_9222 builder) {
        this.chatManager = new ChatManager(this);
        super.method_5693(builder);
        builder.method_56912(IS_PAUSED, (Object)false);
        builder.method_56912(IS_FOLLOWING, (Object)false);
    }

    public boolean method_17326() {
        return true;
    }

    public boolean isFollowing() {
        return (Boolean)this.field_6011.method_12789(IS_FOLLOWING);
    }

    public void setFollowing(boolean following) {
        this.field_6011.method_12778(IS_FOLLOWING, (Object)following);
    }

    public boolean isPaused() {
        return (Boolean)this.field_6011.method_12789(IS_PAUSED);
    }

    public void setPaused(boolean paused) {
        this.field_6011.method_12778(IS_PAUSED, (Object)paused);
    }

    public void method_5652(class_2487 nbt) {
        super.method_5652(nbt);
        nbt.method_10556("IsPaused", this.isPaused());
        nbt.method_10556("IsFollowing", this.isFollowing());
        nbt.method_10566("dialogues", (class_2520)this.chatManager.saveDialogues());
        this.skinManager.writeNbt(nbt);
    }

    public void method_5749(class_2487 nbt) {
        super.method_5749(nbt);
        if (nbt.method_10545("IsPaused")) {
            this.setPaused(nbt.method_10577("IsPaused").orElse(false));
        }
        if (nbt.method_10545("IsFollowing")) {
            this.setFollowing(nbt.method_10577("IsFollowing").orElse(false));
        }
        if (nbt.method_10545("dialogues")) {
            this.chatManager.setFromNbt(nbt.method_10562("dialogues"));
        }
        this.skinManager.readNbt(nbt);
    }

    public static class_5132.class_5133 createAttributes() {
        return class_1314.method_26828().method_26868(class_5134.field_23716, 20.0).method_26868(class_5134.field_23719, 0.3);
    }

    protected void method_5959() {
        super.method_5959();
        this.field_6201.method_6277(1, (class_1352)new class_1394((class_1314)this, 0.7));
        this.field_6201.method_6277(6, (class_1352)new CustomDoorGoal(this));
        this.field_6201.method_6277(4, (class_1352)new class_1376((class_1308)this));
    }

    public boolean method_64397(class_3218 world, class_1282 source, float amount) {
        if (this.isPaused()) {
            return false;
        }
        boolean hurt = super.method_64397(world, source, amount);
        if (hurt && source.method_5529() != null && !world.method_8608()) {
            class_2561 nameText = this.method_5797();
            String npcName = nameText != null ? nameText.getString() : "NPC";
            class_1297 class_12972 = source.method_5529();
            if (class_12972 instanceof class_1657) {
                class_1657 player = (class_1657)class_12972;
                String hitDialogue = this.chatManager.getRandomChat(CiviliansMod.playerLanguages.get(player.method_5667()), NpcChat.ChatReason.HURT);
                player.method_7353((class_2561)class_2561.method_43470((String)(npcName + ": " + hitDialogue)), true);
            }
            double dx = this.method_23317() - source.method_5529().method_23317();
            double dz = this.method_23321() - source.method_5529().method_23321();
            double fleeDistance = 12.0;
            this.method_5942().method_6337(this.method_23317() + dx * fleeDistance, this.method_23318(), this.method_23321() + dz * fleeDistance, 1.2);
        }
        return hurt;
    }

    protected class_1269 method_5992(class_1657 player, class_1268 hand) {
        CiviliansMod.LOGGER.info("[CiviliansMod] This is the NPC: {}", (Object)this.method_5628());
        if (hand == class_1268.field_5808) {
            class_1799 heldItem = player.method_5998(hand);
            if (heldItem.method_31574(class_1802.field_8719) && !this.method_5782() && !this.method_37908().method_8608() && this.canBeLeashedBy(player)) {
                this.method_60964((class_1297)player, true);
                return class_1269.field_5812;
            }
            if (player.method_5715()) {
                if (!this.method_37908().method_8608()) {
                    this.method_5942().method_6340();
                    double dx = player.method_23317() - this.method_23317();
                    double dz = player.method_23321() - this.method_23321();
                    this.targetYaw = (float)(Math.atan2(dz, dx) * 57.29577951308232) - 90.0f;
                    this.isTurning = true;
                    this.lookAtPlayerTicks = 60;
                    if (player instanceof class_3222) {
                        class_3222 serverPlayer = (class_3222)player;
                        if (!this.hasSentTo(player.method_5667())) {
                            this.markSentTo(player.method_5667());
                            OpenScreenDialoguesPayload openScreenDialoguesPayload = new OpenScreenDialoguesPayload(this.method_5628(), this.chatManager.getDialogues());
                            ServerPlayNetworking.send((class_3222)serverPlayer, (class_8710)openScreenDialoguesPayload);
                            CiviliansMod.LOGGER.info("[CiviliansMod] Sent dialogues for NPC {}", (Object)this.method_5628());
                        }
                    }
                    return class_1269.field_5812;
                }
                if (this.dialoguesReceived) {
                    CiviliansMod.LOGGER.info("[CiviliansMod] Opening GUI for NPC {}", (Object)this.method_5628());
                    this.openCustomNPCScreen();
                } else {
                    CiviliansMod.LOGGER.warn("[CiviliansMod] No dialogues yet for NPC {}", (Object)this.method_5628());
                }
                return class_1269.field_5812;
            }
            if (!this.method_37908().method_8608()) {
                this.method_5942().method_6340();
                double dx = player.method_23317() - this.method_23317();
                double dz = player.method_23321() - this.method_23321();
                this.targetYaw = (float)(Math.atan2(dz, dx) * 57.29577951308232) - 90.0f;
                this.isTurning = true;
                this.lookAtPlayerTicks = 60;
                class_2561 nameText = this.method_5797();
                String npcName = nameText != null ? nameText.getString() : "NPC";
                String dialogue = this.chatManager.getRandomChat(CiviliansMod.playerLanguages.get(player.method_5667()), NpcChat.ChatReason.INTERACT);
                player.method_7353((class_2561)class_2561.method_43470((String)(npcName + ": " + dialogue)), true);
            }
            return class_1269.field_5812;
        }
        return super.method_5992(player, hand);
    }

    @Environment(value=EnvType.CLIENT)
    public void openCustomNPCScreen() {
        if (this.skinManager.slim && this.skinManager.defaultSkin) {
            class_310.method_1551().method_1507((class_437)new SlimNPCScreen(this));
        } else if (this.skinManager.defaultSkin) {
            class_310.method_1551().method_1507((class_437)new DefaultNPCScreen(this));
        } else {
            class_310.method_1551().method_1507((class_437)new CustomNPCScreen(this));
        }
    }

    public class_243 method_29919() {
        return new class_243(0.0, 0.9, 0.0);
    }

    public boolean canBeLeashedBy(class_1657 player) {
        return !this.method_60953() && !player.method_5715();
    }

    public void method_5773() {
        super.method_5773();
        if (this.method_37908().field_9236 && --this.updateDialoguesTicks == 0) {
            ClientPlayNetworking.send((class_8710)new ClientDialogueSyncPayload(this.method_5667()));
        }
    }

    public void method_6007() {
        if (this.isPaused()) {
            this.method_5942().method_6340();
            this.method_18800(0.0, 0.0, 0.0);
            class_1657 nearestPlayer = this.method_37908().method_18460((class_1297)this, 5.0);
            if (nearestPlayer != null) {
                double dx = nearestPlayer.method_23317() - this.method_23317();
                double dy = nearestPlayer.method_23320() - this.method_23320();
                double dz = nearestPlayer.method_23321() - this.method_23321();
                double distance = Math.sqrt(dx * dx + dz * dz);
                float targetYaw = (float)(Math.atan2(dz, dx) * 57.29577951308232) - 90.0f;
                float targetPitch = (float)(-(Math.atan2(dy, distance) * 57.29577951308232));
                this.field_6241 = this.adjustTowards(this.field_6241, targetYaw);
                this.method_36457(this.adjustTowards(this.method_36455(), targetPitch));
            }
            return;
        }
        if (this.isFollowing() && this.method_37908() != null && !this.method_37908().field_9236) {
            class_1657 nearestPlayer = this.method_37908().method_18460((class_1297)this, 15.0);
            if (nearestPlayer != null) {
                double distanceToPlayer = this.method_5858((class_1297)nearestPlayer);
                if (distanceToPlayer > 4.0 && distanceToPlayer < 400.0) {
                    double deltaX = nearestPlayer.method_23317() - this.method_23317();
                    nearestPlayer.method_23320();
                    this.method_23320();
                    double deltaZ = nearestPlayer.method_23321() - this.method_23321();
                    double distance = Math.sqrt(deltaX * deltaX + deltaZ * deltaZ);
                    double followSpeed = Math.min(3.5, 0.35 + distance / 10.0);
                    this.method_5942().method_6335((class_1297)nearestPlayer, followSpeed);
                    if (distance > 16.0) {
                        this.method_5808(nearestPlayer.method_23317() - deltaX / 2.0, nearestPlayer.method_23318(), nearestPlayer.method_23321() - deltaZ / 2.0, this.method_36454(), this.method_36455());
                        this.method_5942().method_6340();
                    }
                } else if (distanceToPlayer <= 4.0) {
                    this.method_5942().method_6340();
                }
            } else {
                this.method_5942().method_6340();
            }
        }
        super.method_6007();
        if (this.isTurning) {
            this.smoothTurnToTargetYaw();
        }
        if (this.lookAtPlayerTicks > 0) {
            --this.lookAtPlayerTicks;
            this.method_5942().method_6340();
            this.method_18800(0.0, 0.0, 0.0);
        }
        if (this.method_5805() && this.method_6032() < this.method_6063()) {
            if (this.regenerationCooldown <= 0) {
                this.method_6025(1.0f);
                this.regenerationCooldown = 20;
            } else {
                --this.regenerationCooldown;
            }
        }
    }

    private float adjustTowards(float current, float target) {
        float delta = class_3532.method_15393((float)(target - current));
        if (delta > 5.0f) {
            delta = 5.0f;
        } else if (delta < -5.0f) {
            delta = -5.0f;
        }
        return current + delta;
    }

    private void smoothTurnToTargetYaw() {
        float turnRate = 7.5f;
        float yawDifference = this.wrapDegrees(this.targetYaw - this.method_36454());
        if (Math.abs(yawDifference) < 1.0f) {
            this.method_36456(this.targetYaw);
            this.field_6283 = this.targetYaw;
            this.field_6241 = this.targetYaw;
            this.isTurning = false;
        } else {
            float yawAdjustment = Math.min(turnRate, Math.max(-turnRate, yawDifference));
            this.method_36456(this.method_36454() + yawAdjustment);
            this.field_6283 = this.method_36454();
            this.field_6241 = this.method_36454();
        }
    }

    private float wrapDegrees(float degrees) {
        while (degrees >= 180.0f) {
            degrees -= 360.0f;
        }
        while (degrees < -180.0f) {
            degrees += 360.0f;
        }
        return degrees;
    }

    public boolean hasSentTo(UUID playerId) {
        return this.sent.contains(playerId);
    }

    public void markSentTo(UUID playerId) {
        this.sent.add(playerId);
    }

    public static class NameManager {
        String[] defaultModelNames = new String[]{"Charles", "Cade", "Henry", "Liam", "Rodney", "Nathaniel", "Elliot", "Julian", "Malcolm", "Tobias", "Wesley", "Felix", "Desmond", "Simon", "Miles", "Everett", "Dorian", "Quentin", "Cedric", "Adrian", "Roman", "Marcus", "Gideon", "Levi", "Jasper"};
        String[] slimModelNames = new String[]{"Evelyn", "Sarah", "Olivia", "Emma", "Alexia", "Amelia", "Celeste", "Lillian", "Joleen", "Rosalie", "Clara", "Vivienne", "Elena", "Margot", "Nora", "Daphne", "Fiona", "Genevieve", "Juliette", "Lucille", "Naomi", "Ivy", "Serena", "Vera", "Adelaide"};
        NPCEntity npcEntity;

        public NameManager(NPCEntity npcEntity) {
            this.npcEntity = npcEntity;
        }

        public void setRandomName(boolean slim) {
            if (slim) {
                this.npcEntity.method_5665((class_2561)class_2561.method_43470((String)this.slimModelNames[class_5819.method_43047().method_43048(this.slimModelNames.length)]));
            } else {
                this.npcEntity.method_5665((class_2561)class_2561.method_43470((String)this.defaultModelNames[class_5819.method_43047().method_43048(this.defaultModelNames.length)]));
            }
        }
    }

    public static class SkinManager {
        byte[] skinByteArray;
        SkinIdentifier skinIdentifier;
        int baseVariant;
        boolean slim;
        NPCEntity npcEntity;
        boolean defaultSkin;

        public void setBaseVariant(int baseVariant) {
            this.baseVariant = baseVariant;
        }

        public SkinManager(NPCEntity npcEntity) {
            this.npcEntity = npcEntity;
            this.defaultSkin = true;
            this.baseVariant = npcEntity.field_5974.method_43048(88);
            this.slim = this.baseVariant > 43;
            if (npcEntity.nameManager != null) {
                npcEntity.nameManager.setRandomName(this.slim);
            } else {
                CiviliansMod.LOGGER.warn("[CiviliansMod] nameManager is null in SkinManager constructor");
            }
        }

        public boolean isSlim() {
            return this.slim;
        }

        public void setSkinByteArray(byte[] skinByteArray) {
            this.skinByteArray = skinByteArray;
        }

        @Environment(value=EnvType.CLIENT)
        public void setIdSkin(SkinIdentifier skin) {
            this.skinIdentifier = skin;
        }

        @Environment(value=EnvType.CLIENT)
        public SkinIdentifier getIdSkin() {
            if (this.skinIdentifier == null) {
                return NPCUtil.getNPCTexture(this.baseVariant);
            }
            return this.skinIdentifier;
        }

        void writeNbt(class_2487 nbt) {
            nbt.method_10569("basevariant", this.baseVariant);
            if (this.skinByteArray != null) {
                nbt.method_10570("skin", this.skinByteArray);
            }
        }

        void readNbt(class_2487 nbt) {
            byte[] skinData;
            this.baseVariant = nbt.method_10550("basevariant").orElse(0);
            if (FabricLoader.getInstance().getEnvironmentType() == EnvType.CLIENT) {
                if (this.baseVariant < 0 || this.baseVariant >= NPCUtil.getSkins().size()) {
                    CiviliansMod.LOGGER.warn("Invalid baseVariant {} loaded from NBT, resetting to 0", (Object)this.baseVariant);
                    this.baseVariant = 0;
                }
            } else if (this.baseVariant < 0) {
                this.baseVariant = 0;
            }
            if (nbt.method_10545("skin") && (skinData = (byte[])nbt.method_10547("skin").orElse(null)) != null && skinData.length > 0) {
                this.skinByteArray = Arrays.copyOf(skinData, skinData.length);
            }
        }

        public void setSlim(boolean slim) {
            this.slim = slim;
        }
    }

    public static class ChatManager {
        NPCEntity npc;
        Map<String, Map<NpcChat.ChatReason, List<String>>> dialogues;
        Map<NpcChat.ChatReason, List<String>> customDialogues = new EnumMap<NpcChat.ChatReason, List<String>>(NpcChat.ChatReason.class);

        public ChatManager(NPCEntity npc) {
            this.npc = npc;
            this.dialogues = new HashMap<String, Map<NpcChat.ChatReason, List<String>>>(DefaultChat.getDefaultChat());
        }

        public String getRandomChat(String language, NpcChat.ChatReason reason) {
            List<String> messages;
            List<String> custom = this.customDialogues.get((Object)reason);
            if (custom != null && !custom.isEmpty()) {
                return custom.get(class_5819.method_43047().method_43048(custom.size()));
            }
            Map<NpcChat.ChatReason, List<String>> langDialogues = this.dialogues.get(language);
            if (langDialogues == null || langDialogues.isEmpty()) {
                CiviliansMod.LOGGER.warn("[CiviliansMod] No dialogues for language {}, falling back to en_us (NPC ID: {})", (Object)language, (Object)this.npc.method_5628());
                langDialogues = DefaultChat.getDefaultChat().get("en_us");
            }
            if (langDialogues == null && !this.dialogues.isEmpty()) {
                langDialogues = this.dialogues.values().iterator().next();
                CiviliansMod.LOGGER.warn("[CiviliansMod] No en_us dialogues, using first available language for NPC {}", (Object)this.npc.method_5628());
            }
            if (langDialogues == null) {
                CiviliansMod.LOGGER.warn("[CiviliansMod] No dialogues available at all, using placeholder for NPC {}", (Object)this.npc.method_5628());
                langDialogues = new EnumMap<NpcChat.ChatReason, List<String>>(NpcChat.ChatReason.class);
            }
            if (this.dialogues.isEmpty()) {
                CiviliansMod.LOGGER.error("[CiviliansMod] Dialogue map empty, loading default dialogues for NPC {}", (Object)this.npc.method_5628());
                this.dialogues.putAll(DefaultChat.getDefaultChat());
            }
            if ((messages = langDialogues.getOrDefault((Object)reason, Collections.singletonList("..."))).isEmpty()) {
                messages = Collections.singletonList("...");
            }
            return messages.get(class_5819.method_43047().method_43048(messages.size()));
        }

        public Map<NpcChat.ChatReason, List<String>> getDialoguesForLanguage(String language) {
            Map<NpcChat.ChatReason, List<String>> languageMap = this.dialogues.get(language);
            if (languageMap == null || languageMap.isEmpty()) {
                CiviliansMod.LOGGER.warn("[CiviliansMod] No dialogues for language {}, falling back to en_us (NPC ID: {})", (Object)language, (Object)this.npc.method_5628());
                languageMap = DefaultChat.getDefaultChat().get("en_us");
            }
            if (languageMap == null && !this.dialogues.isEmpty()) {
                languageMap = this.dialogues.values().iterator().next();
                CiviliansMod.LOGGER.warn("[CiviliansMod] No en_us dialogues, using first available language for NPC {}", (Object)this.npc.method_5628());
            }
            if (languageMap == null) {
                CiviliansMod.LOGGER.warn("[CiviliansMod] No dialogues available at all, creating default placeholder map for NPC {}", (Object)this.npc.method_5628());
                languageMap = new EnumMap<NpcChat.ChatReason, List<String>>(NpcChat.ChatReason.class);
            }
            for (NpcChat.ChatReason reason : NpcChat.ChatReason.values()) {
                languageMap.computeIfAbsent(reason, r -> new ArrayList<String>(Collections.singletonList("...")));
            }
            return languageMap;
        }

        public Map<NpcChat.ChatReason, List<String>> getTranslatedDialogues(String language) {
            return this.getDialoguesForLanguage(language);
        }

        public class_2487 saveDialogues() {
            class_2487 main = new class_2487();
            class_2487 langs = new class_2487();
            for (Map.Entry<String, Map<NpcChat.ChatReason, List<String>>> langEntry : this.dialogues.entrySet()) {
                class_2487 langCompound = new class_2487();
                for (Map.Entry<NpcChat.ChatReason, List<String>> reasonEntry : langEntry.getValue().entrySet()) {
                    class_2499 list = new class_2499();
                    for (String msg : reasonEntry.getValue()) {
                        list.add((Object)class_2519.method_23256((String)msg));
                    }
                    langCompound.method_10566(reasonEntry.getKey().getName(), (class_2520)list);
                }
                langs.method_10566(langEntry.getKey(), (class_2520)langCompound);
            }
            main.method_10566("Languages", (class_2520)langs);
            class_2487 customCompound = new class_2487();
            for (Map.Entry<NpcChat.ChatReason, List<String>> entry : this.customDialogues.entrySet()) {
                class_2499 list = new class_2499();
                for (String msg : entry.getValue()) {
                    list.add((Object)class_2519.method_23256((String)msg));
                }
                customCompound.method_10566(entry.getKey().getName(), (class_2520)list);
            }
            main.method_10566("CustomDialogues", (class_2520)customCompound);
            return main;
        }

        public void setFromNbt(Optional<class_2487> nbtOptional) {
            Optional customOpt;
            if (nbtOptional.isEmpty()) {
                return;
            }
            this.dialogues.clear();
            this.customDialogues.clear();
            class_2487 nbt = nbtOptional.get();
            Optional langsOpt = nbt.method_10562("Languages");
            if (langsOpt.isPresent()) {
                class_2487 langs = (class_2487)langsOpt.get();
                for (String language : langs.method_10541()) {
                    Optional langCompoundOpt = langs.method_10562(language);
                    if (langCompoundOpt.isEmpty()) continue;
                    class_2487 langCompound = (class_2487)langCompoundOpt.get();
                    EnumMap reasonMap = new EnumMap(NpcChat.ChatReason.class);
                    for (NpcChat.ChatReason reason : NpcChat.ChatReason.values()) {
                        Optional listOpt;
                        if (!langCompound.method_10545(reason.getName()) || (listOpt = langCompound.method_10554(reason.getName())).isEmpty()) continue;
                        class_2499 list = (class_2499)listOpt.get();
                        ArrayList messages = new ArrayList();
                        list.forEach(e -> messages.add(e.method_68658().orElse("")));
                        reasonMap.put(reason, messages);
                    }
                    this.dialogues.put(language, reasonMap);
                }
            }
            if ((customOpt = nbt.method_10562("CustomDialogues")).isPresent()) {
                class_2487 custom = (class_2487)customOpt.get();
                for (NpcChat.ChatReason reason : NpcChat.ChatReason.values()) {
                    Optional listOpt;
                    if (!custom.method_10545(reason.getName()) || (listOpt = custom.method_10554(reason.getName())).isEmpty()) continue;
                    class_2499 list = (class_2499)listOpt.get();
                    ArrayList messages = new ArrayList();
                    list.forEach(e -> messages.add(e.method_68658().orElse("")));
                    this.customDialogues.put(reason, messages);
                }
            }
            if (this.dialogues.isEmpty()) {
                this.dialogues.putAll(DefaultChat.getDefaultChat());
            }
        }

        public Map<String, Map<NpcChat.ChatReason, List<String>>> getDialogues() {
            return this.dialogues;
        }

        public void setDialogues(Map<String, Map<NpcChat.ChatReason, List<String>>> newDialogues) {
            this.dialogues.clear();
            this.dialogues.putAll(newDialogues);
        }

        public Map<NpcChat.ChatReason, List<String>> getCustomDialogues() {
            return this.customDialogues;
        }

        public void setCustomDialogues(Map<NpcChat.ChatReason, List<String>> map) {
            this.customDialogues.clear();
            this.customDialogues.putAll(map);
        }

        public void markDialoguesDirty(UUID avoid) {
            class_1937 class_19372 = this.npc.method_37908();
            if (!(class_19372 instanceof class_3218)) {
                return;
            }
            class_3218 serverWorld = (class_3218)class_19372;
            for (class_3222 player : serverWorld.method_18766(p -> !p.method_5667().equals(avoid))) {
                try {
                    ServerPlayNetworking.send((class_3222)player, (class_8710)new DialogueSyncPayload(this.npc.method_5628(), this.dialogues, this.customDialogues));
                }
                catch (IOException e) {
                    CiviliansMod.LOGGER.error("[CiviliansMod] Failed to sync dialogues to player {}", (Object)player.method_7334().getName(), (Object)e);
                }
            }
        }

        @NotNull
        static BiConsumer<String, Map<NpcChat.ChatReason, List<String>>> getManageCompoundSave(class_2487 mainCompound) {
            return (language, reasonToMessagesMap) -> {
                class_2487 languageCompound = new class_2487();
                reasonToMessagesMap.forEach((reason, messages) -> {
                    class_2499 messageList = new class_2499();
                    messages.forEach(message -> messageList.add((Object)class_2519.method_23256((String)message)));
                    languageCompound.method_10566(reason.getName(), (class_2520)messageList);
                });
                mainCompound.method_10566(language, (class_2520)languageCompound);
            };
        }
    }
}

