/*
 * Decompiled with CFR 0.152.
 */
package net.asian.civiliansmod.gui;

import java.util.ArrayList;
import java.util.List;
import net.asian.civiliansmod.custom_skins.SkinFolderManager;
import net.asian.civiliansmod.entity.NPCEntity;
import net.asian.civiliansmod.gui.AbstractConfigScreen;
import net.asian.civiliansmod.gui.CustomNPCScreen;
import net.asian.civiliansmod.gui.DefaultNPCScreen;
import net.asian.civiliansmod.gui.SlimNPCScreen;
import net.asian.civiliansmod.networking.NPCDataPayload;
import net.asian.civiliansmod.networking.payload.npc.skin.ChangeBaseSkinPayload;
import net.asian.civiliansmod.networking.payload.npc.skin.ChangeSkinPayload;
import net.asian.civiliansmod.util.NPCUtil;
import net.fabricmc.fabric.api.client.networking.v1.ClientPlayNetworking;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1314;
import net.minecraft.class_1921;
import net.minecraft.class_1937;
import net.minecraft.class_2487;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_342;
import net.minecraft.class_364;
import net.minecraft.class_4185;
import net.minecraft.class_437;
import net.minecraft.class_4587;
import net.minecraft.class_4597;
import net.minecraft.class_638;
import net.minecraft.class_7833;
import net.minecraft.class_8710;
import net.minecraft.class_898;
import org.joml.Quaternionfc;

public abstract class AbstractNPCScreen
extends AbstractConfigScreen {
    private final NPCEntity npc;
    private static final int ENTITY_PREVIEW_SIZE = 25;
    private static final int ENTITY_SPACING = 58;
    private static final int COLUMN_WIDTH = 130;
    private final int defaultSkin;
    private int selectedVariant;
    private int selectedVariantIndex = -1;
    private int scrollOffset = 0;
    private int maxScrollOffset;
    private boolean isScrolling = false;
    private int scrollbarHeight = 0;
    private int scrollbarY = 0;
    private final int originalVariant;
    private int scrollbarGrabOffset = 0;
    private class_342 nameInputField;
    private class_4185 upslimButton;
    private class_4185 updefaultButton;
    boolean save = false;
    boolean follow;
    boolean stay;
    int startVariantIndex = 0;
    List<Integer> toRender = new ArrayList<Integer>();

    public AbstractNPCScreen(NPCEntity npc) {
        this(npc, -1, NPCUtil.getSkins().indexOf(npc.getSkinManager().getIdSkin()));
    }

    public AbstractNPCScreen(NPCEntity npc, int selected, int defaultSkin) {
        super(npc, (class_2561)class_2561.method_43470((String)"Change NPC Variant"));
        this.npc = npc;
        this.selectedVariant = selected;
        this.toRender = this.getSkinsToRender();
        this.originalVariant = NPCUtil.getSkins().indexOf(npc.getSkinManager().getIdSkin());
        this.defaultSkin = defaultSkin;
        this.follow = npc.isFollowing();
        this.stay = npc.isPaused();
    }

    public AbstractNPCScreen(NPCEntity npc, int selected, int defaultSkin, int selectedVariantIndex, boolean follow, boolean stay) {
        super(npc, (class_2561)class_2561.method_43470((String)"Change NPC Variant"));
        this.npc = npc;
        this.selectedVariant = selected;
        this.toRender = this.getSkinsToRender();
        this.selectedVariantIndex = selectedVariantIndex;
        this.originalVariant = NPCUtil.getSkins().indexOf(npc.getSkinManager().getIdSkin());
        this.defaultSkin = defaultSkin;
        this.follow = follow;
        this.stay = stay;
    }

    protected abstract List<Integer> getSkinsToRender();

    public boolean method_25421() {
        return false;
    }

    private void updateScrollBarDimensions() {
        int containerHeight = 166;
        int containerY = (this.field_22790 - containerHeight) / 2;
        int totalRows = (int)Math.ceil((double)this.toRender.size() / 3.0);
        int visibleRows = (containerHeight - 55) / 58;
        this.maxScrollOffset = Math.max(0, (totalRows - visibleRows) * 58);
        this.startVariantIndex = this.scrollOffset / 58 * 3;
        int scrollBarTotalHeight = containerHeight - 55;
        this.scrollbarHeight = 15;
        this.scrollbarY = containerY + 40 + (int)((float)this.scrollOffset / (float)this.maxScrollOffset * (float)(scrollBarTotalHeight - this.scrollbarHeight));
    }

    private void drawMainContainer(class_332 context) {
        class_2960 guiTexture = class_2960.method_60655((String)"civiliansmod", (String)"textures/gui/gui.png");
        int containerWidth = 256;
        int containerHeight = 166;
        int containerX = (this.field_22789 - containerWidth) / 2;
        int containerY = (this.field_22790 - containerHeight) / 2;
        context.method_25290(class_1921::method_62277, guiTexture, containerX, containerY, 0.0f, 0.0f, containerWidth, containerHeight, containerWidth, containerHeight);
    }

    public void method_25394(class_332 context, int mouseX, int mouseY, float delta) {
        super.method_25394(context, mouseX, mouseY, delta);
        this.drawMainContainer(context);
        context.method_27534(this.field_22793, (class_2561)class_2561.method_43470((String)"Civilian Customizer"), this.field_22789 / 2, 30, 0xFFFFFF);
        this.renderCenterPreview(context, mouseX, mouseY);
        this.renderVariants(context, mouseX, mouseY, delta);
        this.renderVanillaScrollBar(context);
        this.nameInputField.method_25394(context, mouseX, mouseY, delta);
        this.upslimButton.field_22764 = this instanceof CustomNPCScreen;
        this.updefaultButton.field_22764 = this instanceof CustomNPCScreen;
        for (class_364 button : this.method_25396()) {
            if (!(button instanceof class_4185)) continue;
            ((class_4185)button).method_25394(context, mouseX, mouseY, delta);
        }
    }

    @Override
    protected void method_25426() {
        super.method_25426();
        int containerWidth = 256;
        int containerHeight = 166;
        int containerX = (this.field_22789 - containerWidth) / 2;
        int containerY = (this.field_22790 - containerHeight) / 2;
        this.method_37063((class_364)class_4185.method_46430((class_2561)class_2561.method_43470((String)"Wide"), button -> class_310.method_1551().method_1507((class_437)new DefaultNPCScreen(this.npc, this.selectedVariant, this.defaultSkin, this.selectedVariantIndex, this.follow, this.stay))).method_46434(containerX + 82, containerY + 22, 39, 12).method_46431());
        this.method_37063((class_364)class_4185.method_46430((class_2561)class_2561.method_43470((String)"Slim"), button -> class_310.method_1551().method_1507((class_437)new SlimNPCScreen(this.npc, this.selectedVariant, this.defaultSkin, this.selectedVariantIndex, this.follow, this.stay))).method_46434(containerX + 121, containerY + 22, 40, 12).method_46431());
        this.method_37063((class_364)class_4185.method_46430((class_2561)class_2561.method_43470((String)"Custom"), button -> class_310.method_1551().method_1507((class_437)new CustomNPCScreen(this.npc, this.selectedVariant, this.defaultSkin, this.selectedVariantIndex, this.follow, this.stay))).method_46434(containerX + 161, containerY + 22, 39, 12).method_46431());
        this.method_37063((class_364)class_4185.method_46430((class_2561)class_2561.method_43470((String)"Save"), button -> {
            this.save = true;
            this.method_25419();
            this.scrollOffset = 0;
            this.updateScrollBarDimensions();
        }).method_46434(containerX + 11, containerY + 136, 50, 14).method_46431());
        this.upslimButton = class_4185.method_46430((class_2561)class_2561.method_43470((String)"\u2191Slim"), button -> SkinFolderManager.openFolder(SkinFolderManager.NPCModel.SLIM)).method_46434(containerX + 202, containerY + containerHeight - 37, 49, 20).method_46431();
        this.method_37063((class_364)this.upslimButton);
        this.updefaultButton = class_4185.method_46430((class_2561)class_2561.method_43470((String)"\u2191Wide"), button -> SkinFolderManager.openFolder(SkinFolderManager.NPCModel.WIDE)).method_46434(containerX + 202, containerY + containerHeight - 66, 49, 20).method_46431();
        this.method_37063((class_364)this.updefaultButton);
        String currentName = this.npc.method_5797() != null ? this.npc.method_5797().getString() : "";
        this.nameInputField = new class_342(this.field_22793, containerX + 5, containerY + 22, 62, 14, (class_2561)class_2561.method_43470((String)"Enter NPC Name"));
        class_4185 pauseButton = class_4185.method_46430((class_2561)class_2561.method_43470((String)(this.npc.isPaused() ? "Stay: On" : "Stay: Off")), button -> {
            boolean newState = !this.npc.isPaused();
            this.npc.setPaused(newState);
            button.method_25355((class_2561)class_2561.method_43470((String)(newState ? "Stay: On" : "Stay: Off")));
        }).method_46434(containerX + 202, containerY + containerHeight - 124, 49, 20).method_46431();
        this.method_37063((class_364)pauseButton);
        class_4185 followButton = class_4185.method_46430((class_2561)class_2561.method_43470((String)(this.npc.isFollowing() ? "Follow: On" : "Follow: Off")), button -> {
            boolean newState = !this.npc.isFollowing();
            this.npc.setFollowing(newState);
            button.method_25355((class_2561)class_2561.method_43470((String)(newState ? "Follow: On" : "Follow: Off")));
        }).method_46434(containerX + 202, containerY + containerHeight - 95, 49, 20).method_46431();
        this.method_37063((class_364)followButton);
        this.nameInputField.method_1852(currentName);
        this.nameInputField.method_1880(32);
        this.method_25429((class_364)this.nameInputField);
        int totalRows = 22;
        int visibleRows = (this.field_22790 - 100) / 58;
        this.maxScrollOffset = Math.max(0, (totalRows - visibleRows) * 58);
        this.updateScrollBarDimensions();
    }

    public void method_25419() {
        if (class_310.method_1551().field_1724 != null) {
            if (!this.save) {
                this.npc.getSkinManager().setIdSkin(NPCUtil.getNPCTexture(this.defaultSkin));
                this.npc.setFollowing(this.follow);
                this.npc.setPaused(this.stay);
                super.method_25419();
                return;
            }
            NPCDataPayload payload = new NPCDataPayload(this.npc.method_5667(), this.nameInputField.method_1882(), this.npc.isPaused(), this.npc.isFollowing());
            ClientPlayNetworking.send((class_8710)payload);
            if (this.npc.getSkinManager().getIdSkin().custom()) {
                ChangeSkinPayload payload1 = new ChangeSkinPayload(this.npc.method_5667(), this.npc.getSkinManager().getIdSkin().slim(), this.npc.getSkinManager().getIdSkin());
                ClientPlayNetworking.send((class_8710)payload1);
            } else {
                if (this.selectedVariantIndex == -1) {
                    super.method_25419();
                    return;
                }
                ChangeBaseSkinPayload payload1 = new ChangeBaseSkinPayload(this.npc.method_5667(), this.selectedVariantIndex);
                ClientPlayNetworking.send((class_8710)payload1);
            }
        }
        super.method_25419();
    }

    private void renderVanillaScrollBar(class_332 context) {
        int containerWidth = 256;
        int containerHeight = 166;
        int containerX = (this.field_22789 - containerWidth) / 2;
        int containerY = (this.field_22790 - containerHeight) / 2;
        int scrollBarX = containerX + 70;
        int scrollBarY = containerY + 38;
        int scrollBarHeight = containerHeight - 51;
        context.method_25294(scrollBarX, scrollBarY, scrollBarX + 6, scrollBarY + scrollBarHeight, -14671840);
        context.method_25294(scrollBarX + 1, this.scrollbarY, scrollBarX + 5, this.scrollbarY + this.scrollbarHeight, -5592406);
    }

    public boolean method_25402(double mouseX, double mouseY, int button) {
        int panelX;
        int clickedVariant;
        int containerWidth = 256;
        int containerX = (this.field_22789 - containerWidth) / 2;
        int scrollBarX = containerX + 70;
        if (mouseX >= (double)scrollBarX && mouseX <= (double)(scrollBarX + 6) && mouseY >= (double)this.scrollbarY && mouseY <= (double)(this.scrollbarY + this.scrollbarHeight)) {
            this.isScrolling = true;
            this.scrollbarGrabOffset = (int)(mouseY - (double)this.scrollbarY);
            return true;
        }
        if (button == 0 && (clickedVariant = this.detectClickedVariant(mouseX, mouseY, panelX = containerX + 83)) != -1) {
            this.selectedVariant = clickedVariant;
            if (clickedVariant < this.toRender.size()) {
                this.selectedVariantIndex = this.toRender.get(clickedVariant);
            }
            this.npc.getSkinManager().setIdSkin(NPCUtil.getNPCTexture(this.selectedVariantIndex));
            if (!NPCUtil.getNPCTexture(clickedVariant).custom()) {
                this.npc.getSkinManager().setBaseVariant(this.selectedVariantIndex);
            }
            this.npc.method_5652(this.npc.method_5647(new class_2487()));
        }
        return super.method_25402(mouseX, mouseY, button);
    }

    private int detectClickedVariant(double mouseX, double mouseY, int panelX) {
        int containerHeight = 166;
        int containerY = (this.field_22790 - containerHeight) / 2;
        int startY = containerY + 39;
        int columnWidth = 38;
        int columnOffset = 1;
        if (mouseY < (double)containerY || mouseY > (double)(containerY + containerHeight)) {
            return -1;
        }
        int minIndex = Math.min(this.toRender.size() - this.startVariantIndex, 9);
        for (int i = 0; i <= minIndex; ++i) {
            int rowIndex = i / 3;
            int columnIndex = i % 3;
            int xPosition = panelX + columnIndex * (columnWidth + columnOffset);
            int yPosition = startY + rowIndex * 58;
            if (yPosition < containerY || yPosition + 58 > containerY + containerHeight || !(mouseX >= (double)xPosition) || !(mouseX <= (double)(xPosition + columnWidth)) || !(mouseY >= (double)yPosition) || !(mouseY <= (double)(yPosition + 58))) continue;
            return this.startVariantIndex + i;
        }
        return -1;
    }

    private void renderCenterPreview(class_332 context, int mouseX, int mouseY) {
        int variantToRender = this.selectedVariantIndex == -1 ? this.originalVariant : this.selectedVariantIndex;
        NPCEntity previewNPC = this.originalVariant == -1 ? this.createBaseCenterPreviewNPC() : this.createCenterPreviewNPC(variantToRender);
        int guiWidth = 256;
        int guiHeight = 166;
        int guiX = (this.field_22789 - guiWidth) / 2;
        int guiY = (this.field_22790 - guiHeight) / 2;
        int previewX = guiX + 36;
        int previewY = guiY + guiHeight / 2 + 35;
        float deltaX = previewX - mouseX;
        float deltaY = (float)(mouseY - previewY) + 50.0f;
        float sensitivityFactor = 2.5f;
        float headYaw = (float)Math.atan2(deltaX, 50.0) * 57.295776f / sensitivityFactor;
        float pitch = (float)Math.atan2(deltaY, 50.0) * 57.295776f / sensitivityFactor;
        pitch = Math.max(-30.0f, Math.min(30.0f, pitch));
        float bodyYaw = headYaw / 1.2f;
        previewNPC.method_5847(headYaw);
        previewNPC.method_36457(pitch);
        previewNPC.field_6283 = bodyYaw;
        this.renderEntity(context.method_51448(), previewX, previewY, 35, (class_1297)previewNPC, 180.0f);
    }

    public boolean method_25403(double mouseX, double mouseY, int button, double deltaX, double deltaY) {
        if (this.isScrolling) {
            int containerHeight = 166;
            int containerY = (this.field_22790 - containerHeight) / 2;
            int scrollBarY = containerY + 40;
            int scrollBarHeight = containerHeight - 55;
            float relativeY = (float)(mouseY - (double)scrollBarY - (double)this.scrollbarGrabOffset);
            float scrollPercent = relativeY / (float)(scrollBarHeight - this.scrollbarHeight);
            this.scrollOffset = Math.max(0, Math.min((int)(scrollPercent * (float)this.maxScrollOffset), this.maxScrollOffset));
            this.scrollOffset = this.scrollOffset / 58 * 58;
            this.updateScrollBarDimensions();
            return true;
        }
        return super.method_25403(mouseX, mouseY, button, deltaX, deltaY);
    }

    public boolean method_25401(double mouseX, double mouseY, double horizontalAmount, double verticalAmount) {
        this.scrollOffset = (short)Math.max(0, Math.min(this.scrollOffset - (int)(verticalAmount * 58.0), this.maxScrollOffset));
        this.updateScrollBarDimensions();
        return super.method_25401(mouseX, mouseY, horizontalAmount, verticalAmount);
    }

    public boolean method_25406(double mouseX, double mouseY, int button) {
        this.isScrolling = false;
        this.scrollbarGrabOffset = 0;
        return super.method_25406(mouseX, mouseY, button);
    }

    private void renderVariants(class_332 context, int mouseX, int mouseY, float ignoredDelta) {
        int containerWidth = 256;
        int containerHeight = 166;
        int containerX = (this.field_22789 - containerWidth) / 2;
        int containerY = (this.field_22790 - containerHeight) / 2;
        int startY = containerY + 61;
        int panelX = containerX + 77;
        int columnWidth = 33;
        int columnOffset = 6;
        int minIndex = Math.min(this.toRender.size() - this.startVariantIndex, 6);
        for (int i = this.startVariantIndex; i < this.startVariantIndex + minIndex; ++i) {
            int rowIndex = (i - this.startVariantIndex) / 3;
            int columnIndex = (i - this.startVariantIndex) % 3;
            int xPosition = panelX + columnIndex * (columnWidth + columnOffset);
            int yPosition = startY + rowIndex * 58;
            this.renderVariantPreview(context, xPosition, yPosition, i, mouseX, mouseY);
        }
    }

    private void renderVariantPreview(class_332 context, int x, int y, int variantIndex, int mouseX, int mouseY) {
        NPCEntity previewNPC = this.createPreviewNPC(variantIndex);
        int containerWidth = 256;
        int containerHeight = 166;
        int containerX = (this.field_22789 - containerWidth) / 2;
        int containerY = (this.field_22790 - containerHeight) / 2;
        int maxX = containerX + containerWidth;
        int maxY = containerY + containerHeight;
        int adjustedX = x + 5;
        int adjustedY = y - 24;
        int entityWidth = 39;
        int entityHeight = 58;
        if (adjustedX + entityWidth > maxX || adjustedX < containerX) {
            return;
        }
        if (adjustedY + entityHeight > maxY || adjustedY < containerY) {
            return;
        }
        this.renderEntity(context.method_51448(), x + 25, y + 29, 25, (class_1297)previewNPC, 145.0f);
        if (mouseX >= adjustedX && mouseX <= adjustedX + entityWidth && mouseY >= adjustedY && mouseY <= adjustedY + entityHeight) {
            int outlineThickness = 2;
            context.method_25294(adjustedX, adjustedY, adjustedX + entityWidth, adjustedY + outlineThickness, -1);
            context.method_25294(adjustedX, adjustedY + entityHeight - outlineThickness, adjustedX + entityWidth, adjustedY + entityHeight, -1);
            context.method_25294(adjustedX, adjustedY, adjustedX + outlineThickness, adjustedY + entityHeight, -1);
            context.method_25294(adjustedX + entityWidth - outlineThickness, adjustedY, adjustedX + entityWidth, adjustedY + entityHeight, -1);
        }
    }

    private NPCEntity createPreviewNPC(int variantIndex) {
        class_638 world = class_310.method_1551().field_1687;
        NPCEntity previewNPC = new NPCEntity((class_1299<? extends class_1314>)this.npc.method_5864(), (class_1937)world);
        previewNPC.getSkinManager().setIdSkin(NPCUtil.getNPCTexture(this.toRender.get(variantIndex)));
        previewNPC.method_5977(true);
        previewNPC.method_5803(true);
        previewNPC.method_5847(0.0f);
        return previewNPC;
    }

    private NPCEntity createCenterPreviewNPC(int skinId) {
        class_638 world = class_310.method_1551().field_1687;
        NPCEntity previewNPC = new NPCEntity((class_1299<? extends class_1314>)this.npc.method_5864(), (class_1937)world);
        previewNPC.getSkinManager().setIdSkin(NPCUtil.getNPCTexture(skinId));
        previewNPC.method_5977(true);
        previewNPC.method_5803(true);
        previewNPC.method_5847(0.0f);
        return previewNPC;
    }

    private NPCEntity createBaseCenterPreviewNPC() {
        class_638 world = class_310.method_1551().field_1687;
        NPCEntity previewNPC = new NPCEntity((class_1299<? extends class_1314>)this.npc.method_5864(), (class_1937)world);
        previewNPC.getSkinManager().setIdSkin(this.npc.getSkinManager().getIdSkin());
        previewNPC.method_5977(true);
        previewNPC.method_5803(true);
        previewNPC.method_5847(0.0f);
        return previewNPC;
    }

    private void renderEntity(class_4587 matrices, int x, int y, int scale, class_1297 entity, float rotation) {
        class_898 dispatcher = class_310.method_1551().method_1561();
        matrices.method_22903();
        matrices.method_22904((double)x, (double)y, 50.0);
        matrices.method_22905((float)scale, (float)(-scale), (float)scale);
        matrices.method_22907((Quaternionfc)class_7833.field_40716.rotationDegrees(180.0f + rotation));
        int lightOverride = 0xF000F0;
        dispatcher.method_62424(entity, 0.0, 0.0, 0.0, 1.0f, matrices, (class_4597)class_310.method_1551().method_22940().method_23000(), lightOverride);
        matrices.method_22909();
    }
}

