/*
 * Decompiled with CFR 0.152.
 */
package net.asian.civiliansmod.gui.widgets;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import net.asian.civiliansmod.chat.NpcChat;
import net.asian.civiliansmod.entity.NPCEntity;
import net.asian.civiliansmod.gui.CustomChatScreen;
import net.asian.civiliansmod.gui.widgets.ChatReasonEntryScrollContainer;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_3532;
import net.minecraft.class_4265;

public class GlobalChatScrollWidget
extends class_4265<ChatReasonEntryScrollContainer> {
    NPCEntity npc;
    CustomChatScreen screen;
    boolean customMode;

    public GlobalChatScrollWidget(NPCEntity npc, class_310 minecraftClient, int width, int height, int x, int y, int itemHeight, CustomChatScreen screen, boolean customMode) {
        super(minecraftClient, width, height, y, itemHeight);
        this.npc = npc;
        this.screen = screen;
        this.customMode = customMode;
        npc.getChatManager().getTranslatedDialogues(minecraftClient.method_1526().method_4669()).forEach((chatReason, strings) -> this.method_25396().add(new ChatReasonEntryScrollContainer(npc, (NpcChat.ChatReason)((Object)chatReason), (List<String>)strings, screen, customMode)));
        this.method_48229(x, y);
        this.refreshChildren();
    }

    public boolean isCustomMode() {
        return this.customMode;
    }

    public void refreshChildren() {
        this.method_25396().clear();
        String language = class_310.method_1551().method_1526().method_4669();
        Map<NpcChat.ChatReason, List<String>> dialoguesMap = this.customMode ? this.npc.getChatManager().getCustomDialogues() : this.npc.getChatManager().getTranslatedDialogues(language);
        dialoguesMap.forEach((chatReason, strings) -> {
            if (strings == null) {
                strings = new ArrayList<String>();
            }
            this.method_25396().add(new ChatReasonEntryScrollContainer(this.npc, (NpcChat.ChatReason)((Object)chatReason), (List<String>)strings, this.screen, this.customMode));
        });
        if (dialoguesMap.isEmpty() && this.customMode) {
            for (NpcChat.ChatReason reason : NpcChat.ChatReason.values()) {
                this.method_25396().add(new ChatReasonEntryScrollContainer(this.npc, reason, new ArrayList<String>(), this.screen, true));
            }
        }
    }

    public int method_25342() {
        return this.method_46426();
    }

    public void method_48579(class_332 context, int mouseX, int mouseY, float delta) {
        this.method_49603(context);
        this.method_25311(context, mouseX, mouseY, delta);
        context.method_44380();
        this.renderScrollBar(context);
    }

    protected void renderScrollBar(class_332 context) {
        if (this.field_22764) {
            int contentHeight = this.getTotalContentHeight();
            int visibleHeight = this.field_22759;
            int scrollbarHeight = (int)((float)visibleHeight * (float)visibleHeight / (float)contentHeight);
            scrollbarHeight = class_3532.method_15340((int)scrollbarHeight, (int)32, (int)(visibleHeight - 8));
            int scrollY = (int)(this.method_44387() * (double)(visibleHeight - scrollbarHeight) / (double)this.method_44390()) + this.method_46427();
            scrollY = Math.max(scrollY, this.method_46427());
            int scrollbarX = this.method_65507();
            context.method_25294(scrollbarX, scrollY - 2, scrollbarX + 3, scrollY + scrollbarHeight, -5592406);
        }
    }

    protected int getEntryTop(int index) {
        int y = this.method_46427() - (int)this.method_44387();
        for (int i = 0; i < index; ++i) {
            y += ((ChatReasonEntryScrollContainer)((Object)this.method_25396().get(i))).getHeight();
        }
        return y;
    }

    protected int getTotalContentHeight() {
        return this.method_25396().stream().mapToInt(ChatReasonEntryScrollContainer::getHeight).sum();
    }

    protected void method_25311(class_332 context, int mouseX, int mouseY, float delta) {
        int rowLeft = this.method_25342();
        int rowWidth = this.method_25322();
        int entryCount = this.method_25340();
        int y = this.method_46427() - (int)this.method_44387();
        for (int i = 0; i < entryCount; ++i) {
            ChatReasonEntryScrollContainer entry = (ChatReasonEntryScrollContainer)((Object)this.method_25396().get(i));
            int entryHeight = entry.getHeight();
            if (y + entryHeight >= this.method_46427() && y <= this.method_55443()) {
                this.method_44397(context, mouseX, mouseY, delta, i, rowLeft, y, rowWidth, entryHeight);
            }
            y += entryHeight;
        }
    }

    public boolean method_25401(double d, double e, double f, double g) {
        if (!this.field_22764) {
            return false;
        }
        this.method_44382(this.method_44387() - g * this.method_44393());
        return true;
    }

    public int method_44390() {
        return this.getTotalContentHeight() - this.method_25364();
    }

    protected int method_65507() {
        return this.method_46426() + this.field_22758 - 3;
    }

    public void method_25348(double mouseX, double mouseY) {
        this.method_25396().forEach(dialogueEntryScrollContainer -> {
            if (dialogueEntryScrollContainer.onClick(mouseX, mouseY)) {
                return;
            }
            if (dialogueEntryScrollContainer.open) {
                dialogueEntryScrollContainer.entries.forEach(entry -> entry.dialogueEntryList.forEach(dialogueEntry -> dialogueEntry.method_25348(mouseX, mouseY)));
            }
        });
    }

    public boolean method_25402(double mouseX, double mouseY, int button) {
        if (!this.method_25405(mouseX, mouseY)) {
            return false;
        }
        for (ChatReasonEntryScrollContainer container : this.method_25396()) {
            if (!container.method_25402(mouseX, mouseY, button)) continue;
            return true;
        }
        return false;
    }
}

