/*
 * Decompiled with CFR 0.152.
 */
package net.asian.civiliansmod.model;

import com.mojang.logging.LogUtils;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import net.asian.civiliansmod.renderer.NPCRenderState;
import net.fabricmc.loader.api.FabricLoader;
import net.minecraft.class_10034;
import net.minecraft.class_156;
import net.minecraft.class_1921;
import net.minecraft.class_5603;
import net.minecraft.class_5605;
import net.minecraft.class_5606;
import net.minecraft.class_5609;
import net.minecraft.class_5610;
import net.minecraft.class_572;
import net.minecraft.class_5819;
import net.minecraft.class_630;
import org.slf4j.Logger;

public class NPCModel
extends class_572<NPCRenderState> {
    private static final Logger LOGGER = LogUtils.getLogger();
    private static final Set<String> warnedMods = new HashSet<String>();
    private final List<class_630> parts;
    public final class_630 leftSleeve;
    public final class_630 rightSleeve;
    public final class_630 leftPants;
    public final class_630 rightPants;
    public final class_630 jacket;
    private final boolean thinArms;

    public NPCModel(class_630 modelPart, boolean thinArms) {
        super(modelPart, class_1921::method_23580);
        this.thinArms = thinArms;
        this.leftSleeve = this.field_27433.method_32086("left_sleeve");
        this.rightSleeve = this.field_3401.method_32086("right_sleeve");
        this.leftPants = this.field_3397.method_32086("left_pants");
        this.rightPants = this.field_3392.method_32086("right_pants");
        this.jacket = this.field_3391.method_32086("jacket");
        this.parts = List.of(this.field_3398, this.field_3391, this.field_27433, this.field_3401, this.field_3397, this.field_3392);
    }

    public static class_5609 getTexturedModelData(class_5605 dilation, boolean thinArms) {
        class_5609 modelData = class_572.method_32011((class_5605)dilation, (float)0.0f);
        class_5610 modelPartData = modelData.method_32111();
        if (thinArms) {
            leftArm = modelPartData.method_32117("left_arm", class_5606.method_32108().method_32101(32, 48).method_32098(-1.0f, -2.0f, -2.0f, 3.0f, 12.0f, 4.0f, dilation), class_5603.method_32091((float)5.0f, (float)2.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f));
            rightArm = modelPartData.method_32117("right_arm", class_5606.method_32108().method_32101(40, 16).method_32098(-2.0f, -2.0f, -2.0f, 3.0f, 12.0f, 4.0f, dilation), class_5603.method_32091((float)-5.0f, (float)2.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f));
            leftArm.method_32117("left_sleeve", class_5606.method_32108().method_32101(48, 48).method_32098(-1.0f, -2.0f, -2.0f, 3.0f, 12.0f, 4.0f, dilation.method_32094(0.25f)), class_5603.field_27701);
            rightArm.method_32117("right_sleeve", class_5606.method_32108().method_32101(40, 32).method_32098(-2.0f, -2.0f, -2.0f, 3.0f, 12.0f, 4.0f, dilation.method_32094(0.25f)), class_5603.field_27701);
        } else {
            leftArm = modelPartData.method_32117("left_arm", class_5606.method_32108().method_32101(32, 48).method_32098(-1.0f, -2.0f, -2.0f, 4.0f, 12.0f, 4.0f, dilation), class_5603.method_32091((float)5.0f, (float)2.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f));
            rightArm = modelPartData.method_32117("right_arm", class_5606.method_32108().method_32101(40, 16).method_32098(-3.0f, -2.0f, -2.0f, 4.0f, 12.0f, 4.0f, dilation), class_5603.method_32091((float)-5.0f, (float)2.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f));
            leftArm.method_32117("left_sleeve", class_5606.method_32108().method_32101(48, 48).method_32098(-1.0f, -2.0f, -2.0f, 4.0f, 12.0f, 4.0f, dilation.method_32094(0.25f)), class_5603.field_27701);
            rightArm.method_32117("right_sleeve", class_5606.method_32108().method_32101(40, 32).method_32098(-3.0f, -2.0f, -2.0f, 4.0f, 12.0f, 4.0f, dilation.method_32094(0.25f)), class_5603.field_27701);
        }
        class_5610 leftLeg = modelPartData.method_32117("left_leg", class_5606.method_32108().method_32101(16, 48).method_32098(-2.0f, 0.0f, -2.0f, 4.0f, 12.0f, 4.0f, dilation), class_5603.method_32091((float)1.9f, (float)12.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f));
        class_5610 rightLeg = modelPartData.method_32117("right_leg", class_5606.method_32108().method_32101(0, 16).method_32098(-2.0f, 0.0f, -2.0f, 4.0f, 12.0f, 4.0f, dilation), class_5603.method_32091((float)-1.9f, (float)12.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f));
        leftLeg.method_32117("left_pants", class_5606.method_32108().method_32101(0, 48).method_32098(-2.0f, 0.0f, -2.0f, 4.0f, 12.0f, 4.0f, dilation.method_32094(0.25f)), class_5603.field_27701);
        rightLeg.method_32117("right_pants", class_5606.method_32108().method_32101(0, 32).method_32098(-2.0f, 0.0f, -2.0f, 4.0f, 12.0f, 4.0f, dilation.method_32094(0.25f)), class_5603.field_27701);
        class_5610 body = modelPartData.method_32116("body");
        body.method_32117("jacket", class_5606.method_32108().method_32101(16, 32).method_32098(-4.0f, 0.0f, -2.0f, 8.0f, 12.0f, 4.0f, dilation.method_32094(0.25f)), class_5603.field_27701);
        return modelData;
    }

    public void setAngles(NPCRenderState playerEntityRenderState) {
        if (playerEntityRenderState == null) {
            this.method_2805(false);
            return;
        }
        try {
            super.method_17087((class_10034)playerEntityRenderState);
        }
        catch (Throwable e) {
            String culprit = this.findCulpritMod(e);
            if (warnedMods.add(culprit)) {
                LOGGER.warn("[Civilians] Another Mod tried to inject into Civilians code via Mixin! Please report this to the Mod Developer for compatibility. Likely culprit: {}", (Object)culprit, (Object)e);
            }
            this.field_3391.field_3665 = true;
            this.field_3398.field_3665 = true;
            this.field_27433.field_3665 = true;
            this.field_3401.field_3665 = true;
            this.field_3397.field_3665 = true;
            this.field_3392.field_3665 = true;
            this.field_3394.field_3665 = false;
            this.jacket.field_3665 = false;
            this.leftSleeve.field_3665 = false;
            this.rightSleeve.field_3665 = false;
            this.leftPants.field_3665 = false;
            this.rightPants.field_3665 = false;
        }
        this.updateVisibility(playerEntityRenderState);
    }

    private void updateVisibility(NPCRenderState playerEntityRenderState) {
        this.method_2805(!playerEntityRenderState.spectator);
        this.field_3394.field_3665 = playerEntityRenderState.hatVisible;
        this.jacket.field_3665 = playerEntityRenderState.jacketVisible;
        this.leftPants.field_3665 = playerEntityRenderState.leftPantsLegVisible;
        this.rightPants.field_3665 = playerEntityRenderState.rightPantsLegVisible;
        this.leftSleeve.field_3665 = playerEntityRenderState.leftSleeveVisible;
        this.rightSleeve.field_3665 = playerEntityRenderState.rightSleeveVisible;
    }

    public void method_2805(boolean visible) {
        super.method_2805(visible);
        this.leftSleeve.field_3665 = visible;
        this.rightSleeve.field_3665 = visible;
        this.leftPants.field_3665 = visible;
        this.rightPants.field_3665 = visible;
        this.jacket.field_3665 = visible;
    }

    public class_630 getRandomPart(class_5819 random) {
        return (class_630)class_156.method_32309(this.parts, (class_5819)random);
    }

    private String findCulpritMod(Throwable t) {
        List<String> modIds = FabricLoader.getInstance().getAllMods().stream().map(mod -> mod.getMetadata().getId()).toList();
        for (Throwable current = t; current != null; current = current.getCause()) {
            for (StackTraceElement ste : current.getStackTrace()) {
                String[] parts;
                String classPartName = ste.getClassName();
                if (classPartName.startsWith("net.asian.civiliansmod") || classPartName.startsWith("net.minecraft")) continue;
                for (String modId : modIds) {
                    if (!classPartName.startsWith(modId)) continue;
                    return modId;
                }
                for (String part : parts = classPartName.split("\\.")) {
                    if (part.equals("com") || part.equals("org") || part.equals("net")) continue;
                    return part;
                }
            }
        }
        return "Unknown Mod";
    }
}

