/*
 * Decompiled with CFR 0.152.
 */
package net.asian.civiliansmod.networking.payload.npc.dialogue;

import com.google.common.reflect.TypeToken;
import com.google.gson.Gson;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.Base64;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;
import net.asian.civiliansmod.CiviliansMod;
import net.asian.civiliansmod.chat.NpcChat;
import net.asian.civiliansmod.entity.NPCEntity;
import net.asian.civiliansmod.gui.CustomChatScreen;
import net.fabricmc.fabric.api.client.networking.v1.ClientPlayNetworking;
import net.minecraft.class_1297;
import net.minecraft.class_1937;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_437;
import net.minecraft.class_8710;
import net.minecraft.class_9129;
import net.minecraft.class_9135;
import net.minecraft.class_9139;

public record DialogueSyncPayload(int npcId, String info) implements class_8710
{
    public static final class_8710.class_9154<DialogueSyncPayload> ID = new class_8710.class_9154(class_2960.method_60655((String)"civiliansmod", (String)"dialogue_sync"));
    public static final class_9139<class_9129, DialogueSyncPayload> CODEC = class_9139.method_56435((class_9139)class_9135.field_49675, DialogueSyncPayload::npcId, (class_9139)class_9135.field_48554, DialogueSyncPayload::info, DialogueSyncPayload::new);

    public DialogueSyncPayload(int npcId, Map<String, Map<NpcChat.ChatReason, List<String>>> dialogues, Map<NpcChat.ChatReason, List<String>> customDialogues) throws IOException {
        this(npcId, DialogueSyncPayload.compress(new Gson().toJson(Map.of("dialogues", dialogues, "custom", customDialogues))));
    }

    public class_8710.class_9154<? extends class_8710> method_56479() {
        return ID;
    }

    public void handlePacket(ClientPlayNetworking.Context context) {
        class_1937 class_19372 = context.player().method_37908();
        if (!(class_19372 instanceof class_1937)) {
            return;
        }
        class_1937 world = class_19372;
        class_1297 class_12972 = world.method_8469(this.npcId);
        if (!(class_12972 instanceof NPCEntity)) {
            return;
        }
        NPCEntity entity = (NPCEntity)class_12972;
        try {
            String clientLanguage;
            Map dialoguesForLanguage;
            String json = DialogueSyncPayload.decompress(this.info);
            Gson gson = new Gson();
            Map dialoguespack = (Map)gson.fromJson(json, new TypeToken<Map<String, Object>>(){}.getType());
            Map dialogueMap = new HashMap();
            HashMap<NpcChat.ChatReason, List<String>> customMap = new HashMap();
            if (dialoguespack.containsKey("dialogues")) {
                dialogueMap = (Map)gson.fromJson(gson.toJson(dialoguespack.get("dialogues")), new TypeToken<Map<String, Map<NpcChat.ChatReason, List<String>>>>(){}.getType());
            }
            if (dialoguespack.containsKey("custom")) {
                customMap = (Map)gson.fromJson(gson.toJson(dialoguespack.get("custom")), new TypeToken<Map<NpcChat.ChatReason, List<String>>>(){}.getType());
            }
            if (customMap == null) {
                customMap = new HashMap();
            }
            if ((dialoguesForLanguage = (Map)dialogueMap.get(clientLanguage = class_310.method_1551().method_1526().method_4669())) == null) {
                dialoguesForLanguage = (Map)dialogueMap.get("en_us");
                CiviliansMod.LOGGER.warn("[CiviliansMod] No dialogues for language {}, falling back to en_us", (Object)clientLanguage);
            }
            if (dialoguesForLanguage == null && !dialogueMap.isEmpty()) {
                dialoguesForLanguage = (Map)dialogueMap.values().iterator().next();
                CiviliansMod.LOGGER.warn("[CiviliansMod] No en_us dialogues, using first available language");
            }
            if (dialoguesForLanguage != null) {
                HashMap<String, Map<NpcChat.ChatReason, List<String>>> correctLanguage = new HashMap<String, Map<NpcChat.ChatReason, List<String>>>();
                correctLanguage.put(clientLanguage, dialoguesForLanguage);
                entity.getChatManager().setDialogues(correctLanguage);
                entity.getChatManager().setCustomDialogues(customMap);
                entity.dialoguesReceived = true;
                CiviliansMod.LOGGER.info("[CiviliansMod] Set {} dialogues and {} custom for NPC {}", new Object[]{dialoguesForLanguage.size(), customMap.size(), this.npcId});
            } else {
                CiviliansMod.LOGGER.error("[CiviliansMod] No dialogues available for NPC {}", (Object)this.npcId);
            }
            class_310 client = class_310.method_1551();
            client.execute(() -> client.execute(() -> {
                class_437 patt0$temp = client.field_1755;
                if (patt0$temp instanceof CustomChatScreen) {
                    CustomChatScreen screen = (CustomChatScreen)patt0$temp;
                    CiviliansMod.LOGGER.info("[CiviliansMod] Refreshing CustomChatScreen after dialogue sync for NPC " + this.npcId);
                    screen.fullInit();
                }
            }));
        }
        catch (Exception e) {
            CiviliansMod.LOGGER.error("[CiviliansMod] Failed to handle DialogueSyncPayload for NPC {}", (Object)this.npcId, (Object)e);
        }
    }

    public static String compress(String str) throws IOException {
        ByteArrayOutputStream byteStream = new ByteArrayOutputStream();
        try (GZIPOutputStream gzip = new GZIPOutputStream(byteStream);){
            gzip.write(str.getBytes(StandardCharsets.UTF_8));
        }
        return Base64.getEncoder().encodeToString(byteStream.toByteArray());
    }

    public static String decompress(String compressed) throws IOException {
        String string;
        byte[] data = Base64.getDecoder().decode(compressed);
        GZIPInputStream gzip = new GZIPInputStream(new ByteArrayInputStream(data));
        try {
            string = new String(gzip.readAllBytes(), StandardCharsets.UTF_8);
        }
        catch (Throwable throwable) {
            try {
                try {
                    gzip.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (Exception e) {
                CiviliansMod.LOGGER.error("Decompression error", (Throwable)e);
                throw e;
            }
        }
        gzip.close();
        return string;
    }
}

