/*
 * Decompiled with CFR 0.152.
 */
package net.asian.civiliansmod.util;

import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Stream;
import net.asian.civiliansmod.CiviliansMod;
import net.asian.civiliansmod.util.FolderUtil;
import net.asian.civiliansmod.util.SkinIdentifier;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1011;
import net.minecraft.class_1043;
import net.minecraft.class_1044;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import org.jetbrains.annotations.NotNull;

@Environment(value=EnvType.CLIENT)
public class NPCUtil {
    public static final Map<Integer, SkinIdentifier> waitingSync = new HashMap<Integer, SkinIdentifier>();
    static final List<SkinIdentifier> skins = new ArrayList<SkinIdentifier>();
    public static Map<SkinIdentifier, byte[]> images = new HashMap<SkinIdentifier, byte[]>();

    public static List<SkinIdentifier> getSkins() {
        return skins;
    }

    public static boolean isSlim(int index) {
        return skins.get(index).slim();
    }

    private static void registerDefaultSkins() {
        class_310.method_1551().method_1478().method_14488("textures/entity/npc/wide", path -> path.toString().endsWith(".png")).forEach((id, resource) -> skins.add(new SkinIdentifier((class_2960)id, false, false)));
    }

    private static void registerSlimSkins() {
        class_310.method_1551().method_1478().method_14488("textures/entity/npc/slim", path -> path.toString().endsWith(".png")).forEach((id, resource) -> skins.add(new SkinIdentifier((class_2960)id, true, false)));
    }

    private static void registerDefaultCustomSkins() {
        try (Stream<Path> files = Files.list(FolderUtil.WIDE_SKIN_PATH);){
            NPCUtil.searchAndConvertSkins(files, false);
        }
        catch (IOException e) {
            CiviliansMod.LOGGER.error("error while listing skin files");
            e.printStackTrace();
        }
    }

    private static void registerSlimCustomSkins() {
        try (Stream<Path> files = Files.list(FolderUtil.SLIM_SKIN_PATH);){
            NPCUtil.searchAndConvertSkins(files, true);
        }
        catch (IOException e) {
            CiviliansMod.LOGGER.error("error while listing skin files");
            e.printStackTrace();
        }
    }

    public static SkinIdentifier getNPCTexture(int texture) {
        if (skins.isEmpty()) {
            CiviliansMod.LOGGER.error("Tried to get NPC skin but no skins are loaded!");
            return new SkinIdentifier(class_2960.method_60655((String)"minecraft", (String)"textures/entity/steve.png"), false, true);
        }
        if (texture < 0 || texture >= skins.size()) {
            CiviliansMod.LOGGER.warn("Invalid skin index {} (skins.size = {}). Using 0 as fallback.", (Object)texture, (Object)skins.size());
            texture = 0;
        }
        return skins.get(texture);
    }

    public static void refreshTextures() {
        skins.clear();
        NPCUtil.registerDefaultSkins();
        NPCUtil.registerSlimSkins();
        NPCUtil.registerDefaultCustomSkins();
        NPCUtil.registerSlimCustomSkins();
    }

    private static void searchAndConvertSkins(Stream<@NotNull Path> files, boolean slim) {
        AtomicInteger i = new AtomicInteger();
        files.forEach(file -> {
            if (file.getFileName().toString().endsWith(".png")) {
                try {
                    InputStream stream = Files.newInputStream(file, new OpenOption[0]);
                    try {
                        byte[] skin = stream.readAllBytes();
                        stream.close();
                        class_1011 image = class_1011.method_49277((byte[])skin);
                        if (image.method_4323() != 64 || image.method_4307() != 64) {
                            return;
                        }
                        String textureName = "custom_skin_" + String.valueOf(UUID.randomUUID());
                        class_1043 dynamicTexture = new class_1043(() -> textureName, image);
                        class_2960 textureId = class_2960.method_60655((String)"civiliansmod", (String)textureName);
                        class_310.method_1551().method_1531().method_4616(textureId, (class_1044)dynamicTexture);
                        skins.add(new SkinIdentifier(textureId, slim, true));
                        images.put(skins.getLast(), skin);
                        image.close();
                    }
                    catch (Exception e) {
                        CiviliansMod.LOGGER.error("Error while converting skin files", (Throwable)e);
                    }
                }
                catch (IOException e) {
                    CiviliansMod.LOGGER.error("Error while converting skin files", (Throwable)e);
                }
            }
        });
    }

    public static void registerSkin() {
    }
}

