/*
 * Decompiled with CFR 0.152.
 */
package cc.madefor.phoenix.ccsecureboot;

import cc.madefor.phoenix.ccsecureboot.CCSecureBoot;
import cc.madefor.phoenix.ccsecureboot.mixin.ServerContextAccessor;
import dan200.computercraft.api.ComputerCraftAPI;
import dan200.computercraft.api.filesystem.Mount;
import dan200.computercraft.api.lua.IComputerSystem;
import dan200.computercraft.api.lua.ILuaAPI;
import dan200.computercraft.api.lua.LuaException;
import dan200.computercraft.api.lua.LuaFunction;
import dan200.computercraft.api.lua.MethodResult;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.Writer;
import java.lang.ref.WeakReference;
import java.math.BigInteger;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import java.security.KeyFactory;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.SecureRandom;
import java.security.Signature;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.NamedParameterSpec;
import java.security.spec.PKCS8EncodedKeySpec;
import java.util.Date;
import javax.security.auth.x500.X500Principal;
import net.minecraft.server.MinecraftServer;
import org.bouncycastle.asn1.ASN1ObjectIdentifier;
import org.bouncycastle.asn1.ASN1OctetString;
import org.bouncycastle.asn1.pkcs.PrivateKeyInfo;
import org.bouncycastle.asn1.x500.RDN;
import org.bouncycastle.asn1.x500.X500Name;
import org.bouncycastle.asn1.x509.Certificate;
import org.bouncycastle.cert.X509CRLHolder;
import org.bouncycastle.cert.X509CertificateHolder;
import org.bouncycastle.cert.X509v2CRLBuilder;
import org.bouncycastle.cert.X509v3CertificateBuilder;
import org.bouncycastle.cert.jcajce.JcaX509CertificateHolder;
import org.bouncycastle.operator.ContentSigner;
import org.bouncycastle.operator.OperatorCreationException;
import org.bouncycastle.operator.jcajce.JcaContentSignerBuilder;
import org.bouncycastle.pkcs.PKCS10CertificationRequest;
import org.bouncycastle.pkcs.jcajce.JcaPKCS10CertificationRequestBuilder;
import org.bouncycastle.util.io.pem.PemObject;
import org.bouncycastle.util.io.pem.PemObjectGenerator;
import org.bouncycastle.util.io.pem.PemReader;
import org.bouncycastle.util.io.pem.PemWriter;
import org.jspecify.annotations.Nullable;

public class CCSecureBootAPI
implements ILuaAPI {
    private static @Nullable java.security.cert.Certificate rootCertificate = null;
    private static @Nullable PrivateKey rootKey = null;
    private static @Nullable X509CRLHolder rootCRL = null;
    private static WeakReference<MinecraftServer> mcServer = new WeakReference<Object>(null);
    private static final Object rootKeyLock = new Object();
    private static final Object rootCRLLock = new Object();
    private final IComputerSystem computer;
    private @Nullable String mountPath = null;

    public CCSecureBootAPI(IComputerSystem computer) {
        this.computer = computer;
    }

    @LuaFunction
    public final ByteBuffer enroll(ByteBuffer pem) throws LuaException {
        if (rootKey == null) {
            throw new LuaException("An error occurred while loading the root key; check the server logs for more information.");
        }
        File file = this.computer.getLevel().method_8503().method_27050(ServerContextAccessor.getFolder()).resolve("certs/enrolled/" + this.computer.getID()).toFile();
        if (file.exists()) {
            throw new LuaException("This computer is already enrolled in secure boot");
        }
        try {
            byte[] bytes = new byte[pem.remaining()];
            pem.get(bytes);
            PemReader reader = new PemReader((Reader)new InputStreamReader(new ByteArrayInputStream(bytes)));
            PemObject data = reader.readPemObject();
            reader.close();
            PKCS10CertificationRequest csr = new PKCS10CertificationRequest(data.getContent());
            RDN[] rdns = csr.getSubject().getRDNs(new ASN1ObjectIdentifier("2.5.4.45"));
            if (rdns.length == 0) {
                throw new LuaException("CSR does not contain computer ID");
            }
            byte[] id_bytes = ((ASN1OctetString)rdns[0].getFirst().getValue()).getOctets();
            String id_str = new String(id_bytes, StandardCharsets.ISO_8859_1);
            if (!id_str.equals(String.valueOf(this.computer.getID()))) {
                throw new LuaException("CSR ID does not match computer ID");
            }
            X509Certificate cert = this.sign(csr, rootKey);
            ByteArrayOutputStream stream = new ByteArrayOutputStream();
            PemWriter writer = new PemWriter((Writer)new OutputStreamWriter(stream));
            writer.writeObject((PemObjectGenerator)new PemObject("CERTIFICATE", cert.getEncoded()));
            writer.close();
            file.getParentFile().mkdirs();
            file.createNewFile();
            return ByteBuffer.wrap(stream.toByteArray());
        }
        catch (Exception e) {
            throw new LuaException("Could not sign certificate: " + e.getMessage());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @LuaFunction
    public final MethodResult unenroll(ByteBuffer certbuf, ByteBuffer sigbuf) {
        if (rootCertificate == null) {
            return MethodResult.of((Object[])new Object[]{false, "An error occurred while loading the root certificate; check the server logs for more information."});
        }
        File file = this.computer.getLevel().method_8503().method_27050(ServerContextAccessor.getFolder()).resolve("certs/enrolled/" + this.computer.getID()).toFile();
        if (!file.exists()) {
            return MethodResult.of((Object)true);
        }
        try {
            byte[] certbytes = new byte[certbuf.remaining()];
            certbuf.get(certbytes);
            PemReader reader = new PemReader((Reader)new InputStreamReader(new ByteArrayInputStream(certbytes)));
            PemObject certdata = reader.readPemObject();
            reader.close();
            X509Certificate cert = (X509Certificate)CertificateFactory.getInstance("X.509").generateCertificate(new ByteArrayInputStream(certdata.getContent()));
            Object object = rootCRLLock;
            synchronized (object) {
                if (rootCRL != null && rootCRL.getRevokedCertificate(cert.getSerialNumber()) != null) {
                    return MethodResult.of((Object[])new Object[]{false, "Certificate has been revoked"});
                }
            }
            cert.verify(rootCertificate.getPublicKey());
            byte[] sigbytes = new byte[sigbuf.remaining()];
            sigbuf.get(sigbytes);
            Signature sig = Signature.getInstance("Ed25519");
            sig.initVerify(cert);
            RDN[] rdns = new JcaX509CertificateHolder(cert).getSubject().getRDNs(new ASN1ObjectIdentifier("2.5.4.45"));
            if (rdns.length == 0) {
                return MethodResult.of((Object[])new Object[]{false, "Certificate does not contain computer ID"});
            }
            byte[] id_bytes = ((ASN1OctetString)rdns[0].getFirst().getValue()).getOctets();
            sig.update(id_bytes);
            if (!sig.verify(sigbytes)) {
                return MethodResult.of((Object[])new Object[]{false, "Could not verify signature"});
            }
            Object object2 = rootCRLLock;
            synchronized (object2) {
                if (rootCRL != null) {
                    X509v2CRLBuilder crlBuilder = new X509v2CRLBuilder(rootCRL);
                    crlBuilder.addCRLEntry(cert.getSerialNumber(), new Date(System.currentTimeMillis()), 4);
                    rootCRL = crlBuilder.build(new JcaContentSignerBuilder("Ed25519").build(rootKey));
                    File crlfile = this.computer.getLevel().method_8503().method_27050(ServerContextAccessor.getFolder()).resolve("certs/revoked.crl").toFile();
                    PemWriter writer = new PemWriter((Writer)new FileWriter(crlfile));
                    writer.writeObject((PemObjectGenerator)new PemObject("X509 CRL", rootCRL.getEncoded()));
                    writer.close();
                }
            }
            return MethodResult.of((Object)file.delete());
        }
        catch (Exception e) {
            return MethodResult.of((Object[])new Object[]{false, e.getMessage()});
        }
    }

    public String[] getNames() {
        return new String[0];
    }

    public @Nullable String getModuleName() {
        return "secureboot";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void startup() {
        PemWriter writer;
        super.startup();
        MinecraftServer server = this.computer.getLevel().method_8503();
        this.mountPath = this.computer.mount("rom/pxboot/certs", (Mount)ComputerCraftAPI.createSaveDirMount((MinecraftServer)server, (String)"certs", (long)0L), "certs");
        Object object = rootKeyLock;
        synchronized (object) {
            PemObject pemObject;
            PemReader reader;
            File file;
            if (!mcServer.refersTo(server)) {
                rootKey = null;
                rootCertificate = null;
                rootCRL = null;
                mcServer = new WeakReference<MinecraftServer>(server);
            }
            PublicKey pk = null;
            if (rootKey == null) {
                file = server.method_27050(ServerContextAccessor.getFolder()).resolve("root.key").toFile();
                if (file.exists()) {
                    try {
                        reader = new PemReader((Reader)new FileReader(file));
                        pemObject = reader.readPemObject();
                        reader.close();
                        PKCS8EncodedKeySpec pk8 = new PKCS8EncodedKeySpec(pemObject.getContent());
                        KeyFactory factory = KeyFactory.getInstance("Ed25519");
                        rootKey = factory.generatePrivate(pk8);
                    }
                    catch (Exception e) {
                        CCSecureBoot.LOG.warn("Failed to read root.key from file: {}", (Object)e.getMessage());
                    }
                } else {
                    CCSecureBoot.LOG.info("Creating secure boot root key");
                    try {
                        KeyPair keypair = KeyPairGenerator.getInstance("Ed25519").generateKeyPair();
                        rootKey = keypair.getPrivate();
                        assert (rootKey.getFormat().equals("PKCS#8"));
                        pk = keypair.getPublic();
                        file.getParentFile().mkdirs();
                        writer = new PemWriter((Writer)new FileWriter(file));
                        writer.writeObject((PemObjectGenerator)new PemObject("PRIVATE KEY", rootKey.getEncoded()));
                        writer.close();
                    }
                    catch (Exception e) {
                        CCSecureBoot.LOG.error("Could not create private key: {}", (Object)e.getMessage());
                    }
                }
            }
            if (rootKey != null && rootCertificate == null) {
                file = server.method_27050(ServerContextAccessor.getFolder()).resolve("certs/root.pem").toFile();
                if (file.exists()) {
                    try {
                        reader = new PemReader((Reader)new FileReader(file));
                        pemObject = reader.readPemObject();
                        reader.close();
                        rootCertificate = CertificateFactory.getInstance("X.509").generateCertificate(new ByteArrayInputStream(pemObject.getContent()));
                    }
                    catch (Exception e) {
                        CCSecureBoot.LOG.warn("Failed to read root.pem from file: {}", (Object)e.getMessage());
                    }
                } else {
                    CCSecureBoot.LOG.info("Creating secure boot root certificate");
                    try {
                        if (pk == null) {
                            KeyPairGenerator generator = KeyPairGenerator.getInstance("Ed25519");
                            PrivateKeyInfo pk8 = PrivateKeyInfo.getInstance((Object)rootKey.getEncoded());
                            generator.initialize(new NamedParameterSpec("Ed25519"), (SecureRandom)new StaticSecureRandom(pk8.getPrivateKey().getOctets()));
                            pk = generator.generateKeyPair().getPublic();
                        }
                        JcaPKCS10CertificationRequestBuilder csrbuilder = new JcaPKCS10CertificationRequestBuilder(new X500Principal("CN=CCSecureBoot Root"), pk);
                        JcaContentSignerBuilder csbuilder = new JcaContentSignerBuilder("Ed25519");
                        ContentSigner signer = csbuilder.build(rootKey);
                        PKCS10CertificationRequest csr = csrbuilder.build(signer);
                        rootCertificate = this.sign(csr, rootKey);
                        file.getParentFile().mkdirs();
                        PemWriter writer2 = new PemWriter((Writer)new FileWriter(file));
                        writer2.writeObject((PemObjectGenerator)new PemObject("CERTIFICATE", rootCertificate.getEncoded()));
                        writer2.close();
                    }
                    catch (Exception e) {
                        CCSecureBoot.LOG.error("Could not create certificate: {}", (Object)e.getMessage());
                    }
                }
            }
        }
        object = rootCRLLock;
        synchronized (object) {
            if (rootCRL == null) {
                File file = server.method_27050(ServerContextAccessor.getFolder()).resolve("certs/revoked.crl").toFile();
                if (file.exists()) {
                    try {
                        PemReader reader = new PemReader((Reader)new FileReader(file));
                        PemObject pemObject = reader.readPemObject();
                        reader.close();
                        rootCRL = new X509CRLHolder(pemObject.getContent());
                    }
                    catch (Exception e) {
                        CCSecureBoot.LOG.warn("Failed to read revoked.crl from file: {}", (Object)e.getMessage());
                        try {
                            X509v2CRLBuilder builder = new X509v2CRLBuilder(new X500Name("CN=CCSecureBoot Root"), new Date(System.currentTimeMillis()));
                            ContentSigner sigGen = new JcaContentSignerBuilder("Ed25519").build(rootKey);
                            rootCRL = builder.build(sigGen);
                        }
                        catch (Exception e1) {
                            CCSecureBoot.LOG.error("Failed to create empty CRL: {}", (Object)e1.getMessage());
                        }
                    }
                } else {
                    try {
                        X509v2CRLBuilder builder = new X509v2CRLBuilder(new X500Name("CN=CCSecureBoot Root"), new Date(System.currentTimeMillis()));
                        ContentSigner sigGen = new JcaContentSignerBuilder("Ed25519").build(rootKey);
                        rootCRL = builder.build(sigGen);
                        writer = new PemWriter((Writer)new FileWriter(file));
                        writer.writeObject((PemObjectGenerator)new PemObject("X509 CRL", rootCRL.getEncoded()));
                        writer.close();
                    }
                    catch (Exception e1) {
                        CCSecureBoot.LOG.error("Failed to create empty CRL: {}", (Object)e1.getMessage());
                    }
                }
            }
        }
    }

    public void shutdown() {
        super.shutdown();
        if (this.mountPath != null) {
            this.computer.unmount(this.mountPath);
        }
    }

    private X509Certificate sign(PKCS10CertificationRequest inputCSR, PrivateKey caPrivate) throws IOException, OperatorCreationException, CertificateException, NoSuchProviderException, NoSuchAlgorithmException, InvalidKeySpecException {
        byte[] serial = new byte[32];
        SecureRandom.getInstanceStrong().nextBytes(serial);
        X509v3CertificateBuilder myCertificateGenerator = new X509v3CertificateBuilder(new X500Name("CN=CCSecureBoot Root"), new BigInteger(serial), new Date(System.currentTimeMillis()), new Date(System.currentTimeMillis() + 946080000000L), inputCSR.getSubject(), inputCSR.getSubjectPublicKeyInfo());
        ContentSigner sigGen = new JcaContentSignerBuilder("Ed25519").build(caPrivate);
        X509CertificateHolder holder = myCertificateGenerator.build(sigGen);
        Certificate eeX509CertificateStructure = holder.toASN1Structure();
        CertificateFactory cf = CertificateFactory.getInstance("X.509");
        ByteArrayInputStream is1 = new ByteArrayInputStream(eeX509CertificateStructure.getEncoded());
        X509Certificate theCert = (X509Certificate)cf.generateCertificate(is1);
        is1.close();
        return theCert;
    }

    private static class StaticSecureRandom
    extends SecureRandom {
        private final byte[] privateKey;

        public StaticSecureRandom(byte[] privateKey) {
            this.privateKey = (byte[])privateKey.clone();
        }

        @Override
        public void nextBytes(byte[] bytes) {
            System.arraycopy(this.privateKey, 2, bytes, 0, this.privateKey.length - 2);
        }
    }
}

