/*
 * Decompiled with CFR 0.152.
 */
package mods.flammpfeil.slashblade;

import com.google.common.base.CaseFormat;
import java.util.List;
import java.util.Objects;
import mods.flammpfeil.slashblade.SlashBladeConfig;
import mods.flammpfeil.slashblade.SlashBladeCreativeGroup;
import mods.flammpfeil.slashblade.ability.EnemyStep;
import mods.flammpfeil.slashblade.ability.Guard;
import mods.flammpfeil.slashblade.ability.KickJump;
import mods.flammpfeil.slashblade.ability.LockOnManager;
import mods.flammpfeil.slashblade.ability.SlayerStyleArts;
import mods.flammpfeil.slashblade.ability.StunManager;
import mods.flammpfeil.slashblade.ability.SummonedSwordArts;
import mods.flammpfeil.slashblade.ability.SuperSlashArts;
import mods.flammpfeil.slashblade.ability.Untouchable;
import mods.flammpfeil.slashblade.advancement.SlashBladeItemPredicate;
import mods.flammpfeil.slashblade.capability.concentrationrank.CapabilityConcentrationRank;
import mods.flammpfeil.slashblade.capability.inputstate.CapabilityInputState;
import mods.flammpfeil.slashblade.capability.mobeffect.CapabilityMobEffect;
import mods.flammpfeil.slashblade.capability.slashblade.CapabilitySlashBlade;
import mods.flammpfeil.slashblade.client.renderer.entity.BladeItemEntityRenderer;
import mods.flammpfeil.slashblade.client.renderer.entity.BladeStandEntityRenderer;
import mods.flammpfeil.slashblade.client.renderer.entity.DriveRenderer;
import mods.flammpfeil.slashblade.client.renderer.entity.JudgementCutRenderer;
import mods.flammpfeil.slashblade.client.renderer.entity.SlashEffectRenderer;
import mods.flammpfeil.slashblade.client.renderer.entity.SummonedSwordRenderer;
import mods.flammpfeil.slashblade.client.renderer.model.BladeModelManager;
import mods.flammpfeil.slashblade.entity.BladeItemEntity;
import mods.flammpfeil.slashblade.entity.BladeStandEntity;
import mods.flammpfeil.slashblade.entity.EntityAbstractSummonedSword;
import mods.flammpfeil.slashblade.entity.EntityBlisteringSwords;
import mods.flammpfeil.slashblade.entity.EntityDrive;
import mods.flammpfeil.slashblade.entity.EntityHeavyRainSwords;
import mods.flammpfeil.slashblade.entity.EntityJudgementCut;
import mods.flammpfeil.slashblade.entity.EntitySlashEffect;
import mods.flammpfeil.slashblade.entity.EntitySpiralSwords;
import mods.flammpfeil.slashblade.entity.EntityStormSwords;
import mods.flammpfeil.slashblade.event.BladeMotionEventBroadcaster;
import mods.flammpfeil.slashblade.event.handler.AllowFlightOverrwrite;
import mods.flammpfeil.slashblade.event.handler.BlockPickCanceller;
import mods.flammpfeil.slashblade.event.handler.CapabilityAttachHandler;
import mods.flammpfeil.slashblade.event.handler.FallHandler;
import mods.flammpfeil.slashblade.event.handler.KillCounter;
import mods.flammpfeil.slashblade.event.handler.KnockBackHandler;
import mods.flammpfeil.slashblade.event.handler.RankPointHandler;
import mods.flammpfeil.slashblade.event.handler.RefineHandler;
import mods.flammpfeil.slashblade.item.BladeStandItem;
import mods.flammpfeil.slashblade.item.ItemProudSoul;
import mods.flammpfeil.slashblade.item.ItemSlashBlade;
import mods.flammpfeil.slashblade.item.ItemSlashBladeDetune;
import mods.flammpfeil.slashblade.item.ItemTierSlashBlade;
import mods.flammpfeil.slashblade.network.NetworkManager;
import mods.flammpfeil.slashblade.recipe.RecipeSerializerRegistry;
import mods.flammpfeil.slashblade.registry.ComboStateRegistry;
import mods.flammpfeil.slashblade.registry.ModAttributes;
import mods.flammpfeil.slashblade.registry.SlashArtsRegistry;
import mods.flammpfeil.slashblade.registry.SpecialEffectsRegistry;
import mods.flammpfeil.slashblade.registry.combo.ComboCommands;
import mods.flammpfeil.slashblade.registry.slashblade.SlashBladeDefinition;
import mods.flammpfeil.slashblade.registry.specialeffects.SpecialEffect;
import mods.flammpfeil.slashblade.slasharts.SlashArts;
import mods.flammpfeil.slashblade.util.TargetSelector;
import net.minecraft.ChatFormatting;
import net.minecraft.advancements.critereon.ItemPredicate;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.Registry;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.stats.StatFormatter;
import net.minecraft.stats.Stats;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.MobCategory;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Rarity;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.event.EntityRenderersEvent;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.capabilities.RegisterCapabilitiesEvent;
import net.minecraftforge.event.entity.EntityAttributeModificationEvent;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.ModLoadingContext;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.config.IConfigSpec;
import net.minecraftforge.fml.config.ModConfig;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.RegisterEvent;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Mod(value="slashblade")
public class SlashBlade {
    public static final String MODID = "slashblade";
    public static final Logger LOGGER = LogManager.getLogger();

    public static ResourceLocation prefix(String path) {
        return new ResourceLocation(MODID, path);
    }

    public SlashBlade() {
        IEventBus modEventBus = FMLJavaModLoadingContext.get().getModEventBus();
        ModLoadingContext.get().registerConfig(ModConfig.Type.COMMON, (IConfigSpec)SlashBladeConfig.COMMON_CONFIG);
        modEventBus.addListener(this::setup);
        MinecraftForge.EVENT_BUS.register((Object)this);
        ModAttributes.ATTRIBUTES.register(modEventBus);
        NetworkManager.register();
        ComboStateRegistry.COMBO_STATE.register(modEventBus);
        SlashArtsRegistry.SLASH_ARTS.register(modEventBus);
        SlashBladeCreativeGroup.CREATIVE_MODE_TABS.register(modEventBus);
        RecipeSerializerRegistry.RECIPE_TYPES.register(modEventBus);
        RecipeSerializerRegistry.RECIPE_SERIALIZER.register(modEventBus);
        SpecialEffectsRegistry.SPECIAL_EFFECT.register(modEventBus);
        ItemPredicate.register((ResourceLocation)SlashBlade.prefix(MODID), SlashBladeItemPredicate::new);
    }

    private void setup(FMLCommonSetupEvent event) {
        MinecraftForge.EVENT_BUS.addListener(KnockBackHandler::onLivingKnockBack);
        FallHandler.getInstance().register();
        LockOnManager.getInstance().register();
        Guard.getInstance().register();
        MinecraftForge.EVENT_BUS.register((Object)new CapabilityAttachHandler());
        MinecraftForge.EVENT_BUS.register((Object)new StunManager());
        RefineHandler.getInstance().register();
        KillCounter.getInstance().register();
        RankPointHandler.getInstance().register();
        AllowFlightOverrwrite.getInstance().register();
        BlockPickCanceller.getInstance().register();
        BladeMotionEventBroadcaster.getInstance().register();
        MinecraftForge.EVENT_BUS.addListener(TargetSelector::onInputChange);
        SummonedSwordArts.getInstance().register();
        SlayerStyleArts.getInstance().register();
        Untouchable.getInstance().register();
        EnemyStep.getInstance().register();
        KickJump.getInstance().register();
        SuperSlashArts.getInstance().register();
        ComboCommands.initDefaultStandByCommands();
    }

    public static Registry<SlashBladeDefinition> getSlashBladeDefinitionRegistry(Level level) {
        if (level.m_5776_()) {
            return BladeModelManager.getClientSlashBladeRegistry();
        }
        return level.m_9598_().m_175515_(SlashBladeDefinition.REGISTRY_KEY);
    }

    public static HolderLookup.RegistryLookup<SlashBladeDefinition> getSlashBladeDefinitionRegistry(HolderLookup.Provider access) {
        return access.m_255025_(SlashBladeDefinition.REGISTRY_KEY);
    }

    @Mod.EventBusSubscriber(bus=Mod.EventBusSubscriber.Bus.MOD)
    public static class RegistryEvents {
        public static final ResourceLocation BladeItemEntityLoc = new ResourceLocation("slashblade", RegistryEvents.classToString(BladeItemEntity.class));
        public static EntityType<BladeItemEntity> BladeItem;
        public static final ResourceLocation BladeStandEntityLoc;
        public static EntityType<BladeStandEntity> BladeStand;
        public static final ResourceLocation SummonedSwordLoc;
        public static EntityType<EntityAbstractSummonedSword> SummonedSword;
        public static final ResourceLocation SpiralSwordsLoc;
        public static EntityType<EntitySpiralSwords> SpiralSwords;
        public static final ResourceLocation StormSwordsLoc;
        public static EntityType<EntityStormSwords> StormSwords;
        public static final ResourceLocation BlisteringSwordsLoc;
        public static EntityType<EntityBlisteringSwords> BlisteringSwords;
        public static final ResourceLocation HeavyRainSwordsLoc;
        public static EntityType<EntityHeavyRainSwords> HeavyRainSwords;
        public static final ResourceLocation JudgementCutLoc;
        public static EntityType<EntityJudgementCut> JudgementCut;
        public static final ResourceLocation SlashEffectLoc;
        public static EntityType<EntitySlashEffect> SlashEffect;
        public static final ResourceLocation DriveLoc;
        public static EntityType<EntityDrive> Drive;
        public static ResourceLocation SWORD_SUMMONED;

        @SubscribeEvent
        public static void register(RegisterEvent event) {
            event.register(ForgeRegistries.Keys.ITEMS, helper -> {
                helper.register(new ResourceLocation(SlashBlade.MODID, "slashblade_wood"), (Object)new ItemSlashBladeDetune(new ItemTierSlashBlade(60, 2.0f), 2, 0.0f, new Item.Properties()).setDestructable().setTexture(SlashBlade.prefix("model/wood.png")));
                helper.register(new ResourceLocation(SlashBlade.MODID, "slashblade_bamboo"), (Object)new ItemSlashBladeDetune(new ItemTierSlashBlade(70, 3.0f), 3, 0.0f, new Item.Properties()).setDestructable().setTexture(SlashBlade.prefix("model/bamboo.png")));
                helper.register(new ResourceLocation(SlashBlade.MODID, "slashblade_silverbamboo"), (Object)new ItemSlashBladeDetune(new ItemTierSlashBlade(40, 3.0f), 3, 0.0f, new Item.Properties()).setTexture(SlashBlade.prefix("model/silverbamboo.png")));
                helper.register(new ResourceLocation(SlashBlade.MODID, "slashblade_white"), (Object)new ItemSlashBladeDetune(new ItemTierSlashBlade(70, 4.0f), 4, 0.0f, new Item.Properties()).setTexture(SlashBlade.prefix("model/white.png")));
                helper.register(new ResourceLocation(SlashBlade.MODID, SlashBlade.MODID), (Object)new ItemSlashBlade(new ItemTierSlashBlade(40, 4.0f), 4, 0.0f, new Item.Properties()));
                helper.register(new ResourceLocation(SlashBlade.MODID, "proudsoul"), (Object)new ItemProudSoul(new Item.Properties()){

                    public int getEnchantmentValue(ItemStack stack) {
                        return 50;
                    }
                });
                helper.register(new ResourceLocation(SlashBlade.MODID, "proudsoul_ingot"), (Object)new ItemProudSoul(new Item.Properties()){

                    public int getEnchantmentValue(ItemStack stack) {
                        return 100;
                    }
                });
                helper.register(new ResourceLocation(SlashBlade.MODID, "proudsoul_tiny"), (Object)new ItemProudSoul(new Item.Properties()){

                    public int getEnchantmentValue(ItemStack stack) {
                        return 10;
                    }
                });
                helper.register(new ResourceLocation(SlashBlade.MODID, "proudsoul_sphere"), (Object)new ItemProudSoul(new Item.Properties().m_41497_(Rarity.UNCOMMON)){

                    public int getEnchantmentValue(ItemStack stack) {
                        return 150;
                    }

                    public void m_7373_(@NotNull ItemStack stack, @Nullable Level level, @NotNull List<Component> components, @NotNull TooltipFlag flag) {
                        CompoundTag tag;
                        if (stack.m_41783_() != null && (tag = stack.m_41783_()).m_128441_("SpecialAttackType")) {
                            ResourceLocation SA = new ResourceLocation(tag.m_128461_("SpecialAttackType"));
                            if (SlashArtsRegistry.REGISTRY.get().containsKey(SA) && !Objects.equals(SlashArtsRegistry.REGISTRY.get().getValue(SA), SlashArtsRegistry.NONE.get())) {
                                components.add((Component)Component.m_237110_((String)"slashblade.tooltip.slash_art", (Object[])new Object[]{Objects.requireNonNull((SlashArts)SlashArtsRegistry.REGISTRY.get().getValue(SA)).getDescription()}).m_130940_(ChatFormatting.GRAY));
                            }
                        }
                        super.m_7373_(stack, level, components, flag);
                    }
                });
                helper.register(new ResourceLocation(SlashBlade.MODID, "proudsoul_crystal"), (Object)new ItemProudSoul(new Item.Properties().m_41497_(Rarity.RARE)){

                    public int getEnchantmentValue(ItemStack stack) {
                        return 200;
                    }

                    @OnlyIn(value=Dist.CLIENT)
                    public void m_7373_(@NotNull ItemStack stack, @Nullable Level level, @NotNull List<Component> components, @NotNull TooltipFlag flag) {
                        CompoundTag tag;
                        if (stack.m_41783_() != null && (tag = stack.m_41783_()).m_128441_("SpecialEffectType")) {
                            Minecraft mcinstance = Minecraft.m_91087_();
                            LocalPlayer player = mcinstance.f_91074_;
                            ResourceLocation se = new ResourceLocation(tag.m_128461_("SpecialEffectType"));
                            if (SpecialEffectsRegistry.REGISTRY.get().containsKey(se) && player != null) {
                                components.add((Component)Component.m_237110_((String)"slashblade.tooltip.special_effect", (Object[])new Object[]{SpecialEffect.getDescription(se), Component.m_237113_((String)String.valueOf(SpecialEffect.getRequestLevel(se))).m_130940_(SpecialEffect.isEffective(se, player.f_36078_) ? ChatFormatting.RED : ChatFormatting.DARK_GRAY)}).m_130940_(ChatFormatting.GRAY));
                            }
                        }
                        super.m_7373_(stack, level, components, flag);
                    }
                });
                helper.register(new ResourceLocation(SlashBlade.MODID, "proudsoul_trapezohedron"), (Object)new ItemProudSoul(new Item.Properties().m_41497_(Rarity.EPIC)){

                    public int getEnchantmentValue(ItemStack stack) {
                        return (Integer)SlashBladeConfig.TRAPEZOHEDRON_MAX_REFINE.get();
                    }
                });
                helper.register(new ResourceLocation(SlashBlade.MODID, "bladestand_1"), (Object)new BladeStandItem(new Item.Properties().m_41497_(Rarity.COMMON)));
                helper.register(new ResourceLocation(SlashBlade.MODID, "bladestand_2"), (Object)new BladeStandItem(new Item.Properties().m_41497_(Rarity.COMMON)));
                helper.register(new ResourceLocation(SlashBlade.MODID, "bladestand_v"), (Object)new BladeStandItem(new Item.Properties().m_41497_(Rarity.COMMON)));
                helper.register(new ResourceLocation(SlashBlade.MODID, "bladestand_s"), (Object)new BladeStandItem(new Item.Properties().m_41497_(Rarity.COMMON)));
                helper.register(new ResourceLocation(SlashBlade.MODID, "bladestand_1w"), (Object)new BladeStandItem(new Item.Properties().m_41497_(Rarity.COMMON), true));
                helper.register(new ResourceLocation(SlashBlade.MODID, "bladestand_2w"), (Object)new BladeStandItem(new Item.Properties().m_41497_(Rarity.COMMON), true));
            });
            event.register(ForgeRegistries.Keys.ENTITY_TYPES, helper -> {
                EntityType entity = SummonedSword = EntityType.Builder.m_20704_(EntityAbstractSummonedSword::new, (MobCategory)MobCategory.MISC).m_20699_(0.5f, 0.5f).setTrackingRange(4).setUpdateInterval(20).setCustomClientFactory(EntityAbstractSummonedSword::createInstance).m_20712_(SummonedSwordLoc.toString());
                helper.register(SummonedSwordLoc, (Object)entity);
                entity = StormSwords = EntityType.Builder.m_20704_(EntityStormSwords::new, (MobCategory)MobCategory.MISC).m_20699_(0.5f, 0.5f).setTrackingRange(4).setUpdateInterval(20).setCustomClientFactory(EntityStormSwords::createInstance).m_20712_(StormSwordsLoc.toString());
                helper.register(StormSwordsLoc, (Object)entity);
                entity = SpiralSwords = EntityType.Builder.m_20704_(EntitySpiralSwords::new, (MobCategory)MobCategory.MISC).m_20699_(0.5f, 0.5f).setTrackingRange(4).setUpdateInterval(20).setCustomClientFactory(EntitySpiralSwords::createInstance).m_20712_(SpiralSwordsLoc.toString());
                helper.register(SpiralSwordsLoc, (Object)entity);
                entity = BlisteringSwords = EntityType.Builder.m_20704_(EntityBlisteringSwords::new, (MobCategory)MobCategory.MISC).m_20699_(0.5f, 0.5f).setTrackingRange(4).setUpdateInterval(20).setCustomClientFactory(EntityBlisteringSwords::createInstance).m_20712_(BlisteringSwordsLoc.toString());
                helper.register(BlisteringSwordsLoc, (Object)entity);
                entity = HeavyRainSwords = EntityType.Builder.m_20704_(EntityHeavyRainSwords::new, (MobCategory)MobCategory.MISC).m_20699_(0.5f, 0.5f).setTrackingRange(4).setUpdateInterval(20).setCustomClientFactory(EntityHeavyRainSwords::createInstance).m_20712_(HeavyRainSwordsLoc.toString());
                helper.register(HeavyRainSwordsLoc, (Object)entity);
                entity = JudgementCut = EntityType.Builder.m_20704_(EntityJudgementCut::new, (MobCategory)MobCategory.MISC).m_20699_(2.5f, 2.5f).setTrackingRange(4).setUpdateInterval(20).setCustomClientFactory(EntityJudgementCut::createInstance).m_20712_(JudgementCutLoc.toString());
                helper.register(JudgementCutLoc, (Object)entity);
                entity = BladeItem = EntityType.Builder.m_20704_(BladeItemEntity::new, (MobCategory)MobCategory.MISC).m_20699_(0.25f, 0.25f).setTrackingRange(4).setUpdateInterval(20).setCustomClientFactory(BladeItemEntity::createInstanceFromPacket).m_20712_(BladeItemEntityLoc.toString());
                helper.register(BladeItemEntityLoc, (Object)entity);
                entity = BladeStand = EntityType.Builder.m_20704_(BladeStandEntity::new, (MobCategory)MobCategory.MISC).m_20699_(0.5f, 0.5f).setTrackingRange(10).setUpdateInterval(20).setShouldReceiveVelocityUpdates(false).setCustomClientFactory(BladeStandEntity::createInstance).m_20712_(BladeStandEntityLoc.toString());
                helper.register(BladeStandEntityLoc, (Object)entity);
                entity = SlashEffect = EntityType.Builder.m_20704_(EntitySlashEffect::new, (MobCategory)MobCategory.MISC).m_20699_(3.0f, 3.0f).setTrackingRange(4).setUpdateInterval(20).setCustomClientFactory(EntitySlashEffect::createInstance).m_20712_(SlashEffectLoc.toString());
                helper.register(SlashEffectLoc, (Object)entity);
                entity = Drive = EntityType.Builder.m_20704_(EntityDrive::new, (MobCategory)MobCategory.MISC).m_20699_(3.0f, 3.0f).setTrackingRange(4).setUpdateInterval(20).setCustomClientFactory(EntityDrive::createInstance).m_20712_(DriveLoc.toString());
                helper.register(DriveLoc, (Object)entity);
            });
            event.register(ForgeRegistries.Keys.STAT_TYPES, helper -> {
                SWORD_SUMMONED = RegistryEvents.registerCustomStat("sword_summoned");
            });
        }

        private static String classToString(Class<? extends Entity> entityClass) {
            return CaseFormat.UPPER_CAMEL.to(CaseFormat.LOWER_UNDERSCORE, entityClass.getSimpleName()).replace("entity_", "");
        }

        @SubscribeEvent
        public static void onRegisterRenderers(EntityRenderersEvent.RegisterRenderers event) {
            event.registerEntityRenderer(SummonedSword, SummonedSwordRenderer::new);
            event.registerEntityRenderer(StormSwords, SummonedSwordRenderer::new);
            event.registerEntityRenderer(SpiralSwords, SummonedSwordRenderer::new);
            event.registerEntityRenderer(BlisteringSwords, SummonedSwordRenderer::new);
            event.registerEntityRenderer(HeavyRainSwords, SummonedSwordRenderer::new);
            event.registerEntityRenderer(JudgementCut, JudgementCutRenderer::new);
            event.registerEntityRenderer(BladeItem, BladeItemEntityRenderer::new);
            event.registerEntityRenderer(BladeStand, BladeStandEntityRenderer::new);
            event.registerEntityRenderer(SlashEffect, SlashEffectRenderer::new);
            event.registerEntityRenderer(Drive, DriveRenderer::new);
        }

        @SubscribeEvent
        public static void onRegisterCapability(RegisterCapabilitiesEvent event) {
            CapabilitySlashBlade.register(event);
            CapabilityMobEffect.register(event);
            CapabilityInputState.register(event);
            CapabilityConcentrationRank.register(event);
        }

        @SubscribeEvent
        public static void onEntityAttributeModificationEvent(EntityAttributeModificationEvent event) {
            event.add(EntityType.f_20532_, (Attribute)ModAttributes.SLASHBLADE_DAMAGE.get());
        }

        private static ResourceLocation registerCustomStat(String name) {
            ResourceLocation resourcelocation = new ResourceLocation(SlashBlade.MODID, name);
            Registry.m_122961_((Registry)BuiltInRegistries.f_256771_, (String)name, (Object)resourcelocation);
            Stats.f_12988_.m_12899_((Object)resourcelocation, StatFormatter.f_12873_);
            return resourcelocation;
        }

        static {
            BladeStandEntityLoc = new ResourceLocation(SlashBlade.MODID, RegistryEvents.classToString(BladeStandEntity.class));
            SummonedSwordLoc = new ResourceLocation(SlashBlade.MODID, RegistryEvents.classToString(EntityAbstractSummonedSword.class));
            SpiralSwordsLoc = new ResourceLocation(SlashBlade.MODID, RegistryEvents.classToString(EntitySpiralSwords.class));
            StormSwordsLoc = new ResourceLocation(SlashBlade.MODID, RegistryEvents.classToString(EntityStormSwords.class));
            BlisteringSwordsLoc = new ResourceLocation(SlashBlade.MODID, RegistryEvents.classToString(EntityBlisteringSwords.class));
            HeavyRainSwordsLoc = new ResourceLocation(SlashBlade.MODID, RegistryEvents.classToString(EntityHeavyRainSwords.class));
            JudgementCutLoc = new ResourceLocation(SlashBlade.MODID, RegistryEvents.classToString(EntityJudgementCut.class));
            SlashEffectLoc = new ResourceLocation(SlashBlade.MODID, RegistryEvents.classToString(EntitySlashEffect.class));
            DriveLoc = new ResourceLocation(SlashBlade.MODID, RegistryEvents.classToString(EntityDrive.class));
        }
    }
}

