/*
 * Decompiled with CFR 0.152.
 */
package mods.flammpfeil.slashblade.capability.mobeffect;

import java.util.Collection;
import java.util.Optional;
import java.util.Set;
import net.minecraft.world.effect.MobEffect;

public interface IMobEffectState {
    public static final int AVOID_MAX = 3;
    public static final int COOLDOWN_TICKS = 20;

    default public void setManagedStun(long now, long duration) {
        if (duration <= 0L) {
            return;
        }
        long solvedDuration = Math.min(duration, (long)this.getStunLimit());
        long timeout = now + solvedDuration;
        if (this.getStunTimeOut() < timeout) {
            this.setStunTimeOut(timeout);
        }
    }

    public void setStunTimeOut(long var1);

    default public void clearStunTimeOut() {
        this.setStunTimeOut(-1L);
    }

    public long getStunTimeOut();

    default public boolean isStun(long now) {
        return this.isStun(now, false);
    }

    default public boolean isStun(long now, boolean isVirtual) {
        long timeout = this.getStunTimeOut();
        if (timeout <= 0L) {
            return false;
        }
        if ((timeout -= now) <= 0L || (long)this.getStunLimit() < timeout) {
            if (!isVirtual) {
                this.clearStunTimeOut();
            }
            return false;
        }
        return true;
    }

    public int getStunLimit();

    public void setStunLimit(int var1);

    public int getUntouchableLimit();

    public void setUntouchableLimit(int var1);

    default public void setManagedUntouchable(long now, long duration) {
        if (duration <= 0L) {
            return;
        }
        long solvedDuration = Math.min(duration, (long)this.getUntouchableLimit());
        long timeout = now + solvedDuration;
        if (this.getUntouchableTimeOut().isEmpty() || this.getUntouchableTimeOut().get() < timeout) {
            this.setUntouchableTimeOut(Optional.of(timeout));
        }
    }

    public void setUntouchableTimeOut(Optional<Long> var1);

    default public void clearUntouchableTimeOut(boolean isVirtual) {
        if (!isVirtual) {
            this.setUntouchableTimeOut(Optional.empty());
        }
    }

    public Optional<Long> getUntouchableTimeOut();

    default public boolean isUntouchable(long now) {
        return this.isUntouchable(now, false);
    }

    default public boolean isUntouchable(long now, boolean isVirtual) {
        return this.getUntouchableTimeOut().filter(timeout -> now < timeout).map(t -> {
            this.setUntouchableWorked();
            return true;
        }).orElseGet(() -> {
            this.clearUntouchableTimeOut(isVirtual);
            return false;
        });
    }

    public Set<MobEffect> getEffectSet();

    default public void storeEffects(Collection<MobEffect> effects) {
        this.getEffectSet().clear();
        this.getEffectSet().addAll(effects);
    }

    public boolean hasUntouchableWorked();

    public void setUntouchableWorked(boolean var1);

    default public void setUntouchableWorked() {
        this.setUntouchableWorked(true);
    }

    public float getStoredHealth();

    public void storeHealth(float var1);

    public Optional<Long> getAvoidCooldown();

    public int getAvoidCount();

    public void setAvoidCooldown(Optional<Long> var1);

    public void setAvoidCount(int var1);

    default public boolean checkCanAvoid(long now) {
        if (this.getAvoidCount() < 3) {
            return true;
        }
        return this.getAvoidCooldown().filter(ct -> now < ct).isEmpty();
    }

    default public int doAvoid(long now) {
        if (!this.checkCanAvoid(now)) {
            return 0;
        }
        return this.getAvoidCooldown().filter(ct -> now < ct).map(ct -> {
            int count = this.getAvoidCount() + 1;
            this.setAvoidCount(count);
            return count;
        }).orElseGet(() -> {
            this.setAvoidCount(1);
            this.setAvoidCooldown(Optional.of(now + 20L));
            return 1;
        });
    }
}

