/*
 * Decompiled with CFR 0.152.
 */
package mods.flammpfeil.slashblade.client.renderer;

import com.mojang.blaze3d.vertex.PoseStack;
import java.awt.Color;
import java.util.Optional;
import mods.flammpfeil.slashblade.capability.inputstate.CapabilityInputState;
import mods.flammpfeil.slashblade.capability.slashblade.ISlashBladeState;
import mods.flammpfeil.slashblade.client.renderer.model.BladeModelManager;
import mods.flammpfeil.slashblade.client.renderer.model.obj.WavefrontObject;
import mods.flammpfeil.slashblade.client.renderer.util.BladeRenderState;
import mods.flammpfeil.slashblade.item.ItemSlashBlade;
import mods.flammpfeil.slashblade.util.InputCommand;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.entity.LivingEntityRenderer;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.client.event.RenderLivingEvent;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.eventbus.api.SubscribeEvent;

public class LockonCircleRender {
    static final ResourceLocation modelLoc = new ResourceLocation("slashblade", "model/util/lockon.obj");
    static final ResourceLocation textureLoc = new ResourceLocation("slashblade", "model/util/lockon.png");

    public static LockonCircleRender getInstance() {
        return SingletonHolder.instance;
    }

    private LockonCircleRender() {
    }

    public void register() {
        MinecraftForge.EVENT_BUS.register((Object)this);
    }

    @SubscribeEvent
    public void onRenderLiving(RenderLivingEvent<?, ?> event) {
        Minecraft minecraftInstance = Minecraft.m_91087_();
        LocalPlayer player = minecraftInstance.f_91074_;
        if (player == null) {
            return;
        }
        if (player.getCapability(CapabilityInputState.INPUT_STATE).filter(input -> input.getCommands().contains((Object)InputCommand.SNEAK)).isEmpty()) {
            return;
        }
        ItemStack stack = player.m_21205_();
        Level level = player.m_9236_();
        Optional<Color> effectColor = stack.getCapability(ItemSlashBlade.BLADESTATE).filter(s -> event.getEntity().equals((Object)s.getTargetEntity(level))).map(ISlashBladeState::getEffectColor);
        if (effectColor.isEmpty()) {
            return;
        }
        LivingEntityRenderer renderer = event.getRenderer();
        LivingEntity livingEntity = event.getEntity();
        if (!livingEntity.m_6084_()) {
            return;
        }
        float health = livingEntity.m_21223_() / livingEntity.m_21233_();
        Color col = new Color(effectColor.get().getRGB() & 0xFFFFFF | 0xAA000000, true);
        PoseStack poseStack = event.getPoseStack();
        float f = livingEntity.m_20206_() * 0.5f;
        float partialTicks = event.getPartialTick();
        poseStack.m_85836_();
        poseStack.m_85837_(0.0, (double)f, 0.0);
        Vec3 offset = renderer.f_114476_.f_114358_.m_90583_().m_82546_(livingEntity.m_20318_(partialTicks).m_82520_(0.0, (double)f, 0.0));
        offset = offset.m_82490_(0.5);
        poseStack.m_85837_(offset.m_7096_(), offset.m_7098_(), offset.m_7094_());
        poseStack.m_252781_(renderer.f_114476_.m_253208_());
        float scale = 0.0025f;
        poseStack.m_85841_(scale, -scale, scale);
        WavefrontObject model = BladeModelManager.getInstance().getModel(modelLoc);
        ResourceLocation resourceTexture = textureLoc;
        MultiBufferSource buffer = event.getMultiBufferSource();
        String base = "lockonBase";
        String mask = "lockonHealthMask";
        String value = "lockonHealth";
        BladeRenderState.setCol(col);
        BladeRenderState.renderOverridedLuminous(ItemStack.f_41583_, model, "lockonBase", resourceTexture, poseStack, buffer, 0xF000E0);
        poseStack.m_85836_();
        poseStack.m_252880_(0.0f, 0.0f, health * 10.0f);
        BladeRenderState.setCol(new Color(0x20000000, true));
        BladeRenderState.renderOverridedLuminousDepthWrite(ItemStack.f_41583_, model, "lockonHealthMask", resourceTexture, poseStack, buffer, 0xF000E0);
        poseStack.m_85849_();
        BladeRenderState.setCol(col);
        BladeRenderState.renderOverridedLuminousDepthWrite(ItemStack.f_41583_, model, "lockonHealth", resourceTexture, poseStack, buffer, 0xF000E0);
        poseStack.m_85849_();
    }

    private static final class SingletonHolder {
        private static final LockonCircleRender instance = new LockonCircleRender();

        private SingletonHolder() {
        }
    }
}

