/*
 * Decompiled with CFR 0.152.
 */
package mods.flammpfeil.slashblade.compat.jei;

import mezz.jei.api.gui.builder.IIngredientAcceptor;
import mezz.jei.api.recipe.category.extensions.vanilla.smithing.ISmithingCategoryExtension;
import mods.flammpfeil.slashblade.recipe.SlashBladeSmithingRecipe;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.core.RegistryAccess;
import net.minecraft.world.Container;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import org.jetbrains.annotations.NotNull;

public class SlashBladeSmithingCategoryExtension
implements ISmithingCategoryExtension<SlashBladeSmithingRecipe> {
    public <T extends IIngredientAcceptor<T>> void setTemplate(SlashBladeSmithingRecipe recipe, T ingredientAcceptor) {
        Ingredient ingredient = recipe.getTemplate();
        ingredientAcceptor.addIngredients(ingredient);
    }

    public <T extends IIngredientAcceptor<T>> void setBase(SlashBladeSmithingRecipe recipe, T ingredientAcceptor) {
        Ingredient ingredient = recipe.getBase();
        ingredientAcceptor.addIngredients(ingredient);
    }

    public <T extends IIngredientAcceptor<T>> void setAddition(SlashBladeSmithingRecipe recipe, T ingredientAcceptor) {
        Ingredient ingredient = recipe.getAddition();
        ingredientAcceptor.addIngredients(ingredient);
    }

    public <T extends IIngredientAcceptor<T>> void setOutput(SlashBladeSmithingRecipe recipe, @NotNull T ingredientAcceptor) {
        Ingredient templateIngredient = recipe.getTemplate();
        Ingredient baseIngredient = recipe.getBase();
        Ingredient additionIngredient = recipe.getAddition();
        ItemStack[] additions = additionIngredient.m_43908_();
        if (additions.length == 0) {
            return;
        }
        ItemStack addition = additions[0];
        for (ItemStack template : templateIngredient.m_43908_()) {
            for (ItemStack base : baseIngredient.m_43908_()) {
                Container recipeInput = SlashBladeSmithingCategoryExtension.createInput(template, base, addition);
                ItemStack output = SlashBladeSmithingCategoryExtension.assembleResultItem(recipeInput, recipe);
                ingredientAcceptor.addItemStack(output);
            }
        }
    }

    private static <I extends Container> ItemStack assembleResultItem(I input, Recipe<I> recipe) {
        Minecraft minecraft = Minecraft.m_91087_();
        ClientLevel level = minecraft.f_91073_;
        if (level == null) {
            throw new NullPointerException("level must not be null.");
        }
        RegistryAccess registryAccess = level.m_9598_();
        return recipe.m_5874_(input, registryAccess);
    }

    private static Container createInput(ItemStack template, ItemStack base, ItemStack addition) {
        SimpleContainer container = new SimpleContainer(3);
        container.m_6836_(0, template);
        container.m_6836_(1, base);
        container.m_6836_(2, addition);
        return container;
    }
}

