/*
 * Decompiled with CFR 0.152.
 */
package mods.flammpfeil.slashblade.entity;

import java.util.EnumSet;
import java.util.List;
import javax.annotation.Nullable;
import mods.flammpfeil.slashblade.SlashBlade;
import mods.flammpfeil.slashblade.entity.EntitySlashEffect;
import mods.flammpfeil.slashblade.entity.IShootable;
import mods.flammpfeil.slashblade.entity.Projectile;
import mods.flammpfeil.slashblade.util.AttackManager;
import mods.flammpfeil.slashblade.util.EnumSetConverter;
import mods.flammpfeil.slashblade.util.KnockBacks;
import mods.flammpfeil.slashblade.util.NBTHelper;
import mods.flammpfeil.slashblade.util.TargetSelector;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.projectile.ProjectileUtil;
import net.minecraft.world.item.alchemy.PotionUtils;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.network.NetworkHooks;
import net.minecraftforge.network.PlayMessages;
import org.jetbrains.annotations.NotNull;

public class EntityJudgementCut
extends Projectile
implements IShootable {
    private static final EntityDataAccessor<Integer> COLOR = SynchedEntityData.m_135353_(EntityJudgementCut.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final EntityDataAccessor<Integer> FLAGS = SynchedEntityData.m_135353_(EntityJudgementCut.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final EntityDataAccessor<Float> RANK = SynchedEntityData.m_135353_(EntityJudgementCut.class, (EntityDataSerializer)EntityDataSerializers.f_135029_);
    private int lifetime = 10;
    private final int seed;
    private double damage = 1.0;
    private boolean cycleHit = false;
    private final SoundEvent livingEntitySound = SoundEvents.f_12557_;
    EnumSet<FlagsState> flags = EnumSet.noneOf(FlagsState.class);
    int intFlags = 0;

    public int getSeed() {
        return this.seed;
    }

    public boolean doCycleHit() {
        return this.cycleHit;
    }

    public void setCycleHit(boolean cycleHit) {
        this.cycleHit = cycleHit;
    }

    protected SoundEvent getHitEntitySound() {
        return this.livingEntitySound;
    }

    public EntityJudgementCut(EntityType<? extends Projectile> entityTypeIn, Level worldIn) {
        super(entityTypeIn, worldIn);
        this.m_20242_(true);
        this.seed = this.f_19796_.m_188503_(360);
    }

    public static EntityJudgementCut createInstance(PlayMessages.SpawnEntity packet, Level worldIn) {
        return new EntityJudgementCut((EntityType<? extends Projectile>)SlashBlade.RegistryEvents.JudgementCut, worldIn);
    }

    @Override
    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(COLOR, (Object)0x3333FF);
        this.f_19804_.m_135372_(FLAGS, (Object)0);
        this.f_19804_.m_135372_(RANK, (Object)Float.valueOf(0.0f));
    }

    protected void m_7380_(@NotNull CompoundTag compound) {
        super.m_7380_(compound);
        NBTHelper.getNBTCoupler(compound).put("Color", this.getColor()).put("Rank", Float.valueOf(this.getRank())).put("damage", this.damage).put("crit", this.getIsCritical()).put("clip", this.isNoClip()).put("Lifetime", this.getLifetime());
    }

    protected void m_7378_(@NotNull CompoundTag compound) {
        super.m_7378_(compound);
        NBTHelper.getNBTCoupler(compound).get("Color", this::setColor, new Integer[0]).get("Rank", this::setRank, new Float[0]).get("damage", v -> {
            this.damage = v;
        }, this.damage).get("crit", this::setIsCritical, new Boolean[0]).get("clip", this::setNoClip, new Boolean[0]).get("Lifetime", this::setLifetime, new Integer[0]);
    }

    @NotNull
    public Packet<ClientGamePacketListener> m_5654_() {
        return NetworkHooks.getEntitySpawningPacket((Entity)this);
    }

    @Override
    public void m_6686_(double x, double y, double z, float velocity, float inaccuracy) {
        this.m_20334_(0.0, 0.0, 0.0);
    }

    @OnlyIn(value=Dist.CLIENT)
    public boolean m_6783_(double distance) {
        double d0 = this.m_20191_().m_82309_() * 10.0;
        if (Double.isNaN(d0)) {
            d0 = 1.0;
        }
        return distance < (d0 = d0 * 64.0 * EntityJudgementCut.m_20150_()) * d0;
    }

    @OnlyIn(value=Dist.CLIENT)
    public void m_6453_(double x, double y, double z, float yaw, float pitch, int posRotationIncrements, boolean teleport) {
        this.m_6034_(x, y, z);
        this.m_19915_(yaw, pitch);
    }

    @OnlyIn(value=Dist.CLIENT)
    public void m_6001_(double x, double y, double z) {
        this.m_20334_(0.0, 0.0, 0.0);
    }

    private void setFlags(FlagsState value) {
        this.flags.add(value);
        this.refreshFlags();
    }

    private void removeFlags(FlagsState value) {
        this.flags.remove((Object)value);
        this.refreshFlags();
    }

    private void refreshFlags() {
        if (this.m_9236_().m_5776_()) {
            int newValue = (Integer)this.f_19804_.m_135370_(FLAGS);
            if (this.intFlags != newValue) {
                this.intFlags = newValue;
                this.flags = EnumSetConverter.convertToEnumSet(FlagsState.class, this.intFlags);
            }
        } else {
            int newValue = EnumSetConverter.convertToInt(this.flags);
            if (this.intFlags != newValue) {
                this.f_19804_.m_135381_(FLAGS, (Object)newValue);
                this.intFlags = newValue;
            }
        }
    }

    public void setIsCritical(boolean value) {
        if (value) {
            this.setFlags(FlagsState.Critical);
        } else {
            this.removeFlags(FlagsState.Critical);
        }
    }

    public boolean getIsCritical() {
        this.refreshFlags();
        return this.flags.contains((Object)FlagsState.Critical);
    }

    public void setNoClip(boolean value) {
        this.f_19794_ = value;
        if (value) {
            this.setFlags(FlagsState.NoClip);
        } else {
            this.removeFlags(FlagsState.NoClip);
        }
    }

    public boolean isNoClip() {
        if (!this.m_9236_().m_5776_()) {
            return this.f_19794_;
        }
        this.refreshFlags();
        return this.flags.contains((Object)FlagsState.NoClip);
    }

    public void m_8119_() {
        super.m_8119_();
        if (this.f_19797_ < 8 && this.f_19797_ % 2 == 0) {
            this.m_5496_(this.getHitEntitySound(), 0.2f, 0.5f + 0.25f * this.f_19796_.m_188501_());
        }
        if (this.getShooter() != null) {
            if (this.f_19797_ % 2 == 0) {
                KnockBacks knockBackType = this.getIsCritical() ? KnockBacks.toss : KnockBacks.cancel;
                AttackManager.areaAttack(this, knockBackType.action, 4.0, true, false, 0.16f, null);
            }
            int count = 3;
            if (this.getIsCritical() && 0 < this.f_19797_ && this.f_19797_ <= 3) {
                EntitySlashEffect jc = new EntitySlashEffect((EntityType<? extends Projectile>)SlashBlade.RegistryEvents.SlashEffect, this.m_9236_());
                jc.m_19890_(this.m_20185_(), this.m_20186_(), this.m_20189_(), 120.0f * (float)this.f_19797_ + (float)this.seed, 0.0f);
                jc.setRotationRoll(30.0f);
                jc.m_5602_(this.getShooter());
                jc.setMute(false);
                jc.setIsCritical(true);
                jc.setDamage(0.1f);
                jc.setColor(this.getColor());
                jc.setBaseSize(0.5f);
                jc.setKnockBack(KnockBacks.cancel);
                jc.setIndirect(true);
                jc.setRank(this.getRank());
                this.m_9236_().m_7967_((Entity)jc);
            }
        }
        this.tryDespawn();
    }

    protected void tryDespawn() {
        if (!this.m_9236_().m_5776_() && this.getLifetime() < this.f_19797_) {
            this.burst();
        }
    }

    public int getColor() {
        return (Integer)this.m_20088_().m_135370_(COLOR);
    }

    public void setColor(int value) {
        this.m_20088_().m_135381_(COLOR, (Object)value);
    }

    public float getRank() {
        return ((Float)this.m_20088_().m_135370_(RANK)).floatValue();
    }

    public void setRank(float value) {
        this.m_20088_().m_135381_(RANK, (Object)Float.valueOf(value));
    }

    public int getLifetime() {
        return Math.min(this.lifetime, 1000);
    }

    public void setLifetime(int value) {
        this.lifetime = value;
    }

    @Override
    @Nullable
    public Entity getShooter() {
        return this.m_19749_();
    }

    @Override
    public void setShooter(Entity shooter) {
        this.m_5602_(shooter);
    }

    public List<MobEffectInstance> getPotionEffects() {
        List effects = PotionUtils.m_43566_((CompoundTag)this.getPersistentData());
        if (effects.isEmpty()) {
            effects.add(new MobEffectInstance(MobEffects.f_19614_, 1, 1));
        }
        return effects;
    }

    public void burst() {
        if (!this.m_9236_().m_5776_()) {
            if (this.m_9236_() instanceof ServerLevel) {
                ((ServerLevel)this.m_9236_()).m_8767_((ParticleOptions)ParticleTypes.f_123797_, this.m_20185_(), this.m_20186_(), this.m_20189_(), 16, 0.5, 0.5, 0.5, 0.25);
            }
            this.burst(this.getPotionEffects(), null);
        }
        super.m_142687_(Entity.RemovalReason.DISCARDED);
    }

    public void burst(List<MobEffectInstance> effects, @Nullable Entity focusEntity) {
        List<Entity> list = TargetSelector.getTargettableEntitiesWithinAABB(this.m_9236_(), 2.0, this);
        list.stream().filter(e -> e instanceof LivingEntity).map(e -> (LivingEntity)e).forEach(e -> {
            double distanceSq = this.m_20280_((Entity)e);
            if (distanceSq < 9.0) {
                double factor = 1.0 - Math.sqrt(distanceSq) / 4.0;
                if (e == focusEntity) {
                    factor = 1.0;
                }
                this.affectEntity((LivingEntity)e, effects, factor);
            }
        });
    }

    public void affectEntity(LivingEntity focusEntity, List<MobEffectInstance> effects, double factor) {
        for (MobEffectInstance effectinstance : this.getPotionEffects()) {
            MobEffect effect = effectinstance.m_19544_();
            if (effect.m_8093_()) {
                effect.m_19461_((Entity)this, this.getShooter(), focusEntity, effectinstance.m_19564_(), factor);
                continue;
            }
            int duration = (int)(factor * (double)effectinstance.m_19557_() + 0.5);
            if (duration <= 0) continue;
            focusEntity.m_7292_(new MobEffectInstance(effect, duration, effectinstance.m_19564_(), effectinstance.m_19571_(), effectinstance.m_19572_()));
        }
    }

    public void setDamage(double damageIn) {
        this.damage = damageIn;
    }

    @Override
    public double getDamage() {
        return this.damage;
    }

    @Nullable
    public EntityHitResult getRayTrace(Vec3 p_213866_1_, Vec3 p_213866_2_) {
        return ProjectileUtil.m_37304_((Level)this.m_9236_(), (Entity)this, (Vec3)p_213866_1_, (Vec3)p_213866_2_, (AABB)this.m_20191_().m_82369_(this.m_20184_()).m_82400_(1.0), p_213871_1_ -> !p_213871_1_.m_5833_() && p_213871_1_.m_6084_() && p_213871_1_.m_6087_() && p_213871_1_ != this.getShooter());
    }

    static enum FlagsState {
        Critical,
        NoClip;

    }
}

