/*
 * Decompiled with CFR 0.152.
 */
package mods.flammpfeil.slashblade.event.bladestand;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import mods.flammpfeil.slashblade.SlashBlade;
import mods.flammpfeil.slashblade.capability.slashblade.ISlashBladeState;
import mods.flammpfeil.slashblade.data.builtin.SlashBladeBuiltInRegistry;
import mods.flammpfeil.slashblade.data.tag.SlashBladeItemTags;
import mods.flammpfeil.slashblade.entity.BladeStandEntity;
import mods.flammpfeil.slashblade.event.SlashBladeEvent;
import mods.flammpfeil.slashblade.event.bladestand.BladeChangeSpecialAttackEvent;
import mods.flammpfeil.slashblade.event.bladestand.BladeChangeSpecialEffectEvent;
import mods.flammpfeil.slashblade.event.bladestand.CopySpecialAttackFromBladeEvent;
import mods.flammpfeil.slashblade.event.bladestand.CopySpecialEffectFromBladeEvent;
import mods.flammpfeil.slashblade.event.bladestand.PreCopySpecialAttackFromBladeEvent;
import mods.flammpfeil.slashblade.event.bladestand.PreCopySpecialEffectFromBladeEvent;
import mods.flammpfeil.slashblade.event.bladestand.ProudSoulEnchantmentEvent;
import mods.flammpfeil.slashblade.init.SBItems;
import mods.flammpfeil.slashblade.item.ItemSlashBlade;
import mods.flammpfeil.slashblade.recipe.RequestDefinition;
import mods.flammpfeil.slashblade.recipe.SlashBladeIngredient;
import mods.flammpfeil.slashblade.registry.SlashArtsRegistry;
import mods.flammpfeil.slashblade.registry.SpecialEffectsRegistry;
import mods.flammpfeil.slashblade.registry.slashblade.SlashBladeDefinition;
import mods.flammpfeil.slashblade.registry.specialeffects.SpecialEffect;
import net.minecraft.core.Registry;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.tags.DamageTypeTags;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.boss.wither.WitherBoss;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber
public class BlandStandEventHandler {
    @SubscribeEvent
    public static void eventKoseki(SlashBladeEvent.BladeStandAttackEvent event) {
        Registry<SlashBladeDefinition> slashBladeDefinitionRegistry = SlashBlade.getSlashBladeDefinitionRegistry(event.getBladeStand().m_9236_());
        if (!slashBladeDefinitionRegistry.m_7804_(SlashBladeBuiltInRegistry.KOSEKI.m_135782_())) {
            return;
        }
        if (!(event.getDamageSource().m_7639_() instanceof WitherBoss)) {
            return;
        }
        if (!event.getDamageSource().m_269533_(DamageTypeTags.f_268415_)) {
            return;
        }
        SlashBladeIngredient in = SlashBladeIngredient.of(RequestDefinition.Builder.newInstance().build());
        if (!in.test(event.getBlade())) {
            return;
        }
        event.getBladeStand().m_31805_(Objects.requireNonNull((SlashBladeDefinition)slashBladeDefinitionRegistry.m_6246_(SlashBladeBuiltInRegistry.KOSEKI)).getBlade());
        event.setCanceled(true);
    }

    @SubscribeEvent
    public static void eventChangeSE(SlashBladeEvent.BladeStandAttackEvent event) {
        Entity entity = event.getDamageSource().m_7639_();
        if (!(entity instanceof ServerPlayer)) {
            return;
        }
        ServerPlayer player = (ServerPlayer)entity;
        ItemStack stack = player.m_21120_(InteractionHand.MAIN_HAND);
        ItemStack blade = event.getBlade();
        if (blade.m_41619_()) {
            return;
        }
        if (!stack.m_204117_(SlashBladeItemTags.CAN_CHANGE_SE)) {
            return;
        }
        Level world = player.m_9236_();
        ISlashBladeState state = event.getSlashBladeState();
        if (stack.m_41783_() == null) {
            return;
        }
        CompoundTag tag = stack.m_41783_();
        if (tag.m_128441_("SpecialEffectType")) {
            BladeStandEntity bladeStand = event.getBladeStand();
            ResourceLocation SEKey = new ResourceLocation(tag.m_128461_("SpecialEffectType"));
            if (!SpecialEffectsRegistry.REGISTRY.get().containsKey(SEKey)) {
                return;
            }
            if (state.hasSpecialEffect(SEKey)) {
                return;
            }
            BladeChangeSpecialEffectEvent e = new BladeChangeSpecialEffectEvent(blade, state, SEKey, event);
            if (!player.m_7500_()) {
                e.setShrinkCount(1);
            }
            MinecraftForge.EVENT_BUS.post((Event)e);
            if (e.isCanceled()) {
                return;
            }
            if (stack.m_41613_() < e.getShrinkCount()) {
                return;
            }
            state.addSpecialEffect(e.getSEKey());
            RandomSource random = player.m_217043_();
            BlandStandEventHandler.spawnSucceedEffects(world, bladeStand, random);
            stack.m_41774_(e.getShrinkCount());
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    public static void eventChangeSA(SlashBladeEvent.BladeStandAttackEvent event) {
        Entity entity = event.getDamageSource().m_7639_();
        if (!(entity instanceof ServerPlayer)) {
            return;
        }
        ServerPlayer player = (ServerPlayer)entity;
        ItemStack stack = player.m_21120_(InteractionHand.MAIN_HAND);
        CompoundTag tag = stack.m_41783_();
        if (!stack.m_204117_(SlashBladeItemTags.CAN_CHANGE_SA) || tag == null || !tag.m_128441_("SpecialAttackType")) {
            return;
        }
        ResourceLocation SAKey = new ResourceLocation(tag.m_128461_("SpecialAttackType"));
        if (!SlashArtsRegistry.REGISTRY.get().containsKey(SAKey)) {
            return;
        }
        ItemStack blade = event.getBlade();
        blade.getCapability(ItemSlashBlade.BLADESTATE).ifPresent(state -> {
            if (!SAKey.equals((Object)state.getSlashArtsKey())) {
                BladeChangeSpecialAttackEvent e = new BladeChangeSpecialAttackEvent(blade, (ISlashBladeState)state, SAKey, event);
                if (!player.m_7500_()) {
                    e.setShrinkCount(1);
                }
                MinecraftForge.EVENT_BUS.post((Event)e);
                if (e.isCanceled()) {
                    return;
                }
                if (stack.m_41613_() < e.getShrinkCount()) {
                    return;
                }
                state.setSlashArtsKey(e.getSAKey());
                RandomSource random = player.m_217043_();
                BladeStandEntity bladeStand = event.getBladeStand();
                BlandStandEventHandler.spawnSucceedEffects(player.m_9236_(), bladeStand, random);
                stack.m_41774_(e.getShrinkCount());
            }
        });
        event.setCanceled(true);
    }

    @SubscribeEvent
    public static void eventCopySE(SlashBladeEvent.BladeStandAttackEvent event) {
        Entity entity = event.getDamageSource().m_7639_();
        if (!(entity instanceof ServerPlayer)) {
            return;
        }
        ServerPlayer player = (ServerPlayer)entity;
        ItemStack stack = player.m_21120_(InteractionHand.MAIN_HAND);
        ItemStack blade = event.getBlade();
        if (blade.m_41619_()) {
            return;
        }
        if (!stack.m_204117_(SlashBladeItemTags.CAN_COPY_SE)) {
            return;
        }
        CompoundTag crystalTag = stack.m_41783_();
        if (crystalTag != null && crystalTag.m_128441_("SpecialEffectType")) {
            return;
        }
        Level world = player.m_9236_();
        if (world.m_5776_()) {
            return;
        }
        ISlashBladeState state = event.getSlashBladeState();
        BladeStandEntity bladeStand = event.getBladeStand();
        List<ResourceLocation> specialEffects = state.getSpecialEffects();
        for (ResourceLocation se : specialEffects) {
            if (!SpecialEffectsRegistry.REGISTRY.get().containsKey(se)) continue;
            PreCopySpecialEffectFromBladeEvent pe = new PreCopySpecialEffectFromBladeEvent(blade, state, se, event, Objects.requireNonNull((SpecialEffect)SpecialEffectsRegistry.REGISTRY.get().getValue(se)).isRemovable(), Objects.requireNonNull((SpecialEffect)SpecialEffectsRegistry.REGISTRY.get().getValue(se)).isCopiable());
            if (!player.m_7500_()) {
                pe.setShrinkCount(1);
            }
            MinecraftForge.EVENT_BUS.post((Event)pe);
            if (pe.isCanceled()) {
                return;
            }
            if (stack.m_41613_() < pe.getShrinkCount() || !pe.isCopiable()) continue;
            ItemStack orb = new ItemStack((ItemLike)SBItems.proudsoul_crystal);
            CompoundTag tag = new CompoundTag();
            tag.m_128359_("SpecialEffectType", se.toString());
            orb.m_41751_(tag);
            stack.m_41774_(pe.getShrinkCount());
            RandomSource random = player.m_217043_();
            BlandStandEventHandler.spawnSucceedEffects(world, bladeStand, random);
            ItemEntity itemEntity = player.m_36176_(orb, true);
            if (pe.isRemovable()) {
                state.removeSpecialEffect(se);
            }
            CopySpecialEffectFromBladeEvent e = new CopySpecialEffectFromBladeEvent(pe, orb, itemEntity);
            MinecraftForge.EVENT_BUS.post((Event)e);
            event.setCanceled(true);
            return;
        }
    }

    @SubscribeEvent
    public static void eventCopySA(SlashBladeEvent.BladeStandAttackEvent event) {
        Entity entity = event.getDamageSource().m_7639_();
        if (!(entity instanceof Player)) {
            return;
        }
        Player player = (Player)entity;
        ItemStack stack = player.m_21120_(InteractionHand.MAIN_HAND);
        ItemStack blade = event.getBlade();
        if (blade.m_41619_()) {
            return;
        }
        if (!stack.m_204117_(SlashBladeItemTags.CAN_COPY_SA) || !stack.m_41793_()) {
            return;
        }
        Level world = player.m_9236_();
        if (world.m_5776_()) {
            return;
        }
        ISlashBladeState state = event.getSlashBladeState();
        BladeStandEntity bladeStand = event.getBladeStand();
        ResourceLocation SA = state.getSlashArtsKey();
        if (SA != null && !SA.equals((Object)SlashArtsRegistry.NONE.getId())) {
            PreCopySpecialAttackFromBladeEvent pe = new PreCopySpecialAttackFromBladeEvent(blade, state, SA, event);
            if (!player.m_7500_()) {
                pe.setShrinkCount(1);
            }
            MinecraftForge.EVENT_BUS.post((Event)pe);
            if (pe.isCanceled()) {
                return;
            }
            if (stack.m_41613_() < pe.getShrinkCount()) {
                return;
            }
            ItemStack orb = new ItemStack((ItemLike)SBItems.proudsoul_sphere);
            CompoundTag tag = new CompoundTag();
            tag.m_128359_("SpecialAttackType", state.getSlashArtsKey().toString());
            orb.m_41751_(tag);
            stack.m_41774_(pe.getShrinkCount());
            RandomSource random = player.m_217043_();
            BlandStandEventHandler.spawnSucceedEffects(world, bladeStand, random);
            ItemEntity itemEntity = player.m_36176_(orb, true);
            CopySpecialAttackFromBladeEvent e = new CopySpecialAttackFromBladeEvent(pe, orb, itemEntity);
            MinecraftForge.EVENT_BUS.post((Event)e);
            event.setCanceled(true);
        }
    }

    @SubscribeEvent(priority=EventPriority.LOW)
    public static void eventProudSoulEnchantment(SlashBladeEvent.BladeStandAttackEvent event) {
        Entity entity = event.getDamageSource().m_7639_();
        if (!(entity instanceof Player)) {
            return;
        }
        Player player = (Player)entity;
        if (player.m_9236_().m_5776_()) {
            return;
        }
        ItemStack stack = player.m_21120_(InteractionHand.MAIN_HAND);
        ItemStack blade = event.getBlade();
        if (blade.m_41619_()) {
            return;
        }
        if (!stack.m_204117_(SlashBladeItemTags.PROUD_SOULS)) {
            return;
        }
        if (!stack.m_41793_()) {
            return;
        }
        Level world = player.m_9236_();
        RandomSource random = world.m_213780_();
        BladeStandEntity bladeStand = event.getBladeStand();
        Map currentBladeEnchantments = blade.getAllEnchantments();
        HashMap enchantments = new HashMap();
        AtomicInteger totalShrinkCount = new AtomicInteger(0);
        if (!player.m_7500_()) {
            totalShrinkCount.set(1);
        }
        stack.getAllEnchantments().forEach((enchantment, level) -> {
            if (event.isCanceled()) {
                return;
            }
            if (!blade.canApplyAtEnchantingTable(enchantment)) {
                return;
            }
            float probability = 1.0f;
            if (stack.m_150930_(SBItems.proudsoul_tiny)) {
                probability = 0.25f;
            }
            if (stack.m_150930_(SBItems.proudsoul)) {
                probability = 0.5f;
            }
            if (stack.m_150930_(SBItems.proudsoul_ingot)) {
                probability = 0.75f;
            }
            int enchantLevel = Math.min(enchantment.m_6586_(), EnchantmentHelper.getTagEnchantmentLevel((Enchantment)enchantment, (ItemStack)blade) + 1);
            ProudSoulEnchantmentEvent e = new ProudSoulEnchantmentEvent(blade, event.getSlashBladeState(), (Enchantment)enchantment, enchantLevel, false, probability, totalShrinkCount.get(), event);
            MinecraftForge.EVENT_BUS.post((Event)e);
            if (e.isCanceled()) {
                return;
            }
            totalShrinkCount.set(e.getTotalShrinkCount());
            enchantments.put(e.getEnchantment(), e.getEnchantLevel());
            if (!e.willTryNextEnchant()) {
                event.setCanceled(true);
            }
        });
        if (stack.m_41613_() < totalShrinkCount.get()) {
            return;
        }
        stack.m_41774_(totalShrinkCount.get());
        currentBladeEnchantments.putAll(enchantments);
        EnchantmentHelper.m_44865_((Map)currentBladeEnchantments, (ItemStack)blade);
        if (!enchantments.isEmpty()) {
            BlandStandEventHandler.spawnSucceedEffects(world, bladeStand, random);
        }
        event.setCanceled(true);
    }

    @SubscribeEvent
    public static void copySAEnchantmentCheck(PreCopySpecialAttackFromBladeEvent event) {
        SlashBladeEvent.BladeStandAttackEvent oriEvent = event.getOriginalEvent();
        if (oriEvent == null) {
            return;
        }
        Player player = (Player)oriEvent.getDamageSource().m_7639_();
        if (player != null) {
            ItemStack stack = player.m_21120_(InteractionHand.MAIN_HAND);
            ItemStack blade = event.getBlade();
            Set enchantments = EnchantmentHelper.m_44831_((ItemStack)stack).keySet();
            boolean flag = false;
            for (Enchantment e : enchantments) {
                if (EnchantmentHelper.getTagEnchantmentLevel((Enchantment)e, (ItemStack)blade) < e.m_6586_()) continue;
                flag = true;
            }
            if (!flag) {
                event.setCanceled(true);
            }
        }
    }

    @SubscribeEvent
    public static void proudSoulEnchantmentProbabilityCheck(ProudSoulEnchantmentEvent event) {
        Level world;
        RandomSource random;
        SlashBladeEvent.BladeStandAttackEvent oriEvent = event.getOriginalEvent();
        if (oriEvent == null) {
            return;
        }
        Player player = (Player)oriEvent.getDamageSource().m_7639_();
        if (player != null && (random = (world = player.m_9236_()).m_213780_()).m_188501_() > event.getProbability()) {
            event.setCanceled(true);
        }
    }

    private static void spawnSucceedEffects(Level world, BladeStandEntity bladeStand, RandomSource random) {
        if (!(world instanceof ServerLevel)) {
            return;
        }
        ServerLevel serverLevel = (ServerLevel)world;
        serverLevel.m_245803_((Entity)bladeStand, bladeStand.m_31748_(), SoundEvents.f_12563_, SoundSource.BLOCKS, 0.5f, 0.8f);
        for (int i = 0; i < 32; ++i) {
            double zDist;
            double yDist;
            double xDist = random.m_188501_() * 2.0f - 1.0f;
            if (!(xDist * xDist + (yDist = (double)(random.m_188501_() * 2.0f - 1.0f)) * yDist + (zDist = (double)(random.m_188501_() * 2.0f - 1.0f)) * zDist <= 1.0)) continue;
            double x = bladeStand.m_20165_(xDist / 4.0);
            double y = bladeStand.m_20227_(0.5 + yDist / 4.0);
            double z = bladeStand.m_20246_(zDist / 4.0);
            serverLevel.m_8767_((ParticleOptions)ParticleTypes.f_123760_, x, y, z, 0, xDist, yDist + 0.2, zDist, 1.0);
        }
    }
}

