/*
 * Decompiled with CFR 0.152.
 */
package mods.flammpfeil.slashblade.event.handler;

import java.util.EnumSet;
import mods.flammpfeil.slashblade.capability.inputstate.IInputState;
import mods.flammpfeil.slashblade.client.SlashBladeKeyMappings;
import mods.flammpfeil.slashblade.item.ItemSlashBlade;
import mods.flammpfeil.slashblade.network.MoveCommandMessage;
import mods.flammpfeil.slashblade.network.NetworkManager;
import mods.flammpfeil.slashblade.util.EnumSetConverter;
import mods.flammpfeil.slashblade.util.InputCommand;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.world.level.Level;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.CapabilityManager;
import net.minecraftforge.common.capabilities.CapabilityToken;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(value={Dist.CLIENT})
public class MoveInputHandler {
    public static final Capability<IInputState> INPUT_STATE = CapabilityManager.get((CapabilityToken)new CapabilityToken<IInputState>(){});
    public static final String LAST_CHANGE_TIME = "SB_LAST_CHANGE_TIME";

    public static boolean checkFlag(int data, int flags) {
        return (data & flags) == flags;
    }

    @OnlyIn(value=Dist.CLIENT)
    @SubscribeEvent
    public static void onPlayerPostTick(TickEvent.ClientTickEvent event) {
        boolean doSend;
        if (event.phase != TickEvent.Phase.END) {
            return;
        }
        LocalPlayer player = Minecraft.m_91087_().f_91074_;
        if (player == null) {
            return;
        }
        if (player.m_21205_().m_41619_() || !player.m_21205_().getCapability(ItemSlashBlade.BLADESTATE).isPresent()) {
            return;
        }
        EnumSet<InputCommand> commands = EnumSet.noneOf(InputCommand.class);
        if (player.f_108618_.f_108568_) {
            commands.add(InputCommand.FORWARD);
        }
        if (player.f_108618_.f_108569_) {
            commands.add(InputCommand.BACK);
        }
        if (player.f_108618_.f_108570_) {
            commands.add(InputCommand.LEFT);
        }
        if (player.f_108618_.f_108571_) {
            commands.add(InputCommand.RIGHT);
        }
        if (player.f_108618_.f_108573_) {
            commands.add(InputCommand.SNEAK);
        }
        if (player.f_108618_.f_108572_) {
            commands.add(InputCommand.JUMP);
        }
        Minecraft minecraftInstance = Minecraft.m_91087_();
        if (SlashBladeKeyMappings.KEY_SPECIAL_MOVE.m_90857_()) {
            commands.add(InputCommand.SPRINT);
        }
        if (minecraftInstance.f_91066_.f_92095_.m_90857_()) {
            commands.add(InputCommand.R_DOWN);
        }
        if (minecraftInstance.f_91066_.f_92096_.m_90857_()) {
            commands.add(InputCommand.L_DOWN);
        }
        if (SlashBladeKeyMappings.KEY_SUMMON_BLADE.m_90857_()) {
            commands.add(InputCommand.M_DOWN);
        }
        EnumSet old = player.getCapability(INPUT_STATE).map(IInputState::getCommands).orElseGet(() -> EnumSet.noneOf(InputCommand.class));
        Level worldIn = player.m_20193_();
        long currentTime = worldIn.m_46467_();
        boolean bl = doSend = !old.equals(commands);
        if (doSend) {
            player.getCapability(INPUT_STATE).ifPresent(state -> {
                commands.forEach(c -> {
                    if (!old.contains(c)) {
                        state.getLastPressTimes().put((InputCommand)((Object)((Object)c)), currentTime);
                    }
                });
                state.getCommands().clear();
                state.getCommands().addAll(commands);
            });
            MoveCommandMessage msg = new MoveCommandMessage();
            msg.command = EnumSetConverter.convertToInt(commands);
            NetworkManager.INSTANCE.sendToServer((Object)msg);
        }
    }
}

