/*
 * Decompiled with CFR 0.152.
 */
package mods.flammpfeil.slashblade.recipe;

import com.google.common.collect.ImmutableSet;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonSyntaxException;
import java.util.Collections;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import mods.flammpfeil.slashblade.init.SBItems;
import mods.flammpfeil.slashblade.recipe.RequestDefinition;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.common.crafting.CraftingHelper;
import net.minecraftforge.common.crafting.IIngredientSerializer;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;
import org.jetbrains.annotations.NotNull;

public class SlashBladeIngredient
extends Ingredient {
    private final Set<Item> items;
    private final RequestDefinition request;

    protected SlashBladeIngredient(Set<Item> items, RequestDefinition request) {
        super(items.stream().map(item -> {
            ItemStack stack = new ItemStack((ItemLike)item);
            request.initItemStack(stack);
            return new Ingredient.ItemValue(stack);
        }));
        if (items.isEmpty()) {
            throw new IllegalArgumentException("Cannot create a SlashBladeIngredient with no items");
        }
        this.items = Collections.unmodifiableSet(items);
        this.request = request;
    }

    public static SlashBladeIngredient of(ItemLike item, RequestDefinition request) {
        return new SlashBladeIngredient(Set.of(item.m_5456_()), request);
    }

    public static SlashBladeIngredient of(RequestDefinition request) {
        return new SlashBladeIngredient(Set.of(SBItems.slashblade), request);
    }

    public static SlashBladeIngredient of(ItemLike item, ResourceLocation request) {
        return new SlashBladeIngredient(Set.of(item.m_5456_()), RequestDefinition.Builder.newInstance().name(request).build());
    }

    public static SlashBladeIngredient of(ResourceLocation request) {
        return new SlashBladeIngredient(Set.of(SBItems.slashblade), RequestDefinition.Builder.newInstance().name(request).build());
    }

    public static SlashBladeIngredient blankNameless() {
        return SlashBladeIngredient.of(RequestDefinition.Builder.newInstance().build());
    }

    public boolean test(ItemStack input) {
        if (input == null) {
            return false;
        }
        return this.items.contains(input.m_41720_()) && this.request.test(input);
    }

    public boolean isSimple() {
        return false;
    }

    @NotNull
    public IIngredientSerializer<? extends Ingredient> getSerializer() {
        return Serializer.INSTANCE;
    }

    @NotNull
    public JsonElement m_43942_() {
        JsonObject json = new JsonObject();
        json.addProperty("type", Objects.requireNonNull(CraftingHelper.getID((IIngredientSerializer)Serializer.INSTANCE)).toString());
        if (this.items.size() == 1) {
            json.addProperty("item", Objects.requireNonNull(ForgeRegistries.ITEMS.getKey((Object)this.items.iterator().next())).toString());
        } else {
            JsonArray items = new JsonArray();
            this.items.stream().map(arg_0 -> ((IForgeRegistry)ForgeRegistries.ITEMS).getKey(arg_0)).sorted().forEach(name -> items.add(name.toString()));
            json.add("items", (JsonElement)items);
        }
        json.add("request", this.request.toJson());
        return json;
    }

    public static class Serializer
    implements IIngredientSerializer<SlashBladeIngredient> {
        public static final Serializer INSTANCE = new Serializer();

        @NotNull
        public SlashBladeIngredient parse(FriendlyByteBuf buffer) {
            Set<Item> items = Stream.generate(() -> (Item)buffer.readRegistryIdUnsafe(ForgeRegistries.ITEMS)).limit(buffer.m_130242_()).collect(Collectors.toSet());
            RequestDefinition request = RequestDefinition.fromNetwork(buffer);
            return new SlashBladeIngredient(items, request);
        }

        @NotNull
        public SlashBladeIngredient parse(JsonObject json) {
            ImmutableSet items;
            if (json.has("item")) {
                items = Set.of(CraftingHelper.getItem((String)GsonHelper.m_13906_((JsonObject)json, (String)"item"), (boolean)true));
            } else if (json.has("items")) {
                ImmutableSet.Builder builder = ImmutableSet.builder();
                JsonArray itemArray = GsonHelper.m_13933_((JsonObject)json, (String)"items");
                for (int i = 0; i < itemArray.size(); ++i) {
                    builder.add((Object)CraftingHelper.getItem((String)GsonHelper.m_13805_((JsonElement)itemArray.get(i), (String)("items[" + i + "]")), (boolean)true));
                }
                items = builder.build();
            } else {
                throw new JsonSyntaxException("Must set either 'item' or 'items'");
            }
            RequestDefinition request = RequestDefinition.fromJSON(json.getAsJsonObject("request"));
            return new SlashBladeIngredient((Set<Item>)items, request);
        }

        public void write(FriendlyByteBuf buffer, SlashBladeIngredient ingredient) {
            buffer.m_130130_(ingredient.items.size());
            for (Item item : ingredient.items) {
                buffer.writeRegistryIdUnsafe(ForgeRegistries.ITEMS, (Object)item);
            }
            ingredient.request.toNetwork(buffer);
        }
    }
}

