/*
 * Decompiled with CFR 0.152.
 */
package mods.flammpfeil.slashblade.registry.slashblade;

import com.google.common.collect.Lists;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Comparator;
import java.util.List;
import mods.flammpfeil.slashblade.SlashBlade;
import mods.flammpfeil.slashblade.SlashBladeCreativeGroup;
import mods.flammpfeil.slashblade.capability.slashblade.ISlashBladeState;
import mods.flammpfeil.slashblade.capability.slashblade.SlashBladeState;
import mods.flammpfeil.slashblade.event.SlashBladeRegistryEvent;
import mods.flammpfeil.slashblade.init.SBItems;
import mods.flammpfeil.slashblade.item.ItemSlashBlade;
import mods.flammpfeil.slashblade.registry.slashblade.EnchantmentDefinition;
import mods.flammpfeil.slashblade.registry.slashblade.PropertiesDefinition;
import mods.flammpfeil.slashblade.registry.slashblade.RenderDefinition;
import net.minecraft.Util;
import net.minecraft.core.Holder;
import net.minecraft.core.Registry;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.registries.ForgeRegistries;
import org.jetbrains.annotations.Nullable;

public class SlashBladeDefinition {
    public static final Codec<SlashBladeDefinition> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)ResourceLocation.f_135803_.optionalFieldOf("item", (Object)SlashBlade.prefix("slashblade")).forGetter(SlashBladeDefinition::getItemName), (App)ResourceLocation.f_135803_.fieldOf("name").forGetter(SlashBladeDefinition::getName), (App)RenderDefinition.CODEC.fieldOf("render").forGetter(SlashBladeDefinition::getRenderDefinition), (App)PropertiesDefinition.CODEC.fieldOf("properties").forGetter(SlashBladeDefinition::getStateDefinition), (App)EnchantmentDefinition.CODEC.listOf().optionalFieldOf("enchantments", (Object)Lists.newArrayList()).forGetter(SlashBladeDefinition::getEnchantments), (App)ResourceLocation.f_135803_.optionalFieldOf("creativeGroup", (Object)SlashBladeCreativeGroup.SLASHBLADE_GROUP.getId()).forGetter(SlashBladeDefinition::getCreativeGroup)).apply((Applicative)instance, SlashBladeDefinition::new));
    public static final ResourceKey<Registry<SlashBladeDefinition>> REGISTRY_KEY = ResourceKey.m_135788_((ResourceLocation)SlashBlade.prefix("named_blades"));
    private final ResourceLocation item;
    private final ResourceLocation name;
    private final RenderDefinition renderDefinition;
    private final PropertiesDefinition stateDefinition;
    private final List<EnchantmentDefinition> enchantments;
    private final ResourceLocation creativeGroup;
    public static final BladeComparator COMPARATOR = new BladeComparator();

    public SlashBladeDefinition(ResourceLocation name, RenderDefinition renderDefinition, PropertiesDefinition stateDefinition, List<EnchantmentDefinition> enchantments) {
        this(SlashBlade.prefix("slashblade"), name, renderDefinition, stateDefinition, enchantments, SlashBladeCreativeGroup.SLASHBLADE_GROUP.getId());
    }

    public SlashBladeDefinition(ResourceLocation name, RenderDefinition renderDefinition, PropertiesDefinition stateDefinition, List<EnchantmentDefinition> enchantments, ResourceLocation creativeGroup) {
        this(SlashBlade.prefix("slashblade"), name, renderDefinition, stateDefinition, enchantments, creativeGroup);
    }

    public SlashBladeDefinition(ResourceLocation item, ResourceLocation name, RenderDefinition renderDefinition, PropertiesDefinition stateDefinition, List<EnchantmentDefinition> enchantments) {
        this(item, name, renderDefinition, stateDefinition, enchantments, SlashBladeCreativeGroup.SLASHBLADE_GROUP.getId());
    }

    public SlashBladeDefinition(ResourceLocation item, ResourceLocation name, RenderDefinition renderDefinition, PropertiesDefinition stateDefinition, List<EnchantmentDefinition> enchantments, ResourceLocation creativeGroup) {
        this.item = item;
        this.name = name;
        this.renderDefinition = renderDefinition;
        this.stateDefinition = stateDefinition;
        this.enchantments = enchantments;
        this.creativeGroup = creativeGroup;
    }

    public ResourceLocation getItemName() {
        return this.item;
    }

    public ResourceLocation getName() {
        return this.name;
    }

    public String getTranslationKey() {
        return Util.m_137492_((String)"item", (ResourceLocation)this.getName());
    }

    public RenderDefinition getRenderDefinition() {
        return this.renderDefinition;
    }

    public PropertiesDefinition getStateDefinition() {
        return this.stateDefinition;
    }

    public List<EnchantmentDefinition> getEnchantments() {
        return this.enchantments;
    }

    public ItemStack getBlade() {
        return this.getBlade(this.getItem());
    }

    public ItemStack getBlade(Item bladeItem) {
        if (MinecraftForge.EVENT_BUS.post((Event)new SlashBladeRegistryEvent.Pre(this))) {
            return ItemStack.f_41583_;
        }
        ItemStack result = new ItemStack((ItemLike)bladeItem);
        ISlashBladeState state = (ISlashBladeState)result.getCapability(ItemSlashBlade.BLADESTATE).orElse((Object)new SlashBladeState(result));
        state.setNonEmpty();
        state.setBaseAttackModifier(this.stateDefinition.getBaseAttackModifier());
        state.setMaxDamage(this.stateDefinition.getMaxDamage());
        state.setComboRoot(this.stateDefinition.getComboRoot());
        state.setSlashArtsKey(this.stateDefinition.getSpecialAttackType());
        this.stateDefinition.getSpecialEffects().forEach(state::addSpecialEffect);
        this.stateDefinition.getDefaultType().forEach(type -> {
            switch (type) {
                case BEWITCHED: {
                    state.setDefaultBewitched(true);
                    break;
                }
                case BROKEN: {
                    result.m_41721_(result.m_41776_() - 1);
                    state.setBroken(true);
                    break;
                }
                case SEALED: {
                    state.setSealed(true);
                    break;
                }
            }
        });
        state.setModel(this.renderDefinition.getModelName());
        state.setTexture(this.renderDefinition.getTextureName());
        state.setColorCode(this.renderDefinition.getSummonedSwordColor());
        state.setEffectColorInverse(this.renderDefinition.isSummonedSwordColorInverse());
        state.setCarryType(this.renderDefinition.getStandbyRenderType());
        if (!this.getName().equals((Object)SlashBlade.prefix("none"))) {
            state.setTranslationKey(this.getTranslationKey());
        }
        result.m_41784_().m_128365_("bladeState", (Tag)state.serializeNBT());
        for (EnchantmentDefinition instance : this.enchantments) {
            Enchantment enchantment = (Enchantment)ForgeRegistries.ENCHANTMENTS.getValue(instance.getEnchantmentID());
            if (enchantment == null) continue;
            result.m_41663_(enchantment, instance.getEnchantmentLevel());
        }
        if (this.stateDefinition.isUnbreakable()) {
            result.m_41784_().m_128379_("Unbreakable", true);
        }
        SlashBladeRegistryEvent.Post postRegistry = new SlashBladeRegistryEvent.Post(this, result);
        MinecraftForge.EVENT_BUS.post((Event)postRegistry);
        return postRegistry.getBlade();
    }

    public Item getItem() {
        @Nullable Item value = (Item)ForgeRegistries.ITEMS.getValue(this.item);
        if (value == null) {
            return SBItems.slashblade;
        }
        return value;
    }

    public ResourceLocation getCreativeGroup() {
        return this.creativeGroup;
    }

    public static class BladeComparator
    implements Comparator<Holder.Reference<SlashBladeDefinition>> {
        @Override
        public int compare(Holder.Reference<SlashBladeDefinition> left, Holder.Reference<SlashBladeDefinition> right) {
            ResourceLocation leftKey = left.m_205785_().m_135782_();
            ResourceLocation rightKey = right.m_205785_().m_135782_();
            boolean checkSame = leftKey.m_135827_().equalsIgnoreCase(rightKey.m_135827_());
            if (!checkSame) {
                if (leftKey.m_135827_().equalsIgnoreCase("slashblade")) {
                    return -1;
                }
                if (rightKey.m_135827_().equalsIgnoreCase("slashblade")) {
                    return 1;
                }
            }
            String leftName = leftKey.toString();
            String rightName = rightKey.toString();
            return leftName.compareToIgnoreCase(rightName);
        }
    }
}

