/*
 * Decompiled with CFR 0.152.
 */
package mods.flammpfeil.slashblade.capability.slashblade;

import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import mods.flammpfeil.slashblade.capability.slashblade.ISlashBladeState;
import mods.flammpfeil.slashblade.capability.slashblade.SimpleSlashBladeState;
import mods.flammpfeil.slashblade.client.renderer.CarryType;
import mods.flammpfeil.slashblade.item.ItemSlashBlade;
import mods.flammpfeil.slashblade.registry.ComboStateRegistry;
import mods.flammpfeil.slashblade.registry.SlashArtsRegistry;
import mods.flammpfeil.slashblade.util.EnumSetConverter;
import mods.flammpfeil.slashblade.util.NBTHelper;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.capabilities.ICapabilitySerializable;
import net.minecraftforge.common.util.LazyOptional;

public class SimpleBladeStateCapabilityProvider
implements ICapabilityProvider,
ICapabilitySerializable<CompoundTag> {
    protected LazyOptional<ISlashBladeState> state;

    public SimpleBladeStateCapabilityProvider(ItemStack blade, ResourceLocation model, ResourceLocation texture, float attack, int damage) {
        this.state = !blade.m_41619_() ? LazyOptional.of(() -> new SimpleSlashBladeState(blade, model, texture, attack, damage)) : LazyOptional.empty();
    }

    @Nonnull
    public <T> LazyOptional<T> getCapability(@Nonnull Capability<T> cap, @Nullable Direction side) {
        return ItemSlashBlade.BLADESTATE.orEmpty(cap, this.state);
    }

    public CompoundTag serializeNBT() {
        CompoundTag tag = new CompoundTag();
        this.state.ifPresent(instance -> {
            tag.m_128356_("lastActionTime", instance.getLastActionTime());
            tag.m_128405_("TargetEntity", instance.getTargetEntityId());
            tag.m_128379_("_onClick", instance.onClick());
            tag.m_128350_("fallDecreaseRate", instance.getFallDecreaseRate());
            tag.m_128350_("AttackAmplifier", instance.getAttackAmplifier());
            tag.m_128359_("currentCombo", instance.getComboSeq().toString());
            tag.m_128405_("Damage", instance.getDamage());
            tag.m_128405_("proudSoul", instance.getProudSoulCount());
            tag.m_128379_("isBroken", instance.isBroken());
            tag.m_128379_("isSealed", instance.isSealed());
            tag.m_128405_("killCount", instance.getKillCount());
            tag.m_128405_("RepairCounter", instance.getRefine());
            tag.m_128359_("SpecialAttackType", Objects.requireNonNull(Optional.ofNullable(instance.getSlashArtsKey()).orElse(SlashArtsRegistry.JUDGEMENT_CUT.getId())).toString());
            tag.m_128344_("StandbyRenderType", (byte)instance.getCarryType().ordinal());
            tag.m_128405_("SummonedSwordColor", instance.getColorCode());
            tag.m_128379_("SummonedSwordColorInverse", instance.isEffectColorInverse());
            tag.m_128365_("adjustXYZ", (Tag)NBTHelper.newDoubleNBTList(instance.getAdjust()));
            tag.m_128359_("ComboRoot", Objects.requireNonNull(Optional.ofNullable(instance.getComboRoot()).orElse(ComboStateRegistry.STANDBY.getId())).toString());
        });
        return tag;
    }

    public void deserializeNBT(CompoundTag tag) {
        this.state.ifPresent(instance -> {
            if (tag == null) {
                return;
            }
            instance.setNonEmpty();
            instance.setLastActionTime(tag.m_128454_("lastActionTime"));
            instance.setTargetEntityId(tag.m_128451_("TargetEntity"));
            instance.setOnClick(tag.m_128471_("_onClick"));
            instance.setFallDecreaseRate(tag.m_128457_("fallDecreaseRate"));
            instance.setAttackAmplifier(tag.m_128457_("AttackAmplifier"));
            instance.setComboSeq(ResourceLocation.m_135820_((String)tag.m_128461_("currentCombo")));
            instance.setDamage(tag.m_128451_("Damage"));
            instance.setProudSoulCount(tag.m_128451_("proudSoul"));
            instance.setBroken(tag.m_128471_("isBroken"));
            instance.setSealed(tag.m_128471_("isSealed"));
            instance.setKillCount(tag.m_128451_("killCount"));
            instance.setRefine(tag.m_128451_("RepairCounter"));
            instance.setCarryType((CarryType)EnumSetConverter.fromOrdinal((Enum[])CarryType.values(), (int)tag.m_128445_("StandbyRenderType"), (Enum)CarryType.PSO2));
            instance.setColorCode(tag.m_128451_("SummonedSwordColor"));
            instance.setEffectColorInverse(tag.m_128471_("SummonedSwordColorInverse"));
            instance.setAdjust(NBTHelper.getVector3d(tag, "adjustXYZ"));
            instance.setComboRoot(ResourceLocation.m_135820_((String)tag.m_128461_("ComboRoot")));
        });
    }
}

