/*
 * Decompiled with CFR 0.152.
 */
package mods.flammpfeil.slashblade.client.renderer.event;

import com.google.common.cache.LoadingCache;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import mods.flammpfeil.slashblade.SlashBlade;
import mods.flammpfeil.slashblade.client.renderer.model.BladeModelManager;
import mods.flammpfeil.slashblade.client.renderer.model.obj.WavefrontObject;
import mods.flammpfeil.slashblade.init.DefaultResources;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.PreparableReloadListener;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.util.profiling.ProfilerFiller;
import org.jetbrains.annotations.NotNull;

public class ModelResourceLoader
implements PreparableReloadListener {
    private static final ResourceLocation MODEL_DIR = SlashBlade.prefix("model");
    private static final String FILE_TYPES = ".obj";

    private void loadResources(ResourceManager manager) {
        BladeModelManager instance = BladeModelManager.getInstance();
        LoadingCache<ResourceLocation, WavefrontObject> cache = instance.cache;
        cache.invalidateAll();
        instance.defaultModel = new WavefrontObject(DefaultResources.resourceDefaultModel);
        Map resources = manager.m_214159_(MODEL_DIR.m_135815_(), resLoc -> resLoc.m_135815_().endsWith(FILE_TYPES));
        resources.keySet().forEach(instance::getModel);
    }

    @NotNull
    public CompletableFuture<Void> m_5540_(PreparableReloadListener.PreparationBarrier stage, @NotNull ResourceManager resourceManager, @NotNull ProfilerFiller preparationsProfiler, @NotNull ProfilerFiller reloadProfiler, @NotNull Executor backgroundExecutor, @NotNull Executor gameExecutor) {
        return CompletableFuture.runAsync(() -> this.loadResources(resourceManager), backgroundExecutor).thenCompose(arg_0 -> ((PreparableReloadListener.PreparationBarrier)stage).m_6769_(arg_0));
    }
}

