/*
 * Decompiled with CFR 0.152.
 */
package mods.flammpfeil.slashblade.compat.emi;

import dev.emi.emi.api.recipe.EmiRecipe;
import dev.emi.emi.api.recipe.EmiRecipeCategory;
import dev.emi.emi.api.render.EmiTexture;
import dev.emi.emi.api.stack.EmiIngredient;
import dev.emi.emi.api.stack.EmiStack;
import dev.emi.emi.api.widget.WidgetHolder;
import java.util.ArrayList;
import java.util.List;
import mods.flammpfeil.slashblade.compat.emi.EMICompat;
import mods.flammpfeil.slashblade.compat.emi.EMISimpleRecipe;
import mods.flammpfeil.slashblade.recipe.SlashBladeSmithingRecipe;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.core.RegistryAccess;
import net.minecraft.world.Container;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;

public class SlashBladeSmithingEmiRecipe
extends EMISimpleRecipe {
    private final SlashBladeSmithingRecipe recipe;

    public SlashBladeSmithingEmiRecipe(SlashBladeSmithingRecipe recipe) {
        super(SlashBladeSmithingEmiRecipe.createInputs(recipe), SlashBladeSmithingEmiRecipe.createOutputs(recipe), recipe.m_6423_());
        this.recipe = recipe;
    }

    private static List<EmiIngredient> createInputs(SlashBladeSmithingRecipe recipe) {
        ArrayList<EmiIngredient> inputs = new ArrayList<EmiIngredient>();
        inputs.add(EmiIngredient.of((Ingredient)recipe.getTemplate()));
        inputs.add(EmiIngredient.of((Ingredient)recipe.getBase()));
        inputs.add(EmiIngredient.of((Ingredient)recipe.getAddition()));
        return inputs;
    }

    private static List<EmiStack> createOutputs(SlashBladeSmithingRecipe recipe) {
        ArrayList<EmiStack> outputs = new ArrayList<EmiStack>();
        ItemStack[] additions = recipe.getAddition().m_43908_();
        if (additions.length == 0) {
            return outputs;
        }
        ItemStack addition = additions[0];
        for (ItemStack template : recipe.getTemplate().m_43908_()) {
            for (ItemStack base : recipe.getBase().m_43908_()) {
                Container input = SlashBladeSmithingEmiRecipe.createInput(template, base, addition);
                ItemStack output = SlashBladeSmithingEmiRecipe.assembleResultItem(input, recipe);
                if (output.m_41619_()) continue;
                outputs.add(EmiStack.of((ItemStack)output));
            }
        }
        return outputs;
    }

    private static Container createInput(ItemStack template, ItemStack base, ItemStack addition) {
        SimpleContainer container = new SimpleContainer(3);
        container.m_6836_(0, template);
        container.m_6836_(1, base);
        container.m_6836_(2, addition);
        return container;
    }

    private static ItemStack assembleResultItem(Container input, SlashBladeSmithingRecipe recipe) {
        Minecraft minecraft = Minecraft.m_91087_();
        ClientLevel level = minecraft.f_91073_;
        if (level == null) {
            throw new NullPointerException("level must not be null.");
        }
        RegistryAccess registryAccess = level.m_9598_();
        return recipe.m_5874_(input, registryAccess);
    }

    public EmiRecipeCategory getCategory() {
        return EMICompat.SLASHBLADE_SMITHING_CATEGORY;
    }

    public int getDisplayWidth() {
        return 112;
    }

    public int getDisplayHeight() {
        return 18;
    }

    public void addWidgets(WidgetHolder widgets) {
        widgets.addTexture(EmiTexture.EMPTY_ARROW, 62, 1);
        widgets.addSlot((EmiIngredient)this.inputs.get(0), 0, 0);
        widgets.addSlot((EmiIngredient)this.inputs.get(1), 18, 0);
        widgets.addSlot((EmiIngredient)this.inputs.get(2), 36, 0);
        widgets.addSlot((EmiIngredient)this.outputs.get(0), 94, 0).recipeContext((EmiRecipe)this);
    }

    public SlashBladeSmithingRecipe getRecipe() {
        return this.recipe;
    }
}

