/*
 * Decompiled with CFR 0.152.
 */
package mods.flammpfeil.slashblade.emi.mixin;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import dev.emi.emi.EmiPort;
import dev.emi.emi.api.stack.EmiIngredient;
import dev.emi.emi.api.stack.EmiStack;
import dev.emi.emi.api.stack.ItemEmiStack;
import dev.emi.emi.api.stack.serializer.EmiIngredientSerializer;
import dev.emi.emi.api.stack.serializer.EmiStackSerializer;
import dev.emi.emi.runtime.EmiLog;
import dev.emi.emi.stack.serializer.ItemEmiStackSerializer;
import java.util.Objects;
import java.util.regex.Matcher;
import mods.flammpfeil.slashblade.capability.slashblade.ISlashBladeState;
import mods.flammpfeil.slashblade.item.ItemSlashBlade;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.nbt.TagParser;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.common.util.LazyOptional;
import org.spongepowered.asm.mixin.Mixin;

@Mixin(value={ItemEmiStackSerializer.class}, remap=false)
public abstract class MixinItemEmiStackSerializer
implements EmiStackSerializer<ItemEmiStack> {
    public JsonElement serialize(ItemEmiStack stack) {
        LazyOptional optional;
        ItemStack itemStack;
        if (stack.getAmount() == 1L && stack.getChance() == 1.0f && stack.getRemainder().isEmpty() && !(stack.getItemStack().m_41720_() instanceof ItemSlashBlade)) {
            String s = this.getType() + ":" + stack.getId();
            if (stack.hasNbt()) {
                s = s + stack.getNbt().m_7916_();
            }
            return new JsonPrimitive(s);
        }
        JsonObject json = new JsonObject();
        json.addProperty("type", this.getType());
        json.addProperty("id", stack.getId().toString());
        if (stack.hasNbt()) {
            json.addProperty("nbt", stack.getNbt().m_7916_());
        }
        if (stack.getAmount() != 1L) {
            json.addProperty("amount", (Number)stack.getAmount());
        }
        if (stack.getChance() != 1.0f) {
            json.addProperty("chance", (Number)Float.valueOf(stack.getChance()));
        }
        if ((itemStack = stack.getItemStack()).m_41720_() instanceof ItemSlashBlade && (optional = itemStack.getCapability(ItemSlashBlade.BLADESTATE)).isPresent()) {
            json.addProperty("sbCaps", ((ISlashBladeState)optional.orElseThrow(NullPointerException::new)).serializeNBT().m_7916_());
        }
        if (!stack.getRemainder().isEmpty()) {
            JsonElement remainderElement;
            EmiStack remainder = stack.getRemainder();
            if (!remainder.getRemainder().isEmpty()) {
                remainder = remainder.copy().setRemainder(EmiStack.EMPTY);
            }
            if (remainder.getRemainder().isEmpty() && (remainderElement = EmiIngredientSerializer.getSerialized((EmiIngredient)remainder)) != null) {
                json.add("remainder", remainderElement);
            }
        }
        return json;
    }

    public EmiIngredient deserialize(JsonElement element) {
        ResourceLocation id = null;
        String nbt = null;
        String capNBT = null;
        long amount = 1L;
        float chance = 1.0f;
        EmiStack remainder = EmiStack.EMPTY;
        if (GsonHelper.m_13803_((JsonElement)element)) {
            String s = element.getAsString();
            Matcher m = STACK_REGEX.matcher(s);
            if (m.matches()) {
                id = EmiPort.id((String)m.group(2), (String)m.group(3));
                nbt = m.group(4);
            }
        } else if (element.isJsonObject()) {
            EmiIngredient ing;
            JsonObject json = element.getAsJsonObject();
            id = EmiPort.id((String)GsonHelper.m_13906_((JsonObject)json, (String)"id"));
            nbt = GsonHelper.m_13851_((JsonObject)json, (String)"nbt", null);
            capNBT = GsonHelper.m_13906_((JsonObject)json, (String)"sbCaps");
            amount = GsonHelper.m_13828_((JsonObject)json, (String)"amount", (long)1L);
            chance = GsonHelper.m_13820_((JsonObject)json, (String)"chance", (float)1.0f);
            if (GsonHelper.m_13900_((JsonObject)json, (String)"remainder") && (ing = EmiIngredientSerializer.getDeserialized((JsonElement)json.get("remainder"))) instanceof EmiStack) {
                EmiStack stack;
                remainder = stack = (EmiStack)ing;
            }
        }
        if (id != null) {
            try {
                EmiStack stack;
                CompoundTag nbtComp = null;
                if (nbt != null) {
                    nbtComp = TagParser.m_129359_(nbt);
                }
                if (capNBT != null) {
                    CompoundTag tag = new CompoundTag();
                    tag.m_128365_("Parent", (Tag)TagParser.m_129359_((String)capNBT));
                    ItemStack itemStack = new ItemStack((ItemLike)Objects.requireNonNull((Item)EmiPort.getItemRegistry().m_7745_(id)), (int)amount, tag);
                    CompoundTag newNbt = itemStack.m_41784_();
                    if (nbtComp != null) {
                        for (String key : nbtComp.m_128431_()) {
                            newNbt.m_128365_(key, nbtComp.m_128423_(key).m_6426_());
                        }
                    }
                    stack = new ItemEmiStack(itemStack);
                } else {
                    stack = this.create(id, nbtComp, amount);
                }
                if (chance != 1.0f) {
                    stack.setChance(chance);
                }
                if (!remainder.isEmpty()) {
                    stack.setRemainder(remainder);
                }
                return stack;
            }
            catch (Exception e) {
                EmiLog.error((String)"Error parsing NBT in deserialized stack", (Throwable)e);
                return EmiStack.EMPTY;
            }
        }
        return EmiStack.EMPTY;
    }
}

