/*
 * Decompiled with CFR 0.152.
 */
package mods.flammpfeil.slashblade.event.handler;

import mods.flammpfeil.slashblade.SlashBladeConfig;
import mods.flammpfeil.slashblade.capability.concentrationrank.ConcentrationRankCapabilityProvider;
import mods.flammpfeil.slashblade.capability.concentrationrank.IConcentrationRank;
import mods.flammpfeil.slashblade.capability.slashblade.ISlashBladeState;
import mods.flammpfeil.slashblade.event.SlashBladeEvent;
import mods.flammpfeil.slashblade.item.ItemSlashBlade;
import mods.flammpfeil.slashblade.item.SwordType;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.entity.living.LivingDeathEvent;
import net.minecraftforge.event.entity.living.LivingExperienceDropEvent;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.SubscribeEvent;

public class KillCounter {
    public static KillCounter getInstance() {
        return SingletonHolder.instance;
    }

    private KillCounter() {
    }

    public void register() {
        MinecraftForge.EVENT_BUS.register((Object)this);
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public void onLivingDeathEvent(LivingDeathEvent event) {
        Entity trueSource = event.getSource().m_7639_();
        if (!(trueSource instanceof LivingEntity)) {
            return;
        }
        ItemStack stack = ((LivingEntity)trueSource).m_21205_();
        if (stack.m_41619_()) {
            return;
        }
        if (!stack.getCapability(ItemSlashBlade.BLADESTATE).isPresent()) {
            return;
        }
        stack.getCapability(ItemSlashBlade.BLADESTATE).ifPresent(state -> {
            SlashBladeEvent.AddKillCountEvent killCountEvent = new SlashBladeEvent.AddKillCountEvent(stack, (ISlashBladeState)state, 1);
            MinecraftForge.EVENT_BUS.post((Event)killCountEvent);
            state.setKillCount(state.getKillCount() + killCountEvent.getNewCount());
        });
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public void onXPDropping(LivingExperienceDropEvent event) {
        Player player = event.getAttackingPlayer();
        if (player == null) {
            return;
        }
        ItemStack stack = player.m_21205_();
        if (stack.m_41619_()) {
            return;
        }
        if (!stack.getCapability(ItemSlashBlade.BLADESTATE).isPresent()) {
            return;
        }
        IConcentrationRank.ConcentrationRanks rankBonus = player.getCapability(ConcentrationRankCapabilityProvider.RANK_POINT).map(rp -> rp.getRank(player.m_20193_().m_46467_())).orElse(IConcentrationRank.ConcentrationRanks.NONE);
        int souls = (int)Math.floor((float)event.getDroppedExperience() * (1.0f + (float)rankBonus.level * 0.1f));
        stack.getCapability(ItemSlashBlade.BLADESTATE).ifPresent(state -> {
            SlashBladeEvent.AddProudSoulEvent soulEvent = new SlashBladeEvent.AddProudSoulEvent(stack, (ISlashBladeState)state, Math.min((Integer)SlashBladeConfig.MAX_PROUD_SOUL_GOT.get(), souls));
            MinecraftForge.EVENT_BUS.post((Event)soulEvent);
            int newCount = soulEvent.getNewCount();
            state.setProudSoulCount(state.getProudSoulCount() + newCount);
            if (SwordType.from(stack).contains((Object)SwordType.SOULEATER)) {
                int damage = Math.max(1, newCount / 4);
                stack.m_41721_(Math.max(stack.m_41773_() - damage, 0));
            }
        });
    }

    private static final class SingletonHolder {
        private static final KillCounter instance = new KillCounter();

        private SingletonHolder() {
        }
    }
}

