/*
 * Decompiled with CFR 0.152.
 */
package mods.flammpfeil.slashblade.event.handler;

import java.util.concurrent.atomic.AtomicInteger;
import mods.flammpfeil.slashblade.SlashBladeConfig;
import mods.flammpfeil.slashblade.capability.slashblade.ISlashBladeState;
import mods.flammpfeil.slashblade.capability.slashblade.SlashBladeState;
import mods.flammpfeil.slashblade.event.RefineProgressEvent;
import mods.flammpfeil.slashblade.event.RefineSettlementEvent;
import mods.flammpfeil.slashblade.item.ItemSlashBlade;
import mods.flammpfeil.slashblade.util.AdvancementHelper;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.AnvilUpdateEvent;
import net.minecraftforge.event.entity.player.AnvilRepairEvent;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.SubscribeEvent;

public class RefineHandler {
    private static final ResourceLocation REFINE = new ResourceLocation("slashblade", "tips/refine");

    public static RefineHandler getInstance() {
        return SingletonHolder.instance;
    }

    private RefineHandler() {
    }

    public void register() {
        MinecraftForge.EVENT_BUS.register((Object)this);
    }

    @SubscribeEvent(priority=EventPriority.LOW)
    public void onAnvilUpdateEvent(AnvilUpdateEvent event) {
        if (!event.getOutput().m_41619_()) {
            return;
        }
        ItemStack base = event.getLeft();
        ItemStack material = event.getRight();
        if (base.m_41619_()) {
            return;
        }
        if (!base.getCapability(ItemSlashBlade.BLADESTATE).isPresent()) {
            return;
        }
        if (material.m_41619_()) {
            return;
        }
        boolean isRepairable = base.m_41720_().m_6832_(base, material);
        if (!isRepairable) {
            return;
        }
        int level = material.getEnchantmentValue();
        if (level < 0) {
            return;
        }
        ItemStack result = base.m_41777_();
        int refineLimit = Math.max(10, level);
        int materialCost = 0;
        int levelCostBase = (Integer)SlashBladeConfig.REFINE_LEVEL_COST.get();
        int costResult = 0;
        AtomicInteger refineResult = new AtomicInteger(0);
        result.getCapability(ItemSlashBlade.BLADESTATE).ifPresent(s -> refineResult.set(s.getRefine()));
        while (materialCost < material.m_41613_()) {
            RefineProgressEvent e = new RefineProgressEvent(result, (ISlashBladeState)result.getCapability(ItemSlashBlade.BLADESTATE).orElse((Object)new SlashBladeState(result)), materialCost + 1, levelCostBase, costResult, refineResult.get(), event);
            MinecraftForge.EVENT_BUS.post((Event)e);
            if (e.isCanceled()) break;
            refineResult.set(e.getRefineResult());
            materialCost = e.getMaterialCost();
            costResult = e.getCostResult() + e.getLevelCost();
            if (event.getPlayer().m_150110_().f_35937_ || event.getPlayer().f_36078_ >= costResult) continue;
            break;
        }
        if (result.getCapability(ItemSlashBlade.BLADESTATE).isPresent()) {
            ISlashBladeState state = result.getCapability(ItemSlashBlade.BLADESTATE).resolve().orElse(new SlashBladeState(result));
            RefineSettlementEvent e2 = new RefineSettlementEvent(result, state, materialCost, costResult, refineResult.get(), event);
            MinecraftForge.EVENT_BUS.post((Event)e2);
            if (e2.isCanceled()) {
                return;
            }
            materialCost = e2.getMaterialCost();
            costResult = e2.getCostResult();
            if (state.getRefine() <= refineLimit) {
                if (state.getRefine() + e2.getRefineResult() < 200) {
                    state.setMaxDamage(state.getMaxDamage() + e2.getRefineResult());
                } else if (state.getRefine() < 200) {
                    state.setMaxDamage(state.getMaxDamage() + Math.min(state.getRefine() + e2.getRefineResult(), 200) - state.getRefine());
                }
                state.setProudSoulCount(state.getProudSoulCount() + this.getRefineProudsoulCount(level, state, e2));
                state.setRefine(e2.getRefineResult());
            }
            result.m_41721_(result.m_41773_() - Math.max(result.m_41773_(), materialCost * Math.max(1, level / 2)));
            result.m_41784_().m_128365_("bladeState", (Tag)state.serializeNBT());
        }
        event.setMaterialCost(materialCost);
        event.setCost(costResult);
        event.setOutput(result);
    }

    public int getRefineProudsoulCount(int level, ISlashBladeState state, RefineSettlementEvent e2) {
        return (e2.getRefineResult() - state.getRefine()) * Math.min(5000, level * 10);
    }

    @SubscribeEvent
    public void onAnvilRepairEvent(AnvilRepairEvent event) {
        int after;
        if (!(event.getEntity() instanceof ServerPlayer)) {
            return;
        }
        ItemStack material = event.getRight();
        ItemStack base = event.getLeft();
        ItemStack output = event.getOutput();
        if (base.m_41619_()) {
            return;
        }
        if (!(base.m_41720_() instanceof ItemSlashBlade)) {
            return;
        }
        if (material.m_41619_()) {
            return;
        }
        boolean isRepairable = base.m_41720_().m_6832_(base, material);
        if (!isRepairable) {
            return;
        }
        int before = base.getCapability(ItemSlashBlade.BLADESTATE).map(ISlashBladeState::getRefine).orElse(0);
        if (before < (after = output.getCapability(ItemSlashBlade.BLADESTATE).map(ISlashBladeState::getRefine).orElse(0).intValue())) {
            AdvancementHelper.grantCriterion((ServerPlayer)event.getEntity(), REFINE);
        }
    }

    @SubscribeEvent
    public void refineLimitCheck(RefineProgressEvent event) {
        AnvilUpdateEvent oriEvent = event.getOriginalEvent();
        if (oriEvent == null) {
            return;
        }
        int refineLimit = Math.max(10, oriEvent.getRight().getEnchantmentValue());
        if (event.getRefineResult() < refineLimit) {
            event.setRefineResult(event.getRefineResult() + 1);
        }
    }

    private static final class SingletonHolder {
        private static final RefineHandler instance = new RefineHandler();

        private SingletonHolder() {
        }
    }
}

