/*
 * Decompiled with CFR 0.152.
 */
package mods.flammpfeil.slashblade.recipe;

import java.util.Map;
import java.util.Objects;
import mods.flammpfeil.slashblade.SlashBladeConfig;
import mods.flammpfeil.slashblade.capability.slashblade.ISlashBladeState;
import mods.flammpfeil.slashblade.item.ItemSlashBlade;
import mods.flammpfeil.slashblade.recipe.SlashBladeShapedRecipeSerializer;
import mods.flammpfeil.slashblade.registry.SlashBladeItems;
import mods.flammpfeil.slashblade.registry.slashblade.SlashBladeDefinition;
import net.minecraft.core.RegistryAccess;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.inventory.CraftingContainer;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.ShapedRecipe;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.registries.ForgeRegistries;
import org.jetbrains.annotations.NotNull;

public class SlashBladeShapedRecipe
extends ShapedRecipe {
    public static final RecipeSerializer<SlashBladeShapedRecipe> SERIALIZER = new SlashBladeShapedRecipeSerializer<ShapedRecipe, SlashBladeShapedRecipe>(RecipeSerializer.f_44076_, SlashBladeShapedRecipe::new);
    private final ResourceLocation outputBlade;

    public SlashBladeShapedRecipe(ShapedRecipe compose, ResourceLocation outputBlade) {
        super(compose.m_6423_(), compose.m_6076_(), compose.m_245232_(), compose.m_44220_(), compose.m_44221_(), compose.m_7527_(), SlashBladeShapedRecipe.getResultBlade(outputBlade));
        this.outputBlade = outputBlade;
    }

    private static ItemStack getResultBlade(ResourceLocation outputBlade) {
        Item bladeItem = ForgeRegistries.ITEMS.containsKey(outputBlade) ? (Item)ForgeRegistries.ITEMS.getValue(outputBlade) : (Item)SlashBladeItems.SLASHBLADE.get();
        return Objects.requireNonNullElseGet(bladeItem, SlashBladeItems.SLASHBLADE).m_7968_();
    }

    public ResourceLocation getOutputBlade() {
        return this.outputBlade;
    }

    private ResourceKey<SlashBladeDefinition> getOutputBladeKey() {
        return ResourceKey.m_135785_(SlashBladeDefinition.REGISTRY_KEY, (ResourceLocation)this.outputBlade);
    }

    @NotNull
    public ItemStack m_8043_(@NotNull RegistryAccess access) {
        ItemStack result = SlashBladeShapedRecipe.getResultBlade(this.getOutputBlade());
        if (!Objects.equals(ForgeRegistries.ITEMS.getKey((Object)result.m_41720_()), this.getOutputBlade())) {
            result = ((SlashBladeDefinition)access.m_175515_(SlashBladeDefinition.REGISTRY_KEY).m_123013_(this.getOutputBladeKey())).getBlade();
        }
        return result;
    }

    @NotNull
    public ItemStack m_5874_(@NotNull CraftingContainer container, @NotNull RegistryAccess access) {
        ItemStack result = this.m_8043_(access);
        if (!(result.m_41720_() instanceof ItemSlashBlade)) {
            result = new ItemStack((ItemLike)SlashBladeItems.SLASHBLADE.get());
        }
        ISlashBladeState resultState = (ISlashBladeState)result.getCapability(ItemSlashBlade.BLADESTATE).orElseThrow(NullPointerException::new);
        boolean sumRefine = (Boolean)SlashBladeConfig.DO_CRAFTING_SUM_REFINE.get();
        int proudSoul = resultState.getProudSoulCount();
        int killCount = resultState.getKillCount();
        int refine = resultState.getRefine();
        for (ItemStack stack : container.m_280657_()) {
            if (!(stack.m_41720_() instanceof ItemSlashBlade)) continue;
            ISlashBladeState ingredientState = (ISlashBladeState)stack.getCapability(ItemSlashBlade.BLADESTATE).orElseThrow(NullPointerException::new);
            proudSoul += ingredientState.getProudSoulCount();
            killCount += ingredientState.getKillCount();
            refine = sumRefine ? (refine += ingredientState.getRefine()) : Math.max(refine, ingredientState.getRefine());
            this.updateEnchantment(result, stack);
        }
        resultState.setProudSoulCount(proudSoul);
        resultState.setKillCount(killCount);
        resultState.setRefine(refine);
        result.m_41784_().m_128365_("bladeState", (Tag)resultState.serializeNBT());
        return result;
    }

    private void updateEnchantment(ItemStack result, ItemStack ingredient) {
        Map newItemEnchants = result.getAllEnchantments();
        Map oldItemEnchants = ingredient.getAllEnchantments();
        for (Enchantment enchantIndex : oldItemEnchants.keySet()) {
            int destLevel = newItemEnchants.getOrDefault(enchantIndex, 0);
            int srcLevel = (Integer)oldItemEnchants.get(enchantIndex);
            srcLevel = Math.max(srcLevel, destLevel);
            srcLevel = Math.min(srcLevel, enchantIndex.m_6586_());
            boolean canApplyFlag = enchantIndex.canApplyAtEnchantingTable(result);
            if (!canApplyFlag) continue;
            for (Enchantment curEnchantIndex : newItemEnchants.keySet()) {
                if (curEnchantIndex == enchantIndex || enchantIndex.m_44695_(curEnchantIndex)) continue;
                canApplyFlag = false;
                break;
            }
            if (!canApplyFlag) continue;
            newItemEnchants.put(enchantIndex, srcLevel);
        }
        EnchantmentHelper.m_44865_((Map)newItemEnchants, (ItemStack)result);
    }

    @NotNull
    public RecipeSerializer<?> m_7707_() {
        return SERIALIZER;
    }
}

