/*
 * Decompiled with CFR 0.152.
 */
package mods.flammpfeil.slashblade.recipe;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Stream;
import mods.flammpfeil.slashblade.SlashBladeConfig;
import mods.flammpfeil.slashblade.capability.slashblade.ISlashBladeState;
import mods.flammpfeil.slashblade.item.ItemSlashBlade;
import mods.flammpfeil.slashblade.registry.SlashBladeItems;
import mods.flammpfeil.slashblade.registry.slashblade.SlashBladeDefinition;
import net.minecraft.core.RegistryAccess;
import net.minecraft.nbt.Tag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.Container;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.SmithingRecipe;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraftforge.common.ForgeHooks;
import net.minecraftforge.registries.ForgeRegistries;
import org.jetbrains.annotations.NotNull;

public class SlashBladeSmithingRecipe
implements SmithingRecipe {
    public static final RecipeSerializer<SlashBladeSmithingRecipe> SERIALIZER = new Serializer();
    private final ResourceLocation outputBlade;
    private final ResourceLocation id;
    private final Ingredient template;
    private final Ingredient base;
    private final Ingredient addition;

    public SlashBladeSmithingRecipe(ResourceLocation id, ResourceLocation outputBlade, Ingredient template, Ingredient base, Ingredient addition) {
        this.id = id;
        this.outputBlade = outputBlade;
        this.template = template;
        this.base = base;
        this.addition = addition;
    }

    public SlashBladeSmithingRecipe(ResourceLocation outputBlade, Ingredient template, Ingredient base, Ingredient addition) {
        this(outputBlade, outputBlade, template, base, addition);
    }

    public Ingredient getTemplate() {
        return this.template;
    }

    public Ingredient getBase() {
        return this.base;
    }

    public Ingredient getAddition() {
        return this.addition;
    }

    private static ItemStack getResultBlade(ResourceLocation outputBlade) {
        Item bladeItem = ForgeRegistries.ITEMS.containsKey(outputBlade) ? (Item)ForgeRegistries.ITEMS.getValue(outputBlade) : (Item)SlashBladeItems.SLASHBLADE.get();
        return Objects.requireNonNullElseGet(bladeItem, SlashBladeItems.SLASHBLADE).m_7968_();
    }

    @NotNull
    public ItemStack m_8043_(@NotNull RegistryAccess access) {
        ItemStack result = SlashBladeSmithingRecipe.getResultBlade(this.getOutputBlade());
        if (!Objects.equals(ForgeRegistries.ITEMS.getKey((Object)result.m_41720_()), this.getOutputBlade())) {
            result = Objects.requireNonNull((SlashBladeDefinition)access.m_175515_(SlashBladeDefinition.REGISTRY_KEY).m_7745_(this.getOutputBlade())).getBlade();
        }
        return result;
    }

    public boolean m_5818_(Container container, @NotNull Level level) {
        return this.template.test(container.m_8020_(0)) && this.base.test(container.m_8020_(1)) && this.addition.test(container.m_8020_(2));
    }

    @NotNull
    public ItemStack m_5874_(@NotNull Container container, @NotNull RegistryAccess access) {
        ItemStack result = this.m_8043_(access);
        if (!(result.m_41720_() instanceof ItemSlashBlade)) {
            result = new ItemStack((ItemLike)SlashBladeItems.SLASHBLADE.get());
        }
        ISlashBladeState resultState = (ISlashBladeState)result.getCapability(ItemSlashBlade.BLADESTATE).orElseThrow(NullPointerException::new);
        ItemStack stack = container.m_8020_(1);
        if (!stack.getCapability(ItemSlashBlade.BLADESTATE).isPresent()) {
            return ItemStack.f_41583_;
        }
        ISlashBladeState ingredientState = (ISlashBladeState)stack.getCapability(ItemSlashBlade.BLADESTATE).orElseThrow(NullPointerException::new);
        resultState.setProudSoulCount(resultState.getProudSoulCount() + ingredientState.getProudSoulCount());
        resultState.setKillCount((Boolean)SlashBladeConfig.DO_CRAFTING_SUM_REFINE.get() != false ? Math.max(resultState.getKillCount(), ingredientState.getKillCount()) : resultState.getKillCount() + ingredientState.getKillCount());
        resultState.setRefine(resultState.getRefine() + ingredientState.getRefine());
        result.m_41784_().m_128365_("bladeState", (Tag)resultState.serializeNBT());
        this.updateEnchantment(result, stack);
        return result;
    }

    @NotNull
    public ResourceLocation m_6423_() {
        return this.id;
    }

    @NotNull
    public RecipeSerializer<?> m_7707_() {
        return SERIALIZER;
    }

    public boolean m_142505_() {
        return Stream.of(this.template, this.base, this.addition).anyMatch(ForgeHooks::hasNoElements);
    }

    public boolean m_266166_(@NotNull ItemStack stack) {
        return this.template.test(stack);
    }

    public boolean m_266343_(@NotNull ItemStack stack) {
        return this.base.test(stack);
    }

    public boolean m_266253_(@NotNull ItemStack stack) {
        return this.addition.test(stack);
    }

    public ResourceLocation getOutputBlade() {
        return this.outputBlade;
    }

    private void updateEnchantment(ItemStack result, ItemStack ingredient) {
        Map newItemEnchants = result.getAllEnchantments();
        Map oldItemEnchants = ingredient.getAllEnchantments();
        for (Enchantment enchantIndex : oldItemEnchants.keySet()) {
            int destLevel = newItemEnchants.getOrDefault(enchantIndex, 0);
            int srcLevel = (Integer)oldItemEnchants.get(enchantIndex);
            srcLevel = Math.max(srcLevel, destLevel);
            srcLevel = Math.min(srcLevel, enchantIndex.m_6586_());
            boolean canApplyFlag = enchantIndex.canApplyAtEnchantingTable(result);
            if (!canApplyFlag) continue;
            for (Enchantment curEnchantIndex : newItemEnchants.keySet()) {
                if (curEnchantIndex == enchantIndex || enchantIndex.m_44695_(curEnchantIndex)) continue;
                canApplyFlag = false;
                break;
            }
            if (!canApplyFlag) continue;
            newItemEnchants.put(enchantIndex, srcLevel);
        }
        EnchantmentHelper.m_44865_((Map)newItemEnchants, (ItemStack)result);
    }

    public static class Serializer
    implements RecipeSerializer<SlashBladeSmithingRecipe> {
        @NotNull
        public SlashBladeSmithingRecipe fromJson(@NotNull ResourceLocation id, @NotNull JsonObject json) {
            Ingredient ingredient = Ingredient.m_43917_((JsonElement)GsonHelper.m_289747_((JsonObject)json, (String)"template"));
            Ingredient ingredient1 = Ingredient.m_43917_((JsonElement)GsonHelper.m_289747_((JsonObject)json, (String)"base"));
            Ingredient ingredient2 = Ingredient.m_43917_((JsonElement)GsonHelper.m_289747_((JsonObject)json, (String)"addition"));
            ResourceLocation output = new ResourceLocation(GsonHelper.m_13906_((JsonObject)json, (String)"blade"));
            return new SlashBladeSmithingRecipe(id, output, ingredient, ingredient1, ingredient2);
        }

        public SlashBladeSmithingRecipe fromNetwork(@NotNull ResourceLocation id, @NotNull FriendlyByteBuf buffer) {
            Ingredient ingredient = Ingredient.m_43940_((FriendlyByteBuf)buffer);
            Ingredient ingredient1 = Ingredient.m_43940_((FriendlyByteBuf)buffer);
            Ingredient ingredient2 = Ingredient.m_43940_((FriendlyByteBuf)buffer);
            ResourceLocation blade = buffer.m_130281_();
            return new SlashBladeSmithingRecipe(id, blade, ingredient, ingredient1, ingredient2);
        }

        public void toNetwork(@NotNull FriendlyByteBuf buffer, SlashBladeSmithingRecipe recipe) {
            recipe.template.m_43923_(buffer);
            recipe.base.m_43923_(buffer);
            recipe.addition.m_43923_(buffer);
            buffer.m_130085_(recipe.outputBlade);
        }
    }
}

